/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stymgt;

import java.io.Serializable;
import java.util.ArrayList;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.BaseJmsOrder;

public class StudyMgtOrder
extends BaseJmsOrder
implements Serializable {
    private static final long serialVersionUID = 3258417226779603505L;
    private final String callingAET;
    private final String calledAET;
    private final int cmdField;
    private final int actionTypeID;
    private final String iuid;
    private final Dataset ds;

    public StudyMgtOrder(String callingAET, String calledAET, int cmdField, int actionID, String iuid, Dataset dataset) {
        this.callingAET = callingAET;
        this.calledAET = calledAET;
        this.cmdField = cmdField;
        this.actionTypeID = actionID;
        this.iuid = iuid;
        this.ds = dataset;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final int getActionTypeID() {
        return this.actionTypeID;
    }

    public final int getCommandField() {
        return this.cmdField;
    }

    public final String getSOPInstanceUID() {
        return this.iuid;
    }

    public final Dataset getDataset() {
        return this.ds;
    }

    public String getOrderDetails() {
        return this.cmdFieldAsString() + ", iuid=" + this.iuid;
    }

    private String cmdFieldAsString() {
        return StudyMgtOrder.commandAsString(this.cmdField, this.actionTypeID);
    }

    public static String commandAsString(int cmdField, int actionTypeID) {
        switch (cmdField) {
            case 288: {
                return "N_SET_RQ";
            }
            case 304: {
                return "N_ACTION_RQ(" + actionTypeID + ")";
            }
            case 320: {
                return "N_CREATE_RQ";
            }
            case 336: {
                return "N_DELETE_RQ";
            }
        }
        return Integer.toHexString(cmdField).toUpperCase();
    }

    public void processOrderProperties(Object ... properties) {
        this.setOrderProperty("CalledAETitle", this.callingAET);
        this.setOrderProperty("CallingAETitle", this.calledAET);
        if (this.ds != null) {
            this.setOrderProperty("StudyInstanceUID", this.ds.getString(0x20000D));
            this.setOrderProperty("IssuerOfPatientID", this.ds.getString(0x100021));
            this.setOrderProperty("PatientID", this.ds.getString(0x100020));
            ArrayList<String> seriesUIDList = new ArrayList<String>();
            DcmElement refSeriesSeq = this.ds.get(528661);
            if (refSeriesSeq != null) {
                for (int j = 0; j < refSeriesSeq.countItems(); ++j) {
                    Dataset refSeriesDS = refSeriesSeq.getItem(j);
                    seriesUIDList.add(refSeriesDS.getString(0x20000E));
                }
            }
            this.setOrderMultiProperty("SeriesInstanceUID", seriesUIDList.toArray(new String[0]));
        } else {
            this.setOrderProperty("SOPInstanceUID", this.iuid);
        }
    }
}

