/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.storescp;

import java.io.File;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.InstancesTransferredMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.message.PatientRecordMessage;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.CompressionRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.storescp.StoreScp;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.Storage;
import org.dcm4chex.archive.ejb.interfaces.StorageHome;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.FileSystemMgt2Delegate;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;

public class StoreScpService
extends AbstractScpService {
    public static final String EVENT_TYPE_OBJECT_STORED = "org.dcm4chex.archive.dcm.storescp";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = -7557458153348143439L;

        public boolean isNotificationEnabled(Notification notif) {
            return StoreScpService.EVENT_TYPE_OBJECT_STORED.equals(notif.getType());
        }
    };
    public static final String EVENT_TYPE_NEW_STUDY = "org.dcm4chex.archive.dcm.storescp#newStudy";
    public static final NotificationFilter NOTIF_FILTER_NEW_STUDY = new NotificationFilter(){
        private static final long serialVersionUID = -7557458153348143439L;

        public boolean isNotificationEnabled(Notification notif) {
            return StoreScpService.EVENT_TYPE_NEW_STUDY.equals(notif.getType());
        }
    };
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private final NotificationListener checkPendingSeriesStoredListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notif, Object handback) {
            3 var3_3 = this;
            synchronized (var3_3) {
                if (StoreScpService.this.isRunning) {
                    StoreScpService.this.log.info((Object)"checkPendingSeriesStored is already running!");
                    return;
                }
                StoreScpService.this.isRunning = true;
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            StoreScpService.this.log.debug((Object)"Check for Pending Series Stored");
                            StoreScpService.this.checkPendingSeriesStored();
                        }
                        catch (Exception e) {
                            StoreScpService.this.log.error((Object)"Check for Pending Series Stored failed:", (Throwable)e);
                            Object var3_2 = null;
                            StoreScpService.this.isRunning = false;
                            return;
                        }
                        Object var3_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        StoreScpService.this.isRunning = false;
                        throw throwable;
                    }
                    StoreScpService.this.isRunning = false;
                }
            }).start();
        }
    };
    private Integer listenerID;
    private long checkPendingSeriesStoredInterval;
    private long seriesStoredNotificationDelay;
    private String defFileSystemGroupID;
    private Map imageCUIDS = new LinkedHashMap();
    private Map imageTSUIDS = new LinkedHashMap();
    private Map waveformCUIDS = new LinkedHashMap();
    private Map waveformTSUIDS = new LinkedHashMap();
    private Map videoCUIDS = new LinkedHashMap();
    private Map videoTSUIDS = new LinkedHashMap();
    private Map srCUIDS = new LinkedHashMap();
    private Map srTSUIDS = new LinkedHashMap();
    private Map otherCUIDS = new LinkedHashMap();
    private String timerIDCheckPendingSeriesStored;
    private boolean isRunning;
    private String[] unrestrictedAppendPermissionsToAETitles;
    private FileSystemMgt2Delegate fsmgt = new FileSystemMgt2Delegate(this);
    private ObjectName mwlScuServiceName;
    private static final int MIN_MAX_VALLEN = 65536;
    private int maxValueLength = Integer.MAX_VALUE;
    private int bufferSize = 8192;
    private boolean md5sum = true;
    private boolean syncFileBeforeCStoreRSP = true;
    private boolean syncFileAfterCStoreRSP = false;
    private boolean storeOriginalPatientIDInOtherPatientIDsSeq;
    private boolean storeOriginalPatientIDInOriginalAttrsSeq;
    private StoreScp scp = this.createScp();

    protected StoreScp createScp() {
        return new StoreScp(this);
    }

    protected StoreScp getScp() {
        return this.scp;
    }

    public String getDefaultFileSystemGroupID() {
        return this.defFileSystemGroupID;
    }

    public void setDefaultFileSystemGroupID(String defFileSystemGroupID) {
        this.defFileSystemGroupID = defFileSystemGroupID;
    }

    public final String getCheckPendingSeriesStoredInterval() {
        return RetryIntervalls.formatInterval(this.checkPendingSeriesStoredInterval);
    }

    public void setCheckPendingSeriesStoredInterval(String interval) throws Exception {
        long oldInterval = this.checkPendingSeriesStoredInterval;
        this.checkPendingSeriesStoredInterval = RetryIntervalls.parseInterval(interval);
        if (this.getState() == 3 && oldInterval != this.checkPendingSeriesStoredInterval) {
            this.stopSeriesStoredScheduler();
            this.startSeriesStoredScheduler();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public final String getSeriesStoredNotificationDelay() {
        return RetryIntervalls.formatInterval(this.seriesStoredNotificationDelay);
    }

    public void setSeriesStoredNotificationDelay(String interval) {
        this.seriesStoredNotificationDelay = RetryIntervalls.parseIntervalOrNever(interval);
    }

    public final boolean isMd5sum() {
        return this.md5sum;
    }

    public final void setMd5sum(boolean md5sum) {
        this.md5sum = md5sum;
    }

    public final void setSyncFileBeforeCStoreRSP(boolean syncFileBeforeCStoreRSP) {
        this.syncFileBeforeCStoreRSP = syncFileBeforeCStoreRSP;
    }

    public final boolean isSyncFileBeforeCStoreRSP() {
        return this.syncFileBeforeCStoreRSP;
    }

    public final void setSyncFileAfterCStoreRSP(boolean syncFileAfterCStoreRSP) {
        this.syncFileAfterCStoreRSP = syncFileAfterCStoreRSP;
    }

    public final boolean isSyncFileAfterCStoreRSP() {
        return this.syncFileAfterCStoreRSP;
    }

    public final boolean isStoreOriginalPatientIDInOtherPatientIDsSeq() {
        return this.storeOriginalPatientIDInOtherPatientIDsSeq;
    }

    public final void setStoreOriginalPatientIDInOtherPatientIDsSeq(boolean storeOriginalPatientIDInOtherPatientIDsSeq) {
        this.storeOriginalPatientIDInOtherPatientIDsSeq = storeOriginalPatientIDInOtherPatientIDsSeq;
    }

    public final boolean isStoreOriginalPatientIDInOriginalAttrsSeq() {
        return this.storeOriginalPatientIDInOriginalAttrsSeq;
    }

    public final void setStoreOriginalPatientIDInOriginalAttrsSeq(boolean storeOriginalPatientIDInOriginalAttrsSeq) {
        this.storeOriginalPatientIDInOriginalAttrsSeq = storeOriginalPatientIDInOriginalAttrsSeq;
    }

    public int getMaxValueLength() {
        return this.maxValueLength;
    }

    public void setMaxValueLength(int maxValueLength) {
        if (maxValueLength < 65536) {
            throw new IllegalArgumentException("maxValueLength: " + maxValueLength + " < " + 65536);
        }
        this.maxValueLength = maxValueLength;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final boolean isStudyDateInFilePath() {
        return this.scp.isStudyDateInFilePath();
    }

    public final void setStudyDateInFilePath(boolean enable) {
        this.scp.setStudyDateInFilePath(enable);
    }

    public final boolean isSourceAETInFilePath() {
        return this.scp.isSourceAETInFilePath();
    }

    public final void setSourceAETInFilePath(boolean enable) {
        this.scp.setSourceAETInFilePath(enable);
    }

    public final boolean isYearInFilePath() {
        return this.scp.isYearInFilePath();
    }

    public final void setYearInFilePath(boolean enable) {
        this.scp.setYearInFilePath(enable);
    }

    public final boolean isMonthInFilePath() {
        return this.scp.isMonthInFilePath();
    }

    public final void setMonthInFilePath(boolean enable) {
        this.scp.setMonthInFilePath(enable);
    }

    public final boolean isDayInFilePath() {
        return this.scp.isDayInFilePath();
    }

    public final void setDayInFilePath(boolean enable) {
        this.scp.setDayInFilePath(enable);
    }

    public final boolean isHourInFilePath() {
        return this.scp.isHourInFilePath();
    }

    public final void setHourInFilePath(boolean enable) {
        this.scp.setHourInFilePath(enable);
    }

    public final String getReferencedDirectoryPath() {
        return this.scp.getReferencedDirectoryPath();
    }

    public final void setReferencedDirectoryPath(String pathOrURI) {
        this.scp.setReferencedDirectoryPath(pathOrURI);
    }

    public String getReferencedFileSystemGroupID() {
        return this.scp.getReferencedFileSystemGroupID();
    }

    public void setReferencedFileSystemGroupID(String groupID) {
        this.scp.setReferencedFileSystemGroupID(groupID);
    }

    public final boolean isReadReferencedFile() {
        return this.scp.isReadReferencedFile();
    }

    public final void setReadReferencedFile(boolean readReferencedFile) {
        this.scp.setReadReferencedFile(readReferencedFile);
    }

    public final boolean isMd5sumReferencedFile() {
        return this.scp.isMd5sumReferencedFile();
    }

    public final void setMd5sumReferencedFile(boolean md5ReferencedFile) {
        this.scp.setMd5sumReferencedFile(md5ReferencedFile);
    }

    public final boolean isAcceptMissingPatientID() {
        return this.scp.isAcceptMissingPatientID();
    }

    public final void setAcceptMissingPatientID(boolean accept) {
        this.scp.setAcceptMissingPatientID(accept);
    }

    public final boolean isAcceptMissingPatientName() {
        return this.scp.isAcceptMissingPatientName();
    }

    public final void setAcceptMissingPatientName(boolean accept) {
        this.scp.setAcceptMissingPatientName(accept);
    }

    public final boolean isSerializeDBUpdate() {
        return this.scp.isSerializeDBUpdate();
    }

    public final void setSerializeDBUpdate(boolean serialize) {
        this.scp.setSerializeDBUpdate(serialize);
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public String getFileSystemMgtServiceNamePrefix() {
        return this.fsmgt.getFileSystemMgtServiceNamePrefix();
    }

    public void setFileSystemMgtServiceNamePrefix(String prefix) {
        this.fsmgt.setFileSystemMgtServiceNamePrefix(prefix);
    }

    public final ObjectName getMwlScuServiceName() {
        return this.mwlScuServiceName;
    }

    public final void setMwlScuServiceName(ObjectName mwlScuServiceName) {
        this.mwlScuServiceName = mwlScuServiceName;
    }

    public final String getUnrestrictedAppendPermissionsToAETitles() {
        return this.unrestrictedAppendPermissionsToAETitles == null ? "ANY" : StringUtils.toString(this.unrestrictedAppendPermissionsToAETitles, '\\');
    }

    public final void setUnrestrictedAppendPermissionsToAETitles(String s) {
        String trim = s.trim();
        this.unrestrictedAppendPermissionsToAETitles = trim.equalsIgnoreCase("ANY") ? null : StringUtils.split(trim, '\\');
    }

    final boolean hasUnrestrictedAppendPermissions(String aet) {
        return this.unrestrictedAppendPermissionsToAETitles == null || Arrays.asList(this.unrestrictedAppendPermissionsToAETitles).contains(aet);
    }

    public String getCoerceWarnCallingAETs() {
        return this.scp.getCoerceWarnCallingAETs();
    }

    public void setCoerceWarnCallingAETs(String aets) {
        this.scp.setCoerceWarnCallingAETs(aets);
    }

    public final boolean isCoerceBeforeWrite() {
        return this.scp.isCoerceBeforeWrite();
    }

    public final void setCoerceBeforeWrite(boolean CoerceBeforeWrite) {
        this.scp.setCoerceBeforeWrite(CoerceBeforeWrite);
    }

    public String getAcceptMismatchIUIDCallingAETs() {
        return this.scp.getAcceptMismatchIUIDCallingAETs();
    }

    public void setAcceptMismatchIUIDCallingAETs(String aets) {
        this.scp.setAcceptMismatchIUIDCallingAETs(aets);
    }

    public final String getOnlyWellKnownInstancesCallingAETs() {
        return this.scp.getOnlyWellKnownInstancesCallingAETs();
    }

    public final void setOnlyWellKnownInstancesCallingAETs(String aets) {
        this.scp.setOnlyWellKnownInstancesCallingAETs(aets);
    }

    public boolean isStoreDuplicateIfDiffHost() {
        return this.scp.isStoreDuplicateIfDiffHost();
    }

    public void setStoreDuplicateIfDiffHost(boolean storeDuplicate) {
        this.scp.setStoreDuplicateIfDiffHost(storeDuplicate);
    }

    public boolean isStoreDuplicateIfDiffMD5() {
        return this.scp.isStoreDuplicateIfDiffMD5();
    }

    public void setStoreDuplicateIfDiffMD5(boolean storeDuplicate) {
        this.scp.setStoreDuplicateIfDiffMD5(storeDuplicate);
    }

    public final String getCompressionRules() {
        return this.scp.getCompressionRules().toString();
    }

    public void setCompressionRules(String rules) {
        this.scp.setCompressionRules(new CompressionRules(rules));
    }

    public final int getUpdateDatabaseMaxRetries() {
        return this.scp.getUpdateDatabaseMaxRetries();
    }

    public final void setUpdateDatabaseMaxRetries(int updateDatabaseMaxRetries) {
        this.scp.setUpdateDatabaseMaxRetries(updateDatabaseMaxRetries);
    }

    public final int getMaxCountUpdateDatabaseRetries() {
        return this.scp.getMaxCountUpdateDatabaseRetries();
    }

    public final void resetMaxCountUpdateDatabaseRetries() {
        this.scp.setMaxCountUpdateDatabaseRetries(0);
    }

    public final long getUpdateDatabaseRetryInterval() {
        return this.scp.getUpdateDatabaseRetryInterval();
    }

    public final void setUpdateDatabaseRetryInterval(long interval) {
        this.scp.setUpdateDatabaseRetryInterval(interval);
    }

    public String getAcceptedImageSOPClasses() {
        return this.toString(this.imageCUIDS);
    }

    public void setAcceptedImageSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.imageCUIDS, s, this.scp);
    }

    public String getAcceptedTransferSyntaxForImageSOPClasses() {
        return this.toString(this.imageTSUIDS);
    }

    public void setAcceptedTransferSyntaxForImageSOPClasses(String s) {
        this.updateAcceptedTransferSyntax(this.imageTSUIDS, s);
    }

    public String getAcceptedVideoSOPClasses() {
        return this.toString(this.videoCUIDS);
    }

    public void setAcceptedVideoSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.videoCUIDS, s, this.scp);
    }

    public String getAcceptedTransferSyntaxForVideoSOPClasses() {
        return this.toString(this.videoTSUIDS);
    }

    public void setAcceptedTransferSyntaxForVideoSOPClasses(String s) {
        this.updateAcceptedTransferSyntax(this.videoTSUIDS, s);
    }

    public String getAcceptedSRSOPClasses() {
        return this.toString(this.srCUIDS);
    }

    public void setAcceptedSRSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.srCUIDS, s, this.scp);
    }

    public String getAcceptedTransferSyntaxForSRSOPClasses() {
        return this.toString(this.srTSUIDS);
    }

    public void setAcceptedTransferSyntaxForSRSOPClasses(String s) {
        this.updateAcceptedTransferSyntax(this.srTSUIDS, s);
    }

    public String getAcceptedWaveformSOPClasses() {
        return this.toString(this.waveformCUIDS);
    }

    public void setAcceptedWaveformSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.waveformCUIDS, s, this.scp);
    }

    public String getAcceptedTransferSyntaxForWaveformSOPClasses() {
        return this.toString(this.waveformTSUIDS);
    }

    public void setAcceptedTransferSyntaxForWaveformSOPClasses(String s) {
        this.updateAcceptedTransferSyntax(this.waveformTSUIDS, s);
    }

    public String getAcceptedOtherSOPClasses() {
        return this.toString(this.otherCUIDS);
    }

    public void setAcceptedOtherSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.otherCUIDS, s, this.scp);
    }

    protected String[] getCUIDs() {
        return StoreScpService.valuesToStringArray(this.otherCUIDS);
    }

    public boolean isCheckIncorrectWorklistEntry() {
        return this.scp.isCheckIncorrectWorklistEntry();
    }

    public void setCheckIncorrectWorklistEntry(boolean check) {
        this.scp.setCheckIncorrectWorklistEntry(check);
    }

    public String getTimerIDCheckPendingSeriesStored() {
        return this.timerIDCheckPendingSeriesStored;
    }

    public void setTimerIDCheckPendingSeriesStored(String timerIDCheckPendingSeriesStored) {
        this.timerIDCheckPendingSeriesStored = timerIDCheckPendingSeriesStored;
    }

    public final ObjectName getPerfMonServiceName() {
        return this.scp.getPerfMonServiceName();
    }

    public final void setPerfMonServiceName(ObjectName perfMonServiceName) {
        this.scp.setPerfMonServiceName(perfMonServiceName);
    }

    protected void startService() throws Exception {
        super.startService();
        this.startSeriesStoredScheduler();
    }

    protected void startSeriesStoredScheduler() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckPendingSeriesStored, this.checkPendingSeriesStoredInterval, this.checkPendingSeriesStoredListener);
    }

    protected void stopService() throws Exception {
        this.stopSeriesStoredScheduler();
        super.stopService();
    }

    protected void stopSeriesStoredScheduler() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckPendingSeriesStored, this.listenerID, this.checkPendingSeriesStoredListener);
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        this.bindAll(StoreScpService.valuesToStringArray(this.imageCUIDS), this.scp);
        this.bindAll(StoreScpService.valuesToStringArray(this.videoCUIDS), this.scp);
        this.bindAll(StoreScpService.valuesToStringArray(this.srCUIDS), this.scp);
        this.bindAll(StoreScpService.valuesToStringArray(this.waveformCUIDS), this.scp);
        this.bindAll(StoreScpService.valuesToStringArray(this.otherCUIDS), this.scp);
        this.dcmHandler.addAssociationListener(this.scp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        this.unbindAll(StoreScpService.valuesToStringArray(this.imageCUIDS));
        this.unbindAll(StoreScpService.valuesToStringArray(this.videoCUIDS));
        this.unbindAll(StoreScpService.valuesToStringArray(this.srCUIDS));
        this.unbindAll(StoreScpService.valuesToStringArray(this.waveformCUIDS));
        this.unbindAll(StoreScpService.valuesToStringArray(this.otherCUIDS));
        this.dcmHandler.removeAssociationListener(this.scp);
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        String[] cuids = StoreScpService.valuesToStringArray(this.imageCUIDS);
        this.putPresContexts(policy, cuids, StoreScpService.valuesToStringArray(this.imageTSUIDS));
        this.putRoleSelections(policy, cuids, true, true);
        cuids = StoreScpService.valuesToStringArray(this.videoCUIDS);
        this.putPresContexts(policy, cuids, StoreScpService.valuesToStringArray(this.videoTSUIDS));
        this.putRoleSelections(policy, cuids, true, true);
        cuids = StoreScpService.valuesToStringArray(this.srCUIDS);
        this.putPresContexts(policy, cuids, StoreScpService.valuesToStringArray(this.srTSUIDS));
        this.putRoleSelections(policy, cuids, true, true);
        cuids = StoreScpService.valuesToStringArray(this.waveformCUIDS);
        this.putPresContexts(policy, cuids, StoreScpService.valuesToStringArray(this.waveformTSUIDS));
        this.putRoleSelections(policy, cuids, true, true);
        cuids = StoreScpService.valuesToStringArray(this.otherCUIDS);
        this.putPresContexts(policy, cuids, StoreScpService.valuesToStringArray(this.tsuidMap));
        this.putRoleSelections(policy, cuids, true, true);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        String[] cuids = StoreScpService.valuesToStringArray(this.imageCUIDS);
        this.putPresContexts(policy, cuids, null);
        this.removeRoleSelections(policy, cuids);
        cuids = StoreScpService.valuesToStringArray(this.videoCUIDS);
        this.putPresContexts(policy, cuids, null);
        this.removeRoleSelections(policy, cuids);
        cuids = StoreScpService.valuesToStringArray(this.srCUIDS);
        this.putPresContexts(policy, cuids, null);
        this.removeRoleSelections(policy, cuids);
        cuids = StoreScpService.valuesToStringArray(this.waveformCUIDS);
        this.putPresContexts(policy, cuids, null);
        this.removeRoleSelections(policy, cuids);
        cuids = StoreScpService.valuesToStringArray(this.otherCUIDS);
        this.putPresContexts(policy, cuids, null);
        this.removeRoleSelections(policy, cuids);
    }

    public FileSystemDTO selectStorageFileSystem(String fsgrpID) throws DcmServiceException {
        try {
            FileSystemDTO fsDTO = this.fsmgt.selectStorageFileSystem(fsgrpID);
            if (fsDTO == null) {
                throw new DcmServiceException(42752);
            }
            return fsDTO;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public FileDTO makeFile(String fileSystemGroupID, Dataset dataset) throws Exception {
        FileSystemDTO fsDTO = this.selectStorageFileSystem(fileSystemGroupID);
        File baseDir = FileUtils.toFile(fsDTO.getDirectoryPath());
        File file = this.scp.makeFile(baseDir, dataset, null);
        String filePath = file.getPath().substring(baseDir.getPath().length() + 1).replace(File.separatorChar, '/');
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileSystemPk(fsDTO.getPk());
        fileDTO.setAvailability(fsDTO.getAvailability());
        fileDTO.setDirectoryPath(fsDTO.getDirectoryPath());
        fileDTO.setFilePath(filePath);
        return fileDTO;
    }

    public void logInstancesStored(Socket s, SeriesStored seriesStored) {
        try {
            String uid;
            InstanceSorter sorter = new InstanceSorter();
            Dataset ian = seriesStored.getIAN();
            String suid = ian.getString(0x20000D);
            Dataset series = ian.getItem(528661);
            DcmElement refSops = series.get(528793);
            int n = refSops.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset refSop = refSops.getItem(i);
                sorter.addInstance(suid, refSop.getString(528720), refSop.getString(528725), null);
            }
            InstancesTransferredMessage msg = new InstancesTransferredMessage(InstancesTransferredMessage.CREATE);
            String srcAET = seriesStored.getSourceAET();
            String srcHost = s != null ? AuditMessage.hostNameOf((InetAddress)s.getInetAddress()) : null;
            String srcID = srcHost != null ? srcHost : srcAET;
            msg.addSourceProcess(srcID, new String[]{srcAET}, null, srcHost, true);
            msg.addDestinationProcess(AuditMessage.getProcessID(), this.calledAETs, AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), false);
            msg.addPatient(seriesStored.getPatientID(), StoreScpService.formatPN(seriesStored.getPatientName()));
            String accno = seriesStored.getAccessionNumber();
            Dataset pps = ian.getItem(528657);
            ParticipantObjectDescription desc = new ParticipantObjectDescription();
            if (accno != null && accno.length() != 0) {
                desc.addAccession(accno);
            }
            if (pps != null && (uid = pps.getString(528725)) != null && uid.length() != 0) {
                desc.addMPPS(uid);
            }
            for (String cuid : sorter.getCUIDs(suid)) {
                ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
                sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
                desc.addSOPClass(sopClass);
            }
            msg.addStudy(ian.getString(0x20000D), desc);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    public void importFile(FileDTO fileDTO, Dataset ds, String prevseriuid, boolean last) throws Exception {
        Storage store = this.getStorage();
        String seriuid = ds.getString(0x20000E);
        if (prevseriuid != null && !prevseriuid.equals(seriuid)) {
            this.logInstancesStoredAndSendSeriesStoredNotification(store, prevseriuid);
        }
        String cuid = ds.getString(524310);
        String iuid = ds.getString(524312);
        FileMetaInfo fmi = DcmObjectFactory.getInstance().newFileMetaInfo(cuid, iuid, fileDTO.getFileTsuid());
        ds.setFileMetaInfo(fmi);
        String filePath = fileDTO.getFilePath();
        this.scp.updateDB(store, ds, fileDTO.getFileSystemPk(), filePath, fileDTO.getFileSize(), fileDTO.getFileMd5(), true);
        if (last) {
            this.logInstancesStoredAndSendSeriesStoredNotification(store, seriuid);
        }
    }

    private void logInstancesStoredAndSendSeriesStoredNotification(Storage store, String seriuid) throws FinderException, RemoteException {
        SeriesStored seriesStored = store.makeSeriesStored(seriuid);
        if (seriesStored == null) {
            return;
        }
        this.logInstancesStored(null, seriesStored);
        this.sendSeriesStoredNotification(store, seriesStored);
    }

    public void logInstancesStoredAndUpdateDerivedFields(Storage store, Socket s, SeriesStored seriesStored) throws FinderException, RemoteException {
        this.logInstancesStored(s, seriesStored);
        store.updateDerivedStudyAndSeriesFields(seriesStored.getSeriesInstanceUID());
    }

    public void sendSeriesStoredNotification(Storage store, SeriesStored seriesStored) throws FinderException, RemoteException {
        this.sendJMXNotification(seriesStored);
        store.commitSeriesStored(seriesStored);
    }

    private void sendObjectStoredNotification(Dataset ds) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(EVENT_TYPE_OBJECT_STORED, (Object)this, eventID);
        notif.setUserData(ds);
        super.sendNotification(notif);
    }

    protected void sendNewStudyNotification(Dataset ds) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(EVENT_TYPE_NEW_STUDY, (Object)this, eventID);
        notif.setUserData(ds);
        super.sendNotification(notif);
    }

    private void checkPendingSeriesStored() throws Exception {
        Storage store = this.getStorage();
        Timestamp updatedBefore = new Timestamp(System.currentTimeMillis() - this.seriesStoredNotificationDelay);
        Collection seriesPks = store.getPksOfPendingSeries(updatedBefore);
        for (Long seriesPk : seriesPks) {
            try {
                SeriesStored seriesStored = store.makeSeriesStored(seriesPk, updatedBefore);
                if (seriesStored == null) continue;
                this.sendSeriesStoredNotification(store, seriesStored);
            }
            catch (Exception x) {
                this.log.warn((Object)("makeSeriesStored for series(pk=" + seriesPk + ") failed! Ignored! Reason:" + x));
            }
        }
    }

    Storage getStorage() throws RemoteException, CreateException, HomeFactoryException {
        return ((StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage")).create();
    }

    public List findMWLEntries(Dataset ds) throws Exception {
        ArrayList resp = new ArrayList();
        this.server.invoke(this.mwlScuServiceName, "findMWLEntries", new Object[]{ds, false, resp}, new String[]{Dataset.class.getName(), Boolean.TYPE.getName(), List.class.getName()});
        return resp;
    }

    void preProcess(Dataset ds) throws Exception {
        this.doPreProcess(ds);
    }

    protected void doPreProcess(Dataset ds) throws Exception {
    }

    void postProcess(Dataset ds) throws Exception {
        this.sendObjectStoredNotification(ds);
        this.doPostProcess(ds);
    }

    protected void doPostProcess(Dataset ds) throws Exception {
    }

    void postCoercionProcessing(Dataset ds) throws Exception {
        this.doPostCoercionProcessing(ds);
    }

    protected void doPostCoercionProcessing(Dataset ds) throws Exception {
    }

    String selectFileSystemGroup(String callingAET, String calledAET, Dataset ds) throws Exception {
        String fsgrid;
        AEManager mgr = this.aeMgr();
        try {
            fsgrid = mgr.findByAET(callingAET).getFileSystemGroupID();
            if (fsgrid != null && fsgrid.length() != 0) {
                return fsgrid;
            }
        }
        catch (UnknownAETException e) {
            // empty catch block
        }
        try {
            fsgrid = mgr.findByAET(calledAET).getFileSystemGroupID();
            if (fsgrid != null && fsgrid.length() != 0) {
                return fsgrid;
            }
        }
        catch (UnknownAETException e) {
            // empty catch block
        }
        return this.defFileSystemGroupID;
    }

    boolean isFileSystemGroupLocalAccessable(String fsgrpid) {
        return this.fsmgt.isFileSystemGroupLocalAccessable(fsgrpid);
    }

    void coercePatientID(Dataset ds) throws DcmServiceException {
        if (this.storeOriginalPatientIDInOtherPatientIDsSeq) {
            DcmElement opidsq = ds.get(0x101002);
            if (opidsq == null) {
                opidsq = ds.putSQ(0x101002);
            }
            Dataset opiditem = opidsq.addNewItem();
            opiditem.putLO(0x100020, ds.getString(0x100020));
            opiditem.putLO(0x100021, ds.getString(0x100021));
        }
        if (this.storeOriginalPatientIDInOriginalAttrsSeq) {
            DcmElement originalAttributesSequence = ds.get(67110241);
            if (originalAttributesSequence == null) {
                originalAttributesSequence = ds.putSQ(67110241);
            }
            Dataset oaSeqValues = originalAttributesSequence.addNewItem();
            oaSeqValues.putLO(67110244);
            oaSeqValues.putDT(67110242, new Date());
            oaSeqValues.putLO(67110243, ds.getString(4390933));
            oaSeqValues.putCS(67110245, "CORRECT");
            DcmElement modifiedAttributesSequence = oaSeqValues.putSQ(0x4000550);
            Dataset maSeqValues = modifiedAttributesSequence.addNewItem();
            maSeqValues.putLO(0x100020, ds.getString(0x100020));
            maSeqValues.putLO(0x100021, ds.getString(0x100021));
        }
        String origPatID = ds.getString(0x100020);
        ds.remove(0x100020);
        ds.remove(0x100021);
        ds.setPrivateCreatorID("dcm4che/archive");
        String calledAET = ds.getString(4390933);
        ds.setPrivateCreatorID(null);
        this.generatePatientID(ds, ds, calledAET);
        this.logPatientIDUpdate(origPatID, ds);
    }

    private void logPatientIDUpdate(String origPatID, Dataset ds) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        PatientRecordMessage msg = new PatientRecordMessage(PatientRecordMessage.UPDATE);
        msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
        PersonName pn = ds.getPersonName(0x100010);
        String pname = pn != null ? pn.format() : null;
        ParticipantObject patient = msg.addPatient(origPatID, pname);
        patient.addParticipantObjectDetail("Description", "Conflicting patient record found, assigning generated PatientID " + ds.getString(0x100020));
        msg.validate();
        Logger.getLogger((String)"auditlog").info((Object)msg);
    }
}

