/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.storescp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParseException;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.PatientRecordMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.codec.CodecCmd;
import org.dcm4chex.archive.codec.CompressCmd;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.CompressionRules;
import org.dcm4chex.archive.dcm.storescp.StoreScpService;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.ejb.interfaces.Storage;
import org.dcm4chex.archive.ejb.jdbc.QueryFilesCmd;
import org.dcm4chex.archive.exceptions.NonUniquePatientIDException;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.perf.PerfMonDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

public class StoreScp
extends DcmServiceBase
implements AssociationListener {
    private static final String ALL = "ALL";
    private static final int MISSING_USER_ID_ERR_STATUS = 52752;
    private static final int NO_APPEND_PERMISSION_ERR_STATUS = 52772;
    private static final String MISSING_USER_ID_ERR_MSG = "Missing user identification for appending existing Study";
    private static final String NO_APPEND_PERMISSION_ERR_MSG = "No permission to append existing Study";
    private static final String STORE_XSL = "cstorerq.xsl";
    private static final String STORE_XML = "-cstorerq.xml";
    private static final String MWL2STORE_XSL = "mwl-cfindrsp2cstorerq.xsl";
    private static final String STORE2MWL_XSL = "cstorerq2mwl-cfindrq.xsl";
    private static final String RECEIVE_BUFFER = "RECEIVE_BUFFER";
    private static final String SERIES_STORED = "SERIES_STORED";
    protected final StoreScpService service;
    private final Logger log;
    private boolean studyDateInFilePath = false;
    private boolean sourceAETInFilePath = false;
    private boolean yearInFilePath = true;
    private boolean monthInFilePath = true;
    private boolean dayInFilePath = true;
    private boolean hourInFilePath = false;
    private boolean acceptMissingPatientID = true;
    private boolean acceptMissingPatientName = true;
    private boolean serializeDBUpdate = false;
    private int updateDatabaseMaxRetries = 2;
    private int maxCountUpdateDatabaseRetries = 0;
    private boolean storeDuplicateIfDiffMD5 = true;
    private boolean storeDuplicateIfDiffHost = true;
    private long updateDatabaseRetryInterval = 0L;
    private CompressionRules compressionRules = new CompressionRules("");
    private String[] coerceWarnCallingAETs = new String[0];
    private String[] acceptMismatchIUIDCallingAETs = new String[0];
    private String[] onlyWellKnownInstancesCallingAETs = new String[0];
    private boolean checkIncorrectWorklistEntry = true;
    private String[] referencedDirectoryPath;
    private String[] referencedDirectoryURI;
    private String refFileSystemGroupID;
    private boolean readReferencedFile = true;
    private boolean md5sumReferencedFile = true;
    private boolean coerceBeforeWrite = false;
    protected PerfMonDelegate perfMon;
    private volatile Executor syncFileExecutor;

    public StoreScp(StoreScpService service) {
        this.service = service;
        this.log = service.getLog();
        this.perfMon = new PerfMonDelegate(this.service);
    }

    public final ObjectName getPerfMonServiceName() {
        return this.perfMon.getPerfMonServiceName();
    }

    public final void setPerfMonServiceName(ObjectName perfMonServiceName) {
        this.perfMon.setPerfMonServiceName(perfMonServiceName);
    }

    public final boolean isAcceptMissingPatientID() {
        return this.acceptMissingPatientID;
    }

    public final void setAcceptMissingPatientID(boolean accept) {
        this.acceptMissingPatientID = accept;
    }

    public final boolean isAcceptMissingPatientName() {
        return this.acceptMissingPatientName;
    }

    public final void setAcceptMissingPatientName(boolean accept) {
        this.acceptMissingPatientName = accept;
    }

    public final boolean isSerializeDBUpdate() {
        return this.serializeDBUpdate;
    }

    public final void setSerializeDBUpdate(boolean serialize) {
        this.serializeDBUpdate = serialize;
    }

    public final String getCoerceWarnCallingAETs() {
        return StringUtils.toString(this.coerceWarnCallingAETs, '\\');
    }

    public final void setCoerceWarnCallingAETs(String aets) {
        this.coerceWarnCallingAETs = StringUtils.split(aets, '\\');
    }

    public final String getAcceptMismatchIUIDCallingAETs() {
        return StringUtils.toString(this.acceptMismatchIUIDCallingAETs, '\\');
    }

    public final void setAcceptMismatchIUIDCallingAETs(String aets) {
        this.acceptMismatchIUIDCallingAETs = StringUtils.split(aets, '\\');
    }

    public final String getOnlyWellKnownInstancesCallingAETs() {
        return StringUtils.toString(this.onlyWellKnownInstancesCallingAETs, '\\');
    }

    public final void setOnlyWellKnownInstancesCallingAETs(String aets) {
        this.onlyWellKnownInstancesCallingAETs = StringUtils.split(aets, '\\');
    }

    public final boolean isStudyDateInFilePath() {
        return this.studyDateInFilePath;
    }

    public final void setStudyDateInFilePath(boolean studyDateInFilePath) {
        this.studyDateInFilePath = studyDateInFilePath;
    }

    public final boolean isSourceAETInFilePath() {
        return this.sourceAETInFilePath;
    }

    public final void setSourceAETInFilePath(boolean sourceAETInFilePath) {
        this.sourceAETInFilePath = sourceAETInFilePath;
    }

    public final boolean isYearInFilePath() {
        return this.yearInFilePath;
    }

    public final void setYearInFilePath(boolean yearInFilePath) {
        this.yearInFilePath = yearInFilePath;
    }

    public final boolean isMonthInFilePath() {
        return this.monthInFilePath;
    }

    public final void setMonthInFilePath(boolean monthInFilePath) {
        this.monthInFilePath = monthInFilePath;
    }

    public final boolean isDayInFilePath() {
        return this.dayInFilePath;
    }

    public final void setDayInFilePath(boolean dayInFilePath) {
        this.dayInFilePath = dayInFilePath;
    }

    public final boolean isHourInFilePath() {
        return this.hourInFilePath;
    }

    public final void setHourInFilePath(boolean hourInFilePath) {
        this.hourInFilePath = hourInFilePath;
    }

    public final String getReferencedDirectoryPath() {
        if (this.referencedDirectoryPath == null) {
            return ALL;
        }
        StringBuffer sb = new StringBuffer();
        String nl = System.getProperty("line.separator", "\n");
        for (String s : this.referencedDirectoryPath) {
            sb.append(s).append(nl);
        }
        return sb.toString();
    }

    public final void setReferencedDirectoryPath(String pathOrURI) {
        if (ALL.equals(pathOrURI.trim())) {
            this.referencedDirectoryURI = null;
            this.referencedDirectoryPath = null;
        } else {
            StringTokenizer st = new StringTokenizer(pathOrURI, " \t\r\n;");
            int len = st.countTokens();
            this.referencedDirectoryURI = new String[len];
            this.referencedDirectoryPath = new String[len];
            int i = 0;
            while (st.hasMoreElements()) {
                String trimmed = st.nextToken().trim();
                this.referencedDirectoryURI[i] = StoreScp.isURI(trimmed) ? trimmed + '/' : FileUtils.toFile(trimmed).toURI().toString();
                this.referencedDirectoryPath[i] = trimmed;
                ++i;
            }
        }
    }

    public void setReferencedFileSystemGroupID(String groupID) {
        this.refFileSystemGroupID = groupID;
    }

    public String getReferencedFileSystemGroupID() {
        return this.refFileSystemGroupID;
    }

    private static boolean isURI(String pathOrURI) {
        return pathOrURI.indexOf(58) > 1;
    }

    public final boolean isMd5sumReferencedFile() {
        return this.md5sumReferencedFile;
    }

    public final void setMd5sumReferencedFile(boolean md5ReferencedFile) {
        this.md5sumReferencedFile = md5ReferencedFile;
    }

    public final boolean isCoerceBeforeWrite() {
        return this.coerceBeforeWrite;
    }

    public final void setCoerceBeforeWrite(boolean coerceBeforeWrite) {
        this.coerceBeforeWrite = coerceBeforeWrite;
    }

    public final boolean isReadReferencedFile() {
        return this.readReferencedFile;
    }

    public final void setReadReferencedFile(boolean readReferencedFile) {
        this.readReferencedFile = readReferencedFile;
    }

    public final boolean isStoreDuplicateIfDiffHost() {
        return this.storeDuplicateIfDiffHost;
    }

    public final void setStoreDuplicateIfDiffHost(boolean storeDuplicate) {
        this.storeDuplicateIfDiffHost = storeDuplicate;
    }

    public final boolean isStoreDuplicateIfDiffMD5() {
        return this.storeDuplicateIfDiffMD5;
    }

    public final void setStoreDuplicateIfDiffMD5(boolean storeDuplicate) {
        this.storeDuplicateIfDiffMD5 = storeDuplicate;
    }

    public final CompressionRules getCompressionRules() {
        return this.compressionRules;
    }

    public final void setCompressionRules(CompressionRules compressionRules) {
        this.compressionRules = compressionRules;
    }

    public final int getUpdateDatabaseMaxRetries() {
        return this.updateDatabaseMaxRetries;
    }

    public final void setUpdateDatabaseMaxRetries(int updateDatabaseMaxRetries) {
        this.updateDatabaseMaxRetries = updateDatabaseMaxRetries;
    }

    public final int getMaxCountUpdateDatabaseRetries() {
        return this.maxCountUpdateDatabaseRetries;
    }

    public final void setMaxCountUpdateDatabaseRetries(int count) {
        this.maxCountUpdateDatabaseRetries = count;
    }

    public final long getUpdateDatabaseRetryInterval() {
        return this.updateDatabaseRetryInterval;
    }

    public final void setUpdateDatabaseRetryInterval(long interval) {
        this.updateDatabaseRetryInterval = interval;
    }

    public boolean isCheckIncorrectWorklistEntry() {
        return this.checkIncorrectWorklistEntry;
    }

    public void setCheckIncorrectWorklistEntry(boolean checkIncorrectWorklistEntry) {
        this.checkIncorrectWorklistEntry = checkIncorrectWorklistEntry;
    }

    protected void doCStore(ActiveAssociation activeAssoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        InputStream in = rq.getDataAsStream();
        this.perfMon.start(activeAssoc, rq, 1);
        this.perfMon.setProperty(activeAssoc, rq, 1, rq);
        DcmEncodeParam decParam = DcmDecodeParam.valueOf(rq.getTransferSyntaxUID());
        Dataset ds = objFact.newDataset();
        DcmParser parser = DcmParserFactory.getInstance().newDcmParser(in);
        try {
            parser.setMaxValueLength(this.service.getMaxValueLength());
            parser.setDcmHandler(ds.getDcmHandler());
            parser.parseDataset(decParam, 2145386512);
            if (!parser.hasSeenEOF() && parser.getReadTag() != 2145386512) {
                parser.unreadHeader();
                parser.parseDataset(decParam, -1);
            }
            this.doActualCStore(activeAssoc, rq, rspCmd, ds, parser);
        }
        catch (DcmParseException x) {
            throw new DcmServiceException(272, x.getMessage(), x);
        }
        this.perfMon.stop(activeAssoc, rq, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doActualCStore(ActiveAssociation activeAssoc, Dimse rq, Command rspCmd, Dataset ds, DcmParser parser) throws IOException, DcmServiceException {
        File file = null;
        boolean dcm4cheeURIReferenced = rq.getTransferSyntaxUID().equals("1.2.40.0.13.1.1.2.4.94");
        try {
            Dataset coercedElements;
            String availability;
            String retrieveAET;
            Command rqCmd = rq.getCommand();
            Association assoc = activeAssoc.getAssociation();
            String callingAET = assoc.getCallingAET();
            String calledAET = assoc.getCalledAET();
            String iuid = this.checkSOPInstanceUID(rqCmd, ds, callingAET);
            this.checkAppendPermission(assoc, ds);
            if (!this.checkOnlyWellKnownInstances(assoc, iuid, callingAET)) {
                this.log.info((Object)("StoreSCP only accepts well known instances from AE " + callingAET + " ! Ignored Instance:" + iuid));
                return;
            }
            List duplicates = new QueryFilesCmd(iuid).getFileDTOs();
            if (!(duplicates.isEmpty() || this.storeDuplicateIfDiffMD5 || this.storeDuplicateIfDiffHost && !this.containsLocal(duplicates))) {
                this.log.info((Object)("Received Instance[uid=" + iuid + "] already exists - ignored"));
                return;
            }
            this.service.preProcess(ds);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Dataset:\n");
                this.log.debug((Object)ds);
            }
            this.perfMon.setProperty(activeAssoc, rq, 2, ds);
            this.service.logDIMSE(assoc, STORE_XML, ds);
            if (this.isCheckIncorrectWorklistEntry() && this.checkIncorrectWorklistEntry(ds)) {
                this.log.info((Object)("Received Instance[uid=" + iuid + "] ignored! Reason: Incorrect Worklist entry selected!"));
                return;
            }
            FileSystemDTO fsDTO = null;
            String filePath = null;
            byte[] md5sum = null;
            Dataset coerced = this.service.getCoercionAttributesFor(callingAET, STORE_XSL, ds, assoc);
            if (this.coerceBeforeWrite) {
                ds.setPrivateCreatorID("dcm4che/archive");
                ds.putAE(4390932, callingAET);
                ds.putAE(4390933, calledAET);
                ds.setPrivateCreatorID(null);
                if (coerced != null) {
                    this.service.coerceAttributes(ds, coerced);
                }
                this.service.postCoercionProcessing(ds);
            }
            if (dcm4cheeURIReferenced) {
                String uri = ds.getString(4251664);
                if (uri == null) {
                    retrieveAET = ds.getString(524372);
                    availability = ds.getString(524374);
                    if (retrieveAET == null || availability == null) {
                        throw new DcmServiceException(43264, "Missing (0040,E010) Retrieve URI - required for Dcm4che Retrieve URI Transfer Syntax");
                    }
                } else {
                    String[] selected = this.selectReferencedDirectoryURI(uri);
                    if (selected == null) {
                        throw new DcmServiceException(43264, "(0040,E010) Retrieve URI: " + uri + " does not match with configured Referenced Directory Path: " + this.getReferencedDirectoryPath());
                    }
                    filePath = uri.substring(selected[1].length());
                    if (uri.startsWith("file:/") && !(file = new File(new URI(uri))).isFile()) {
                        throw new DcmServiceException(272, "File referenced by (0040,E010) Retrieve URI: " + uri + " not found!");
                    }
                    fsDTO = this.getFileSystemMgt().getFileSystemOfGroup(this.refFileSystemGroupID, selected[0].startsWith("file:") ? new URI(selected[0]).getPath() : selected[0]);
                    retrieveAET = fsDTO.getRetrieveAET();
                    availability = Availability.toString(fsDTO.getAvailability());
                    if (file != null && this.readReferencedFile) {
                        this.log.info((Object)("M-READ " + file));
                        Dataset fileDS = objFact.newDataset();
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            if (this.md5sumReferencedFile) {
                                MessageDigest digest = MessageDigest.getInstance("MD5");
                                DigestInputStream dis = new DigestInputStream(fis, digest);
                                BufferedInputStream bis = new BufferedInputStream(dis);
                                fileDS.readFile(bis, null, 2145386512);
                                byte[] buf = this.getByteBuffer(assoc);
                                while (bis.read(buf) != -1) {
                                }
                                md5sum = digest.digest();
                            } else {
                                BufferedInputStream bis = new BufferedInputStream(fis);
                                fileDS.readFile(bis, null, 2145386512);
                            }
                            Object var29_34 = null;
                        }
                        catch (Throwable throwable) {
                            Object var29_35 = null;
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                        fileDS.putAll(ds, 0);
                        ds = fileDS;
                    }
                }
                if (ds.getFileMetaInfo() == null) {
                    ds.setPrivateCreatorID("dcm4che/archive");
                    String tsuid = ds.getString(0x430030, "1.2.840.10008.1.2");
                    ds.setPrivateCreatorID(null);
                    ds.setFileMetaInfo(objFact.newFileMetaInfo(rqCmd.getAffectedSOPClassUID(), rqCmd.getAffectedSOPInstanceUID(), tsuid));
                }
            } else {
                String fsgrpid = this.service.selectFileSystemGroup(callingAET, calledAET, ds);
                fsDTO = this.service.selectStorageFileSystem(fsgrpid);
                retrieveAET = fsDTO.getRetrieveAET();
                availability = Availability.toString(fsDTO.getAvailability());
                File baseDir = FileUtils.toFile(fsDTO.getDirectoryPath());
                file = this.makeFile(baseDir, ds, callingAET);
                filePath = file.getPath().substring(baseDir.getPath().length() + 1).replace(File.separatorChar, '/');
                CodecCmd compressCmd = null;
                if (parser.getReadTag() == 2145386512 && parser.getReadLength() != -1 && (compressCmd = this.compressionRules.getCompressFor(assoc, ds)) != null) {
                    ((CompressCmd)compressCmd).coerceDataset(ds);
                }
                ds.setFileMetaInfo(objFact.newFileMetaInfo(ds, compressCmd != null ? compressCmd.getTransferSyntaxUID() : rq.getTransferSyntaxUID()));
                this.perfMon.start(activeAssoc, rq, 2);
                this.perfMon.setProperty(activeAssoc, rq, 3, file);
                md5sum = this.storeToFile(parser, ds, file, (CompressCmd)compressCmd, this.getByteBuffer(assoc));
                this.perfMon.stop(activeAssoc, rq, 2);
            }
            if (md5sum != null && this.ignoreDuplicate(duplicates, md5sum)) {
                this.log.info((Object)("Received Instance[uid=" + iuid + "] already exists - ignored"));
                if (!dcm4cheeURIReferenced) {
                    this.deleteFailedStorage(file);
                }
                return;
            }
            ds.putAE(524372, retrieveAET);
            if (!this.coerceBeforeWrite) {
                ds.setPrivateCreatorID("dcm4che/archive");
                ds.putAE(4390932, callingAET);
                ds.putAE(4390933, calledAET);
                ds.setPrivateCreatorID(null);
                if (coerced != null) {
                    this.service.coerceAttributes(ds, coerced);
                }
                this.service.postCoercionProcessing(ds);
            }
            this.checkPatientIdAndName(ds, callingAET);
            Storage store = this.getStorage(assoc);
            SeriesStored seriesStored = this.handleSeriesStored(assoc, store, ds);
            boolean newSeries = seriesStored == null;
            boolean newStudy = false;
            String seriuid = ds.getString(0x20000E);
            if (newSeries) {
                Dataset mwlFilter = this.service.getCoercionAttributesFor(callingAET, STORE2MWL_XSL, ds, assoc);
                if (mwlFilter != null) {
                    coerced = this.merge(coerced, this.mergeMatchingMWLItem(assoc, ds, seriuid, mwlFilter));
                }
                if (!callingAET.equals(calledAET)) {
                    this.service.ignorePatientIDForUnscheduled(ds, 4194933, callingAET);
                    this.service.supplementIssuerOfPatientID(ds, assoc, callingAET, false);
                    this.service.supplementIssuerOfAccessionNumber(ds, assoc, callingAET, false);
                    this.service.supplementInstitutionalData(ds, assoc, callingAET);
                    this.service.generatePatientID(ds, ds, calledAET);
                }
                newStudy = !store.studyExists(ds.getString(0x20000D));
            }
            this.perfMon.start(activeAssoc, rq, 3);
            long fileLength = file != null ? file.length() : 0L;
            long fspk = fsDTO != null ? fsDTO.getPk() : -1L;
            try {
                coercedElements = this.updateDB(store, ds, fspk, filePath, fileLength, md5sum, newSeries);
            }
            catch (NonUniquePatientIDException e) {
                this.service.coercePatientID(ds);
                coerced.putLO(0x100020, ds.getString(0x100020));
                coerced.putLO(0x100021, ds.getString(0x100021));
                coercedElements = this.updateDB(store, ds, fspk, filePath, fileLength, md5sum, newSeries);
            }
            if (newSeries) {
                seriesStored = this.initSeriesStored(ds, callingAET, retrieveAET);
                assoc.putProperty(SERIES_STORED, seriesStored);
                if (newStudy) {
                    this.service.sendNewStudyNotification(ds);
                }
            }
            this.appendInstanceToSeriesStored(seriesStored, ds, retrieveAET, availability);
            coerced = this.merge(coerced, coercedElements);
            try {
                this.logCoercion(ds, coerced);
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to generate audit log for attribute coercion:", (Throwable)e);
            }
            ds.putAll(coercedElements, 2);
            this.perfMon.setProperty(activeAssoc, rq, 2, ds);
            this.perfMon.stop(activeAssoc, rq, 3);
            if (coerced.isEmpty() || !this.contains(this.coerceWarnCallingAETs, callingAET)) {
                rspCmd.putUS(2304, 0);
            } else {
                int[] coercedTags = new int[coerced.size()];
                Iterator it = coerced.iterator();
                for (int i = 0; i < coercedTags.length; ++i) {
                    coercedTags[i] = ((DcmElement)it.next()).tag();
                }
                rspCmd.putAT(2305, coercedTags);
                rspCmd.putUS(2304, 45056);
            }
            this.service.postProcess(ds);
        }
        catch (DcmServiceException e) {
            this.log.warn((Object)e.getMessage(), (Throwable)e);
            if (!dcm4cheeURIReferenced) {
                this.deleteFailedStorage(file);
            }
            throw e;
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            if (!dcm4cheeURIReferenced) {
                this.deleteFailedStorage(file);
            }
            throw new DcmServiceException(272, e);
        }
    }

    protected SeriesStored handleSeriesStored(Association assoc, Storage store, Dataset ds) throws FinderException, RemoteException, Exception {
        String seriuid = ds.getString(0x20000E);
        SeriesStored seriesStored = (SeriesStored)assoc.getProperty(SERIES_STORED);
        if (seriesStored != null && !seriuid.equals(seriesStored.getSeriesInstanceUID())) {
            this.service.logInstancesStoredAndUpdateDerivedFields(store, assoc.getSocket(), seriesStored);
            this.doAfterSeriesIsStored(store, assoc, seriesStored);
            seriesStored = null;
        }
        return seriesStored;
    }

    private void logCoercion(Dataset ds, Dataset coerced) {
        if (coerced.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = coerced.iterator();
        while (i.hasNext()) {
            String coercedValue;
            String originalValue;
            DcmElement coercedElement = (DcmElement)i.next();
            DcmElement originalElement = ds.get(coercedElement.tag());
            if (originalElement == null || (originalValue = originalElement.toString()).equals(coercedValue = coercedElement.toString())) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(" [");
            sb.append(originalValue);
            sb.append("->");
            sb.append(coercedValue);
            sb.append("]");
        }
        if (sb.length() > 0) {
            sb.insert(0, "The following elements were coerced during storage: ");
            HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
            PatientRecordMessage msg = new PatientRecordMessage(PatientRecordMessage.UPDATE);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            PersonName pn = ds.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            ParticipantObject patient = msg.addPatient(ds.getString(0x100020, "NO_PATIENT_ID"), pname);
            patient.addParticipantObjectDetail("Description", sb.toString());
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
    }

    private String[] selectReferencedDirectoryURI(String uri) {
        if (this.referencedDirectoryPath == null) {
            this.log.debug((Object)("ReferencedDirectoryPath is set to ALL! uri:" + uri));
            try {
                FileSystemDTO[] fsDTOs;
                for (FileSystemDTO dto : fsDTOs = this.getFileSystemMgt().getFileSystemsOfGroup(this.refFileSystemGroupID)) {
                    String dir = dto.getDirectoryPath();
                    String fsUri = StoreScp.isURI(dir) ? dir + "/" : FileUtils.toFile(dir).toURI().toString();
                    this.log.debug((Object)("Filesystem URI:" + fsUri));
                    if (!uri.startsWith(fsUri)) continue;
                    return new String[]{dir, fsUri};
                }
            }
            catch (Exception x) {
                this.log.error((Object)"Can't get FilesystemMgt Bean!", (Throwable)x);
            }
        } else {
            for (int i = 0; i < this.referencedDirectoryURI.length; ++i) {
                if (!uri.startsWith(this.referencedDirectoryURI[i])) continue;
                return new String[]{this.referencedDirectoryPath[i], this.referencedDirectoryURI[i]};
            }
        }
        return null;
    }

    private SeriesStored initSeriesStored(Dataset ds, String callingAET, String retrieveAET) {
        Dataset patAttrs = AttributeFilter.getPatientAttributeFilter().filter(ds);
        Dataset studyAttrs = AttributeFilter.getStudyAttributeFilter().filter(ds);
        Dataset seriesAttrs = AttributeFilter.getSeriesAttributeFilter().filter(ds);
        Dataset ian = DcmObjectFactory.getInstance().newDataset();
        ian.putUI(0x20000D, ds.getString(0x20000D));
        Dataset refSeries = ian.putSQ(528661).addNewItem();
        refSeries.putUI(0x20000E, ds.getString(0x20000E));
        refSeries.putSQ(528793);
        Dataset pps = seriesAttrs.getItem(528657);
        DcmElement refPPSSeq = ian.putSQ(528657);
        if (pps != null) {
            if (!pps.contains(4210713)) {
                pps.putSQ(4210713);
            }
            refPPSSeq.addItem(pps);
        }
        return new SeriesStored(callingAET, retrieveAET, patAttrs, studyAttrs, seriesAttrs, ian);
    }

    private void appendInstanceToSeriesStored(SeriesStored seriesStored, Dataset ds, String retrieveAET, String availability) {
        Dataset refSOP = seriesStored.getIAN().get(528661).getItem().get(528793).addNewItem();
        refSOP.putUI(528720, ds.getString(524310));
        refSOP.putUI(528725, ds.getString(524312));
        refSOP.putAE(524372, retrieveAET);
        refSOP.putCS(524374, availability);
    }

    private void checkAppendPermission(Association a, Dataset ds) throws Exception {
        if (this.service.hasUnrestrictedAppendPermissions(a.getCallingAET())) {
            return;
        }
        String seriuid = ds.getString(0x20000E);
        SeriesStored seriesStored = (SeriesStored)a.getProperty(SERIES_STORED);
        if (seriesStored != null && seriuid.equals(seriesStored.getSeriesInstanceUID())) {
            return;
        }
        String suid = ds.getString(0x20000D);
        if (!this.getStorage(a).studyExists(suid)) {
            return;
        }
        Subject subject = (Subject)a.getProperty("user");
        if (subject == null) {
            throw new DcmServiceException(52752, MISSING_USER_ID_ERR_MSG);
        }
        if (!this.service.getStudyPermissionManager(a).hasPermission(suid, "A", subject)) {
            throw new DcmServiceException(52772, NO_APPEND_PERMISSION_ERR_MSG);
        }
    }

    private boolean checkOnlyWellKnownInstances(Association assoc, String iuid, String callingAET) throws Exception {
        if (this.contains(this.onlyWellKnownInstancesCallingAETs, callingAET)) {
            return this.getStorage(assoc).instanceExists(iuid);
        }
        return true;
    }

    private Dataset merge(Dataset ds, Dataset merge) {
        if (ds == null) {
            return merge;
        }
        if (merge == null) {
            return ds;
        }
        ds.putAll(merge, 2);
        return ds;
    }

    private Dataset mergeMatchingMWLItem(Association assoc, Dataset ds, String seriuid, Dataset mwlFilter) {
        List mwlItems;
        this.log.info((Object)("Query for matching worklist entries for received Series[" + seriuid + "]"));
        try {
            mwlItems = this.service.findMWLEntries(mwlFilter);
        }
        catch (Exception e) {
            this.log.error((Object)("Query for matching worklist entries for received Series[" + seriuid + "] failed:"), (Throwable)e);
            return null;
        }
        int size = mwlItems.size();
        this.log.info((Object)("" + size + " matching worklist entries found for received Series[ " + seriuid + "]"));
        if (size == 0) {
            return null;
        }
        String callingAET = assoc.getCallingAET();
        Dataset coerce = this.service.getCoercionAttributesFor(callingAET, MWL2STORE_XSL, (Dataset)mwlItems.get(0), assoc);
        if (coerce == null) {
            this.log.error((Object)("Failed to find or load stylesheet mwl-cfindrsp2cstorerq.xsl for " + callingAET + ". Cannot coerce object attributes with request information."));
            return null;
        }
        if (size > 1) {
            DcmElement rqAttrsSq = coerce.get(4194933);
            Dataset coerce0 = coerce.exclude(new int[]{4194933});
            for (int i = 1; i < size; ++i) {
                Dataset item;
                Dataset coerce1 = this.service.getCoercionAttributesFor(callingAET, MWL2STORE_XSL, (Dataset)mwlItems.get(i), assoc);
                if (!coerce1.match(coerce0, true, true)) {
                    this.log.warn((Object)("Several (" + size + ") matching worklist entries " + "found for received Series[ " + seriuid + "], which differs also in attributes NOT mapped to the Request Attribute Sequence item " + "- Do not coerce object attributes with request information."));
                    return null;
                }
                if (rqAttrsSq == null || (item = coerce1.getItem(4194933)) == null) continue;
                rqAttrsSq.addItem(item);
            }
        }
        this.service.coerceAttributes(ds, coerce);
        return coerce;
    }

    private boolean checkIncorrectWorklistEntry(Dataset ds) throws Exception {
        Dataset mpps;
        Dataset refPPS = ds.getItem(528657);
        if (refPPS == null) {
            return false;
        }
        String ppsUID = refPPS.getString(528725);
        if (ppsUID == null) {
            return false;
        }
        try {
            mpps = this.getMPPSManager().getMPPS(ppsUID);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        Dataset item = mpps.getItem(4194945);
        return item != null && "110514".equals(item.getString(524544)) && "DCM".equals(item.getString(524546));
    }

    private MPPSManager getMPPSManager() throws CreateException, RemoteException, HomeFactoryException {
        return ((MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager")).create();
    }

    private FileSystemMgt2 getFileSystemMgt() throws RemoteException, CreateException, HomeFactoryException {
        return ((FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2")).create();
    }

    private byte[] getByteBuffer(Association assoc) {
        byte[] buf = (byte[])assoc.getProperty(RECEIVE_BUFFER);
        if (buf == null) {
            buf = new byte[this.service.getBufferSize()];
            assoc.putProperty(RECEIVE_BUFFER, buf);
        }
        return buf;
    }

    private boolean containsLocal(List duplicates) {
        int n = duplicates.size();
        for (int i = 0; i < n; ++i) {
            FileDTO dto = (FileDTO)duplicates.get(i);
            if (!this.service.isFileSystemGroupLocalAccessable(dto.getFileSystemGroupID())) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDuplicate(List duplicates, byte[] md5sum) {
        int n = duplicates.size();
        for (int i = 0; i < n; ++i) {
            FileDTO dto = (FileDTO)duplicates.get(i);
            if (this.storeDuplicateIfDiffMD5 && !Arrays.equals(md5sum, dto.getFileMd5()) || this.storeDuplicateIfDiffHost && !this.service.isFileSystemGroupLocalAccessable(dto.getFileSystemGroupID())) continue;
            return true;
        }
        return false;
    }

    private void deleteFailedStorage(File file) {
        if (file == null) {
            return;
        }
        this.log.info((Object)("M-DELETE file:" + file));
        file.delete();
        File seriesDir = file.getParentFile();
        if (seriesDir.delete()) {
            seriesDir.getParentFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dataset updateDB(Storage storage, Dataset ds, long fspk, String filePath, long fileLength, byte[] md5, boolean updateStudyAccessTime) throws DcmServiceException, NonUniquePatientIDException {
        int retry = 0;
        while (true) {
            try {
                if (this.serializeDBUpdate) {
                    Storage storage2 = storage;
                    synchronized (storage2) {
                        return storage.store(ds, fspk, filePath, fileLength, md5, updateStudyAccessTime, this.service.patientMatching());
                    }
                }
                return storage.store(ds, fspk, filePath, fileLength, md5, updateStudyAccessTime, this.service.patientMatching());
            }
            catch (NonUniquePatientIDException e) {
                throw e;
            }
            catch (Exception e) {
                if (++retry > this.updateDatabaseMaxRetries) {
                    this.service.getLog().error((Object)("failed to update DB with entries for received " + filePath), (Throwable)e);
                    throw new DcmServiceException(272, (Throwable)e);
                }
                this.maxCountUpdateDatabaseRetries = Math.max(retry, this.maxCountUpdateDatabaseRetries);
                this.service.getLog().warn((Object)("failed to update DB with entries for received " + filePath + " - retry"), (Throwable)e);
                try {
                    Thread.sleep(this.updateDatabaseRetryInterval);
                    continue;
                }
                catch (InterruptedException e1) {
                    this.log.warn((Object)"update Database Retry Interval interrupted:", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }

    Storage getStorage(Association assoc) throws RemoteException, CreateException, HomeFactoryException {
        Storage store = (Storage)assoc.getProperty("ejb/Storage");
        if (store == null) {
            store = this.service.getStorage();
            assoc.putProperty("ejb/Storage", store);
        }
        return store;
    }

    File makeFile(File basedir, Dataset ds, String callingAET) throws Exception {
        Date studyDate;
        Calendar date = Calendar.getInstance();
        StringBuffer filePath = new StringBuffer();
        if (this.sourceAETInFilePath && callingAET != null) {
            filePath.append(callingAET);
            filePath.append(File.separatorChar);
        }
        if (this.studyDateInFilePath && (studyDate = ds.getDateTime(524320, 524336)) != null) {
            date.setTime(studyDate);
        }
        if (this.yearInFilePath) {
            filePath.append(String.valueOf(date.get(1)));
            filePath.append(File.separatorChar);
        }
        if (this.monthInFilePath) {
            filePath.append(String.valueOf(date.get(2) + 1));
            filePath.append(File.separatorChar);
        }
        if (this.dayInFilePath) {
            filePath.append(String.valueOf(date.get(5)));
            filePath.append(File.separatorChar);
        }
        if (this.hourInFilePath) {
            filePath.append(String.valueOf(date.get(11)));
            filePath.append(File.separatorChar);
        }
        filePath.append(FileUtils.toHex(ds.getString(0x20000D).hashCode()));
        filePath.append(File.separatorChar);
        filePath.append(FileUtils.toHex(ds.getString(0x20000E).hashCode()));
        File dir = new File(basedir, filePath.toString());
        return FileUtils.createNewFile(dir, ds.getString(524312).hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] storeToFile(DcmParser parser, Dataset ds, final File file, CompressCmd compressCmd, byte[] buffer) throws Exception {
        MessageDigest md;
        block16: {
            this.log.info((Object)("M-WRITE file:" + file));
            md = null;
            BufferedOutputStream bos = null;
            FileOutputStream fos = new FileOutputStream(file);
            if (this.service.isMd5sum()) {
                md = MessageDigest.getInstance("MD5");
                DigestOutputStream dos = new DigestOutputStream(fos, md);
                bos = new BufferedOutputStream(dos, buffer);
            } else {
                bos = new BufferedOutputStream(fos, buffer);
            }
            try {
                DcmDecodeParam decParam = parser.getDcmDecodeParam();
                String tsuid = ds.getFileMetaInfo().getTransferSyntaxUID();
                DcmEncodeParam encParam = DcmEncodeParam.valueOf(tsuid);
                ds.writeFile(bos, encParam);
                if (parser.getReadTag() == 2145386512) {
                    int len = parser.getReadLength();
                    InputStream in = parser.getInputStream();
                    if (encParam.encapsulated) {
                        ds.writeHeader(bos, encParam, 2145386512, 20290, -1);
                        if (decParam.encapsulated) {
                            parser.parseHeader();
                            while (parser.getReadTag() == -73728) {
                                len = parser.getReadLength();
                                ds.writeHeader(bos, encParam, -73728, 0, len);
                                bos.copyFrom(in, len);
                                parser.parseHeader();
                            }
                        } else {
                            int read = compressCmd.compress(decParam.byteOrder, parser.getInputStream(), bos, null);
                            StoreScp.skipFully(in, parser.getReadLength() - read);
                        }
                        ds.writeHeader(bos, encParam, -73507, 0, 0);
                    } else {
                        ds.writeHeader(bos, encParam, 2145386512, parser.getReadVR(), len);
                        bos.copyFrom(in, len);
                    }
                    parser.parseDataset(decParam, -1);
                    ds.subSet(2145386512, -1).writeDataset(bos, encParam);
                }
                bos.flush();
                if (this.service.isSyncFileBeforeCStoreRSP()) {
                    fos.getFD().sync();
                } else if (this.service.isSyncFileAfterCStoreRSP()) {
                    final FileOutputStream fos2 = fos;
                    this.syncFileExecutor().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        public void run() {
                            block8: {
                                fos2.getFD().sync();
                                Object var3_1 = null;
                                try {
                                    fos2.close();
                                }
                                catch (Exception ignore) {}
                                break block8;
                                {
                                    catch (Exception e) {
                                        StoreScp.this.log.error((Object)("sync of " + file + " failed:"), (Throwable)e);
                                        Object var3_2 = null;
                                        try {
                                            fos2.close();
                                        }
                                        catch (Exception ignore) {}
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var3_3 = null;
                                    try {
                                        fos2.close();
                                    }
                                    catch (Exception ignore) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    });
                    fos = null;
                }
                Object var16_16 = null;
                if (fos == null) break block16;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            fos.close();
        }
        if (md == null) return null;
        byte[] byArray = md.digest();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Executor syncFileExecutor() {
        Executor result = this.syncFileExecutor;
        if (result == null) {
            StoreScp storeScp = this;
            synchronized (storeScp) {
                result = this.syncFileExecutor;
                if (result == null) {
                    this.syncFileExecutor = result = Executors.newSingleThreadExecutor();
                }
            }
        }
        return result;
    }

    private static void skipFully(InputStream in, int n) throws IOException {
        int skipped = 0;
        for (int remaining = n; remaining > 0; remaining -= skipped) {
            skipped = (int)in.skip(remaining);
            if (skipped != 0) continue;
            throw new EOFException();
        }
    }

    private String checkSOPInstanceUID(Command rqCmd, Dataset ds, String aet) throws DcmServiceException {
        String cuid = StoreScp.checkNotNull(ds.getString(524310), "Missing SOP Class UID (0008,0016)");
        String iuid = StoreScp.checkNotNull(ds.getString(524312), "Missing SOP Instance UID (0008,0018)");
        StoreScp.checkNotNull(ds.getString(0x20000D), "Missing Study Instance UID (0020,000D)");
        StoreScp.checkNotNull(ds.getString(0x20000E), "Missing Series Instance UID (0020,000E)");
        if (!rqCmd.getAffectedSOPInstanceUID().equals(iuid)) {
            String prompt = "SOP Instance UID in Dataset [" + iuid + "] differs from Affected SOP Instance UID[" + rqCmd.getAffectedSOPInstanceUID() + "]";
            this.log.warn((Object)prompt);
            if (!this.contains(this.acceptMismatchIUIDCallingAETs, aet)) {
                throw new DcmServiceException(43264, prompt);
            }
        }
        if (!rqCmd.getAffectedSOPClassUID().equals(cuid)) {
            throw new DcmServiceException(43264, "SOP Class UID in Dataset differs from Affected SOP Class UID");
        }
        return iuid;
    }

    private static String checkNotNull(String val, String msg) throws DcmServiceException {
        if (val == null) {
            throw new DcmServiceException(43264, msg);
        }
        return val;
    }

    private void checkPatientIdAndName(Dataset ds, String aet) throws DcmServiceException, HomeFactoryException, RemoteException, CreateException, FinderException {
        String pid = ds.getString(0x100020);
        String pname = ds.getString(0x100010);
        if (pid == null && !this.acceptMissingPatientID) {
            throw new DcmServiceException(43264, "Acceptance of objects without Patient ID is disabled");
        }
        if (pname == null && !this.acceptMissingPatientName) {
            throw new DcmServiceException(43264, "Acceptance of objects without Patient Name is disabled");
        }
    }

    private boolean contains(Object[] a, Object e) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(e)) continue;
            return true;
        }
        return false;
    }

    public void write(Association src, PDU pdu) {
        if (pdu instanceof AAssociateAC) {
            this.perfMon.assocEstEnd(src, 1);
        }
    }

    public void received(Association src, PDU pdu) {
        if (pdu instanceof AAssociateRQ) {
            this.perfMon.assocEstStart(src, 1);
        }
    }

    public void write(Association src, Dimse dimse) {
    }

    public void received(Association src, Dimse dimse) {
    }

    public void error(Association src, IOException ioe) {
    }

    public void closing(Association assoc) {
        SeriesStored seriesStored;
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelStart(assoc, 1);
        }
        if ((seriesStored = (SeriesStored)assoc.getProperty(SERIES_STORED)) != null) {
            try {
                Storage store = this.getStorage(assoc);
                this.service.logInstancesStoredAndUpdateDerivedFields(store, assoc.getSocket(), seriesStored);
                this.doAfterSeriesIsStored(store, assoc, seriesStored);
            }
            catch (Exception e) {
                this.handleClosingFailed(e);
            }
        }
    }

    protected void handleClosingFailed(Exception e) {
        this.log.error((Object)"Clean up on Association close failed:", (Throwable)e);
    }

    public void closed(Association assoc) {
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelEnd(assoc, 1);
        }
    }

    protected void doAfterSeriesIsStored(Storage store, Association assoc, SeriesStored seriesStored) throws Exception {
    }
}

