/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stgcmt;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.JMException;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.RoleSelection;
import org.dcm4che.util.UIDGenerator;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.stgcmt.StgCmtOrder;
import org.dcm4chex.archive.dcm.stgcmt.StgCmtScuScp;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.Storage;
import org.dcm4chex.archive.ejb.interfaces.StorageHome;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;

public class StgCmtScuScpService
extends AbstractScpService
implements MessageListener {
    private static final int MSG_ID = 1;
    private static final int ERR_STGCMT_RJ = -2;
    private static final int ERR_ASSOC_RJ = -1;
    private static final int PCID_STGCMT = 1;
    protected ObjectName queryRetrieveScpServiceName;
    private String queueName = "StgCmtScuScp";
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private RetryIntervalls scuRetryIntervalls = new RetryIntervalls();
    private RetryIntervalls scpRetryIntervalls = new RetryIntervalls();
    private LinkedHashMap<String, String> requestStgCmtFromAETs = new LinkedHashMap();
    private String[] trustStgCmtFromAETs;
    private StgCmtScuScp stgCmtScuScp = new StgCmtScuScp(this);
    private long receiveResultInSameAssocTimeout;
    private int concurrency = 1;
    private int fetchSize;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public String getRequestStgCmtFromAETs() {
        if (this.requestStgCmtFromAETs.isEmpty()) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.requestStgCmtFromAETs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key);
            if (!key.equals(value)) {
                sb.append(':').append(value);
            }
            sb.append('\\');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setRequestStgCmtFromAETs(String aets) {
        this.requestStgCmtFromAETs.clear();
        if (aets != null && aets.length() > 0 && !aets.equalsIgnoreCase("NONE")) {
            String[] a = StringUtils.split(aets, '\\');
            for (int i = 0; i < a.length; ++i) {
                String s = a[i];
                int c = s.indexOf(58);
                if (c == -1) {
                    this.requestStgCmtFromAETs.put(s, s);
                    continue;
                }
                if (c <= 0 || c >= s.length() - 1) continue;
                this.requestStgCmtFromAETs.put(s.substring(0, c), s.substring(c + 1));
            }
        }
    }

    public String getTrustStgCmtFromAETs() {
        return this.trustStgCmtFromAETs == null ? "ANY" : (this.trustStgCmtFromAETs.length == 0 ? "NONE" : StringUtils.toString(this.trustStgCmtFromAETs, '\\'));
    }

    public void setTrustStgCmtFromAETs(String aets) {
        String trim = aets.trim();
        this.trustStgCmtFromAETs = trim.equalsIgnoreCase("ANY") ? null : (trim.equalsIgnoreCase("NONE") ? new String[]{} : StringUtils.split(trim, '\\'));
    }

    boolean trustStgCmtFromAET(String aet) {
        if (this.trustStgCmtFromAETs == null) {
            return true;
        }
        for (String trust : this.trustStgCmtFromAETs) {
            if (!aet.equals(trust)) continue;
            return true;
        }
        return false;
    }

    public final String getScuRetryIntervalls() {
        return this.scuRetryIntervalls.toString();
    }

    public final void setScuRetryIntervalls(String s) {
        this.scuRetryIntervalls = new RetryIntervalls(s);
    }

    public final String getScpRetryIntervalls() {
        return this.scpRetryIntervalls.toString();
    }

    public final void setScpRetryIntervalls(String s) {
        this.scpRetryIntervalls = new RetryIntervalls(s);
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final int getReceiveBufferSize() {
        return this.tlsConfig.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.tlsConfig.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.tlsConfig.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.tlsConfig.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.tlsConfig.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.tlsConfig.setTcpNoDelay(on);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final ObjectName getQueryRetrieveScpServiceName() {
        return this.queryRetrieveScpServiceName;
    }

    public final void setQueryRetrieveScpServiceName(ObjectName name) {
        this.queryRetrieveScpServiceName = name;
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public final void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public final long getReceiveResultInSameAssocTimeout() {
        return this.receiveResultInSameAssocTimeout;
    }

    public final void setReceiveResultInSameAssocTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.receiveResultInSameAssocTimeout = timeout;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.1.20.1", this.stgCmtScuScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.1.20.1");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.1.20.1", StgCmtScuScpService.valuesToStringArray(this.tsuidMap));
        policy.putRoleSelection("1.2.840.10008.1.20.1", true, true);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.1.20.1", null);
        policy.removeRoleSelection("1.2.840.10008.1.20.1");
    }

    boolean isLocalRetrieveAET(String aet) {
        try {
            return (Boolean)this.server.invoke(this.queryRetrieveScpServiceName, "isLocalRetrieveAET", new Object[]{aet}, new String[]{String.class.getName()});
        }
        catch (JMException e) {
            throw new RuntimeException("Failed to invoke isLocalRetrieveAET() on " + this.queryRetrieveScpServiceName, e);
        }
    }

    public int scheduleStgCmtForStudy(String suid, String called, String calling) throws Exception {
        Dataset retrRq = DcmObjectFactory.getInstance().newDataset();
        retrRq.putCS(524370, "STUDY");
        retrRq.putUI(0x20000D, suid);
        return this.scheduleStgCmtForRetrRq(retrRq, called, calling);
    }

    public int scheduleStgCmtForSeries(String suid, String called, String calling) throws Exception {
        Dataset retrRq = DcmObjectFactory.getInstance().newDataset();
        retrRq.putCS(524370, "SERIES");
        retrRq.putUI(0x20000E, suid);
        return this.scheduleStgCmtForRetrRq(retrRq, called, calling);
    }

    private int scheduleStgCmtForRetrRq(Dataset retrRq, String called, String calling) throws Exception {
        if (called == null || called.trim().length() == 0) {
            throw new IllegalArgumentException("Missing CalledAET");
        }
        RetrieveCmd cmd = RetrieveCmd.create((Dataset)retrRq);
        cmd.setFetchSize(this.fetchSize);
        FileInfo[][] fileInfos = cmd.getFileInfos();
        if (fileInfos.length > 0) {
            Dataset actionInfo = DcmObjectFactory.getInstance().newDataset();
            DcmElement refSOPSeq = actionInfo.putSQ(528793);
            for (FileInfo[] fileInfo : fileInfos) {
                Dataset item = refSOPSeq.addNewItem();
                item.putUI(528720, fileInfo[0].sopCUID);
                item.putUI(528725, fileInfo[0].sopIUID);
            }
            this.queueStgCmtOrder(calling, called, actionInfo, false);
        }
        return fileInfos.length;
    }

    public void onInstancesRetrieved(String moveScp, String moveDest, Dataset actionInfo) throws Exception {
        String stgCmtScp;
        if (actionInfo.get(528793).countItems() > 0 && (stgCmtScp = this.requestStgCmtFromAETs.get(moveDest)) != null) {
            this.queueStgCmtOrder(moveScp, stgCmtScp, actionInfo, false);
        }
    }

    void queueStgCmtOrder(String calling, String called, Dataset actionInfo, boolean scpRole) throws Exception {
        if (calling == null || calling.trim().length() == 0) {
            calling = this.calledAETs[0];
        }
        StgCmtOrder order = new StgCmtOrder(calling, called, actionInfo, scpRole);
        order.processOrderProperties(new Object[0]);
        this.jmsDelegate.queue(this.queueName, order, 0, 0L);
    }

    protected void startService() throws Exception {
        super.startService();
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.queueName);
        super.stopService();
    }

    public AEDTO queryAEData(String aet, InetAddress addr) throws DcmServiceException, UnknownAETException {
        try {
            Object o = this.server.invoke(this.aeServiceName, "getAE", new Object[]{aet, addr}, new String[]{String.class.getName(), InetAddress.class.getName()});
            if (o == null) {
                throw new UnknownAETException("Unkown AET: " + aet);
            }
            return (AEDTO)o;
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to query AEData", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                StgCmtOrder order = (StgCmtOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    RetryIntervalls retryIntervalls = order.isScpRole() ? this.scpRetryIntervalls : this.scuRetryIntervalls;
                    long delay = retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    private Dataset commit(StgCmtOrder order) {
        int failureReason = 272;
        Storage storage = null;
        try {
            StorageHome home = (StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage");
            storage = home.create();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to access Storage EJB", (Throwable)e);
        }
        Dataset actionInfo = order.getActionInfo();
        this.log.trace((Object)"StgCmt actionInfo:");
        this.log.trace((Object)actionInfo);
        DcmElement refSOPSeq = actionInfo.get(528793);
        HashMap<String, FileInfo[]> fileInfos = null;
        if (storage != null) {
            try {
                FileInfo[][] aa = ((RetrieveCmd)RetrieveCmd.create((DcmElement)refSOPSeq).setFetchSize(this.fetchSize)).getFileInfos();
                fileInfos = new HashMap<String, FileInfo[]>();
                for (int i = 0; i < aa.length; ++i) {
                    fileInfos.put(aa[i][0].sopIUID, aa[i]);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)"Failed to query DB", (Throwable)e);
            }
        }
        Dataset eventInfo = DcmObjectFactory.getInstance().newDataset();
        eventInfo.putUI(528789, actionInfo.getString(528789));
        DcmElement successSOPSeq = eventInfo.putSQ(528793);
        DcmElement failedSOPSeq = eventInfo.putSQ(528792);
        int n = refSOPSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSOP = refSOPSeq.getItem(i);
            if (storage != null && fileInfos != null && (failureReason = this.commit(storage, refSOP, fileInfos)) == 0) {
                successSOPSeq.addItem(refSOP);
                continue;
            }
            refSOP.putUS(528791, failureReason);
            failedSOPSeq.addItem(refSOP);
        }
        if (failedSOPSeq.isEmpty()) {
            eventInfo.remove(528792);
        }
        return eventInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(StgCmtOrder order) throws Exception {
        PDU ac;
        AEManager aeMgr = this.aeMgr();
        String aet = order.getCalledAET();
        String callingAET = this.getCallingAET(order);
        AEDTO callingAE = aeMgr.findByAET(callingAET);
        AEDTO remoteAE = aeMgr.findByAET(aet);
        Dataset ds = order.isScpRole() ? this.commit(order) : order.getActionInfo();
        AssociationFactory af = AssociationFactory.getInstance();
        Association a = af.newRequestor(this.tlsConfig.createSocket(callingAE, remoteAE));
        a.setAcTimeout(this.acTimeout);
        a.setDimseTimeout(this.dimseTimeout);
        a.setSoCloseDelay(this.soCloseDelay);
        AAssociateRQ rq = af.newAAssociateRQ();
        rq.setCalledAET(aet);
        rq.setCallingAET(callingAET);
        rq.addPresContext(af.newPresContext(1, "1.2.840.10008.1.20.1", StgCmtScuScpService.valuesToStringArray(this.tsuidMap)));
        if (order.isScpRole()) {
            rq.addRoleSelection(af.newRoleSelection("1.2.840.10008.1.20.1", false, true));
        }
        if (!((ac = a.connect(rq)) instanceof AAssociateAC)) {
            throw new DcmServiceException(-1, "Association not accepted by " + aet + ": " + ac);
        }
        ActiveAssociation aa = af.newActiveAssociation(a, null);
        aa.start();
        try {
            if (a.getAcceptedTransferSyntaxUID(1) == null) {
                throw new DcmServiceException(-2, "StgCmt not supported by remote AE: " + aet);
            }
            Command cmd = DcmObjectFactory.getInstance().newCommand();
            if (order.isScpRole()) {
                RoleSelection rs = ((AAssociateAC)ac).getRoleSelection("1.2.840.10008.1.20.1");
                if (rs == null || !rs.scp()) {
                    this.log.warn((Object)("SCU Role of Storage Commitment Service rejected by " + aet + " - try to send N_EVENT_REPORT anyway"));
                }
                cmd.initNEventReportRQ(1, "1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", ds.contains(528792) ? 2 : 1);
                this.invokeDimse(aa, cmd, ds, "StgCmt Result:\n");
            } else {
                cmd.initNActionRQ(1, "1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1);
                ds.putUI(528789, UIDGenerator.getInstance().createUID());
                this.invokeDimse(aa, cmd, ds, "StgCmt Request:\n");
                Thread.sleep(this.receiveResultInSameAssocTimeout);
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
    }

    protected String getCallingAET(StgCmtOrder order) {
        return order.getCallingAET();
    }

    private void invokeDimse(ActiveAssociation aa, Command cmd, Dataset ds, String prompt) throws InterruptedException, IOException, DcmServiceException {
        this.log.debug((Object)prompt);
        this.log.debug((Object)ds);
        AssociationFactory af = AssociationFactory.getInstance();
        Dimse rsp = aa.invoke(af.newDimse(1, cmd, ds)).get();
        Command cmdRsp = rsp.getCommand();
        int status = cmdRsp.getStatus();
        if (status != 0) {
            throw new DcmServiceException(status, cmdRsp.getString(2306));
        }
    }

    private int commit(Storage storage, Dataset refSOP, Map fileInfos) {
        String iuid = refSOP.getString(528725);
        String cuid = refSOP.getString(528720);
        FileInfo[] fileInfo = (FileInfo[])fileInfos.get(iuid);
        if (fileInfo == null) {
            this.log.warn((Object)("Failed Storage Commitment of Instance[uid=" + iuid + "]: no such object"));
            return 274;
        }
        if (!fileInfo[0].sopCUID.equals(cuid)) {
            this.log.warn((Object)("Failed Storage Commitment of Instance[uid=" + iuid + "]: SOP Class in request[" + cuid + "] does not match SOP Class in stored object[" + fileInfo[0].sopCUID + "]"));
            return 281;
        }
        try {
            LinkedHashSet<String> retrieveAETs = new LinkedHashSet<String>();
            for (int i = 0; i < fileInfo.length; ++i) {
                retrieveAETs.add(fileInfo[i].fileRetrieveAET);
                this.checkFile(fileInfo[i]);
            }
            storage.commit(iuid);
            retrieveAETs.add(fileInfo[0].extRetrieveAET);
            retrieveAETs.remove(null);
            if (!retrieveAETs.isEmpty()) {
                refSOP.putAE(524372, retrieveAETs.toArray(new String[retrieveAETs.size()]));
            }
            return 0;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed Storage Commitment of Instance[uid=" + fileInfo[0].sopIUID + "]:"), (Throwable)e);
            return 272;
        }
    }

    private void checkFile(FileInfo info) throws Exception {
        if (this.isLocalRetrieveAET(info.fileRetrieveAET)) {
            FileUtils.verifyMD5(info);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commited(Dataset stgcmtResult) throws DcmServiceException {
        Storage storage = null;
        try {
            try {
                StorageHome home = (StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage");
                storage = home.create();
                storage.commited(stgcmtResult);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed update External AETs in DB records", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
            Object var5_5 = null;
            if (storage == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (storage == null) throw throwable;
            try {
                storage.remove();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        storage.remove();
        return;
    }
}

