/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stgcmt;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.stgcmt.StgCmtScuScpService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.jboss.logging.Logger;

public class StgCmtScuScp
extends DcmServiceBase {
    private static final String RESULT_XSL = "stgcmt-neventreportrq.xsl";
    private final StgCmtScuScpService service;
    private final Logger log;

    public StgCmtScuScp(StgCmtScuScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected Dataset doNAction(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        Dataset data = rq.getDataset();
        this.log.debug((Object)"StgCmt Request:\n");
        this.log.debug((Object)data);
        if (!"1.2.840.10008.1.20.1.1".equals(cmd.getRequestedSOPInstanceUID())) {
            throw new DcmServiceException(274);
        }
        int actionTypeID = cmd.getInt(4104, -1);
        if (actionTypeID != 1) {
            throw new DcmServiceException(291, "ActionTypeID:" + actionTypeID);
        }
        if (!data.containsValue(528789)) {
            throw new DcmServiceException(289, "Missing Transaction UID (0008,1195) in Action Information");
        }
        if (!data.containsValue(528793)) {
            throw new DcmServiceException(289, "Missing Referenced SOP Sequence (0008,1199) in Action Information");
        }
        Association a = assoc.getAssociation();
        String aet = a.getCallingAET();
        try {
            AEDTO aeData = this.service.queryAEData(aet, a.getSocket().getInetAddress());
            this.service.queueStgCmtOrder(a.getCalledAET(), aet, data, true);
        }
        catch (UnknownAETException e) {
            throw new DcmServiceException(43009, aet);
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        return null;
    }

    protected Dataset doNEventReport(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        Dataset data = rq.getDataset();
        this.log.debug((Object)"StgCmt Result:\n");
        this.log.debug((Object)data);
        if (!"1.2.840.10008.1.20.1.1".equals(cmd.getRequestedSOPInstanceUID())) {
            throw new DcmServiceException(274);
        }
        int eventTypeID = cmd.getInt(4098, -1);
        DcmElement refSOPSeq = data.get(528793);
        DcmElement failedSOPSeq = data.get(528792);
        if (eventTypeID == 1) {
            if (refSOPSeq == null) {
                throw new DcmServiceException(289, "Missing Referenced SOP Sequence (0008,1199) in Event Information");
            }
            if (failedSOPSeq != null) {
                throw new DcmServiceException(277, "Unexpected Failed SOP Sequence (0008,1198) in Event Information");
            }
        } else if (eventTypeID == 2) {
            if (failedSOPSeq == null) {
                throw new DcmServiceException(289, "Missing Failed SOP Sequence (0008,1198) in Event Information");
            }
        } else {
            throw new DcmServiceException(275, "EventTypeID:" + eventTypeID);
        }
        if (!data.containsValue(528789)) {
            throw new DcmServiceException(289, "Missing Transaction UID (0008,1195) in Event Information");
        }
        this.checkRefSopSeq(refSOPSeq, false);
        this.checkRefSopSeq(failedSOPSeq, true);
        Association a = assoc.getAssociation();
        String aet = a.getCallingAET();
        if (this.service.trustStgCmtFromAET(aet)) {
            Dataset coerce = this.service.getCoercionAttributesFor(aet, RESULT_XSL, data, a);
            if (coerce != null) {
                this.service.coerceAttributes(data, coerce);
            }
            this.service.commited(data);
        } else {
            this.log.info((Object)("Do not trust Storage Commitment Result received from " + aet));
        }
        return null;
    }

    private void checkRefSopSeq(DcmElement sq, boolean failed) throws DcmServiceException {
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSOP = sq.getItem(i);
            String iuid = refSOP.getString(528725);
            String cuid = refSOP.getString(528720);
            if (iuid == null) {
                throw new DcmServiceException(289, "Missing Ref. SOP Instance UID >(0008,1155) in Item of " + (failed ? "Failed SOP Sequence (0008,1198)" : "Ref. SOP Sequence (0008,1199)"));
            }
            if (cuid == null) {
                throw new DcmServiceException(289, "Missing Ref. SOP Class UID >(0008,1150) in Item of " + (failed ? "Failed SOP Sequence (0008,1198)" : "Ref. SOP Sequence (0008,1199)"));
            }
            if (!failed) continue;
            Integer reason = refSOP.getInteger(528791);
            if (reason == null) {
                throw new DcmServiceException(289, "Missing Failed Reason >(0008,1197) in Item of Failed SOP Sequence (0008,1198)");
            }
            this.log.warn((Object)("Failed Storage Commitment for SOP Instance[iuid=" + iuid + ", cuid=" + cuid + "], reason: " + Integer.toHexString(reason) + "H"));
        }
    }
}

