/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stgcmt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.ejb.jdbc.QueryExternalRetrieveAETsOfSeriesCmd;
import org.jboss.system.ServiceMBeanSupport;

public class StgCmtScuBySeriesStoredService
extends ServiceMBeanSupport {
    private static final String NONE = "NONE";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n");
    protected ObjectName stgCmtServiceName;
    private ObjectName storeScpServiceName;
    private Map<String, String> rqStgCmtOnReceiveFromAETs = new HashMap<String, String>();
    private String noStgCmtIfExternalRetrieveAET;
    private NotificationListener seriesStoredListener;

    public ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getStgCmtServiceName() {
        return this.stgCmtServiceName;
    }

    public final void setStgCmtServiceName(ObjectName name) {
        this.stgCmtServiceName = name;
    }

    public String getRqStgCmtOnReceiveFromAETs() {
        if (this.rqStgCmtOnReceiveFromAETs.isEmpty()) {
            return NONE;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.rqStgCmtOnReceiveFromAETs.entrySet()) {
            sb.append(entry.getKey());
            if (!entry.getKey().equals(entry.getValue())) {
                sb.append('=').append(entry.getValue());
            }
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public void setRqStgCmtOnReceiveFromAETs(String s) throws InstanceNotFoundException, ListenerNotFoundException {
        this.rqStgCmtOnReceiveFromAETs.clear();
        if (!NONE.equals(s)) {
            StringTokenizer st = new StringTokenizer(s, ";\n\r\t");
            String tk = null;
            while (st.hasMoreTokens()) {
                tk = st.nextToken();
                int pos = tk.indexOf(61);
                if (pos == -1) {
                    this.rqStgCmtOnReceiveFromAETs.put(tk, tk);
                    continue;
                }
                this.rqStgCmtOnReceiveFromAETs.put(tk.substring(0, pos), tk.substring(++pos));
            }
        }
        this.updateSeriesStoredListener();
    }

    public String getNoStgCmtIfExternalRetrieveAET() {
        return this.noStgCmtIfExternalRetrieveAET == null ? NONE : this.noStgCmtIfExternalRetrieveAET;
    }

    public void setNoStgCmtIfExternalRetrieveAET(String s) {
        this.noStgCmtIfExternalRetrieveAET = NONE.equals(s) ? null : s;
    }

    private void updateSeriesStoredListener() throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.server != null) {
            if (this.rqStgCmtOnReceiveFromAETs.isEmpty()) {
                if (this.seriesStoredListener != null) {
                    this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
                    this.seriesStoredListener = null;
                }
            } else if (this.seriesStoredListener == null) {
                this.seriesStoredListener = new NotificationListener(){

                    public void handleNotification(Notification notif, Object handback) {
                        StgCmtScuBySeriesStoredService.this.onSeriesStored((SeriesStored)notif.getUserData());
                    }
                };
                this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
            }
        }
    }

    protected void startService() throws Exception {
        super.startService();
        this.updateSeriesStoredListener();
    }

    protected void stopService() throws Exception {
        this.updateSeriesStoredListener();
        super.stopService();
    }

    private void onSeriesStored(SeriesStored stored) {
        String aet = this.rqStgCmtOnReceiveFromAETs.get(stored.getSourceAET());
        if (aet != null) {
            boolean specificExtRetr;
            boolean needStgCmt = true;
            boolean bl = specificExtRetr = !"ANY".equals(this.noStgCmtIfExternalRetrieveAET);
            if (this.noStgCmtIfExternalRetrieveAET != null) {
                needStgCmt = false;
                try {
                    Collection iuidAndAETs = new QueryExternalRetrieveAETsOfSeriesCmd(stored.getSeriesInstanceUID(), 50).getRetrieveAETs();
                    for (String[] iuidAndAET : iuidAndAETs) {
                        if (iuidAndAET[1] != null && (!specificExtRetr || iuidAndAET[1].equals(this.noStgCmtIfExternalRetrieveAET))) continue;
                        needStgCmt = true;
                        break;
                    }
                }
                catch (Exception x) {
                    this.log.warn((Object)("Failed to get ExtRetrAETs for series:" + stored.getSeriesInstanceUID() + "! Send StgCmt anyway."), (Throwable)x);
                }
            }
            if (needStgCmt) {
                Dataset actionInfo = stored.getIAN().get(528661).getItem();
                String callingAet = null;
                int pos = aet.indexOf(58);
                if (pos != -1) {
                    callingAet = aet.substring(0, pos);
                    aet = aet.substring(++pos);
                }
                try {
                    this.log.info((Object)("Queue StgCmt Order! calling:" + callingAet + " called:" + aet));
                    this.server.invoke(this.stgCmtServiceName, "onInstancesRetrieved", new Object[]{callingAet, aet, actionInfo}, new String[]{String.class.getName(), String.class.getName(), Dataset.class.getName()});
                }
                catch (Exception x) {
                    this.log.error((Object)("Failed to queue StorageCommit Order! calledAet:" + aet), (Throwable)x);
                    this.log.debug((Object)actionInfo);
                }
            } else {
                this.log.info((Object)("No Storage Commit necessary! All instances already external retrievable" + (specificExtRetr ? " from " + this.noStgCmtIfExternalRetrieveAET : ".")));
            }
        }
    }
}

