/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AssociationFactory;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RetrieveInfo {
    private static final String[] IVR_LE_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] EVR_LE_TS = new String[]{"1.2.840.10008.1.2.1"};
    private static final String[] NO_PIXEL_TS = new String[]{"1.2.840.10008.1.2.4.96"};
    private static final String[] NO_PIXEL_DEFL_TS = new String[]{"1.2.840.10008.1.2.4.97", "1.2.840.10008.1.2.4.96"};
    private final int size;
    private final Map<String, IuidsAndTsuids> iuidsAndTsuidsByCuid = new HashMap<String, IuidsAndTsuids>();
    private final Map<String, List<FileInfo>> localFilesByIuid = new LinkedHashMap<String, List<FileInfo>>();
    private final Map<String, Set<String>> iuidsByRemoteAET = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> iuidsByExternalAET = new HashMap<String, Set<String>>();
    private final Set<String> notAvailableIuids = new HashSet<String>();
    private final Set<String> availableIuids = new HashSet<String>();
    private final Set<String> studyIuids = new HashSet<String>();
    private final Set<String> seriesIuids = new HashSet<String>();
    private Map.Entry<String, Set<String>> curMoveForward;
    private boolean externalRetrieveAET;
    private static final Comparator<Map.Entry<String, Set<String>>> ASC_IUIDS_SIZE = new Comparator<Map.Entry<String, Set<String>>>(){

        @Override
        public int compare(Map.Entry<String, Set<String>> o1, Map.Entry<String, Set<String>> o2) {
            return o1.getValue().size() - o2.getValue().size();
        }
    };

    private static final boolean isNativeLE_TS(String uid) {
        return "1.2.840.10008.1.2.1".equals(uid) || "1.2.840.10008.1.2".equals(uid);
    }

    RetrieveInfo(QueryRetrieveScpService service, FileInfo[][] instInfos) {
        for (FileInfo[] fileInfos : instInfos) {
            String iuid = fileInfos[0].sopIUID;
            this.studyIuids.add(fileInfos[0].studyIUID);
            this.seriesIuids.add(fileInfos[0].seriesIUID);
            for (int j = 0; j < fileInfos.length; ++j) {
                FileInfo fileInfo = fileInfos[j];
                if (fileInfo.fileRetrieveAET != null && (fileInfo.availability == 0 || fileInfo.availability == 1)) {
                    if (service.isLocalRetrieveAET(fileInfo.fileRetrieveAET)) {
                        this.putLocalFile(fileInfo);
                        continue;
                    }
                    this.putIuid(this.iuidsByRemoteAET, fileInfo.fileRetrieveAET, iuid);
                    continue;
                }
                if (fileInfo.extRetrieveAET == null) continue;
                this.putIuid(this.iuidsByExternalAET, fileInfo.extRetrieveAET, iuid);
            }
        }
    }

    private void putLocalFile(FileInfo fileInfo) {
        String iuid = fileInfo.sopIUID;
        String cuid = fileInfo.sopCUID;
        IuidsAndTsuids iuidsAndTsuids = this.iuidsAndTsuidsByCuid.get(cuid);
        if (iuidsAndTsuids == null) {
            iuidsAndTsuids = new IuidsAndTsuids();
            this.iuidsAndTsuidsByCuid.put(cuid, iuidsAndTsuids);
        }
        iuidsAndTsuids.iuids.add(iuid);
        iuidsAndTsuids.tsuids.add(fileInfo.tsUID);
        List<FileInfo> localFiles = this.localFilesByIuid.get(iuid);
        if (localFiles == null) {
            localFiles = new ArrayList<FileInfo>();
            this.localFilesByIuid.put(iuid, localFiles);
        }
        localFiles.add(fileInfo);
        this.availableIuids.add(iuid);
        this.notAvailableIuids.remove(iuid);
    }

    private void putIuid(Map<String, Set<String>> iuidsByAET, String aet, String iuid) {
        Set<String> iuids = iuidsByAET.get(aet);
        if (iuids == null) {
            iuids = new LinkedHashSet<String>();
            iuidsByAET.put(aet, iuids);
        }
        iuids.add(iuid);
        this.availableIuids.add(iuid);
        this.notAvailableIuids.remove(iuid);
    }

    public void addPresContext(AAssociateRQ rq, Set<String> doNotDecompressTsuids, boolean sendWithDefaultTransferSyntax, boolean offerNoPixelData, boolean offerNoPixelDataDeflate) {
        AssociationFactory asf = AssociationFactory.getInstance();
        for (Map.Entry<String, IuidsAndTsuids> entry : this.iuidsAndTsuidsByCuid.entrySet()) {
            String cuid = entry.getKey();
            IuidsAndTsuids iuidsAndTsuids = entry.getValue();
            if (sendWithDefaultTransferSyntax) {
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, "1.2.840.10008.1.2"));
                continue;
            }
            if (!doNotDecompressTsuids.containsAll(iuidsAndTsuids.tsuids)) {
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, IVR_LE_TS));
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, EVR_LE_TS));
            }
            if (offerNoPixelDataDeflate) {
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, NO_PIXEL_DEFL_TS));
            } else if (offerNoPixelData) {
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, NO_PIXEL_TS));
            }
            for (String tsuid : iuidsAndTsuids.tsuids) {
                if (RetrieveInfo.isNativeLE_TS(tsuid)) continue;
                rq.addPresContext(asf.newPresContext(rq.nextPCID(), cuid, new String[]{tsuid}));
            }
        }
    }

    public Iterator<String> getCUIDs() {
        return this.iuidsAndTsuidsByCuid.keySet().iterator();
    }

    public Set<String> getTransferSyntaxesOfClass(String cuid) {
        IuidsAndTsuids iuidsAndTsuids = this.iuidsAndTsuidsByCuid.get(cuid);
        return iuidsAndTsuids.tsuids;
    }

    public Set<String> removeInstancesOfClass(String cuid) {
        IuidsAndTsuids iuidsAndTsuids = this.iuidsAndTsuidsByCuid.get(cuid);
        for (String iuid : iuidsAndTsuids.iuids) {
            this.localFilesByIuid.remove(iuid);
            this.removeIuid(this.iuidsByRemoteAET, iuid);
            this.removeIuid(this.iuidsByExternalAET, iuid);
        }
        return iuidsAndTsuids.iuids;
    }

    public Collection<String> removeLocalFilesOfClassWithTransferSyntax(String cuid, String tsuid) {
        IuidsAndTsuids iuidsAndTsuids = this.iuidsAndTsuidsByCuid.get(cuid);
        ArrayList<String> iuids = new ArrayList<String>(iuidsAndTsuids.iuids.size());
        for (String iuid : iuidsAndTsuids.iuids) {
            List<FileInfo> files = this.localFilesByIuid.get(iuid);
            Iterator<FileInfo> it = files.iterator();
            while (it.hasNext()) {
                FileInfo fileInfo = it.next();
                if (!fileInfo.tsUID.equals(tsuid)) continue;
                it.remove();
            }
            if (!files.isEmpty()) continue;
            this.localFilesByIuid.remove(iuid);
            iuids.add(iuid);
        }
        return iuids;
    }

    private void removeIuid(Map<String, Set<String>> iuidsByAET, String iuid) {
        Iterator<Set<String>> it = iuidsByAET.values().iterator();
        while (it.hasNext()) {
            Set<String> iuids = it.next();
            iuids.remove(iuid);
            if (!iuids.isEmpty()) continue;
            it.remove();
        }
    }

    public boolean nextMoveForward() {
        if (!this.iuidsByRemoteAET.isEmpty()) {
            this.externalRetrieveAET = false;
            this.curMoveForward = this.removeNextRemoteAET(this.iuidsByRemoteAET);
            return true;
        }
        if (!this.iuidsByExternalAET.isEmpty()) {
            this.externalRetrieveAET = true;
            this.curMoveForward = this.removeNextRemoteAET(this.iuidsByExternalAET);
            return true;
        }
        this.curMoveForward = null;
        return false;
    }

    private Map.Entry<String, Set<String>> removeNextRemoteAET(Map<String, Set<String>> iuidsByAET) {
        Map.Entry<String, Set<String>> entry = Collections.max(iuidsByAET.entrySet(), ASC_IUIDS_SIZE);
        iuidsByAET.remove(entry.getKey());
        Set<String> iuids = entry.getValue();
        for (String iuid : iuids) {
            this.removeIuid(this.iuidsByRemoteAET, iuid);
            this.removeIuid(this.iuidsByExternalAET, iuid);
        }
        return entry;
    }

    public final Collection<List<FileInfo>> getLocalFiles() {
        return this.localFilesByIuid.values();
    }

    public final Set<String> removeLocalIUIDs() {
        Set<String> iuids = this.localFilesByIuid.keySet();
        for (String iuid : iuids) {
            this.removeIuid(this.iuidsByRemoteAET, iuid);
            this.removeIuid(this.iuidsByExternalAET, iuid);
        }
        return iuids;
    }

    public final String getMoveForwardAET() {
        return this.curMoveForward != null ? this.curMoveForward.getKey() : null;
    }

    public final Set<String> getMoveForwardUIDs() {
        return this.curMoveForward != null ? this.curMoveForward.getValue() : null;
    }

    public final boolean isExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public final Set<String> getNotAvailableIUIDs() {
        return this.notAvailableIuids;
    }

    public final Set<String> getAvailableIUIDs() {
        return this.availableIuids;
    }

    public final Set<String> getStudyIUIDs() {
        return this.studyIuids;
    }

    public final Set<String> getSeriesIUIDs() {
        return this.seriesIuids;
    }

    private static class IuidsAndTsuids {
        final Set<String> iuids = new HashSet<String>();
        final Set<String> tsuids = new HashSet<String>();

        private IuidsAndTsuids() {
        }
    }
}

