/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.FinderException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.transform.Templates;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DataSource;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4che.net.PresContext;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.InstancesTransferredMessage;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PIDWithIssuer;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.qrscp.BlockedFindScp;
import org.dcm4chex.archive.dcm.qrscp.FindScp;
import org.dcm4chex.archive.dcm.qrscp.GetScp;
import org.dcm4chex.archive.dcm.qrscp.MoveScp;
import org.dcm4chex.archive.dcm.qrscp.StudyInstanceUIDAndDirPath;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.ejb.jdbc.QueryExternalRetrieveAETsOfSeriesCmd;
import org.dcm4chex.archive.ejb.jdbc.QueryFilesOfSeriesCmd2;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.exceptions.NoPresContextException;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.DicomSecurityDelegate;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.perf.PerfMonDelegate;
import org.dcm4chex.archive.util.DatasetUpdater;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileDataSource;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.logging.Logger;
import org.jboss.util.deadlock.ApplicationDeadlockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRetrieveScpService
extends AbstractScpService {
    private static final int FUZZY_MATCHING = 2;
    private static final String ANY = "ANY";
    private static final String NONE = "NONE";
    private static final String[] EMPTY = new String[0];
    private static final String SEND_BUFFER = "SEND_BUFFER";
    private static final Timer pendingRspTimer = new Timer(true);
    static final UIDDictionary uidDict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private boolean patchJpegLS;
    private String patchJpegLSImplCUID;
    private String patchJpegLSNewImplCUID;
    private String[] sendNoPixelDataToAETs = null;
    private String[] offerNoPixelDataToAETs = null;
    private String[] offerNoPixelDataDeflateToAETs = null;
    private String[] sendWithDefaultTransferSyntaxToAETs = null;
    private String[] ignoreUnsupportedSOPClassFailuresByAETs = null;
    private String[] unrestrictedQueryPermissionsToAETitles = null;
    private String[] unrestrictedReadPermissionsToAETitles = null;
    private String[] unrestrictedExportPermissionsToAETitles = null;
    private String[] hideWithoutIssuerOfPIDFromAETs;
    private boolean invertHideWithoutIssuerOfPIDFromAETs;
    private Map ignorableSOPClasses = new LinkedHashMap();
    private Map<String, String> notDecompressTsuidMap = new LinkedHashMap<String, String>();
    private Set<String> notDecompressTsuidSet;
    private ObjectName stgCmtScuScpName;
    private ObjectName tarRetrieverName;
    private ObjectName pixQueryServiceName;
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);
    private DicomSecurityDelegate dicomSecurity = new DicomSecurityDelegate(this);
    private boolean sendPendingCMoveRSP = true;
    private boolean sendPendingCGetRSP = true;
    private long pendingCMoveRSPInterval = 5000L;
    private long pendingCGetRSPInterval = 5000L;
    private boolean forwardAsMoveOriginator = true;
    private String directForwardingList = "";
    private Map<String, List<String>> directForwardingMap = new HashMap<String, List<String>>();
    protected String localStorageAET;
    private boolean recordStudyAccessTime = true;
    private boolean noMatchForNoValue = true;
    private String[] pixQueryCallingAETs;
    private String[] pixQueryIssuers;
    private String pixQueryDefIssuer;
    private boolean adjustPatientIDOnRetrieval;
    private boolean adjustAccessionNumberOnRetrieval;
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private int maxStoreOpsInvoked = 0;
    private FindScp dicomFindScp = null;
    private FindScp tianiFindScp = new FindScp(this, false);
    private FindScp tianiBlockedFindScp = new BlockedFindScp(this);
    private MoveScp moveScp = null;
    private GetScp getScp = null;
    private int maxUIDsPerMoveRQ = 100;
    private int maxBlockedFindRSP = 10000;
    private int bufferSize = 8192;
    private int retrieveRspStatusForNoMatchingInstanceToRetrieve = 0;
    private int fetchSize;
    private static final String CSTORE_OUT_XSL = "out-cstorerq.xsl";
    private static final String COERCE_TPL = "COERCE_TPL";
    private Map standardCuidMap = new LinkedHashMap();
    private Map privateCuidMap = new LinkedHashMap();
    private Map privateTSuidMap = new LinkedHashMap();
    private boolean coerceAttributeTopDown = false;
    private boolean cFindRspDebugLogDeferToDoBeforeRsp = false;
    private boolean verifyMD5OnMakeCStoreRQ = false;
    protected DatasetUpdater datasetUpdater = null;
    private static final ExtNegotiator extNegotiator = new ExtNegotiator(){

        public byte[] negotiate(byte[] offered) {
            if (offered.length > 2) {
                offered[2] = (byte)(offered[2] & (AttributeFilter.isSoundexEnabled() ? (byte)1 : 0));
            }
            return offered;
        }
    };

    public QueryRetrieveScpService() {
        this.moveScp = this.createMoveScp();
        this.getScp = this.createGetScp();
        this.dicomFindScp = this.createFindScp();
    }

    DicomSecurityDelegate dicomSecurity() {
        return this.dicomSecurity;
    }

    protected MoveScp createMoveScp() {
        return new MoveScp(this);
    }

    protected GetScp createGetScp() {
        return new GetScp(this);
    }

    protected FindScp createFindScp() {
        return new FindScp(this, true);
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final ObjectName getDicomSecurityServiceName() {
        return this.dicomSecurity.getDicomSecurityServiceName();
    }

    public final void setDicomSecurityServiceName(ObjectName serviceName) {
        this.dicomSecurity.setDicomSecurityServiceName(serviceName);
    }

    public final int getReceiveBufferSize() {
        return this.tlsConfig.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.tlsConfig.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.tlsConfig.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.tlsConfig.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.tlsConfig.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.tlsConfig.setTcpNoDelay(on);
    }

    public final ObjectName getStgCmtScuScpName() {
        return this.stgCmtScuScpName;
    }

    public final void setStgCmtScuScpName(ObjectName stgCmtScuScpName) {
        this.stgCmtScuScpName = stgCmtScuScpName;
    }

    public final ObjectName getTarRetrieverName() {
        return this.tarRetrieverName;
    }

    public final void setTarRetrieverName(ObjectName tarRetrieverName) {
        this.tarRetrieverName = tarRetrieverName;
    }

    public final ObjectName getPixQueryServiceName() {
        return this.pixQueryServiceName;
    }

    public final void setPixQueryServiceName(ObjectName name) {
        this.pixQueryServiceName = name;
    }

    public String getPixQueryCallingAETs() {
        return this.pixQueryCallingAETs == null ? ANY : (this.pixQueryCallingAETs.length == 0 ? NONE : StringUtils.toString(this.pixQueryCallingAETs, '\\'));
    }

    public void setPixQueryCallingAETs(String s) {
        String trim = s.trim();
        this.pixQueryCallingAETs = trim.equalsIgnoreCase(ANY) ? null : (trim.equalsIgnoreCase(NONE) ? EMPTY : StringUtils.split(trim, '\\'));
    }

    public boolean isPixQueryCallingAET(String aet) {
        return this.pixQueryCallingAETs == null || Arrays.asList(this.pixQueryCallingAETs).contains(aet);
    }

    public String getPixQueryIssuers() {
        return this.pixQueryIssuers == null ? ANY : StringUtils.toString(this.pixQueryIssuers, ',');
    }

    public void setPixQueryIssuers(String s) {
        String trim = s.trim();
        this.pixQueryIssuers = trim.equalsIgnoreCase(ANY) ? null : StringUtils.split(trim, ',');
    }

    public boolean isPixQueryIssuer(String issuer) {
        return this.pixQueryIssuers == null || Arrays.asList(this.pixQueryIssuers).contains(issuer);
    }

    public final String getPixQueryDefIssuer() {
        return this.pixQueryDefIssuer;
    }

    public final void setPixQueryDefIssuer(String pixQueryDefIssuer) {
        this.pixQueryDefIssuer = pixQueryDefIssuer;
    }

    public final boolean isAdjustPatientIDOnRetrieval() {
        return this.adjustPatientIDOnRetrieval;
    }

    public final void setAdjustPatientIDOnRetrieval(boolean adjustPatientIDOnRetrieval) {
        this.adjustPatientIDOnRetrieval = adjustPatientIDOnRetrieval;
    }

    public final boolean isAdjustAccessionNumberOnRetrieval() {
        return this.adjustAccessionNumberOnRetrieval;
    }

    public final void setAdjustAccessionNumberOnRetrieval(boolean adjustAccessionNumberOnRetrieval) {
        this.adjustAccessionNumberOnRetrieval = adjustAccessionNumberOnRetrieval;
    }

    public final String getUnrestrictedQueryPermissionsToAETitles() {
        return this.unrestrictedQueryPermissionsToAETitles == null ? ANY : StringUtils.toString(this.unrestrictedQueryPermissionsToAETitles, '\\');
    }

    public final void setUnrestrictedQueryPermissionsToAETitles(String s) {
        String trim = s.trim();
        this.unrestrictedQueryPermissionsToAETitles = trim.equalsIgnoreCase(ANY) ? null : StringUtils.split(trim, '\\');
    }

    final boolean hasUnrestrictedQueryPermissions(String aet) {
        return this.unrestrictedQueryPermissionsToAETitles == null || Arrays.asList(this.unrestrictedQueryPermissionsToAETitles).contains(aet);
    }

    public final String getUnrestrictedReadPermissionsToAETitles() {
        return this.unrestrictedReadPermissionsToAETitles == null ? ANY : StringUtils.toString(this.unrestrictedReadPermissionsToAETitles, '\\');
    }

    public final void setUnrestrictedReadPermissionsToAETitles(String s) {
        String trim = s.trim();
        this.unrestrictedReadPermissionsToAETitles = trim.equalsIgnoreCase(ANY) ? null : StringUtils.split(trim, '\\');
    }

    final boolean hasUnrestrictedReadPermissions(String aet) {
        return this.unrestrictedReadPermissionsToAETitles == null || Arrays.asList(this.unrestrictedReadPermissionsToAETitles).contains(aet);
    }

    public final String getUnrestrictedExportPermissionsToAETitles() {
        return this.unrestrictedExportPermissionsToAETitles == null ? ANY : StringUtils.toString(this.unrestrictedExportPermissionsToAETitles, '\\');
    }

    public final void setUnrestrictedExportPermissionsToAETitles(String s) {
        String trim = s.trim();
        this.unrestrictedExportPermissionsToAETitles = trim.equalsIgnoreCase(ANY) ? null : StringUtils.split(trim, '\\');
    }

    final boolean hasUnrestrictedExportPermissions(String aet) {
        return this.unrestrictedExportPermissionsToAETitles == null || Arrays.asList(this.unrestrictedExportPermissionsToAETitles).contains(aet);
    }

    public final String getHideWithoutIssuerOfPatientIDFromAETs() {
        return this.invertHideWithoutIssuerOfPIDFromAETs ? "!\\" : "" + (this.hideWithoutIssuerOfPIDFromAETs == null ? NONE : StringUtils.toString(this.hideWithoutIssuerOfPIDFromAETs, '\\'));
    }

    public final void setHideWithoutIssuerOfPatientIDFromAETs(String aets) {
        this.invertHideWithoutIssuerOfPIDFromAETs = aets.startsWith("!\\");
        if (this.invertHideWithoutIssuerOfPIDFromAETs) {
            aets = aets.substring(2);
        }
        this.hideWithoutIssuerOfPIDFromAETs = aets.equalsIgnoreCase(NONE) ? null : StringUtils.split(aets, '\\');
    }

    boolean isHideWithoutIssuerOfPIDFromAET(String callingAET) {
        if (this.hideWithoutIssuerOfPIDFromAETs != null) {
            for (String aet : this.hideWithoutIssuerOfPIDFromAETs) {
                if (!aet.equals(callingAET)) continue;
                return !this.invertHideWithoutIssuerOfPIDFromAETs;
            }
        }
        return this.invertHideWithoutIssuerOfPIDFromAETs;
    }

    public final boolean isNoMatchForNoValue() {
        return this.noMatchForNoValue;
    }

    public final void setNoMatchForNoValue(boolean noMatchForNoValue) {
        this.noMatchForNoValue = noMatchForNoValue;
    }

    public final boolean getLazyFetchSeriesAttrsOnImageLevelQuery() {
        return QueryCmd.lazyFetchSeriesAttrsOnImageLevelQuery;
    }

    public final void setLazyFetchSeriesAttrsOnImageLevelQuery(boolean enable) {
        QueryCmd.lazyFetchSeriesAttrsOnImageLevelQuery = enable;
    }

    public final boolean getCacheSeriesAttrsOnImageLevelQuery() {
        return QueryCmd.cacheSeriesAttrsOnImageLevelQuery || QueryCmd.lazyFetchSeriesAttrsOnImageLevelQuery;
    }

    public final void setCacheSeriesAttrsOnImageLevelQuery(boolean enable) {
        QueryCmd.cacheSeriesAttrsOnImageLevelQuery = enable;
    }

    public final boolean getAccessBlobAsLongVarBinaryOnQuery() {
        return QueryCmd.blobAccessType == -4;
    }

    public final void setAccessBlobAsLongVarBinaryOnQuery(boolean enable) {
        QueryCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final boolean getAccessSeriesBlobAsLongVarBinaryOnImageLevelQuery() {
        return QueryCmd.seriesBlobAccessType == -4;
    }

    public final void setAccessSeriesBlobAsLongVarBinaryOnImageLevelQuery(boolean enable) {
        QueryCmd.seriesBlobAccessType = enable ? -4 : 2004;
    }

    public final boolean getLazyFetchSeriesAttrsOnRetrieve() {
        return RetrieveCmd.lazyFetchSeriesAttrs;
    }

    public final void setLazyFetchSeriesAttrsOnRetrieve(boolean enable) {
        RetrieveCmd.lazyFetchSeriesAttrs = enable;
    }

    public final boolean getCacheSeriesAttrsOnRetrieve() {
        return RetrieveCmd.cacheSeriesAttrs || RetrieveCmd.lazyFetchSeriesAttrs;
    }

    public final void setCacheSeriesAttrsOnRetrieve(boolean enable) {
        RetrieveCmd.cacheSeriesAttrs = enable;
    }

    public final int getCacheSeriesAttrsOnRetrieveMaxSize() {
        return RetrieveCmd.getSeriesAttrsCacheMaxSize();
    }

    public final void setCacheSeriesAttrsOnRetrieveMaxSize(int maxSize) {
        RetrieveCmd.setSeriesAttrsCacheMaxSize((int)maxSize);
    }

    public final String getCacheSeriesAttrsOnRetrieveCurrencyTimeLimit() {
        return RetryIntervalls.formatInterval(RetrieveCmd.seriesAttrsCacheCurrencyTimeLimit);
    }

    public final void setCacheSeriesAttrsOnRetrieveCurrencyTimeLimit(String s) {
        RetrieveCmd.seriesAttrsCacheCurrencyTimeLimit = RetryIntervalls.parseInterval(s);
    }

    public final boolean getAccessBlobAsLongVarBinaryOnRetrieve() {
        return RetrieveCmd.blobAccessType == -4;
    }

    public final void setAccessBlobAsLongVarBinaryOnRetrieve(boolean enable) {
        RetrieveCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final boolean getAccessSeriesBlobAsLongVarBinaryOnRetrieve() {
        return RetrieveCmd.seriesBlobAccessType == -4;
    }

    public final void setAccessSeriesBlobAsLongVarBinaryOnRetrieve(boolean enable) {
        RetrieveCmd.seriesBlobAccessType = enable ? -4 : 2004;
    }

    public final String getQueryTransactionIsolationLevel() {
        return QueryCmd.transactionIsolationLevelAsString((int)QueryCmd.transactionIsolationLevel);
    }

    public final void setQueryTransactionIsolationLevel(String level) {
        QueryCmd.transactionIsolationLevel = QueryCmd.transactionIsolationLevelOf((String)level);
    }

    public final String getRetrieveTransactionIsolationLevel() {
        return RetrieveCmd.transactionIsolationLevelAsString((int)RetrieveCmd.transactionIsolationLevel);
    }

    public final void setRetrieveTransactionIsolationLevel(String level) {
        RetrieveCmd.transactionIsolationLevel = RetrieveCmd.transactionIsolationLevelOf((String)level);
    }

    public final boolean isRetrieveWithoutLeftJoins() {
        return RetrieveCmd.isNoLeftJoin();
    }

    public final void setRetrieveWithoutLeftJoins(boolean noLeftJoin) {
        RetrieveCmd.setNoLeftJoin((boolean)noLeftJoin);
    }

    public String getAcceptedPrivateSOPClasses() {
        return this.toString(this.privateCuidMap);
    }

    public void setAcceptedPrivateSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.privateCuidMap, s, null);
    }

    public String getAcceptedTransferSyntaxForPrivateSOPClasses() {
        return this.toString(this.privateTSuidMap);
    }

    public void setAcceptedTransferSyntaxForPrivateSOPClasses(String s) {
        this.updateAcceptedTransferSyntax(this.privateTSuidMap, s);
    }

    public String getAcceptedStandardSOPClasses() {
        return this.toString(this.standardCuidMap);
    }

    public void setAcceptedStandardSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.standardCuidMap, s, null);
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public final void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public final int getMaxStoreOpsInvoked() {
        return this.maxStoreOpsInvoked;
    }

    public final void setMaxStoreOpsInvoked(int maxStoreOpsInvoked) {
        this.maxStoreOpsInvoked = maxStoreOpsInvoked;
    }

    public final boolean isSendPendingCMoveRSP() {
        return this.sendPendingCMoveRSP;
    }

    public final void setSendPendingCMoveRSP(boolean sendPendingCMoveRSP) {
        this.sendPendingCMoveRSP = sendPendingCMoveRSP;
    }

    public final boolean isSendPendingCGetRSP() {
        return this.sendPendingCGetRSP;
    }

    public final void setSendPendingCGetRSP(boolean sendPendingCGetRSP) {
        this.sendPendingCGetRSP = sendPendingCGetRSP;
    }

    public final void setPendingCMoveRSPInterval(long ms) {
        if (ms <= 0L) {
            throw new IllegalArgumentException("pendingCMoveRSPInterval: " + ms);
        }
        this.pendingCMoveRSPInterval = ms;
    }

    public final long getPendingCMoveRSPInterval() {
        return this.pendingCMoveRSPInterval;
    }

    public final void setPendingCGetRSPInterval(long ms) {
        if (ms <= 0L) {
            throw new IllegalArgumentException("pendingCGetRSPInterval: " + ms);
        }
        this.pendingCGetRSPInterval = ms;
    }

    public final long getPendingCGetRSPInterval() {
        return this.pendingCGetRSPInterval;
    }

    public final boolean isForwardAsMoveOriginator() {
        return this.forwardAsMoveOriginator;
    }

    public final void setForwardAsMoveOriginator(boolean forwardAsMoveOriginator) {
        this.forwardAsMoveOriginator = forwardAsMoveOriginator;
    }

    public final boolean isRecordStudyAccessTime() {
        return this.recordStudyAccessTime;
    }

    public final void setRecordStudyAccessTime(boolean updateAccessTime) {
        this.recordStudyAccessTime = updateAccessTime;
    }

    public final String getDoNotDecompressTransferSyntaxes() {
        return this.toString(this.notDecompressTsuidMap);
    }

    public final void setDoNotDecompressTransferSyntaxes(String uids) {
        this.notDecompressTsuidMap = QueryRetrieveScpService.parseUIDs(uids);
        this.notDecompressTsuidSet = new HashSet<String>(this.notDecompressTsuidMap.values());
    }

    Set<String> notDecompressTsuidSet() {
        return this.notDecompressTsuidSet;
    }

    public final String getPatchJpegLSImplCUID() {
        return this.patchJpegLS ? QueryRetrieveScpService.maskNull(this.patchJpegLSImplCUID, ANY) : NONE;
    }

    public final void setPatchJpegLSImplCUID(String s) {
        String trim = s.trim();
        this.patchJpegLS = !trim.equalsIgnoreCase(NONE);
        this.patchJpegLSImplCUID = this.patchJpegLS ? QueryRetrieveScpService.unmaskNull(trim, ANY) : null;
    }

    private static String unmaskNull(String s, String mask) {
        return s.equalsIgnoreCase(mask) ? null : s;
    }

    private static String maskNull(String s, String mask) {
        return s == null ? mask : s;
    }

    public final String getPatchJpegLSNewImplCUID() {
        return QueryRetrieveScpService.maskNull(this.patchJpegLSNewImplCUID, NONE);
    }

    public final void setPatchJpegLSNewImplCUID(String s) {
        this.patchJpegLSNewImplCUID = QueryRetrieveScpService.unmaskNull(s.trim(), NONE);
    }

    public final String getSendNoPixelDataToAETs() {
        return this.sendNoPixelDataToAETs == null ? NONE : StringUtils.toString(this.sendNoPixelDataToAETs, '\\');
    }

    public final void setSendNoPixelDataToAETs(String aets) {
        this.sendNoPixelDataToAETs = NONE.equalsIgnoreCase(aets) ? null : StringUtils.split(aets, '\\');
    }

    public final String getOfferNoPixelDataToAETs() {
        return this.offerNoPixelDataToAETs == null ? ANY : (this.offerNoPixelDataToAETs.length == 0 ? NONE : StringUtils.toString(this.offerNoPixelDataToAETs, '\\'));
    }

    public final void setOfferNoPixelDataToAETs(String aets) {
        this.offerNoPixelDataToAETs = ANY.equalsIgnoreCase(aets) ? null : (NONE.equalsIgnoreCase(aets) ? EMPTY : StringUtils.split(aets, '\\'));
    }

    public final String getOfferNoPixelDataDeflateToAETs() {
        return this.offerNoPixelDataDeflateToAETs == null ? ANY : (this.offerNoPixelDataDeflateToAETs.length == 0 ? NONE : StringUtils.toString(this.offerNoPixelDataDeflateToAETs, '\\'));
    }

    public final void setOfferNoPixelDataDeflateToAETs(String aets) {
        this.offerNoPixelDataDeflateToAETs = ANY.equalsIgnoreCase(aets) ? null : (NONE.equalsIgnoreCase(aets) ? EMPTY : StringUtils.split(aets, '\\'));
    }

    public final String getSendWithDefaultTransferSyntaxToAETs() {
        return this.sendWithDefaultTransferSyntaxToAETs == null ? ANY : (this.sendWithDefaultTransferSyntaxToAETs.length == 0 ? NONE : StringUtils.toString(this.sendWithDefaultTransferSyntaxToAETs, '\\'));
    }

    public final void setSendWithDefaultTransferSyntaxToAETs(String aets) {
        this.sendWithDefaultTransferSyntaxToAETs = ANY.equalsIgnoreCase(aets) ? null : (NONE.equalsIgnoreCase(aets) ? EMPTY : StringUtils.split(aets, '\\'));
    }

    public final String getIgnoreUnsupportedSOPClassFailuresByAETs() {
        return this.ignoreUnsupportedSOPClassFailuresByAETs == null ? NONE : StringUtils.toString(this.ignoreUnsupportedSOPClassFailuresByAETs, '\\');
    }

    public final void setIgnoreUnsupportedSOPClassFailuresByAETs(String aets) {
        this.ignoreUnsupportedSOPClassFailuresByAETs = NONE.equalsIgnoreCase(aets) ? null : StringUtils.split(aets, '\\');
    }

    public final String getIgnorableSOPClasses() {
        return this.toString(this.ignorableSOPClasses);
    }

    public final void setIgnorableSOPClasses(String s) {
        this.ignorableSOPClasses = QueryRetrieveScpService.parseUIDs(s);
    }

    public final int getMaxUIDsPerMoveRQ() {
        return this.maxUIDsPerMoveRQ;
    }

    public final void setMaxUIDsPerMoveRQ(int max) {
        this.maxUIDsPerMoveRQ = max;
    }

    public final void setMaxBlockedFindRSP(int max) {
        this.maxBlockedFindRSP = max;
    }

    public final int getMaxBlockedFindRSP() {
        return this.maxBlockedFindRSP;
    }

    public synchronized void setDirectForwardingList(String directForwardingList) {
        if (!this.directForwardingList.equals(directForwardingList)) {
            String[] mappings;
            this.directForwardingList = directForwardingList;
            this.directForwardingMap.clear();
            for (String mapping : mappings = directForwardingList.split("\\;")) {
                String src;
                String dests;
                int k = mapping.indexOf(44);
                if (k < 0) {
                    dests = "any";
                    src = mapping;
                } else {
                    dests = mapping.substring(k + 1);
                    src = mapping.substring(0, k).trim();
                    if (dests.equals("") || dests.equals("*")) {
                        dests = "any";
                    }
                }
                ArrayList<String> lst = new ArrayList<String>();
                if (!dests.equalsIgnoreCase("any")) {
                    lst.addAll(Arrays.asList(dests.split("\\,")));
                }
                this.directForwardingMap.put(src, lst);
            }
        }
    }

    public synchronized String getDirectForwardingList() {
        return this.directForwardingList;
    }

    public synchronized void addDirectForwarding(String aet, String dest) {
        List<String> lst;
        if (dest == null || dest.equals("") || dest.equals("*")) {
            dest = "any";
        }
        if ((lst = this.directForwardingMap.get(aet)) != null) {
            if (lst.size() == 0 || lst.contains(dest)) {
                return;
            }
            if (dest.equalsIgnoreCase("any")) {
                lst.clear();
            } else {
                lst.add(dest);
            }
        } else {
            lst = new ArrayList<String>();
            if (!dest.equalsIgnoreCase("any")) {
                lst.add(dest);
            }
        }
        this.setDirectForwardingList(this.toDirectForwardList());
    }

    public synchronized void removeDirectForwarding(String aet) {
        this.removeDirectForwarding(aet, "any");
    }

    public synchronized void removeDirectForwarding(String aet, String dest) {
        if (dest == null || dest.equals("") || dest.equals("*")) {
            dest = "any";
        }
        if (dest.equalsIgnoreCase("any")) {
            this.directForwardingMap.remove(aet);
        } else {
            List<String> lst = this.directForwardingMap.get(aet);
            if (lst == null || !lst.contains(dest)) {
                return;
            }
            if (lst.size() == 1) {
                this.directForwardingMap.remove(aet);
            } else {
                lst.remove(dest);
            }
        }
        this.setDirectForwardingList(this.toDirectForwardList());
    }

    private String toDirectForwardList() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (String aet : this.directForwardingMap.keySet()) {
            if (i > 0) {
                buf.append(";");
            }
            List<String> lst = this.directForwardingMap.get(aet);
            buf.append(aet);
            if (lst.size() == 0) {
                buf.append(",any");
                continue;
            }
            for (String dest : lst) {
                buf.append(",").append(dest);
            }
        }
        return buf.toString();
    }

    public synchronized boolean isDirectForwarding(String retrieveAET, String destination) {
        List<String> lst = this.directForwardingMap.get(retrieveAET);
        if (lst != null) {
            return lst.size() == 0 || lst.contains(destination);
        }
        return false;
    }

    public void setLocalStorageAET(String localStorageAET) {
        this.localStorageAET = localStorageAET;
    }

    public String getLocalStorageAET() {
        return this.localStorageAET;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public final ObjectName getPerfMonServiceName() {
        return this.dicomFindScp.getPerfMonServiceName();
    }

    public final void setPerfMonServiceName(ObjectName perfMonServiceName) {
        this.dicomFindScp.setPerfMonServiceName(perfMonServiceName);
        this.moveScp.setPerfMonServiceName(perfMonServiceName);
    }

    public MoveScp getMoveScp() {
        return this.moveScp;
    }

    @Override
    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.1.2.1.1", this.dicomFindScp);
        services.bind("1.2.840.10008.5.1.4.1.2.2.1", this.dicomFindScp);
        services.bind("1.2.840.10008.5.1.4.1.2.3.1", this.dicomFindScp);
        services.bind("1.2.40.0.13.1.5.1.4.1.2.2.1", this.tianiFindScp);
        services.bind("1.2.40.0.13.1.5.1.4.1.2.2.1.1", this.tianiBlockedFindScp);
        services.bind("1.2.840.10008.5.1.4.1.2.1.2", this.moveScp);
        services.bind("1.2.840.10008.5.1.4.1.2.2.2", this.moveScp);
        services.bind("1.2.840.10008.5.1.4.1.2.3.2", this.moveScp);
        services.bind("1.2.840.10008.5.1.4.1.2.1.3", this.getScp);
        services.bind("1.2.840.10008.5.1.4.1.2.2.3", this.getScp);
        services.bind("1.2.840.10008.5.1.4.1.2.3.3", this.getScp);
        this.dcmHandler.addAssociationListener(this.dicomFindScp);
        this.dcmHandler.addAssociationListener(this.moveScp);
    }

    @Override
    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.1.2.1.1");
        services.unbind("1.2.840.10008.5.1.4.1.2.2.1");
        services.unbind("1.2.840.10008.5.1.4.1.2.3.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.1.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.2.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.3.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.1.1.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.2.1.1");
        services.unbind("1.2.40.0.13.1.5.1.4.1.2.3.1.1");
        services.unbind("1.2.840.10008.5.1.4.1.2.1.2");
        services.unbind("1.2.840.10008.5.1.4.1.2.2.2");
        services.unbind("1.2.840.10008.5.1.4.1.2.3.2");
        services.unbind("1.2.840.10008.5.1.4.1.2.1.3");
        services.unbind("1.2.840.10008.5.1.4.1.2.2.3");
        services.unbind("1.2.840.10008.5.1.4.1.2.3.3");
        this.dcmHandler.removeAssociationListener(this.dicomFindScp);
        this.dcmHandler.removeAssociationListener(this.moveScp);
    }

    @Override
    protected void enablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, QueryRetrieveScpService.valuesToStringArray(this.privateCuidMap), QueryRetrieveScpService.valuesToStringArray(this.privateTSuidMap));
        this.putPresContexts(policy, QueryRetrieveScpService.valuesToStringArray(this.standardCuidMap), QueryRetrieveScpService.valuesToStringArray(this.tsuidMap));
    }

    @Override
    protected void disablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, QueryRetrieveScpService.valuesToStringArray(this.privateCuidMap), null);
        this.putPresContexts(policy, QueryRetrieveScpService.valuesToStringArray(this.standardCuidMap), null);
    }

    @Override
    protected void putPresContexts(AcceptorPolicy policy, String[] cuids, String[] tsuids) {
        super.putPresContexts(policy, cuids, tsuids);
        ExtNegotiator neg = tsuids != null ? extNegotiator : null;
        for (int i = 0; i < cuids.length; ++i) {
            policy.putExtNegPolicy(cuids[i], neg);
        }
    }

    public AEDTO queryAEData(String aet, InetAddress address) throws DcmServiceException, UnknownAETException {
        try {
            Object o = this.server.invoke(this.aeServiceName, "getAE", new Object[]{aet, address}, new String[]{String.class.getName(), InetAddress.class.getName()});
            if (o == null) {
                throw new UnknownAETException("Unkown AET: " + aet);
            }
            return (AEDTO)o;
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to query AEData", (Throwable)e);
            throw new DcmServiceException(49152, (Throwable)e);
        }
    }

    Set<PIDWithIssuer> queryCorrespondingPIDs(String pid, String issuer, Map<PIDWithIssuer, Set<PIDWithIssuer>> map) {
        PIDWithIssuer key = new PIDWithIssuer(pid, issuer);
        Set<PIDWithIssuer> pidWithIssuers = map.get(key);
        if (pidWithIssuers == null) {
            List<String[]> results = null;
            try {
                results = this.isPixQueryIssuer(issuer) ? this.queryCorrespondingPIDs(pid, issuer) : null;
            }
            catch (DcmServiceException e) {
                // empty catch block
            }
            if (results == null || results.isEmpty()) {
                pidWithIssuers = new HashSet<PIDWithIssuer>(2);
                pidWithIssuers.add(key);
                map.put(key, pidWithIssuers);
                return pidWithIssuers;
            }
            pidWithIssuers = new HashSet<PIDWithIssuer>();
            for (String[] result : results) {
                PIDWithIssuer pidWithIssuer = new PIDWithIssuer(result[0], result[1]);
                pidWithIssuers.add(pidWithIssuer);
                map.put(pidWithIssuer, pidWithIssuers);
            }
        }
        return pidWithIssuers;
    }

    List<String[]> queryCorrespondingPIDs(String pid, String issuer) throws DcmServiceException {
        try {
            return (List)this.server.invoke(this.pixQueryServiceName, "queryCorrespondingPIDs", new Object[]{pid, issuer != null ? issuer : this.pixQueryDefIssuer, null}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName()});
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to perform PIX Query", (Throwable)e);
            throw new DcmServiceException(49152, (Throwable)e);
        }
    }

    public boolean isPixQueryLocal() throws DcmServiceException {
        try {
            return (Boolean)this.server.getAttribute(this.pixQueryServiceName, "PIXManagerLocal");
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to access PIX Service", (Throwable)e);
            throw new DcmServiceException(49152, (Throwable)e);
        }
    }

    public boolean isLocalRetrieveAET(String aet) {
        for (int i = 0; i < this.calledAETs.length; ++i) {
            if (!aet.equals(this.calledAETs[i])) continue;
            return true;
        }
        return false;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    boolean isWithoutPixelData(String moveDest) {
        return this.sendNoPixelDataToAETs != null && Arrays.asList(this.sendNoPixelDataToAETs).contains(moveDest);
    }

    boolean isOfferNoPixelData(String moveDest) {
        return this.offerNoPixelDataToAETs == null || Arrays.asList(this.offerNoPixelDataToAETs).contains(moveDest);
    }

    boolean isOfferNoPixelDataDeflate(String moveDest) {
        return this.offerNoPixelDataDeflateToAETs == null || Arrays.asList(this.offerNoPixelDataDeflateToAETs).contains(moveDest);
    }

    boolean isSendWithDefaultTransferSyntax(String moveDest) {
        return this.sendWithDefaultTransferSyntaxToAETs == null || Arrays.asList(this.sendWithDefaultTransferSyntaxToAETs).contains(moveDest);
    }

    boolean isIgnorableSOPClass(String cuid, String moveDest) {
        return this.ignorableSOPClasses.containsValue(cuid) || this.ignoreUnsupportedSOPClassFailuresByAETs != null && Arrays.asList(this.ignoreUnsupportedSOPClassFailuresByAETs).contains(moveDest);
    }

    protected void logInstancesSent(Association moveOrGetAs, Association storeAs, ArrayList fileInfos) {
        try {
            InstanceSorter sorter = new InstanceSorter();
            FileInfo fileInfo2 = null;
            for (FileInfo fileInfo2 : fileInfos) {
                sorter.addInstance(fileInfo2.studyIUID, fileInfo2.sopCUID, fileInfo2.sopIUID, null);
            }
            String destAET = storeAs.isRequestor() ? storeAs.getCalledAET() : storeAs.getCallingAET();
            String destHost = AuditMessage.hostNameOf((InetAddress)storeAs.getSocket().getInetAddress());
            String origAET = moveOrGetAs.getCallingAET();
            boolean dstIsRequestor = origAET.equals(destAET);
            boolean srcIsRequestor = !dstIsRequestor && Arrays.asList(this.calledAETs).contains(origAET);
            InstancesTransferredMessage msg = new InstancesTransferredMessage(InstancesTransferredMessage.EXECUTE);
            msg.addSourceProcess(AuditMessage.getProcessID(), this.calledAETs, AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), srcIsRequestor);
            msg.addDestinationProcess(destHost, new String[]{destAET}, null, destHost, dstIsRequestor);
            if (!dstIsRequestor && !srcIsRequestor) {
                String origHost = AuditMessage.hostNameOf((InetAddress)moveOrGetAs.getSocket().getInetAddress());
                msg.addOtherParticipantProcess(origHost, new String[]{origAET}, null, origHost, true);
            }
            msg.addPatient(fileInfo2.patID, QueryRetrieveScpService.formatPN(fileInfo2.patName));
            for (String suid : sorter.getSUIDs()) {
                ParticipantObjectDescription desc = new ParticipantObjectDescription();
                for (String cuid : sorter.getCUIDs(suid)) {
                    ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
                    sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
                    desc.addSOPClass(sopClass);
                }
                msg.addStudy(suid, desc);
            }
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    protected Socket createSocket(String moveCalledAET, AEDTO destAE) throws Exception {
        return this.tlsConfig.createSocket(this.aeMgr().findByAET(moveCalledAET), destAE);
    }

    void onInstancesRetrieved(String moveScp, String moveDest, Dataset stgCmtActionInfo) {
        try {
            this.server.invoke(this.stgCmtScuScpName, "onInstancesRetrieved", new Object[]{moveScp, moveDest, stgCmtActionInfo}, new String[]{String.class.getName(), String.class.getName(), Dataset.class.getName()});
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to invoke onInstancesRetrieved", (Throwable)e);
        }
    }

    File retrieveFileFromTAR(String fsID, String fileID) throws Exception {
        try {
            return (File)this.server.invoke(this.tarRetrieverName, "retrieveFileFromTAR", new Object[]{fsID, fileID}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (InstanceNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (ReflectionException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private FileSystemMgt2 getFileSystemMgt() throws Exception {
        return ((FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2")).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStudyAccessTime(Set<StudyInstanceUIDAndDirPath> studyInfos) {
        FileSystemMgt2 fsMgt;
        if (!this.recordStudyAccessTime) {
            return;
        }
        try {
            fsMgt = this.getFileSystemMgt();
        }
        catch (Exception e) {
            this.log.fatal((Object)"Failed to access FileSystemMgt EJB");
            return;
        }
        try {
            for (StudyInstanceUIDAndDirPath studyInfo : studyInfos) {
                try {
                    fsMgt.touchStudyOnFileSystem(studyInfo.studyIUID, studyInfo.dirpath);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to update access time for study " + studyInfo), (Throwable)e);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                fsMgt.remove();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fsMgt.remove();
        }
        catch (Exception ignore) {}
    }

    private void updateStudyAccessTime(String studyIUID, String dirpath) {
        if (this.recordStudyAccessTime) {
            try {
                this.getFileSystemMgt().touchStudyOnFileSystem(studyIUID, dirpath);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to update access time for study " + studyIUID + " on " + dirpath), (Throwable)e);
            }
        }
    }

    void scheduleSendPendingCMoveRsp(TimerTask sendPendingRsp) {
        if (this.sendPendingCMoveRSP) {
            pendingRspTimer.schedule(sendPendingRsp, 0L, this.pendingCMoveRSPInterval);
        }
    }

    void scheduleSendPendingCGetRsp(TimerTask sendPendingRsp) {
        if (this.sendPendingCGetRSP) {
            pendingRspTimer.schedule(sendPendingRsp, 0L, this.pendingCGetRSPInterval);
        }
    }

    Dataset makeRetrieveRspIdentifier(Collection<String> failedIUIDs) {
        if (failedIUIDs.isEmpty()) {
            return null;
        }
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        String[] a = failedIUIDs.toArray(new String[failedIUIDs.size()]);
        ds.putUI(524376, a);
        if (ds.get(524376).length() < 65536) {
            return ds;
        }
        this.log.warn((Object)"Failed SOP InstanceUID List exceeds 64KB limit - send empty attribute instead");
        ds.putUI(524376);
        return ds;
    }

    Dimse makeCStoreRQ(ActiveAssociation activeAssoc, FileInfo info, AEDTO aeData, int priority, String moveOriginatorAET, int moveRqMsgID, PerfMonDelegate perfMon, Map<PIDWithIssuer, Set<PIDWithIssuer>> pixQueryResults) throws Exception {
        String assocIssuer;
        Association assoc;
        if (this.isVerifyMD5OnMakeCStoreRQ()) {
            FileUtils.verifyMD5(info);
        }
        String dest = (assoc = activeAssoc.getAssociation()).isRequestor() ? assoc.getCalledAET() : assoc.getCallingAET();
        PresContext presCtx = this.selectAcceptedPresContext(assoc, info);
        if (presCtx == null) {
            throw new NoPresContextException("No Presentation Context for " + uidDict.toString(info.sopCUID) + (assoc.isRequestor() ? " accepted by " : " offered by ") + dest);
        }
        Command storeRqCmd = DcmObjectFactory.getInstance().newCommand();
        storeRqCmd.initCStoreRQ(assoc.nextMsgID(), info.sopCUID, info.sopIUID, priority);
        if (moveOriginatorAET != null) {
            storeRqCmd.putUS(4145, moveRqMsgID);
            storeRqCmd.putAE(4144, moveOriginatorAET);
        }
        Dataset mergeAttrs = this.coerceAttributeTopDown ? DatasetUtils.fromByteArray(info.instAttrs, DatasetUtils.fromByteArray(info.seriesAttrs, DatasetUtils.fromByteArray(info.studyAttrs, DatasetUtils.fromByteArray(info.patAttrs)))) : DatasetUtils.fromByteArray(info.patAttrs, DatasetUtils.fromByteArray(info.studyAttrs, DatasetUtils.fromByteArray(info.seriesAttrs, DatasetUtils.fromByteArray(info.instAttrs))));
        if (this.adjustPatientIDOnRetrieval && mergeAttrs.containsValue(0x100020) && mergeAttrs.containsValue(0x100021) && (assocIssuer = this.getAssociatedIssuerOfPatientID(assoc, dest)).length() > 0) {
            this.adjustPatientID(mergeAttrs, assocIssuer, pixQueryResults);
        }
        this.adjustAccessionNumberOnRetrieval(mergeAttrs, assoc, dest);
        this.coerceOutboundCStoreRQ(mergeAttrs, aeData, assoc, dest);
        byte[] buf = (byte[])assoc.getProperty(SEND_BUFFER);
        if (buf == null) {
            buf = new byte[this.bufferSize];
            assoc.putProperty(SEND_BUFFER, buf);
        }
        File f = this.getFile(info);
        FileDataSource ds = new FileDataSource(f, mergeAttrs, buf, this.datasetUpdater);
        ds.setWithoutPixeldata(this.isWithoutPixelData(dest));
        ds.setPatchJpegLS(this.patchJpegLS);
        ds.setPatchJpegLSImplCUID(this.patchJpegLSImplCUID);
        ds.setPatchJpegLSNewImplCUID(this.patchJpegLSNewImplCUID);
        Dimse rq = AssociationFactory.getInstance().newDimse(presCtx.pcid(), storeRqCmd, ds);
        if (perfMon != null) {
            perfMon.setProperty(activeAssoc, rq, 3, f);
        }
        return rq;
    }

    protected void coerceOutboundCStoreRQ(Dataset ds, AEDTO aeData, Association assoc, String dest) throws Exception {
        Dataset coerce;
        Templates coerceTpl = (Templates)assoc.getProperty(COERCE_TPL);
        if (coerceTpl == null) {
            coerceTpl = this.getCoercionTemplates(dest, CSTORE_OUT_XSL);
            assoc.putProperty(COERCE_TPL, coerceTpl);
        }
        if ((coerce = this.getCoercionAttributesFor(assoc, CSTORE_OUT_XSL, ds, coerceTpl)) != null) {
            this.coerceAttributes(ds, coerce);
        }
        this.postCoercionProcessing(ds, 1, assoc);
    }

    void adjustPatientID(Dataset ds, String requestedIssuer, Map<PIDWithIssuer, Set<PIDWithIssuer>> pixQueryResults) {
        Dataset opid;
        String pid = ds.getString(0x100020);
        String issuer = ds.getString(0x100021);
        Set<PIDWithIssuer> correspondingPIDs = this.queryCorrespondingPIDs(pid, issuer, pixQueryResults);
        ds.putLO(0x100020);
        ds.remove(0x100021);
        DcmElement opids = ds.get(0x101002);
        if (opids != null) {
            int n = opids.countItems();
            for (int i = 0; i < n; ++i) {
                opid = opids.getItem(i);
                correspondingPIDs.add(new PIDWithIssuer(opid.getString(0x100020), opid.getString(0x100021)));
            }
        }
        opids = ds.putSQ(0x101002);
        for (PIDWithIssuer pidWithIssuer : correspondingPIDs) {
            opid = ds.contains(0x100021) || requestedIssuer != null && !pidWithIssuer.issuer.equals(requestedIssuer) ? opids.addNewItem() : ds;
            opid.putLO(0x100020, pidWithIssuer.pid);
            opid.putLO(0x100021, pidWithIssuer.issuer);
        }
    }

    private void adjustAccessionNumberOnRetrieval(Dataset ds, Association as, String dest) {
        if (this.adjustAccessionNumberOnRetrieval) {
            this.doAdjustAccessionNumberOnRetrieval(ds, as, dest);
            this.doAdjustAccessionNumberOnRetrieval(ds.get(4194933), as, dest);
            this.doAdjustAccessionNumberOnRetrieval(ds.get(4236144), as, dest);
        }
    }

    private void doAdjustAccessionNumberOnRetrieval(DcmElement sq, Association as, String dest) {
        if (sq != null) {
            int n = sq.countItems();
            for (int i = 0; i < n; ++i) {
                this.doAdjustAccessionNumberOnRetrieval(sq.getItem(i), as, dest);
            }
        }
    }

    private void doAdjustAccessionNumberOnRetrieval(Dataset ds, Association as, String dest) {
        Dataset issuer;
        if (ds.containsValue(524368) && (issuer = ds.getItem(524369)) != null && !this.equalsIssuer(issuer, this.getAssociatedIssuerOfAccessionNumber(as, dest))) {
            this.log.info((Object)("Nullify Accession Number with issuer " + issuer.getString(4194353) + '&' + issuer.getString(4194354) + '&' + issuer.getString(0x400033)));
            ds.putSH(524368);
            ds.remove(524369);
        }
    }

    private boolean equalsIssuer(Dataset item, String[] assocIssuer) {
        return assocIssuer.length == 0 || this.equals(item.getString(4194353), assocIssuer[0]) && (assocIssuer.length == 1 || this.equals(item.getString(4194354), assocIssuer[1]) && (assocIssuer.length == 2 || this.equals(item.getString(0x400033), assocIssuer[2])));
    }

    private boolean equals(String s1, String s2) {
        return s1 == null || s1.length() == 0 || s2 == null || s2.length() == 0 || s1.equals(s2);
    }

    private PresContext selectAcceptedPresContext(Association a, FileInfo info) {
        String[] tsuids = new String[]{"1.2.840.10008.1.2.4.97", "1.2.840.10008.1.2.4.96", info.tsUID, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
        PresContext presCtx = null;
        for (int i = 0; presCtx == null && i < tsuids.length; ++i) {
            presCtx = a.getAcceptedPresContext(info.sopCUID, tsuids[i]);
        }
        return presCtx;
    }

    protected File getFile(FileInfo info) throws Exception {
        return this.getFile(info.basedir, info.fileID, info.size);
    }

    protected File getFile(FileDTO dto) throws Exception {
        return this.getFile(dto.getDirectoryPath(), dto.getFilePath(), dto.getFileSize());
    }

    protected File getFile(String fsID, String fileID, long fileSize) throws Exception {
        File f = this.getFile(fsID, fileID);
        if (f.length() < fileSize) {
            throw new IOException("File is of unexpected size it was truncated at " + (fileSize - f.length()) + " bytes, please check file: " + f);
        }
        return f;
    }

    public File getFile(String fsID, String fileID) throws Exception {
        File file;
        File file2 = file = fsID.startsWith("tar:") ? this.retrieveFileFromTAR(fsID, fileID) : FileUtils.toFile(fsID, fileID);
        if (!file.canRead()) {
            throw new FileNotFoundException(file.getPath());
        }
        return file;
    }

    public Object locateInstance(String sopIUID) throws Exception {
        return this.locateInstance(sopIUID, null);
    }

    public Map<String, Object> locateInstancesOfSeries(String seriesIUID, String studyIUID) throws Exception {
        HashSet<String> dirPaths = new HashSet<String>();
        QueryFilesOfSeriesCmd2 query = new QueryFilesOfSeriesCmd2(seriesIUID, this.fetchSize);
        Map fileDTOsByIUID = query.getFileDTOsByIUID();
        HashMap<String, Object> fileOrAETByIUID = new HashMap<String, Object>();
        for (Map.Entry entry : fileDTOsByIUID.entrySet()) {
            String iuid = (String)entry.getKey();
            List value = (List)entry.getValue();
            Object[] fileDTOs = value.toArray(new FileDTO[value.size()]);
            Arrays.sort(fileDTOs);
            FileDTO localFileDTO = this.getLocalFileDTO((FileDTO[])fileDTOs);
            if (localFileDTO != null) {
                String dirPath = localFileDTO.getDirectoryPath();
                if (studyIUID != null && studyIUID.length() != 0 && dirPaths.add(dirPath)) {
                    this.updateStudyAccessTime(studyIUID, dirPath);
                }
                fileOrAETByIUID.put(iuid, this.getFile(localFileDTO));
                continue;
            }
            fileOrAETByIUID.put(iuid, ((FileDTO)fileDTOs[0]).getRetrieveAET());
        }
        if (fileOrAETByIUID.size() < query.getNumberOfSeriesRelatedInstances()) {
            Collection iuidAndAETs = new QueryExternalRetrieveAETsOfSeriesCmd(seriesIUID, this.fetchSize).getRetrieveAETs();
            for (String[] iuidAndAET : iuidAndAETs) {
                if (fileOrAETByIUID.containsKey(iuidAndAET[0])) continue;
                fileOrAETByIUID.put(iuidAndAET[0], iuidAndAET[1]);
            }
        }
        return fileOrAETByIUID;
    }

    private FileDTO getLocalFileDTO(FileDTO[] fileDTOs) {
        for (FileDTO dto : fileDTOs) {
            if (!this.isLocalRetrieveAET(dto.getRetrieveAET())) continue;
            return dto;
        }
        return null;
    }

    public Object locateInstance(String sopIUID, String studyIUID) throws Exception {
        FileDTO[] fileDTOs = null;
        String aet = null;
        FileSystemMgt2 fsMgt = this.getFileSystemMgt();
        try {
            fileDTOs = this.getFilesOfInstance(fsMgt, sopIUID);
            if (fileDTOs.length == 0) {
                aet = fsMgt.getExternalRetrieveAET(sopIUID);
            } else {
                FileDTO localFileDTO = this.getLocalFileDTO(fileDTOs);
                if (localFileDTO != null) {
                    if (studyIUID != null && studyIUID.length() != 0) {
                        this.updateStudyAccessTime(studyIUID, localFileDTO.getDirectoryPath());
                    }
                    return this.getFile(localFileDTO);
                }
                aet = fileDTOs[0].getRetrieveAET();
            }
        }
        catch (FinderException ignore) {
            // empty catch block
        }
        if (aet == null) {
            return null;
        }
        AEDTO aeData = this.aeMgr().findByAET(aet);
        return aeData;
    }

    private FileDTO[] getFilesOfInstance(FileSystemMgt2 fsMgt, String sopIUID) throws RemoteException, FinderException {
        try {
            return fsMgt.getFilesOfInstance(sopIUID);
        }
        catch (RemoteException ex) {
            Throwable cause = null;
            RemoteException rex = ex;
            while (rex.detail != null) {
                cause = rex.detail;
                if (cause instanceof ApplicationDeadlockException) {
                    this.log.warn((Object)"Detect Application Deadlock - retry:", cause);
                    return fsMgt.getFilesOfInstance(sopIUID);
                }
                if (!(cause instanceof RemoteException)) break;
                rex = (RemoteException)cause;
            }
            throw ex;
        }
    }

    public DataSource getDatasourceOfInstance(String iuid) throws Exception {
        Dataset dsQ = DcmObjectFactory.getInstance().newDataset();
        dsQ.putUI(524312, iuid);
        dsQ.putCS(524370, "IMAGE");
        RetrieveCmd cmd = RetrieveCmd.create((Dataset)dsQ);
        cmd.setFetchSize(this.fetchSize);
        FileInfo[][] infoList = cmd.getFileInfos();
        if (infoList.length == 0) {
            return null;
        }
        FileInfo[] fileInfos = infoList[0];
        for (int i = 0; i < fileInfos.length; ++i) {
            FileInfo info = fileInfos[i];
            if (!this.isLocalRetrieveAET(info.fileRetrieveAET)) continue;
            File f = this.getFile(info);
            Dataset mergeAttrs = DatasetUtils.fromByteArray(info.patAttrs, DatasetUtils.fromByteArray(info.studyAttrs, DatasetUtils.fromByteArray(info.seriesAttrs, DatasetUtils.fromByteArray(info.instAttrs))));
            FileDataSource ds = new FileDataSource(f, mergeAttrs, new byte[this.bufferSize]);
            ds.setPatchJpegLS(this.patchJpegLS);
            ds.setPatchJpegLSImplCUID(this.patchJpegLSImplCUID);
            ds.setPatchJpegLSNewImplCUID(this.patchJpegLSNewImplCUID);
            return ds;
        }
        return null;
    }

    void prefetchTars(Collection<List<FileInfo>> localFiles) throws Exception {
        HashSet<String> tarPaths = null;
        for (List<FileInfo> list : localFiles) {
            String fileID;
            int tarEnd;
            FileInfo fileInfo = list.get(0);
            String fsID = fileInfo.basedir;
            if (!fsID.startsWith("tar:") || (tarEnd = (fileID = fileInfo.fileID).indexOf(33)) == -1) continue;
            String tarPath = fileID.substring(0, tarEnd);
            if (tarPaths == null) {
                tarPaths = new HashSet<String>(8);
            }
            if (!tarPaths.add(tarPath)) continue;
            try {
                this.retrieveFileFromTAR(fsID, fileID);
            }
            catch (Exception e) {
                throw new Exception("Failed to retrieve TAR " + tarPath + " from file system " + fsID, e);
            }
        }
    }

    void postCoercionProcessing(Dataset ds, int command, Association assoc) throws Exception {
        this.doPostCoercionProcessing(ds, command, assoc);
    }

    protected void doPostCoercionProcessing(Dataset ds, int command, Association assoc) throws Exception {
    }

    public int getRetrieveRspStatusForNoMatchingInstanceToRetrieve() {
        return this.retrieveRspStatusForNoMatchingInstanceToRetrieve;
    }

    public void setRetrieveRspStatusForNoMatchingInstanceToRetrieve(int retrieveRspStatusForNoMatchingInstanceToRetrieve) {
        this.retrieveRspStatusForNoMatchingInstanceToRetrieve = retrieveRspStatusForNoMatchingInstanceToRetrieve;
    }

    public boolean isCoerceAttributeTopDown() {
        return this.coerceAttributeTopDown;
    }

    public void setCoerceAttributeTopDown(boolean reverse) {
        this.coerceAttributeTopDown = reverse;
    }

    public boolean isCFindRspDebugLogDeferToDoBeforeRsp() {
        return this.cFindRspDebugLogDeferToDoBeforeRsp;
    }

    public void setCFindRspDebugLogDeferToDoBeforeRsp(boolean defer) {
        this.cFindRspDebugLogDeferToDoBeforeRsp = defer;
    }

    public void setVerifyMD5OnMakeCStoreRQ(boolean verifyMD5OnMakeCStoreRQ) {
        this.verifyMD5OnMakeCStoreRQ = verifyMD5OnMakeCStoreRQ;
    }

    public boolean isVerifyMD5OnMakeCStoreRQ() {
        return this.verifyMD5OnMakeCStoreRQ;
    }
}

