/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import org.dcm4che.data.Dataset;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.DcmServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum QRLevel {
    PATIENT,
    STUDY,
    SERIES,
    IMAGE;

    private static final int[] UID_TAGS;

    void checkSOPClass(String cuid, String studyRoot, String patientStudyOnly) throws DcmServiceException {
        if (this == PATIENT) {
            if (cuid.equals(studyRoot)) {
                throw new DcmServiceException(43264, "Cannot use Query Retrieve Level PATIENT with Study Root IM");
            }
        } else if (this != STUDY && cuid.equals(patientStudyOnly)) {
            throw new DcmServiceException(43264, "Cannot use Query Retrieve Level " + (Object)((Object)this) + " with Patient Study Only IM");
        }
    }

    void checkRetrieveRQ(Dataset rqData) throws DcmServiceException {
        int level = 0;
        int levelOffset = -this.ordinal();
        while (level < UID_TAGS.length) {
            int uidTag = UID_TAGS[level];
            String[] uids = rqData.getStrings(uidTag);
            if (levelOffset > 0) {
                if (uids != null) {
                    throw new DcmServiceException(43264, "Illegal Unique Key Attribute " + Tags.toString(uidTag) + " in " + (Object)((Object)this) + " Level Retrieve RQ");
                }
            } else {
                if (levelOffset == 0 && (uids == null || uids.length == 0)) {
                    throw new DcmServiceException(43264, "Missing Unique Key Attribute " + Tags.toString(uidTag) + " in " + (Object)((Object)this) + " Level Retrieve RQ");
                }
                if ((levelOffset < 0 || level == 0) && uids != null && uids.length > 1) {
                    throw new DcmServiceException(43264, "Illegal List of UIDs in Unique Key Attribute " + Tags.toString(uidTag) + " in " + (Object)((Object)this) + " Level Retrieve RQ");
                }
            }
            ++level;
            ++levelOffset;
        }
    }

    static QRLevel toQRLevel(Dataset rqData) throws DcmServiceException {
        String qrLevel = rqData.getString(524370);
        try {
            return QRLevel.valueOf(qrLevel);
        }
        catch (NullPointerException e) {
            throw new DcmServiceException(43264, "Missing Query Retrieve Level");
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(43264, "Invalid Retrieve Level " + qrLevel);
        }
    }

    static {
        UID_TAGS = new int[]{0x100020, 0x20000D, 0x20000E, 524312};
    }
}

