/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.common.PIDWithIssuer;
import org.dcm4chex.archive.dcm.qrscp.MoveScu;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.dcm.qrscp.RetrieveInfo;
import org.dcm4chex.archive.dcm.qrscp.StudyInstanceUIDAndDirPath;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.perf.PerfMonDelegate;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTask
implements Runnable {
    protected final QueryRetrieveScpService service;
    protected final Logger log;
    private final String moveDest;
    private final AEDTO aeData;
    private final int movePcid;
    private final Dataset moveRqData;
    private final String moveOriginatorAET;
    private final String moveCalledAET;
    private final int priority;
    private final int msgID;
    private final String sopClassUID;
    private ActiveAssociation moveAssoc;
    private final Set<String> remainingIUIDs;
    private final Set<String> failedIUIDs;
    private final Map<PIDWithIssuer, Set<PIDWithIssuer>> pixQueryResults;
    private final int total;
    private int remaining;
    private int warnings = 0;
    private int completed = 0;
    private boolean canceled = false;
    private boolean moveAssocClosed = false;
    private ArrayList<FileInfo> successfulTransferred = new ArrayList();
    private MoveScu moveScu;
    private boolean directForwarding;
    private RetrieveInfo retrieveInfo;
    private Dataset stgCmtActionInfo;
    private DcmElement refSOPSeq;
    private PerfMonDelegate perfMon;
    private Set<String> invalidRequestedUIDs = new HashSet<String>();
    private DimseListener cancelListener = new DimseListener(){

        public void dimseReceived(Association assoc, Dimse dimse) {
            MoveTask.this.canceled = true;
            MoveScu tmp = MoveTask.this.moveScu;
            if (tmp != null) {
                tmp.forwardCancelRQ(dimse);
            }
        }
    };
    private TimerTask sendPendingRsp = new TimerTask(){

        public void run() {
            if (!MoveTask.this.canceled && MoveTask.this.remaining > 0) {
                Command rsp = MoveTask.this.makeMoveRsp(65280);
                MoveScu tmp = MoveTask.this.moveScu;
                if (MoveTask.this.directForwarding && tmp != null) {
                    tmp.adjustPendingRsp(rsp);
                }
                if (rsp.getInt(4128, 0) > 0) {
                    MoveTask.this.notifyMoveSCU(rsp, null);
                }
            }
        }
    };

    public MoveTask(QueryRetrieveScpService service, ActiveAssociation moveAssoc, int movePcid, Command moveRqCmd, Dataset moveRqData, FileInfo[][] fileInfo, AEDTO aeData, String moveDest) throws DcmServiceException {
        this.service = service;
        this.log = service.getLog();
        this.moveAssoc = moveAssoc;
        this.movePcid = movePcid;
        this.moveRqData = moveRqData;
        this.aeData = aeData;
        this.moveDest = moveDest;
        this.moveOriginatorAET = moveAssoc.getAssociation().getCallingAET();
        this.moveCalledAET = moveAssoc.getAssociation().getCalledAET();
        this.perfMon = service.getMoveScp().getPerfMonDelegate();
        this.priority = moveRqCmd.getInt(1792, 0);
        this.msgID = moveRqCmd.getMessageID();
        this.sopClassUID = moveRqCmd.getAffectedSOPClassUID();
        this.remaining = this.total = fileInfo.length;
        this.retrieveInfo = new RetrieveInfo(service, fileInfo);
        this.remainingIUIDs = this.retrieveInfo.getAvailableIUIDs();
        this.failedIUIDs = this.retrieveInfo.getNotAvailableIUIDs();
        moveAssoc.addCancelListener(this.msgID, this.cancelListener);
        HashMap hashMap = this.pixQueryResults = service.isAdjustPatientIDOnRetrieval() ? new HashMap() : null;
        if (service.getRetrieveRspStatusForNoMatchingInstanceToRetrieve() != 0) {
            this.findInvalidUIDsInRequest(moveRqData, fileInfo);
        }
    }

    private ActiveAssociation openAssociation() throws Exception {
        AssociationFactory asf = AssociationFactory.getInstance();
        Association a = asf.newRequestor(this.service.createSocket(this.moveCalledAET, this.aeData));
        a.setAcTimeout(this.service.getAcTimeout());
        a.setDimseTimeout(this.service.getDimseTimeout());
        a.setSoCloseDelay(this.service.getSoCloseDelay());
        a.putProperty("MoveAssociation", this.moveAssoc);
        AAssociateRQ rq = asf.newAAssociateRQ();
        rq.setCalledAET(this.moveDest);
        rq.setCallingAET(this.moveAssoc.getAssociation().getCalledAET());
        int maxOpsInvoked = this.service.getMaxStoreOpsInvoked();
        if (maxOpsInvoked != 1) {
            rq.setAsyncOpsWindow(asf.newAsyncOpsWindow(maxOpsInvoked, 1));
        }
        this.retrieveInfo.addPresContext(rq, this.service.notDecompressTsuidSet(), this.service.isSendWithDefaultTransferSyntax(this.moveDest), this.service.isOfferNoPixelData(this.moveDest), this.service.isOfferNoPixelDataDeflate(this.moveDest));
        this.perfMon.assocEstStart(a, 1);
        PDU pdu = a.connect(rq);
        this.perfMon.assocEstEnd(a, 1);
        if (!(pdu instanceof AAssociateAC)) {
            throw new IOException("Association not accepted by " + this.moveDest + ":\n" + pdu);
        }
        ActiveAssociation storeAssoc = asf.newActiveAssociation(a, null);
        storeAssoc.start();
        if (a.countAcceptedPresContext() == 0) {
            try {
                storeAssoc.release(false);
            }
            catch (Exception e) {
                this.log.info((Object)("Exception during release of assocation to " + this.moveDest), (Throwable)e);
            }
            throw new IOException("No Presentation Context for Storage accepted by " + this.moveDest);
        }
        this.removeInstancesOfUnsupportedStorageSOPClasses(a);
        return storeAssoc;
    }

    private void removeInstancesOfUnsupportedStorageSOPClasses(Association a) {
        Iterator<String> it = this.retrieveInfo.getCUIDs();
        while (it.hasNext()) {
            Collection<String> iuids;
            String cuid = it.next();
            if (a.listAcceptedPresContext(cuid).isEmpty()) {
                iuids = this.retrieveInfo.removeInstancesOfClass(cuid);
                it.remove();
                this.noPresentationContext(cuid, iuids, "No Presentation Context for " + QueryRetrieveScpService.uidDict.toString(cuid) + " accepted by " + this.moveDest + "\n\tCannot send " + iuids.size() + " instances of this class");
                continue;
            }
            HashSet<String> tsuids = new HashSet<String>(this.service.notDecompressTsuidSet());
            tsuids.retainAll(this.retrieveInfo.getTransferSyntaxesOfClass(cuid));
            for (String tsuid : tsuids) {
                if (a.getAcceptedPresContext(cuid, tsuid) != null || a.getAcceptedPresContext(cuid, "1.2.840.10008.1.2.4.96") != null || a.getAcceptedPresContext(cuid, "1.2.840.10008.1.2.4.97") != null || (iuids = this.retrieveInfo.removeLocalFilesOfClassWithTransferSyntax(cuid, tsuid)).isEmpty()) continue;
                this.noPresentationContext(cuid, iuids, "No Presentation Context for " + QueryRetrieveScpService.uidDict.toString(cuid) + " with " + QueryRetrieveScpService.uidDict.toString(tsuid) + " accepted by " + this.moveDest + "\n\tCannot send " + iuids.size() + " instances of this class");
            }
        }
    }

    private void noPresentationContext(String cuid, Collection<String> iuids, String prompt) {
        if (!this.service.isIgnorableSOPClass(cuid, this.moveDest)) {
            this.failedIUIDs.addAll(iuids);
            this.log.warn((Object)prompt);
        } else {
            this.completed += iuids.size();
            this.log.info((Object)prompt);
        }
        this.remainingIUIDs.removeAll(iuids);
        this.remaining = this.remainingIUIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.service.scheduleSendPendingCMoveRsp(this.sendPendingRsp);
        try {
            Set<String> localUIDs = this.retrieveInfo.removeLocalIUIDs();
            boolean updateLocalUIDs = false;
            while (!this.canceled && this.retrieveInfo.nextMoveForward()) {
                String retrieveAET = this.retrieveInfo.getMoveForwardAET();
                Set<String> iuids = this.retrieveInfo.getMoveForwardUIDs();
                this.directForwarding = !this.retrieveInfo.isExternalRetrieveAET() || this.service.isDirectForwarding(retrieveAET, this.moveDest);
                String moveDest1 = this.directForwarding ? this.moveDest : this.service.getLocalStorageAET();
                String callingAET = this.directForwarding && this.service.isForwardAsMoveOriginator() ? this.moveOriginatorAET : this.moveCalledAET;
                this.moveScu = new MoveScu(this.service, this.moveCalledAET, callingAET, retrieveAET, this.remaining);
                if (iuids.size() == this.total) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Forward original Move RQ to " + retrieveAET));
                    }
                    MoveScu.addStudySeriesIUIDs(this.moveRqData, this.retrieveInfo.getStudyIUIDs(), this.retrieveInfo.getSeriesIUIDs());
                    this.moveScu.forwardMoveRQ(this.movePcid, this.msgID, this.priority, moveDest1, this.moveRqData, iuids);
                } else {
                    this.moveScu.splitAndForwardMoveRQ(this.movePcid, this.msgID, this.priority, moveDest1, this.retrieveInfo.getStudyIUIDs(), this.retrieveInfo.getSeriesIUIDs(), iuids);
                }
                if (this.directForwarding) {
                    this.completed += this.moveScu.completed();
                    this.warnings += this.moveScu.warnings();
                    this.failedIUIDs.addAll(this.moveScu.failedIUIDs());
                    this.remainingIUIDs.removeAll(iuids);
                    this.remaining = this.canceled ? this.moveScu.remaining() : this.remainingIUIDs.size();
                } else if (this.moveScu.completed() > 0 || this.moveScu.warnings() > 0) {
                    updateLocalUIDs = true;
                }
                this.moveScu = null;
            }
            if (!this.canceled) {
                try {
                    if (updateLocalUIDs) {
                        RetrieveCmd cmd = RetrieveCmd.create((Dataset)this.moveRqData);
                        cmd.setFetchSize(this.service.getFetchSize());
                        FileInfo[][] fileInfo = cmd.getFileInfos();
                        this.retrieveInfo = new RetrieveInfo(this.service, fileInfo);
                        localUIDs = this.retrieveInfo.removeLocalIUIDs();
                    }
                    if (!localUIDs.isEmpty()) {
                        this.service.prefetchTars(this.retrieveInfo.getLocalFiles());
                        ActiveAssociation storeAssoc = this.openAssociation();
                        this.retrieveLocal(storeAssoc);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            Object var8_8 = null;
            this.sendPendingRsp.cancel();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.sendPendingRsp.cancel();
            throw throwable;
        }
        if (!this.canceled) {
            this.failedIUIDs.addAll(this.remainingIUIDs);
            this.remainingIUIDs.clear();
            this.remaining = 0;
        }
        this.notifyMoveSCU(this.makeMoveRsp(this.status()), this.service.makeRetrieveRspIdentifier(this.failedIUIDs));
    }

    private void retrieveLocal(ActiveAssociation storeAssoc) {
        this.stgCmtActionInfo = DcmObjectFactory.getInstance().newDataset();
        this.refSOPSeq = this.stgCmtActionInfo.putSQ(528793);
        HashSet<StudyInstanceUIDAndDirPath> studyInfos = new HashSet<StudyInstanceUIDAndDirPath>();
        Association a = storeAssoc.getAssociation();
        Collection<List<FileInfo>> localFiles = this.retrieveInfo.getLocalFiles();
        for (List<FileInfo> list : localFiles) {
            Dimse rq;
            final FileInfo fileInfo = list.get(0);
            final String iuid = fileInfo.sopIUID;
            DimseListener storeScpListener = new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    switch (dimse.getCommand().getStatus()) {
                        case 0: {
                            ++MoveTask.this.completed;
                            MoveTask.this.updateStgCmtActionInfo(fileInfo);
                            MoveTask.this.successfulTransferred.add(fileInfo);
                            break;
                        }
                        case 45056: 
                        case 45062: 
                        case 45063: {
                            ++MoveTask.this.warnings;
                            MoveTask.this.updateStgCmtActionInfo(fileInfo);
                            MoveTask.this.successfulTransferred.add(fileInfo);
                            break;
                        }
                        default: {
                            MoveTask.this.failedIUIDs.add(iuid);
                        }
                    }
                    MoveTask.this.remainingIUIDs.remove(iuid);
                    --MoveTask.this.remaining;
                }
            };
            try {
                rq = this.service.makeCStoreRQ(storeAssoc, fileInfo, this.aeData, this.priority, this.moveOriginatorAET, this.msgID, this.perfMon, this.pixQueryResults);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                this.failedIUIDs.add(iuid);
                this.remainingIUIDs.remove(iuid);
                --this.remaining;
                continue;
            }
            try {
                this.perfMon.start(storeAssoc, rq, 7);
                this.perfMon.setProperty(storeAssoc, rq, 1, rq);
                this.perfMon.setProperty(storeAssoc, rq, 6, fileInfo.studyIUID);
                storeAssoc.invoke(rq, storeScpListener);
                this.perfMon.stop(storeAssoc, rq, 7);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception during move of " + iuid), (Throwable)e);
            }
            if (fileInfo.availability == 0) {
                studyInfos.add(new StudyInstanceUIDAndDirPath(fileInfo));
            }
            if (!this.canceled && a.getState() == 6) continue;
            break;
        }
        if (a.getState() == 6) {
            try {
                this.perfMon.assocRelStart(a, 1);
                storeAssoc.release(true);
                this.perfMon.assocRelEnd(a, 1);
                Thread.sleep(10L);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception during release:", (Throwable)e);
            }
        } else {
            try {
                a.abort(AssociationFactory.getInstance().newAAbort(2, 0));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (!this.successfulTransferred.isEmpty()) {
            this.service.logInstancesSent(this.moveAssoc.getAssociation(), a, this.successfulTransferred);
            this.service.onInstancesRetrieved(this.moveCalledAET, this.moveDest, this.stgCmtActionInfo);
        }
        this.service.updateStudyAccessTime(studyInfos);
    }

    private void updateStgCmtActionInfo(FileInfo fileInfo) {
        Dataset item = this.refSOPSeq.addNewItem();
        item.putUI(528720, fileInfo.sopCUID);
        item.putUI(528725, fileInfo.sopIUID);
    }

    private int status() {
        int status;
        int n = this.canceled ? 65024 : (this.failedIUIDs.isEmpty() ? 0 : (status = this.completed == 0 && this.warnings == 0 ? 42754 : 45056));
        if (status == 0 && !this.invalidRequestedUIDs.isEmpty()) {
            status = this.service.getRetrieveRspStatusForNoMatchingInstanceToRetrieve();
            this.warnings += this.invalidRequestedUIDs.size();
        }
        return status;
    }

    private void notifyMoveSCU(Command moveRspCmd, Dataset moveRspData) {
        if (!this.moveAssocClosed) {
            try {
                this.moveAssoc.getAssociation().write(AssociationFactory.getInstance().newDimse(this.movePcid, moveRspCmd, moveRspData));
            }
            catch (Exception e) {
                this.log.info((Object)"Failed to send Move RSP to Move Originator:", (Throwable)e);
                this.moveAssocClosed = true;
            }
        }
    }

    private Command makeMoveRsp(int status) {
        Command rspCmd = DcmObjectFactory.getInstance().newCommand();
        rspCmd.initCMoveRSP(this.msgID, this.sopClassUID, status);
        if (this.remaining > 0) {
            rspCmd.putUS(4128, this.remaining);
        } else {
            rspCmd.remove(4128);
        }
        rspCmd.putUS(4129, this.completed);
        rspCmd.putUS(4131, this.warnings);
        rspCmd.putUS(4130, this.failedIUIDs.size());
        return rspCmd;
    }

    private void findInvalidUIDsInRequest(Dataset moveRqData, FileInfo[][] fileInfo) {
        String qrLevel = moveRqData.getString(524370);
        String[] uids = null;
        HashSet<String> existingIDs = new HashSet<String>();
        if ("IMAGE".equals(qrLevel)) {
            uids = moveRqData.getStrings(524312);
            for (FileInfo[] fileInfoArray : fileInfo) {
                existingIDs.add(fileInfoArray[0].sopIUID);
            }
        }
        if ("SERIES".equals(qrLevel)) {
            uids = moveRqData.getStrings(0x20000E);
            for (FileInfo[] fileInfoArray : fileInfo) {
                existingIDs.add(fileInfoArray[0].seriesIUID);
            }
        }
        if ("STUDY".equals(qrLevel)) {
            uids = moveRqData.getStrings(0x20000D);
            for (FileInfo[] fileInfoArray : fileInfo) {
                existingIDs.add(fileInfoArray[0].studyIUID);
            }
        }
        if ("PATIENT".equals(qrLevel)) {
            uids = new String[]{moveRqData.getString(0x100020)};
            if (fileInfo.length != 0) {
                existingIDs.add(fileInfo[0][0].patID);
            }
        }
        for (FileInfo[] fileInfoArray : uids) {
            if (existingIDs.contains(fileInfoArray)) continue;
            this.invalidRequestedUIDs.add((String)fileInfoArray);
        }
        if (!this.invalidRequestedUIDs.isEmpty()) {
            this.log.warn((Object)("Found invalid UIDs in c-move: " + this.invalidRequestedUIDs));
        }
    }
}

