/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MoveScu {
    private static final String IMAGE = "IMAGE";
    private static final String PATIENT = "PATIENT";
    private static final byte[] RELATIONAL_RETRIEVE = new byte[]{1};
    private final QueryRetrieveScpService service;
    private final Logger log;
    private final String localAET;
    private final String callingAET;
    private final String calledAET;
    private ActiveAssociation assoc;
    private int remaining;
    private int completed = 0;
    private int failed = 0;
    private int warnings = 0;
    private final Collection<String> failedIUIDs = new ArrayList<String>();
    private boolean canceled;
    private Command moveRspCmd;
    private Dataset moveRspData;

    public MoveScu(QueryRetrieveScpService service, String localAET, String callingAET, String calledAET, int remaining) {
        this.service = service;
        this.log = service.getLog();
        this.localAET = localAET;
        this.callingAET = callingAET;
        this.calledAET = calledAET;
        this.remaining = remaining;
    }

    public final int completed() {
        return this.completed;
    }

    public final int warnings() {
        return this.warnings;
    }

    public final int failed() {
        return this.failed;
    }

    public final int remaining() {
        return this.remaining;
    }

    public final Collection<String> failedIUIDs() {
        return this.failedIUIDs;
    }

    public final Command getMoveRspCmd() {
        return this.moveRspCmd;
    }

    public void forwardCancelRQ(Dimse ccancelrq) {
        this.canceled = true;
        if (this.assoc != null) {
            try {
                this.assoc.getAssociation().write(ccancelrq);
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to forward C-CANCEL-RQ:", (Throwable)e);
            }
        }
    }

    public void splitAndForwardMoveRQ(int pcid, int msgid, int priority, String moveDest, Collection<String> studyIuids, Collection<String> seriesIuids, Collection<String> iuids) {
        String[] a;
        DcmObjectFactory dof = DcmObjectFactory.getInstance();
        Dataset ds = dof.newDataset();
        ds.putCS(524370, IMAGE);
        if (studyIuids.size() == 1) {
            ds.putUI(0x20000D, studyIuids.iterator().next());
        }
        if (seriesIuids.size() == 1) {
            ds.putUI(0x20000E, seriesIuids.iterator().next());
        }
        if ((a = iuids.toArray(new String[iuids.size()])).length <= this.service.getMaxUIDsPerMoveRQ()) {
            ds.putUI(524312, a);
            this.forwardMoveRQ(pcid, msgid, priority, moveDest, ds, iuids);
        } else {
            String[] b = new String[this.service.getMaxUIDsPerMoveRQ()];
            int off = 0;
            while (off + b.length < a.length) {
                System.arraycopy(a, off, b, 0, b.length);
                ds.putUI(524312, b);
                this.forwardMoveRQ(pcid, msgid, priority, moveDest, ds, Arrays.asList(b));
                if (this.canceled) {
                    return;
                }
                off += b.length;
            }
            b = new String[a.length - off];
            System.arraycopy(a, off, b, 0, b.length);
            ds.putUI(524312, b);
            this.forwardMoveRQ(pcid, msgid, priority, moveDest, ds, Arrays.asList(b));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void forwardMoveRQ(int pcid, int msgid, int priority, String moveDest, Dataset moveRqData, Collection<String> iuids) {
        block15: {
            this.remaining -= iuids.size();
            String sopClassUID = PATIENT.equals(moveRqData.getString(524370)) ? "1.2.840.10008.5.1.4.1.2.1.2" : "1.2.840.10008.5.1.4.1.2.2.2";
            try {
                this.assoc = this.openAssociation(pcid, sopClassUID);
            }
            catch (Exception e) {
                this.log.info((Object)("Failed to open assocation to " + this.calledAET), (Throwable)e);
                this.failedIUIDs.addAll(iuids);
                return;
            }
            this.moveRspCmd = null;
            this.moveRspData = null;
            DimseListener moveRspListener = new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MoveScu.this.moveRspCmd = dimse.getCommand();
                    try {
                        MoveScu.this.moveRspData = dimse.getDataset();
                    }
                    catch (IOException e) {
                        MoveScu.this.log.error((Object)("Failure during receive of C-MOVE_RSP from " + MoveScu.this.calledAET), (Throwable)e);
                    }
                }
            };
            AssociationFactory asf = AssociationFactory.getInstance();
            Command moveRqCmd = DcmObjectFactory.getInstance().newCommand();
            moveRqCmd.initCMoveRQ(msgid, sopClassUID, priority, moveDest);
            this.assoc.invoke(asf.newDimse(pcid, moveRqCmd, moveRqData), moveRspListener);
            Object var12_13 = null;
            try {
                this.assoc.release(true);
                Thread.sleep(10L);
            }
            catch (Exception e2) {
                this.log.info((Object)("Exception during release of assocation to " + this.calledAET), (Throwable)e2);
            }
            break block15;
            {
                catch (Exception e) {
                    this.log.error((Object)("Failed to forward MOVE RQ to " + this.calledAET), (Throwable)e);
                    Object var12_14 = null;
                    try {
                        this.assoc.release(true);
                        Thread.sleep(10L);
                    }
                    catch (Exception e2) {
                        this.log.info((Object)("Exception during release of assocation to " + this.calledAET), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    this.assoc.release(true);
                    Thread.sleep(10L);
                }
                catch (Exception e2) {
                    this.log.info((Object)("Exception during release of assocation to " + this.calledAET), (Throwable)e2);
                }
                throw throwable;
            }
        }
        if (this.moveRspCmd == null || this.moveRspCmd.getStatus() == 65280) {
            this.log.error((Object)("No final MOVE RSP received from " + this.calledAET));
            this.failedIUIDs.addAll(iuids);
            this.failed += iuids.size();
        } else {
            this.completed += this.moveRspCmd.getInt(4129, 0);
            this.warnings += this.moveRspCmd.getInt(4131, 0);
            this.failed += this.moveRspCmd.getInt(4130, 0);
            this.remaining += this.moveRspCmd.getInt(4128, 0);
            if (this.moveRspData != null) {
                String[] a = this.moveRspData.getStrings(524376);
                if (a != null && a.length != 0) {
                    this.failedIUIDs.addAll(Arrays.asList(a));
                } else {
                    this.failedIUIDs.addAll(iuids);
                }
            }
        }
        this.moveRspCmd = null;
    }

    private ActiveAssociation openAssociation(int pcid, String sopClassUID) throws Exception {
        AEDTO retrieveAEData = this.service.queryAEData(this.calledAET, null);
        AssociationFactory asf = AssociationFactory.getInstance();
        Association a = asf.newRequestor(this.service.createSocket(this.localAET, retrieveAEData));
        a.setAcTimeout(this.service.getAcTimeout());
        a.setDimseTimeout(this.service.getDimseTimeout());
        a.setSoCloseDelay(this.service.getSoCloseDelay());
        AAssociateRQ rq = asf.newAAssociateRQ();
        rq.setCalledAET(this.calledAET);
        rq.setCallingAET(this.callingAET);
        rq.addPresContext(asf.newPresContext(pcid, sopClassUID));
        rq.addExtNegotiation(asf.newExtNegotiation(sopClassUID, RELATIONAL_RETRIEVE));
        PDU pdu = a.connect(rq);
        if (!(pdu instanceof AAssociateAC)) {
            throw new IOException("Association not accepted by " + this.calledAET + ":\n" + pdu);
        }
        AAssociateAC ac = (AAssociateAC)pdu;
        ActiveAssociation assoc = asf.newActiveAssociation(a, null);
        assoc.start();
        if (a.getAcceptedTransferSyntaxUID(pcid) == null) {
            try {
                assoc.release(false);
            }
            catch (Exception e) {
                this.log.info((Object)("Exception during release of assocation to " + this.calledAET), (Throwable)e);
            }
            throw new IOException(QueryRetrieveScpService.uidDict.toString(sopClassUID) + " not accepted by " + this.calledAET);
        }
        ExtNegotiation extNeg = ac.getExtNegotiation(sopClassUID);
        if (extNeg == null || !Arrays.equals(extNeg.info(), RELATIONAL_RETRIEVE)) {
            this.log.warn((Object)("Relational Retrieve not supported by " + this.calledAET));
        }
        return assoc;
    }

    public void adjustPendingRsp(Command rspCmd) {
        Command tmp = this.moveRspCmd;
        rspCmd.putUS(4128, this.remaining + (tmp == null ? 0 : tmp.getInt(4128, 0)));
        rspCmd.putUS(4129, rspCmd.getInt(4129, 0) + this.completed + (tmp == null ? 0 : tmp.getInt(4129, 0)));
        rspCmd.putUS(4131, rspCmd.getInt(4131, 0) + this.warnings + (tmp == null ? 0 : tmp.getInt(4131, 0)));
        rspCmd.putUS(4130, rspCmd.getInt(4130, 0) + this.failed + (tmp == null ? 0 : tmp.getInt(4130, 0)));
    }

    public static void addStudySeriesIUIDs(Dataset moveRqData, Collection<String> studyIUIDs, Collection<String> seriesIUIDs) {
        String qrLevel = moveRqData.getString(524370);
        if ("STUDY".equals(qrLevel) || PATIENT.equals(qrLevel)) {
            return;
        }
        if (studyIUIDs.size() == 1) {
            moveRqData.putUI(0x20000D, studyIUIDs.iterator().next());
        }
        if ("SERIES".equals(qrLevel)) {
            return;
        }
        if (seriesIUIDs.size() == 1) {
            moveRqData.putUI(0x20000E, seriesIUIDs.iterator().next());
        }
    }
}

