/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.dcm.qrscp.MoveTask;
import org.dcm4chex.archive.dcm.qrscp.QRLevel;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManager;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.perf.PerfMonDelegate;
import org.jboss.logging.Logger;

public class MoveScp
extends DcmServiceBase
implements AssociationListener {
    private static final int MISSING_USER_ID_OF_MOVE_SCU_ERR_STATUS = 52752;
    private static final int MISSING_USER_ID_OF_STORE_SCP_ERR_STATUS = 52754;
    private static final int NO_READ_PERMISSION_ERR_STATUS = 52768;
    private static final int NO_EXPORT_PERMISSION_ERR_STATUS = 52770;
    private static final String MISSING_USER_ID_OF_MOVE_SCU_ERR_MSG = "Missing user identification of Move originator";
    private static final String MISSING_USER_ID_OF_STORE_SCP_ERR_MSG = "Missing or invalid user identification of Move destination";
    private static final String NO_READ_PERMISSION_ERR_MSG = "Move destination has no permission to read Study";
    private static final String NO_EXPORT_PERMISSION_ERR_MSG = "Move originator has no permission to export Study";
    protected final QueryRetrieveScpService service;
    private final Logger log;
    private PerfMonDelegate perfMon;

    public MoveScp(QueryRetrieveScpService service) {
        this.service = service;
        this.log = service.getLog();
        this.perfMon = new PerfMonDelegate(this.service);
    }

    public void c_move(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        Association a = assoc.getAssociation();
        try {
            String dest;
            Dataset rqData = rq.getDataset();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Identifier:\n");
                this.log.debug((Object)rqData);
            }
            if ((dest = rqCmd.getString(1536)) == null) {
                throw new DcmServiceException(49152, "Missing Move Destination");
            }
            QRLevel qrLevel = QRLevel.toQRLevel(rqData);
            qrLevel.checkSOPClass(rqCmd.getAffectedSOPClassUID(), "1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.3.2");
            qrLevel.checkRetrieveRQ(rqData);
            boolean thirdPartyMove = !dest.equals(a.getCallingAET());
            AEDTO aeData = null;
            FileInfo[][] fileInfos = null;
            try {
                this.perfMon.start(assoc, rq, 6);
                this.perfMon.setProperty(assoc, rq, 1, rq);
                aeData = this.service.queryAEData(dest, thirdPartyMove ? null : a.getSocket().getInetAddress());
                fileInfos = this.getFileInfos(rqData);
                this.perfMon.setProperty(assoc, rq, 5, String.valueOf(fileInfos.length));
                this.perfMon.stop(assoc, rq, 6);
                this.checkPermission(a, thirdPartyMove, aeData, fileInfos);
                new Thread(this.createMoveTask(this.service, assoc, rq.pcid(), rqCmd, rqData, fileInfos, aeData, dest)).start();
            }
            catch (DcmServiceException e) {
                throw e;
            }
            catch (UnknownAETException e) {
                throw new DcmServiceException(43009, "Unknown move destination:" + dest);
            }
            catch (SQLException e) {
                this.service.getLog().error((Object)"Query DB failed:", (Throwable)e);
                throw new DcmServiceException(42753, (Throwable)e);
            }
            catch (Throwable e) {
                this.service.getLog().error((Object)"Unexpected exception:", e);
                throw new DcmServiceException(49152, e);
            }
        }
        catch (DcmServiceException e) {
            Command rspCmd = objFact.newCommand();
            rspCmd.initCMoveRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), e.getStatus());
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
            a.write(rsp);
        }
    }

    protected FileInfo[][] getFileInfos(Dataset rqData) throws Exception {
        RetrieveCmd cmd = RetrieveCmd.create((Dataset)rqData);
        cmd.setFetchSize(this.service.getFetchSize());
        return cmd.getFileInfos();
    }

    private void checkPermission(Association a, boolean thirdPartyMove, AEDTO ae, FileInfo[][] fileInfos) throws Exception {
        Iterator iter;
        boolean checkReadPermissions;
        boolean checkExportPermissions = thirdPartyMove && !this.service.hasUnrestrictedExportPermissions(a.getCallingAET());
        boolean bl = checkReadPermissions = !this.service.hasUnrestrictedReadPermissions(ae.getTitle());
        if (!checkExportPermissions && !checkReadPermissions) {
            return;
        }
        HashSet<String> suids = new HashSet<String>();
        for (int i = 0; i < fileInfos.length; ++i) {
            suids.add(fileInfos[i][0].studyIUID);
        }
        Subject subject = (Subject)a.getProperty("user");
        StudyPermissionManager studyPermissionManager = this.service.getStudyPermissionManager(a);
        if (checkExportPermissions) {
            if (subject == null) {
                throw new DcmServiceException(52752, MISSING_USER_ID_OF_MOVE_SCU_ERR_MSG);
            }
            iter = suids.iterator();
            while (iter.hasNext()) {
                if (studyPermissionManager.hasPermission((String)iter.next(), "E", subject)) continue;
                throw new DcmServiceException(52770, NO_EXPORT_PERMISSION_ERR_MSG);
            }
        }
        if (checkReadPermissions) {
            if (subject == null || thirdPartyMove) {
                subject = new Subject();
                String userId = ae.getUserID();
                String passwd = ae.getPassword();
                if (userId == null || userId.length() == 0 || !this.service.dicomSecurity().isValid(userId, passwd, subject)) {
                    throw new DcmServiceException(52754, MISSING_USER_ID_OF_STORE_SCP_ERR_MSG);
                }
            }
            iter = suids.iterator();
            while (iter.hasNext()) {
                if (studyPermissionManager.hasPermission((String)iter.next(), "R", subject)) continue;
                throw new DcmServiceException(52768, NO_READ_PERMISSION_ERR_MSG);
            }
        }
    }

    protected MoveTask createMoveTask(QueryRetrieveScpService service, ActiveAssociation moveAssoc, int movePcid, Command moveRqCmd, Dataset moveRqData, FileInfo[][] fileInfo, AEDTO aeData, String moveDest) throws DcmServiceException {
        return new MoveTask(service, moveAssoc, movePcid, moveRqCmd, moveRqData, fileInfo, aeData, moveDest);
    }

    public final ObjectName getPerfMonServiceName() {
        return this.perfMon.getPerfMonServiceName();
    }

    public final void setPerfMonServiceName(ObjectName perfMonServiceName) {
        this.perfMon.setPerfMonServiceName(perfMonServiceName);
    }

    public PerfMonDelegate getPerfMonDelegate() {
        return this.perfMon;
    }

    public void write(Association src, PDU pdu) {
        if (pdu instanceof AAssociateAC) {
            this.perfMon.assocEstEnd(src, 33);
        }
    }

    public void received(Association src, PDU pdu) {
        if (pdu instanceof AAssociateRQ) {
            this.perfMon.assocEstStart(src, 33);
        }
    }

    public void write(Association src, Dimse dimse) {
    }

    public void received(Association src, Dimse dimse) {
    }

    public void error(Association src, IOException ioe) {
    }

    public void closing(Association assoc) {
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelStart(assoc, 33);
        }
    }

    public void closed(Association assoc) {
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelEnd(assoc, 33);
        }
    }
}

