/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4chex.archive.common.PIDWithIssuer;
import org.dcm4chex.archive.dcm.qrscp.MoveScu;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.dcm.qrscp.RetrieveInfo;
import org.dcm4chex.archive.dcm.qrscp.StudyInstanceUIDAndDirPath;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.exceptions.NoPresContextException;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetTask
implements Runnable {
    private final QueryRetrieveScpService service;
    private final Logger log;
    private ActiveAssociation assoc;
    private String callingAET;
    private String calledAET;
    private final int pcid;
    private final Dataset rqData;
    private final int priority;
    private final int msgID;
    private final String sopClassUID;
    private final ArrayList<FileInfo> transferred = new ArrayList();
    private final Set<String> remainingIUIDs;
    private final Set<String> failedIUIDs;
    private final Map<PIDWithIssuer, Set<PIDWithIssuer>> pixQueryResults;
    private int total;
    private int warnings = 0;
    private int completed = 0;
    private boolean canceled = false;
    private RetrieveInfo retrieveInfo;
    private MoveScu moveScu;
    private DimseListener cancelListener = new DimseListener(){

        public void dimseReceived(Association assoc, Dimse dimse) {
            GetTask.this.canceled = true;
            MoveScu tmp = GetTask.this.moveScu;
            if (tmp != null) {
                tmp.forwardCancelRQ(dimse);
            }
        }
    };
    private TimerTask sendPendingRsp = new TimerTask(){

        public void run() {
            if (!GetTask.this.canceled && !GetTask.this.remainingIUIDs.isEmpty()) {
                GetTask.this.sendGetRsp(65280, null);
            }
        }
    };

    public GetTask(QueryRetrieveScpService service, ActiveAssociation assoc, int pcid, Command rqCmd, Dataset rqData, FileInfo[][] fileInfos) {
        this.service = service;
        this.log = service.getLog();
        this.assoc = assoc;
        this.callingAET = assoc.getAssociation().getCallingAET();
        this.calledAET = assoc.getAssociation().getCalledAET();
        this.pcid = pcid;
        this.rqData = rqData;
        this.sopClassUID = rqCmd.getAffectedSOPClassUID();
        this.priority = rqCmd.getInt(1792, 0);
        this.msgID = rqCmd.getMessageID();
        this.total = fileInfos.length;
        this.retrieveInfo = new RetrieveInfo(service, fileInfos);
        this.remainingIUIDs = this.retrieveInfo.getAvailableIUIDs();
        this.failedIUIDs = this.retrieveInfo.getNotAvailableIUIDs();
        assoc.addCancelListener(this.msgID, this.cancelListener);
        this.pixQueryResults = service.isAdjustPatientIDOnRetrieval() ? new HashMap() : null;
    }

    private void removeInstancesOfUnsupportedStorageSOPClasses() {
        Association a = this.assoc.getAssociation();
        Iterator<String> it = this.retrieveInfo.getCUIDs();
        while (it.hasNext()) {
            Collection<String> iuids;
            String cuid = it.next();
            if (a.listAcceptedPresContext(cuid).isEmpty() && a.getAcceptedPresContext(cuid, "1.2.840.10008.1.2.4.96") == null && a.getAcceptedPresContext(cuid, "1.2.840.10008.1.2.4.97") == null) {
                iuids = this.retrieveInfo.removeInstancesOfClass(cuid);
                it.remove();
                String prompt = "No Presentation Context for " + QueryRetrieveScpService.uidDict.toString(cuid) + " offered by " + this.callingAET + "\n\tCannot send " + iuids.size() + " instances of this class";
                this.noPresentationContext(cuid, iuids, prompt);
                continue;
            }
            HashSet<String> tsuids = new HashSet<String>(this.service.notDecompressTsuidSet());
            tsuids.retainAll(this.retrieveInfo.getTransferSyntaxesOfClass(cuid));
            for (String tsuid : tsuids) {
                if (a.getAcceptedPresContext(cuid, tsuid) != null || (iuids = this.retrieveInfo.removeLocalFilesOfClassWithTransferSyntax(cuid, tsuid)).isEmpty()) continue;
                this.noPresentationContext(cuid, iuids, "No Presentation Context for " + QueryRetrieveScpService.uidDict.toString(cuid) + " with " + QueryRetrieveScpService.uidDict.toString(tsuid) + " accepted by " + this.callingAET + "\n\tCannot send " + iuids.size() + " instances of this class");
            }
        }
    }

    private void noPresentationContext(String cuid, Collection<String> iuids, String prompt) {
        if (!this.service.isIgnorableSOPClass(cuid, this.callingAET)) {
            this.failedIUIDs.addAll(iuids);
            this.log.warn((Object)prompt);
        } else {
            this.completed += iuids.size();
            this.log.info((Object)prompt);
        }
        this.remainingIUIDs.removeAll(iuids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<String> localUIDs = this.retrieveInfo.removeLocalIUIDs();
        boolean updateLocalUIDs = false;
        if (this.retrieveInfo.nextMoveForward()) {
            this.service.scheduleSendPendingCGetRsp(this.sendPendingRsp);
            try {
                do {
                    String retrieveAET = this.retrieveInfo.getMoveForwardAET();
                    Set<String> iuids = this.retrieveInfo.getMoveForwardUIDs();
                    this.moveScu = new MoveScu(this.service, this.calledAET, this.calledAET, retrieveAET, 0);
                    if (iuids.size() == this.total) {
                        MoveScu.addStudySeriesIUIDs(this.rqData, this.retrieveInfo.getStudyIUIDs(), this.retrieveInfo.getSeriesIUIDs());
                        this.moveScu.forwardMoveRQ(this.pcid, this.msgID, this.priority, this.service.getLocalStorageAET(), this.rqData, iuids);
                    } else {
                        this.moveScu.splitAndForwardMoveRQ(this.pcid, this.msgID, this.priority, this.service.getLocalStorageAET(), this.retrieveInfo.getStudyIUIDs(), this.retrieveInfo.getSeriesIUIDs(), iuids);
                    }
                    if (this.moveScu.completed() > 0 || this.moveScu.warnings() > 0) {
                        updateLocalUIDs = true;
                    }
                    this.moveScu = null;
                    if (this.canceled) break;
                } while (this.retrieveInfo.nextMoveForward());
                Object var6_6 = null;
                this.sendPendingRsp.cancel();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.sendPendingRsp.cancel();
                throw throwable;
            }
            {
            }
        }
        if (!this.canceled) {
            try {
                if (updateLocalUIDs) {
                    RetrieveCmd cmd = RetrieveCmd.create((Dataset)this.rqData);
                    cmd.setFetchSize(this.service.getFetchSize());
                    FileInfo[][] fileInfo = cmd.getFileInfos();
                    this.retrieveInfo = new RetrieveInfo(this.service, fileInfo);
                    localUIDs = this.retrieveInfo.removeLocalIUIDs();
                }
                if (!localUIDs.isEmpty()) {
                    this.service.prefetchTars(this.retrieveInfo.getLocalFiles());
                    this.removeInstancesOfUnsupportedStorageSOPClasses();
                    this.retrieveInstances();
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!this.canceled) {
            this.failedIUIDs.addAll(this.remainingIUIDs);
            this.remainingIUIDs.clear();
        }
        this.sendGetRsp(this.status(), this.service.makeRetrieveRspIdentifier(this.failedIUIDs));
    }

    private void retrieveInstances() {
        HashSet<StudyInstanceUIDAndDirPath> studyInfos = new HashSet<StudyInstanceUIDAndDirPath>();
        Association a = this.assoc.getAssociation();
        Collection<List<FileInfo>> localFiles = this.retrieveInfo.getLocalFiles();
        for (List<FileInfo> list : localFiles) {
            Dimse rq;
            if (this.service.isSendPendingCGetRSP()) {
                this.sendGetRsp(65280, null);
            }
            final FileInfo fileInfo = list.get(0);
            final String iuid = fileInfo.sopIUID;
            DimseListener storeScpListener = new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    switch (dimse.getCommand().getStatus()) {
                        case 0: {
                            ++GetTask.this.completed;
                            GetTask.this.transferred.add(fileInfo);
                            break;
                        }
                        case 45056: 
                        case 45062: 
                        case 45063: {
                            ++GetTask.this.warnings;
                            GetTask.this.transferred.add(fileInfo);
                            break;
                        }
                        default: {
                            GetTask.this.failedIUIDs.add(iuid);
                        }
                    }
                    GetTask.this.remainingIUIDs.remove(iuid);
                }
            };
            try {
                rq = this.service.makeCStoreRQ(this.assoc, fileInfo, null, this.priority, null, 0, null, this.pixQueryResults);
            }
            catch (NoPresContextException e) {
                if (!this.service.isIgnorableSOPClass(fileInfo.sopCUID, a.getCallingAET())) {
                    this.failedIUIDs.add(fileInfo.sopIUID);
                    this.remainingIUIDs.remove(iuid);
                    this.log.warn((Object)e.getMessage());
                    continue;
                }
                this.log.info((Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                this.failedIUIDs.add(iuid);
                this.remainingIUIDs.remove(iuid);
                continue;
            }
            try {
                this.assoc.invoke(rq, storeScpListener);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception during retrieve of " + iuid), (Throwable)e);
            }
            if (fileInfo.availability == 0) {
                studyInfos.add(new StudyInstanceUIDAndDirPath(fileInfo));
            }
            if (!this.canceled && a.getState() == 6) continue;
            break;
        }
        if (a.getState() == 6) {
            try {
                this.assoc.waitForPendingRSP();
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"Exception during wait for pending C-STORE RSP:", (Throwable)e);
            }
        }
        if (!this.transferred.isEmpty()) {
            this.service.logInstancesSent(a, a, this.transferred);
        }
        this.service.updateStudyAccessTime(studyInfos);
    }

    private int status() {
        return this.canceled ? 65024 : (this.failedIUIDs.isEmpty() ? 0 : (this.completed == 0 && this.warnings == 0 ? 42754 : 45056));
    }

    private void sendGetRsp(int status, Dataset ds) {
        Command rspCmd = DcmObjectFactory.getInstance().newCommand();
        rspCmd.initCGetRSP(this.msgID, this.sopClassUID, status);
        if (!this.remainingIUIDs.isEmpty()) {
            rspCmd.putUS(4128, this.remainingIUIDs.size());
        } else {
            rspCmd.remove(4128);
        }
        rspCmd.putUS(4129, this.completed);
        rspCmd.putUS(4131, this.warnings);
        rspCmd.putUS(4130, this.failedIUIDs.size());
        try {
            this.assoc.getAssociation().write(AssociationFactory.getInstance().newDimse(this.pcid, rspCmd, ds));
        }
        catch (Exception e) {
            this.log.info((Object)("Failed to send C-GET RSP to " + this.callingAET), (Throwable)e);
        }
    }
}

