/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.qrscp.GetTask;
import org.dcm4chex.archive.dcm.qrscp.QRLevel;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManager;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.jboss.logging.Logger;

public class GetScp
extends DcmServiceBase {
    private static final int MISSING_USER_ID_OF_STORE_SCP_ERR_STATUS = 52754;
    private static final int NO_READ_PERMISSION_ERR_STATUS = 52768;
    private static final String MISSING_USER_ID_OF_STORE_SCP_ERR_MSG = "Missing or invalid user identification of retrieve destination";
    private static final String NO_READ_PERMISSION_ERR_MSG = "Retrieve destination has no permission to read Study";
    protected final QueryRetrieveScpService service;
    private final Logger log;

    public GetScp(QueryRetrieveScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    public void c_get(ActiveAssociation assoc, Dimse rq) throws IOException {
        int pcid = rq.pcid();
        Command rqCmd = rq.getCommand();
        Association a = assoc.getAssociation();
        try {
            Dataset rqData = rq.getDataset();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Identifier:\n");
                this.log.debug((Object)rqData);
            }
            QRLevel qrLevel = QRLevel.toQRLevel(rqData);
            qrLevel.checkSOPClass(rqCmd.getAffectedSOPClassUID(), "1.2.840.10008.5.1.4.1.2.2.3", "1.2.840.10008.5.1.4.1.2.3.3");
            qrLevel.checkRetrieveRQ(rqData);
            FileInfo[][] fileInfos = null;
            try {
                RetrieveCmd cmd = RetrieveCmd.create((Dataset)rqData);
                cmd.setFetchSize(this.service.getFetchSize());
                fileInfos = cmd.getFileInfos();
                this.checkPermission(a, fileInfos);
                new Thread(new GetTask(this.service, assoc, pcid, rqCmd, rqData, fileInfos)).start();
            }
            catch (DcmServiceException e) {
                throw e;
            }
            catch (SQLException e) {
                this.service.getLog().error((Object)"Query DB failed:", (Throwable)e);
                throw new DcmServiceException(42753, (Throwable)e);
            }
            catch (Throwable e) {
                this.service.getLog().error((Object)"Unexpected exception:", e);
                throw new DcmServiceException(49152, e);
            }
        }
        catch (DcmServiceException e) {
            Command rspCmd = objFact.newCommand();
            rspCmd.initCGetRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), e.getStatus());
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(pcid, rspCmd);
            a.write(rsp);
        }
    }

    private void checkPermission(Association a, FileInfo[][] fileInfos) throws Exception {
        if (fileInfos.length == 0) {
            return;
        }
        String callingAET = a.getCallingAET();
        if (this.service.hasUnrestrictedReadPermissions(callingAET)) {
            return;
        }
        Subject subject = (Subject)a.getProperty("user");
        if (subject == null) {
            throw new DcmServiceException(52754, MISSING_USER_ID_OF_STORE_SCP_ERR_MSG);
        }
        StudyPermissionManager studyPermissionManager = this.service.getStudyPermissionManager(a);
        HashSet<String> suids = new HashSet<String>();
        for (int i = 0; i < fileInfos.length; ++i) {
            if (!suids.add(fileInfos[i][0].studyIUID) || studyPermissionManager.hasPermission(fileInfos[i][0].studyIUID, "R", subject)) continue;
            throw new DcmServiceException(52768, NO_READ_PERMISSION_ERR_MSG);
        }
    }
}

