/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.qrscp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.xml.transform.Templates;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.common.PIDWithIssuer;
import org.dcm4chex.archive.dcm.qrscp.QueryRetrieveScpService;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.perf.PerfMonDelegate;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindScp
extends DcmServiceBase
implements AssociationListener {
    protected static final int PID = 0;
    protected static final int ISSUER = 1;
    private static final int FUZZY_MATCHING = 2;
    private static final String QUERY_XSL = "cfindrq.xsl";
    private static final String RESULT_XSL = "cfindrsp.xsl";
    private static final String QUERY_XML = "-cfindrq.xml";
    private static final String RESULT_XML = "-cfindrsp.xml";
    protected static final String FORCE_PIX_QUERY_FLAG = "ForcePIXQueryFlag";
    private static final DcmServiceBase.MultiDimseRsp NO_MATCH_RSP = new DcmServiceBase.MultiDimseRsp(){

        public DimseListener getCancelListener() {
            return null;
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            rspCmd.putUS(2304, 0);
            return null;
        }

        public void release() {
        }
    };
    protected final QueryRetrieveScpService service;
    protected final boolean filterResult;
    protected final Logger log;
    private PerfMonDelegate perfMon;
    private static final int[] EXCLUDE_FROM_RSP_TAGS = new int[]{0x101002, 0x100021, 524369};

    public FindScp(QueryRetrieveScpService service, boolean filterResult) {
        this.service = service;
        this.log = service.getLog();
        this.filterResult = filterResult;
        this.perfMon = new PerfMonDelegate(this.service);
    }

    public final ObjectName getPerfMonServiceName() {
        return this.perfMon.getPerfMonServiceName();
    }

    public final void setPerfMonServiceName(ObjectName perfMonServiceName) {
        this.perfMon.setPerfMonServiceName(perfMonServiceName);
    }

    @Override
    protected DcmServiceBase.MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association a = assoc.getAssociation();
        String callingAET = a.getCallingAET();
        try {
            DcmServiceBase.MultiDimseRsp rsp;
            this.perfMon.start(assoc, rq, 4);
            Command rqCmd = rq.getCommand();
            Dataset rqData = rq.getDataset();
            this.perfMon.setProperty(assoc, rq, 1, rq);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Identifier:\n");
                this.log.debug((Object)rqData);
            }
            this.service.logDIMSE(a, QUERY_XML, rqData);
            this.service.logDicomQuery(a, rq.getCommand().getAffectedSOPClassUID(), rqData);
            Dataset coerce = this.service.getCoercionAttributesFor(callingAET, QUERY_XSL, rqData, a);
            if (coerce != null) {
                this.service.coerceAttributes(rqData, coerce);
            }
            this.service.postCoercionProcessing(rqData, 32, assoc.getAssociation());
            int[] excludeFromRSP = FindScp.excludeFromRSP(rqData);
            this.service.supplementIssuerOfPatientID(rqData, a, callingAET, true);
            Dataset issuerOfAccessionNumberInRQ = rqData.getItem(524369);
            if (!"PATIENT".equals(rqData.getString(524370))) {
                this.service.supplementIssuerOfAccessionNumber(rqData, a, callingAET, true);
            }
            boolean pixQuery = this.forcePixQuery(assoc) || this.service.isPixQueryCallingAET(callingAET);
            Set<PIDWithIssuer> pidWithIssuer = pixQuery ? this.pixQuery(rqData) : null;
            boolean adjustPatientID = pixQuery && pidWithIssuer == null && rqData.containsValue(0x100021);
            rqData.putSQ(0x101002);
            boolean hideWithoutIssuerOfPID = this.service.isHideWithoutIssuerOfPIDFromAET(callingAET);
            boolean fuzzyMatchingOfPN = this.fuzzyMatchingOfPN(a.getAcceptedExtNegotiation(rqCmd.getAffectedSOPClassUID()));
            if (this.service.hasUnrestrictedQueryPermissions(callingAET)) {
                rsp = this.newMultiCFindRsp(rqData, pidWithIssuer, adjustPatientID, excludeFromRSP, issuerOfAccessionNumberInRQ, fuzzyMatchingOfPN, hideWithoutIssuerOfPID, null);
            } else {
                Subject subject = (Subject)a.getProperty("user");
                if (subject != null) {
                    rsp = this.newMultiCFindRsp(rqData, pidWithIssuer, adjustPatientID, excludeFromRSP, issuerOfAccessionNumberInRQ, fuzzyMatchingOfPN, hideWithoutIssuerOfPID, subject);
                } else {
                    this.log.info((Object)"Missing user identification -> no records returned");
                    rsp = NO_MATCH_RSP;
                }
            }
            this.perfMon.stop(assoc, rq, 4);
            return rsp;
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Query DB failed:", (Throwable)e);
            throw new DcmServiceException(49152, (Throwable)e);
        }
    }

    private static int[] excludeFromRSP(Dataset rqData) {
        int count = 0;
        boolean[] exclude = new boolean[EXCLUDE_FROM_RSP_TAGS.length];
        for (int i = 0; i < EXCLUDE_FROM_RSP_TAGS.length; ++i) {
            exclude[i] = !rqData.contains(EXCLUDE_FROM_RSP_TAGS[i]);
            if (!exclude[i]) continue;
            ++count;
        }
        int[] tags = new int[count];
        int j = 0;
        for (int i = 0; i < exclude.length; ++i) {
            if (!exclude[i]) continue;
            tags[j++] = EXCLUDE_FROM_RSP_TAGS[i];
        }
        return tags;
    }

    private boolean forcePixQuery(ActiveAssociation assoc) {
        Object flag = assoc.getAssociation().getProperty(FORCE_PIX_QUERY_FLAG);
        return flag instanceof Boolean && (Boolean)flag != false;
    }

    private boolean fuzzyMatchingOfPN(ExtNegotiation extNeg) {
        byte[] info;
        return extNeg != null && (info = extNeg.info()).length > 2 && info[2] != 0;
    }

    private boolean isUniversalMatching(String key) {
        if (key == null) {
            return true;
        }
        char[] a = key.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '*') continue;
            return false;
        }
        return true;
    }

    private boolean isWildCardMatching(String key) {
        return key.indexOf(42) != -1 || key.indexOf(63) != -1;
    }

    protected Set<PIDWithIssuer> pixQuery(Dataset rqData) throws DcmServiceException {
        HashSet<PIDWithIssuer> result = new HashSet<PIDWithIssuer>();
        this.pixQuery(rqData, result);
        DcmElement opidsq = rqData.get(0x101002);
        if (opidsq != null) {
            int n = opidsq.countItems();
            for (int i = 0; i < n; ++i) {
                this.pixQuery(opidsq.getItem(i), result);
            }
        }
        return result.isEmpty() ? null : result;
    }

    protected boolean skipPixQuery(String pid, String issuer) throws DcmServiceException {
        return this.isUniversalMatching(pid) || !this.service.isPixQueryIssuer(issuer) || this.isWildCardMatching(pid) && !this.service.isPixQueryLocal();
    }

    protected void pixQuery(Dataset rqData, Set<PIDWithIssuer> result) throws DcmServiceException {
        String issuer;
        String pid = rqData.getString(0x100020);
        if (this.skipPixQuery(pid, issuer = rqData.getString(0x100021))) {
            return;
        }
        List<String[]> pidAndIssuers = this.service.queryCorrespondingPIDs(pid, issuer);
        if (pidAndIssuers == null) {
            return;
        }
        for (String[] pidAndIssuer : pidAndIssuers) {
            result.add(new PIDWithIssuer(pidAndIssuer[0], pidAndIssuer[1]));
        }
    }

    protected DcmServiceBase.MultiDimseRsp newMultiCFindRsp(Dataset rqData, Set<PIDWithIssuer> pidWithIssuers, boolean adjustPatientIDs, int[] excludeFromRSP, Dataset issuerOfAccessionNumberInRQ, boolean fuzzyMatchingOfPN, boolean hideWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        QueryCmd queryCmd = QueryCmd.create((Dataset)rqData, pidWithIssuers, (boolean)this.filterResult, (boolean)fuzzyMatchingOfPN, (boolean)this.service.isNoMatchForNoValue(), (boolean)hideWithoutIssuerOfPID, (Subject)subject);
        if (this.filterResult && issuerOfAccessionNumberInRQ != null) {
            rqData.putSQ(524369).addItem(issuerOfAccessionNumberInRQ);
        }
        queryCmd.setFetchSize(this.service.getFetchSize()).execute();
        return new MultiCFindRsp(queryCmd, adjustPatientIDs, rqData.getString(0x100021), excludeFromRSP);
    }

    protected Dataset getDataset(QueryCmd queryCmd) throws SQLException, DcmServiceException {
        return queryCmd.getDataset();
    }

    @Override
    protected void doBeforeRsp(ActiveAssociation assoc, Dimse rsp) {
        if (this.log.isDebugEnabled() && this.service.isCFindRspDebugLogDeferToDoBeforeRsp()) {
            try {
                Dataset ds = rsp.getDataset();
                if (ds != null) {
                    this.log.debug((Object)"Identifier:\n");
                    this.log.debug((Object)ds);
                }
            }
            catch (IOException iOException) {
                this.log.error((Object)"Failed to debug log C-Find response", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMultiRsp(ActiveAssociation assoc, Dimse rq, Command rspCmd, DcmServiceBase.MultiDimseRsp mdr) throws IOException, DcmServiceException {
        try {
            DimseListener cl = mdr.getCancelListener();
            if (cl != null) {
                assoc.addCancelListener(rspCmd.getMessageIDToBeingRespondedTo(), cl);
            }
            do {
                this.perfMon.start(assoc, rq, 5);
                Dataset rspData = mdr.next(assoc, rq, rspCmd);
                Dimse rsp = fact.newDimse(rq.pcid(), rspCmd, rspData);
                this.doBeforeRsp(assoc, rsp);
                assoc.getAssociation().write(rsp);
                this.perfMon.setProperty(assoc, rq, 4, rspData);
                this.perfMon.stop(assoc, rq, 5);
                this.doAfterRsp(assoc, rsp);
            } while (rspCmd.isPending());
            Object var9_8 = null;
            mdr.release();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            mdr.release();
            throw throwable;
        }
    }

    @Override
    public void write(Association src, PDU pdu) {
        if (pdu instanceof AAssociateAC) {
            this.perfMon.assocEstEnd(src, 32);
        }
    }

    @Override
    public void received(Association src, PDU pdu) {
        if (pdu instanceof AAssociateRQ) {
            this.perfMon.assocEstStart(src, 32);
        }
    }

    @Override
    public void write(Association src, Dimse dimse) {
    }

    @Override
    public void received(Association src, Dimse dimse) {
    }

    @Override
    public void error(Association src, IOException ioe) {
    }

    @Override
    public void closing(Association assoc) {
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelStart(assoc, 32);
        }
    }

    @Override
    public void closed(Association assoc) {
        if (assoc.getAAssociateAC() != null) {
            this.perfMon.assocRelEnd(assoc, 32);
        }
    }

    protected class MultiCFindRsp
    implements DcmServiceBase.MultiDimseRsp {
        private final QueryCmd queryCmd;
        private final boolean adjustPatientIDs;
        private final String requestedIssuer;
        private final int[] excludeFromRSP;
        private final Map<PIDWithIssuer, Set<PIDWithIssuer>> pixQueryResults;
        private boolean canceled = false;
        private final int pendingStatus;
        private int count = 0;
        private Templates coerceTpl;

        public MultiCFindRsp(QueryCmd queryCmd, boolean adjustPatientIDs, String requestedIssuer, int[] excludeFromRSP) {
            this.queryCmd = queryCmd;
            this.adjustPatientIDs = adjustPatientIDs;
            this.requestedIssuer = requestedIssuer;
            this.excludeFromRSP = excludeFromRSP;
            this.pixQueryResults = adjustPatientIDs ? new HashMap() : null;
            this.pendingStatus = queryCmd.isKeyNotSupported() ? 65281 : 65280;
        }

        public DimseListener getCancelListener() {
            return new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MultiCFindRsp.this.canceled = true;
                }
            };
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            if (this.canceled) {
                rspCmd.putUS(2304, 65024);
                return null;
            }
            try {
                Dataset coerce;
                Association a = assoc.getAssociation();
                String callingAET = a.getCallingAET();
                if (!this.queryCmd.next()) {
                    rspCmd.putUS(2304, 0);
                    return null;
                }
                rspCmd.putUS(2304, this.pendingStatus);
                Dataset data = FindScp.this.getDataset(this.queryCmd);
                if (this.adjustPatientIDs && data.containsValue(0x100020) && data.containsValue(0x100021)) {
                    if (FindScp.this.filterResult) {
                        Dataset tmp = DcmObjectFactory.getInstance().newDataset();
                        tmp.putAll(data);
                        data = tmp;
                    }
                    FindScp.this.service.adjustPatientID(data, this.requestedIssuer, this.pixQueryResults);
                    if (!data.contains(0x100021)) {
                        data.putLO(0x100021, this.requestedIssuer);
                    }
                }
                if (FindScp.this.filterResult) {
                    data = data.exclude(this.excludeFromRSP);
                    for (int tag : this.excludeFromRSP) {
                        data.remove(tag);
                    }
                }
                if (!FindScp.this.service.isCFindRspDebugLogDeferToDoBeforeRsp()) {
                    FindScp.this.log.debug((Object)"Identifier:\n");
                    FindScp.this.log.debug((Object)data);
                }
                FindScp.this.service.logDIMSE(a, FindScp.RESULT_XML, data);
                if (this.count++ == 0) {
                    this.coerceTpl = FindScp.this.service.getCoercionTemplates(callingAET, FindScp.RESULT_XSL);
                }
                if ((coerce = FindScp.this.service.getCoercionAttributesFor(a, FindScp.RESULT_XSL, data, this.coerceTpl)) != null) {
                    FindScp.this.service.coerceAttributes(data, coerce);
                }
                FindScp.this.service.postCoercionProcessing(data, 32800, assoc.getAssociation());
                return data;
            }
            catch (DcmServiceException e) {
                throw e;
            }
            catch (SQLException e) {
                FindScp.this.log.error((Object)"Retrieve DB record failed:", (Throwable)e);
                throw new DcmServiceException(49152, (Throwable)e);
            }
            catch (Exception e) {
                FindScp.this.log.error((Object)"Corrupted DB record:", (Throwable)e);
                throw new DcmServiceException(49152, (Throwable)e);
            }
        }

        public void release() {
            this.queryCmd.close();
        }
    }
}

