/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mwlscu;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.MWLManager;
import org.dcm4chex.archive.ejb.interfaces.MWLManagerHome;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.XSLTUtils;

public class MwlReplicaService
extends AbstractScuService {
    private static final String NONE = "NONE";
    private static final String MWL_REPLICA_RQ_XSL = "mwl-replica-rq.xsl";
    private static final String MWL_REPLICA_RSP_XSL = "mwl-replica-rsp.xsl";
    private static final int PCID = 1;
    private static final int MSG_ID = 1;
    private static final int MAX_ERRORLIST_SIZE = 1000;
    private static Logger log = Logger.getLogger((String)MwlReplicaService.class.getName());
    private SimpleDateFormat dfDA = new SimpleDateFormat("yyyy/MM/dd");
    private SimpleDateFormat dfDT = new SimpleDateFormat("yyyy/MM/dd hh:mm");
    private SimpleDateFormat dfFull = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long taskInterval = 0L;
    private Integer listenerID;
    private String timerIDMwlReplica;
    private boolean isRunning;
    private String issuerOfPatient;
    private boolean forceIssuerCoercion;
    private boolean debugMode;
    private long msBefore = -1L;
    private long msAfter = -1L;
    private List<String> errorHistory = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean add(String s) {
            if (this.size() > 1000) {
                this.remove(0);
            }
            return super.add(s);
        }
    };
    private String[] calledAETs;
    private Object lastErrorMsg;
    private int countEqualErrors = 0;
    private int errorCount = 0;
    private int totalErrorCount = 0;
    public PatientMatching patientMatching;
    private int priority = 0;
    protected TemplatesDelegate templates = new TemplatesDelegate(this);
    private final NotificationListener mwlReplicationListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            log.debug((Object)"mwlReplicationListener notified!");
            new Thread(new Runnable(){

                public void run() {
                    MwlReplicaService.this.process();
                }
            }).start();
        }
    };

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public String getTimerIDMwlReplica() {
        return this.timerIDMwlReplica;
    }

    public void setTimerIDMwlReplica(String timerIDMwlReplica) {
        this.timerIDMwlReplica = timerIDMwlReplica;
    }

    public final String getTaskInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDMwlReplica, this.listenerID, this.mwlReplicationListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDMwlReplica, this.taskInterval, this.mwlReplicationListener);
        }
    }

    public String getTimeBefore() {
        return this.msBefore == -1L ? NONE : RetryIntervalls.formatInterval(this.msBefore);
    }

    public void setTimeBefore(String timeBefore) {
        this.msBefore = NONE.equals(timeBefore) ? -1L : RetryIntervalls.parseInterval(timeBefore);
    }

    public String getTimeAfter() {
        return this.msAfter == -1L ? NONE : RetryIntervalls.formatInterval(this.msAfter);
    }

    public void setTimeAfter(String timeAfter) {
        this.msAfter = NONE.equals(timeAfter) ? -1L : RetryIntervalls.parseInterval(timeAfter);
    }

    public final String getCalledAET() {
        StringBuilder sb = new StringBuilder(this.calledAETs[0]);
        for (int i = 1; i < this.calledAETs.length; ++i) {
            sb.append("\\").append(this.calledAETs[i]);
        }
        return sb.toString();
    }

    public final void setCalledAET(String aet) {
        StringTokenizer st = new StringTokenizer(aet, "\\");
        this.calledAETs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.calledAETs[i] = st.nextToken();
            ++i;
        }
    }

    public String getIssuerOfPatient() {
        return this.issuerOfPatient == null ? NONE : this.issuerOfPatient;
    }

    public void setIssuerOfPatient(String issuerOfPatient) {
        this.issuerOfPatient = NONE.equalsIgnoreCase(issuerOfPatient) ? null : issuerOfPatient;
    }

    public boolean isForceIssuerCoercion() {
        return this.forceIssuerCoercion;
    }

    public void setForceIssuerCoercion(boolean forceIssuerCoercion) {
        this.forceIssuerCoercion = forceIssuerCoercion;
    }

    public String getPatientMatching() {
        return this.patientMatching.toString();
    }

    public void setPatientMatching(String s) {
        this.patientMatching = new PatientMatching(s.trim());
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public final String getPriority() {
        return DicomPriority.toString(this.priority);
    }

    public final void setPriority(String priority) {
        this.priority = DicomPriority.toCode(priority);
    }

    public final String getCoerceConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setCoerceConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getTotalErrorCount() {
        return this.totalErrorCount;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String showErrorHistory() {
        StringBuffer sb = new StringBuffer(this.errorHistory.size() * 20);
        sb.append(this.errorCount).append(" (").append(this.totalErrorCount).append(" since service start) Errors:");
        Iterator<String> iter = this.errorHistory.iterator();
        while (iter.hasNext()) {
            sb.append("\n").append((Object)iter.next());
        }
        return sb.toString();
    }

    public void resetErrorHistory() {
        this.errorHistory.clear();
        this.lastErrorMsg = null;
        this.countEqualErrors = 0;
        this.errorCount = 0;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDMwlReplica, this.taskInterval, this.mwlReplicationListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDMwlReplica, this.listenerID, this.mwlReplicationListener);
        super.stopService();
    }

    private void logResponse(Dataset rsp, String aet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received matching MWL item from " + aet + " :"));
            log.debug((Object)rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process() {
        MwlReplicaService mwlReplicaService = this;
        synchronized (mwlReplicaService) {
            if (this.isRunning) {
                log.info((Object)"replicateMWL is already running!");
                return false;
            }
            this.isRunning = true;
        }
        log.info((Object)"MWL Replication process started!");
        try {
            List l = this.replicateMWLEntries(this.calledAETs, null);
            log.debug((Object)l);
            boolean bl = true;
            Object var4_6 = null;
            this.isRunning = false;
            return bl;
        }
        catch (Exception e) {
            try {
                log.error((Object)"MWL replication process failed!", (Throwable)e);
                this.errorHistory.add("process:" + e.getMessage());
                boolean bl = false;
                Object var4_7 = null;
                this.isRunning = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.isRunning = false;
                throw throwable;
            }
        }
    }

    public List replicateMWLEntries(String[] aets, Dataset searchDS) {
        ArrayList l;
        try {
            l = this.replicateMWLEntries(aets[0], searchDS);
        }
        catch (Exception x) {
            log.error((Object)("Replicate MWL Entries from " + aets[0] + " failed!"), (Throwable)x);
            this.addError(aets[0], x);
            l = new ArrayList();
        }
        for (int i = 1; i < aets.length; ++i) {
            try {
                l.addAll(this.replicateMWLEntries(aets[i], searchDS));
                continue;
            }
            catch (Exception x) {
                log.error((Object)("Replicate MWL Entries from " + aets[i] + " failed!"), (Throwable)x);
                this.addError(aets[i], x);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List replicateMWLEntries(final String aet, Dataset searchDS) throws Exception {
        log.info((Object)("Start MWL replication from " + aet));
        if (searchDS == null) {
            searchDS = this.getSearchDSForDate(new Date(), this.msBefore, this.msAfter);
            log.debug((Object)"No searchDS given! Use standard 'today list' searchDS instead:");
        }
        searchDS = this.coerceAttributes(searchDS, aet, MWL_REPLICA_RQ_XSL);
        final ArrayList result = new ArrayList();
        if (this.debugMode) {
            log.info((Object)("Query MWL SCP: " + aet + " with keys:"));
            log.info((Object)searchDS);
            DcmElement spsSq = searchDS.get(0x400100);
            log.info((Object)("DEBUG Mode! No MWL Query will be performed!\nDate Time Range:" + spsSq == null ? "No SPSSQ!" : this.getDateTimeRangeString(spsSq)));
            return result;
        }
        log.debug((Object)("Query MWL SCP: " + aet + " with keys:"));
        log.debug((Object)searchDS);
        final MWLManager manager = this.mwlMgt();
        try {
            ActiveAssociation aa = this.openAssociation(aet, "1.2.840.10008.5.1.4.31");
            try {
                Command cmd = DcmObjectFactory.getInstance().newCommand();
                cmd.initCFindRQ(1, "1.2.840.10008.5.1.4.31", this.priority);
                Dimse mcRQ = AssociationFactory.getInstance().newDimse(1, cmd, searchDS);
                aa.invoke(mcRQ, new DimseListener(){

                    public void dimseReceived(Association assoc, Dimse dimse) {
                        Command rspCmd = dimse.getCommand();
                        if (rspCmd.isPending()) {
                            try {
                                Dataset rsp = dimse.getDataset();
                                MwlReplicaService.this.logResponse(rsp, aet);
                                if (MwlReplicaService.this.issuerOfPatient != null && (MwlReplicaService.this.forceIssuerCoercion || !rsp.containsValue(0x100021))) {
                                    rsp.putSH(0x100021, MwlReplicaService.this.issuerOfPatient);
                                    log.debug((Object)("Issuer of patient coerced to " + MwlReplicaService.this.issuerOfPatient));
                                }
                                if (!manager.updateWorklistItem(rsp = MwlReplicaService.this.coerceAttributes(rsp, aet, MwlReplicaService.MWL_REPLICA_RSP_XSL), MwlReplicaService.this.patientMatching)) {
                                    manager.addWorklistItem(rsp, MwlReplicaService.this.patientMatching);
                                }
                                result.add(rsp);
                            }
                            catch (Exception e) {
                                log.error((Object)"Error occured!", (Throwable)e);
                                MwlReplicaService.this.addError("dimseReceived:", e);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Received final C-FIND RSP from " + aet + " :" + dimse));
                        }
                    }
                });
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to release " + aa.getAssociation()));
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.addError(aet, e);
        }
        log.debug((Object)("Result of MWL replica for " + aet + ":"));
        log.debug(result);
        return result;
    }

    private void addError(String aet, Exception e) {
        ++this.errorCount;
        ++this.totalErrorCount;
        String msg = aet + ":" + e.getMessage();
        if (msg.equals(this.lastErrorMsg)) {
            msg = this.dfFull.format(new Date()) + " Repeated " + ++this.countEqualErrors + " times";
            if (this.countEqualErrors > 1) {
                int idx = this.errorHistory.size();
                this.errorHistory.set(--idx, msg);
            } else {
                this.errorHistory.add(msg);
            }
        } else {
            this.lastErrorMsg = msg;
            this.countEqualErrors = 0;
            this.errorHistory.add(this.dfFull.format(new Date()) + " " + msg);
        }
    }

    private String getDateTimeRangeString(DcmElement spsSq) {
        Date[] dates = spsSq.getItem().getDateTimeRange(0x400002, 0x400003);
        if (dates == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dates[0]).append("-").append(dates[1]);
        return sb.toString();
    }

    public List replicateMWLEntriesForDate(String aet, String date) throws Exception {
        Date d;
        Date date2 = d = this.isEmpty(date) ? new Date() : this.dfDA.parse(date);
        if (this.isEmpty(aet)) {
            return this.replicateMWLEntries(this.calledAETs, this.getSearchDSForDate(d, d));
        }
        return this.replicateMWLEntries(aet, this.getSearchDSForDate(d, d));
    }

    public List replicateMWLEntriesForDateRange(String aet, String startDate, String endDate) throws Exception {
        Date end;
        Date start = this.isEmpty(startDate) ? null : this.dfDT.parse(startDate);
        Date date = end = this.isEmpty(endDate) ? null : this.dfDT.parse(endDate);
        if (this.isEmpty(aet)) {
            return this.replicateMWLEntries(this.calledAETs, this.getSearchDSForDate(start, end));
        }
        return this.replicateMWLEntries(aet, this.getSearchDSForDate(start, end));
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    private boolean isEmpty(String param) {
        return param == null || param.length() < 1;
    }

    private Dataset getSearchDSForDate(Date baseDate, long msBefore, long msAfter) {
        if (msBefore < 0L && msAfter < 0L) {
            return this.getSearchDSForDate(baseDate, baseDate);
        }
        Date start = msBefore < 0L ? null : new Date(baseDate.getTime() - msBefore);
        Date end = msAfter < 0L ? null : new Date(baseDate.getTime() + msAfter);
        return this.getSearchDSForDate(start, end);
    }

    private Dataset getSearchDSForDate(Date start, Date end) {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.putCS(524293, "ISO_IR 100");
        Dataset dsSPS = ds.putSQ(0x400100).addNewItem();
        dsSPS.putAE(0x400001);
        this.addStartDate(start, end, dsSPS);
        dsSPS.putCS(524384);
        dsSPS.putPN(0x400006);
        dsSPS.putLO(0x400007);
        dsSPS.putSH(0x400010);
        dsSPS.putSH(0x400011);
        dsSPS.putSQ(0x400008);
        dsSPS.putLO(4194322);
        dsSPS.putSH(0x400009);
        dsSPS.putLO(3281008);
        dsSPS.putCS(0x400020);
        ds.putSH(0x401001);
        ds.putLO(3280992);
        ds.putSQ(3280996);
        ds.putUI(0x20000D);
        ds.putSH(4198403);
        ds.putLO(0x401004);
        ds.putLO(4198402);
        ds.putLT(0x401400);
        ds.putSQ(4198410);
        ds.putLO(4198405);
        ds.putLO(4198408);
        ds.putSH(4198409);
        ds.putPN(0x401010);
        ds.putSQ(0x401011);
        ds.putLT(0x402400);
        ds.putPN(3280946);
        ds.putSQ(3280945);
        ds.putPN(524432);
        ds.putSQ(524438);
        ds.putLO(3280947);
        ds.putSH(524368);
        ds.putDA(0x402004);
        ds.putTM(4202501);
        ds.putLO(4202518);
        ds.putLO(4202519);
        ds.putPN(4202504);
        ds.putSH(4202505);
        ds.putSH(4202512);
        ds.putPN(0x100010);
        ds.putLO(0x100020);
        ds.putLO(3670032);
        ds.putLO(0x380300);
        Dataset dsRefPat = ds.putSQ(528672).addNewItem();
        dsRefPat.putUI(528720);
        dsRefPat.putUI(528725);
        ds.putDA(0x100030);
        ds.putCS(0x100040);
        ds.putDS(0x101030);
        ds.putLO(4206593);
        ds.putLO(3671296);
        ds.putUS(1057216);
        ds.putLO(0x102000);
        ds.putLO(0x102110);
        ds.putLO(3670096);
        log.debug((Object)"### searchDS:");
        log.debug((Object)ds);
        return ds;
    }

    private void addStartDate(Date start, Date end, Dataset dsSPS) {
        if (start != null && end != null) {
            if (this.dfDA.format(start).equals(this.dfDA.format(end))) {
                dsSPS.putDA(0x400002, start);
                if (start.getTime() != end.getTime()) {
                    dsSPS.putTM(0x400003, start, end);
                } else {
                    dsSPS.putTM(0x400003);
                }
            } else {
                dsSPS.putDA(0x400002, start, end);
                dsSPS.putTM(0x400003, start, end);
            }
        } else if (start != end) {
            dsSPS.putDA(0x400002, start, end);
            dsSPS.putTM(0x400003, start, end);
        } else {
            dsSPS.putDA(0x400002);
            dsSPS.putTM(0x400003);
        }
    }

    private Dataset coerceAttributes(Dataset ds, String aet, String xsl) {
        Templates stylesheet = this.templates.getTemplatesForAET(aet, xsl);
        if (stylesheet != null) {
            log.debug((Object)"Dataset before coercion:");
            log.debug((Object)ds);
            Dataset out = DcmObjectFactory.getInstance().newDataset();
            try {
                XSLTUtils.xslt(ds, stylesheet, out);
                this.coerceAttributes((DcmObject)ds, out, null);
            }
            catch (Exception e) {
                log.error((Object)"MWL Replica Attribute coercion failed:", (Throwable)e);
            }
            log.debug((Object)"Dataset after coercion:");
            log.debug((Object)ds);
        }
        return ds;
    }

    private void coerceAttributes(DcmObject ds, DcmObject coerce, DcmElement parent) {
        boolean coerced = false;
        Iterator it = coerce.iterator();
        while (it.hasNext()) {
            DcmElement el = (DcmElement)it.next();
            DcmElement oldEl = ds.get(el.tag());
            if (el.isEmpty()) {
                boolean bl = coerced = oldEl != null && !oldEl.isEmpty();
                if (oldEl == null || coerced) {
                    ds.putXX(el.tag(), el.vr());
                }
            } else {
                DcmElement sq = oldEl;
                switch (el.vr()) {
                    case 21329: {
                        int i;
                        boolean bl = coerced = oldEl != null && sq.vr() != 21329;
                        if (oldEl == null || coerced) {
                            sq = ds.putSQ(el.tag());
                        }
                        int n = el.countItems();
                        for (i = 0; i < n; ++i) {
                            Dataset item = sq.getItem(i);
                            if (item == null) {
                                item = sq.addNewItem();
                            }
                            Dataset coerceItem = el.getItem(i);
                            this.coerceAttributes((DcmObject)item, coerceItem, el);
                            if (coerceItem.isEmpty()) continue;
                            coerced = true;
                        }
                        break;
                    }
                    case 20290: 
                    case 20294: 
                    case 20311: 
                    case 21838: {
                        int i;
                        int n;
                        if (el.hasDataFragments()) {
                            coerced = true;
                            sq = ds.putXXsq(el.tag(), el.vr());
                            n = el.countItems();
                            for (i = 0; i < n; ++i) {
                                sq.addDataFragment(el.getDataFragment(i));
                            }
                            break;
                        }
                    }
                    default: {
                        boolean bl = coerced = oldEl != null && !oldEl.equals(el);
                        if (oldEl != null && !coerced) break;
                        ds.putXX(el.tag(), el.vr(), el.getByteBuffer());
                    }
                }
            }
            if (coerced) {
                log.info((Object)(parent == null ? "Coerce " + oldEl + " to " + el : "Coerce " + oldEl + " to " + el + " in item of " + parent));
                continue;
            }
            if (oldEl == null && log.isDebugEnabled()) {
                log.debug((Object)(parent == null ? "Add " + el : "Add " + el + " in item of " + parent));
            }
            it.remove();
        }
    }

    private MWLManager mwlMgt() throws Exception {
        MWLManagerHome home = (MWLManagerHome)EJBHomeFactory.getFactory().lookup(MWLManagerHome.class, "ejb/MWLManager");
        return home.create();
    }
}

