/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mwlscu;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.MWLManager;
import org.dcm4chex.archive.ejb.interfaces.MWLManagerHome;
import org.dcm4chex.archive.ejb.jdbc.MWLQueryCmd;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class MWLScuService
extends AbstractScuService {
    private static final int PCID = 1;
    private static final int MSG_ID = 1;
    private static final int MIN_MAX_RESULT = 10;
    private String calledAET;
    private int maxResults;
    private int priority = 0;
    private boolean forceMatchingKeyCheck;
    private boolean noMatchForNoValue;

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String aet) {
        this.calledAET = aet;
    }

    public final int getMaxResults() {
        return this.maxResults;
    }

    public final void setMaxResults(int maxResults) {
        if (maxResults < 10) {
            throw new IllegalArgumentException("maxResult: " + maxResults + " lesser than minimal value: " + 10);
        }
        this.maxResults = maxResults;
    }

    public boolean isForceMatchingKeyCheck() {
        return this.forceMatchingKeyCheck;
    }

    public void setForceMatchingKeyCheck(boolean forceMatchingKeyCheck) {
        this.forceMatchingKeyCheck = forceMatchingKeyCheck;
    }

    public final boolean isLocal() {
        return "LOCAL".equalsIgnoreCase(this.calledAET);
    }

    public final boolean isNoMatchForNoValue() {
        return this.noMatchForNoValue;
    }

    public final void setNoMatchForNoValue(boolean noMatchForNoValue) {
        this.noMatchForNoValue = noMatchForNoValue;
    }

    public final String getPriority() {
        return DicomPriority.toString(this.priority);
    }

    public final void setPriority(String priority) {
        this.priority = DicomPriority.toCode(priority);
    }

    public final boolean getAccessBlobAsLongVarBinary() {
        return MWLQueryCmd.blobAccessType == -4;
    }

    public final void setAccessBlobAsLongVarBinary(boolean enable) {
        MWLQueryCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final String getTransactionIsolationLevel() {
        return MWLQueryCmd.transactionIsolationLevelAsString((int)MWLQueryCmd.transactionIsolationLevel);
    }

    public final void setTransactionIsolationLevel(String level) {
        MWLQueryCmd.transactionIsolationLevel = MWLQueryCmd.transactionIsolationLevelOf((String)level);
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public boolean deleteMWLEntry(String rqIDspsID) {
        String[] s2 = StringUtils.split(rqIDspsID, '\\');
        try {
            this.mwlMgt().removeWorklistItem(s2[0], s2[1]);
            this.log.info((Object)("MWL entry with id " + s2[1] + " removed!"));
            return true;
        }
        catch (Exception x) {
            this.log.error((Object)("Can't delete MWLEntry with id:" + s2[1]), (Throwable)x);
            return false;
        }
    }

    public int findMWLEntries(Dataset searchDS, boolean fuzzyMatchingOfPN, List result) throws DcmServiceException {
        this.log.debug((Object)("Query MWL SCP: " + this.calledAET + " with keys:"));
        this.log.debug((Object)searchDS);
        if (this.isLocal()) {
            return this.findMWLEntriesLocal(searchDS, fuzzyMatchingOfPN, result);
        }
        return this.findMWLEntriesFromAET(searchDS, result);
    }

    public int findMWLEntriesLocal(Dataset searchDS, boolean fuzzyMatchingOfPN, List result) throws DcmServiceException {
        int rsp2;
        block6: {
            MWLQueryCmd queryCmd = null;
            try {
                queryCmd = new MWLQueryCmd(searchDS, fuzzyMatchingOfPN, this.noMatchForNoValue);
                queryCmd.setFetchSize(this.getFetchSize()).execute();
                while (queryCmd.next()) {
                    if (result.size() >= this.maxResults) {
                        this.log.info((Object)("Found more than " + this.maxResults + " matching MWL entries. Skipped!"));
                        break;
                    }
                    Dataset rsp2 = queryCmd.getDataset();
                    this.logResponse(rsp2);
                    result.add(rsp2);
                }
                rsp2 = 65280;
                Object var7_8 = null;
                if (queryCmd == null) break block6;
            }
            catch (SQLException x) {
                try {
                    throw new DcmServiceException(272, (Throwable)x);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var7_9 = null;
                        if (queryCmd == null) break block7;
                        queryCmd.close();
                    }
                    throw throwable;
                }
            }
            queryCmd.close();
        }
        return rsp2;
    }

    private void logResponse(Dataset rsp) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received matching MWL item from " + this.calledAET + " :"));
            this.log.debug((Object)rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int findMWLEntriesFromAET(Dataset searchDS, final List result) {
        try {
            int n;
            ActiveAssociation aa = this.openAssociation(this.calledAET, "1.2.840.10008.5.1.4.31");
            try {
                Command cmd = DcmObjectFactory.getInstance().newCommand();
                cmd.initCFindRQ(1, "1.2.840.10008.5.1.4.31", this.priority);
                Dimse mcRQ = AssociationFactory.getInstance().newDimse(1, cmd, searchDS);
                final int[] pendingStatus = new int[]{65280};
                final int[] received = new int[]{0};
                final int[] ignored = new int[]{0};
                final Dataset keys = DcmObjectFactory.getInstance().newDataset();
                if (this.forceMatchingKeyCheck) {
                    keys.putAll(searchDS.subSet(new int[]{524368, 0x20000D}));
                    Dataset spsItem = searchDS.getItem(0x400100);
                    if (spsItem != null && spsItem.containsValue(0x400009)) {
                        keys.putSQ(0x400100).addItem(spsItem.subSet(new int[]{0x400009}));
                    }
                }
                aa.invoke(mcRQ, new DimseListener(){

                    public void dimseReceived(Association assoc, Dimse dimse) {
                        block10: {
                            Command rspCmd = dimse.getCommand();
                            if (rspCmd.isPending()) {
                                try {
                                    pendingStatus[0] = rspCmd.getStatus();
                                    Dataset rsp = dimse.getDataset();
                                    MWLScuService.this.logResponse(rsp);
                                    if (received[0] < MWLScuService.this.maxResults) {
                                        received[0] = received[0] + 1;
                                        if (keys.isEmpty() || keys.match(rsp, true, true)) {
                                            result.add(rsp);
                                            if (received[0] == MWLScuService.this.maxResults) {
                                                MWLScuService.this.log.info((Object)("Cancel MWL FIND operation after receive of " + MWLScuService.this.maxResults + " pending C-FIND RSP."));
                                                MWLScuService.this.cancelFind(assoc);
                                            }
                                        } else {
                                            ignored[0] = ignored[0] + 1;
                                            MWLScuService.this.log.info((Object)"Received MWL FIND Response ignored after additional Matching Key check!");
                                            MWLScuService.this.log.debug((Object)"Received Dataset:");
                                            MWLScuService.this.log.debug((Object)rsp);
                                        }
                                        break block10;
                                    }
                                    MWLScuService.this.log.debug((Object)"Ignore pending C-FIND RSP received after cancel of MWL FIND operation");
                                }
                                catch (IOException e) {
                                    pendingStatus[0] = 272;
                                }
                            } else if (MWLScuService.this.log.isDebugEnabled()) {
                                MWLScuService.this.log.debug((Object)("Received final C-FIND RSP from " + MWLScuService.this.calledAET + " :" + dimse));
                                if (ignored[0] > 0) {
                                    MWLScuService.this.log.debug((Object)(ignored[0] + " of " + received[0] + " received Response Messages ignored after Matching Key Check!"));
                                }
                            }
                        }
                    }
                });
                n = pendingStatus[0];
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to release " + aa.getAssociation()));
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            return n;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return 272;
        }
    }

    private void cancelFind(Association assoc) {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initCCancelRQ(1);
        Dimse dimse = AssociationFactory.getInstance().newDimse(1, cmd);
        try {
            assoc.write(dimse);
        }
        catch (IOException e) {
            this.log.warn((Object)"Failed to cancel C-FIND:", (Throwable)e);
        }
    }

    private MWLManager mwlMgt() throws Exception {
        MWLManagerHome home = (MWLManagerHome)EJBHomeFactory.getFactory().lookup(MWLManagerHome.class, "ejb/MWLManager");
        return home.create();
    }
}

