/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mwlscp;

import java.util.List;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.mwlscp.MWLFindScp;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.ejb.interfaces.MWLManager;
import org.dcm4chex.archive.ejb.interfaces.MWLManagerHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;

public class MWLFindScpService
extends AbstractScpService
implements NotificationListener {
    private static final int FUZZY_MATCHING = 2;
    private static final String SPS_STATUS_STARTED = "STARTED";
    private static final String PPS_STATUS_IN_PROGRESS = "IN PROGRESS";
    private static final NotificationFilterSupport mppsFilter = new NotificationFilterSupport();
    private final ExtNegotiator extNegotiator = new ExtNegotiator(){

        public byte[] negotiate(byte[] offered) {
            if (offered.length > 2) {
                offered[2] = (byte)(offered[2] & (!MWLFindScpService.this.useProxy && AttributeFilter.isSoundexEnabled() ? (byte)1 : 0));
            }
            return offered;
        }
    };
    private ObjectName mppsScpServiceName;
    private ObjectName mwlScuServiceName;
    private boolean useProxy = false;
    private boolean checkMatchingKeySupported = true;
    private MWLFindScp mwlFindScp = new MWLFindScp(this);

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        if (useProxy && this.server != null) {
            this.checkMWLScuConfig();
        }
    }

    public boolean isCheckMatchingKeySupported() {
        return this.checkMatchingKeySupported;
    }

    public void setCheckMatchingKeySupported(boolean checkMatchingKeySupport) {
        this.checkMatchingKeySupported = checkMatchingKeySupport;
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName mppsScpServiceName) {
        this.mppsScpServiceName = mppsScpServiceName;
    }

    public final ObjectName getMwlScuServiceName() {
        return this.mwlScuServiceName;
    }

    public final void setMwlScuServiceName(ObjectName mwlScuServiceName) {
        this.mwlScuServiceName = mwlScuServiceName;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.mppsScpServiceName, this, (NotificationFilter)mppsFilter, null);
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.server.removeNotificationListener(this.mppsScpServiceName, this, (NotificationFilter)mppsFilter, null);
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.31", this.mwlFindScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.31");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.5.1.4.31", MWLFindScpService.valuesToStringArray(this.tsuidMap));
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.31", this.extNegotiator);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.5.1.4.31", null);
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.31", null);
    }

    private MWLManagerHome getMWLManagerHome() throws HomeFactoryException {
        return (MWLManagerHome)EJBHomeFactory.getFactory().lookup(MWLManagerHome.class, "ejb/MWLManager");
    }

    private MPPSManagerHome getMPPSManagerHome() throws HomeFactoryException {
        return (MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset getMPPS(String iuid) throws Exception {
        Dataset dataset;
        MPPSManager mgr = this.getMPPSManagerHome().create();
        try {
            dataset = mgr.getMPPS(iuid);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                mgr.remove();
            }
            catch (Exception ignore) {}
            throw throwable;
        }
        try {
            mgr.remove();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notif, Object handback) {
        MWLManager mgr;
        Dataset mpps = (Dataset)notif.getUserData();
        String iuid = mpps.getString(524312);
        String status = mpps.getString(4194898);
        DcmElement sq = mpps.get(4194928);
        if (sq == null) {
            if (PPS_STATUS_IN_PROGRESS.equals(status)) {
                return;
            }
            try {
                mpps = this.getMPPS(iuid);
                sq = mpps.get(4194928);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to load MPPS - " + iuid), (Throwable)e);
                return;
            }
        }
        try {
            mgr = this.getMWLManagerHome().create();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to access MWL Manager:", (Throwable)e);
            return;
        }
        try {
            String spsStatus = PPS_STATUS_IN_PROGRESS.equals(status) ? SPS_STATUS_STARTED : status;
            int n = sq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = sq.getItem(i);
                String spsid = item.getString(0x400009);
                String rpid = item.getString(0x401001);
                if (spsid == null) continue;
                try {
                    if (mgr.updateSPSStatus(rpid, spsid, spsStatus)) {
                        this.log.info((Object)("Update MWL item[spsid=" + spsid + ", status=" + spsStatus + "]"));
                        continue;
                    }
                    this.log.info((Object)("No such MWL item[spsid=" + spsid + "]"));
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to update MWL item[spsid=" + spsid + "]"), (Throwable)e);
                }
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                mgr.remove();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            mgr.remove();
        }
        catch (Exception ignore) {}
    }

    public boolean checkMWLScuConfig() {
        String proxyAET;
        try {
            proxyAET = (String)this.server.getAttribute(this.mwlScuServiceName, "CalledAETitle");
        }
        catch (Exception x) {
            this.log.warn((Object)"Cant check MWL SCU AET configuration! Continue with assumption that configuration is valid!", (Throwable)x);
            return true;
        }
        if ("LOCAL".equals(proxyAET)) {
            this.log.warn((Object)"Check MWL Proxy Settings: Called AET in MWLScu Service is LOCAL! -> Use local DB access!");
            return false;
        }
        for (int i = 0; i < this.calledAETs.length; ++i) {
            if (!proxyAET.equals(this.calledAETs[i])) continue;
            this.log.warn((Object)("Check MWL Proxy Settings: Called AET (" + proxyAET + ") in MWLScu is also configured as accepted AET here! -> Disable forwarding MWL C-FIND requests to avoid infinite loop!"));
            return false;
        }
        return true;
    }

    public int findMWLEntries(Dataset rqData, boolean fuzzyMatchingOfPN, List l, boolean forceLocal) throws Exception {
        try {
            return (Integer)this.server.invoke(this.mwlScuServiceName, forceLocal ? "findMWLEntriesLocal" : "findMWLEntries", new Object[]{rqData, fuzzyMatchingOfPN, l}, new String[]{Dataset.class.getName(), Boolean.TYPE.getName(), List.class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
    }

    static {
        mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#received");
        mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#linked");
    }
}

