/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mwlscp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Templates;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4chex.archive.dcm.mwlscp.MWLFindScpService;
import org.jboss.logging.Logger;

public class MWLFindScp
extends DcmServiceBase {
    private static final int FUZZY_MATCHING = 2;
    private static final String QUERY_XSL = "mwl-cfindrq.xsl";
    private static final String RESULT_XSL = "mwl-cfindrsp.xsl";
    private static final String QUERY_XML = "-mwl-cfindrq.xml";
    private static final String RESULT_XML = "-mwl-cfindrsp.xml";
    private final MWLFindScpService service;
    private final Logger log;

    public MWLFindScp(MWLFindScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected DcmServiceBase.MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association a = assoc.getAssociation();
        String callingAET = a.getCallingAET();
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        this.log.debug((Object)"Identifier:\n");
        this.log.debug((Object)rqData);
        this.service.logDIMSE(a, QUERY_XML, rqData);
        this.service.logDicomQuery(a, rq.getCommand().getAffectedSOPClassUID(), rqData);
        Dataset coerce = this.service.getCoercionAttributesFor(callingAET, QUERY_XSL, rqData, a);
        if (coerce != null) {
            this.service.coerceAttributes(rqData, coerce);
        }
        ArrayList l = new ArrayList();
        boolean forceLocal = !this.service.isUseProxy() || !this.service.checkMWLScuConfig();
        boolean fuzzyMatchingOfPN = this.fuzzyMatchingOfPN(a.getAcceptedExtNegotiation(rqCmd.getAffectedSOPClassUID()));
        try {
            int pendingStatus = this.service.findMWLEntries(rqData, fuzzyMatchingOfPN, l, forceLocal);
            return new MultiCFindRsp(l, pendingStatus);
        }
        catch (DcmServiceException dse) {
            throw dse;
        }
        catch (Exception e) {
            this.log.error((Object)"Forwarding request to proxy failed!", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private boolean fuzzyMatchingOfPN(ExtNegotiation extNeg) {
        byte[] info;
        return extNeg != null && (info = extNeg.info()).length > 2 && info[2] != 0;
    }

    private class MultiCFindRsp
    implements DcmServiceBase.MultiDimseRsp {
        private final Iterator iterResults;
        private boolean canceled = false;
        private final int pendingStatus;
        private int count = 0;
        private Templates coerceTpl;

        public MultiCFindRsp(List results, int pendingStatus) {
            this.iterResults = results.iterator();
            this.pendingStatus = MWLFindScp.this.service.isCheckMatchingKeySupported() ? pendingStatus : 65280;
        }

        public DimseListener getCancelListener() {
            return new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MultiCFindRsp.this.canceled = true;
                }
            };
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            if (this.canceled) {
                rspCmd.putUS(2304, 65024);
                return null;
            }
            try {
                Dataset coerce;
                if (!this.iterResults.hasNext()) {
                    rspCmd.putUS(2304, 0);
                    return null;
                }
                Association a = assoc.getAssociation();
                String callingAET = a.getCallingAET();
                rspCmd.putUS(2304, this.pendingStatus);
                Dataset rspData = (Dataset)this.iterResults.next();
                MWLFindScp.this.log.debug((Object)"Identifier:\n");
                MWLFindScp.this.log.debug((Object)rspData);
                MWLFindScp.this.service.logDIMSE(a, MWLFindScp.RESULT_XML, rspData);
                if (this.count++ == 0) {
                    this.coerceTpl = MWLFindScp.this.service.getCoercionTemplates(callingAET, MWLFindScp.RESULT_XSL);
                }
                if ((coerce = MWLFindScp.this.service.getCoercionAttributesFor(a, MWLFindScp.RESULT_XSL, rspData, this.coerceTpl)) != null) {
                    MWLFindScp.this.service.coerceAttributes(rspData, coerce);
                }
                return rspData;
            }
            catch (Exception e) {
                MWLFindScp.this.log.error((Object)"Process MWL C-FIND failed:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
        }

        public void release() {
        }
    }
}

