/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mppsscu;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.mppsscp.MPPSScpService;
import org.dcm4chex.archive.dcm.mppsscu.MPPSOrder;
import org.dcm4chex.archive.mbean.JMSDelegate;

public class MPPSScuService
extends AbstractScuService
implements MessageListener,
NotificationListener {
    private static final int PCID_MPPS = 1;
    private static final int[] EXCLUDE_TAGS = new int[]{524310, 524312};
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private ForwardingRules forwardingRules = new ForwardingRules("");
    private ObjectName mppsScpServiceName;
    private String queueName;
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final String getForwardingRules() {
        return this.forwardingRules.toString();
    }

    public final void setForwardingRules(String forwardingRules) {
        this.forwardingRules = new ForwardingRules(forwardingRules);
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName mppsScpServiceName) {
        this.mppsScpServiceName = mppsScpServiceName;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.mppsScpServiceName, this, MPPSScpService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.mppsScpServiceName, this, MPPSScpService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset mpps = (Dataset)notif.getUserData();
        mpps.setPrivateCreatorID("dcm4che/archive");
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("calling", new String[]{mpps.getString(4390932)});
        mpps.setPrivateCreatorID(null);
        String[] destAETs = this.forwardingRules.getForwardDestinationsFor(param);
        for (int i = 0; i < destAETs.length; ++i) {
            MPPSOrder order = new MPPSOrder(mpps.excludePrivate(), ForwardingRules.toAET(destAETs[i]));
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, order, 4, 0L);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                MPPSOrder order = (MPPSOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.sendMPPS(order.isCreate(), order.getDataset(), order.getDestination());
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMPPS(boolean create, Dataset mpps, String aet) throws Exception {
        ActiveAssociation aa = this.openAssociation(aet, "1.2.840.10008.3.1.2.3.3");
        Association a = aa.getAssociation();
        try {
            DcmObjectFactory dof = DcmObjectFactory.getInstance();
            Command cmdRq = dof.newCommand();
            if (create) {
                cmdRq.initNCreateRQ(a.nextMsgID(), "1.2.840.10008.3.1.2.3.3", mpps.getString(524312));
            } else {
                cmdRq.initNSetRQ(a.nextMsgID(), "1.2.840.10008.3.1.2.3.3", mpps.getString(524312));
            }
            Dimse dimseRq = AssociationFactory.getInstance().newDimse(1, cmdRq, mpps.exclude(EXCLUDE_TAGS));
            Dimse dimseRsp = aa.invoke(dimseRq).get();
            Command cmdRsp = dimseRsp.getCommand();
            int status = cmdRsp.getStatus();
            switch (status) {
                case 0: {
                    break;
                }
                case 278: {
                    this.log.warn((Object)("Received Warning Status 116H (=Attribute Value Out of Range) from remote AE " + aet));
                    break;
                }
                default: {
                    this.log.error((Object)("Received Error Status " + Integer.toHexString(status) + "H, Error Comment: " + cmdRsp.getString(2306)));
                    throw new DcmServiceException(status, cmdRsp.getString(2306));
                }
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release " + aa.getAssociation()));
        }
    }
}

