/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mppsscu;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.MPPSEmulator;
import org.dcm4chex.archive.ejb.interfaces.MPPSEmulatorHome;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;

public class MPPSEmulatorService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final long FIVE_MINUTES = 299999L;
    private static final String IN_PROGRESS = "IN PROGRESS";
    private static final String COMPLETED = "COMPLETED";
    private static final int[] MPPS_CREATE_TAGS = new int[]{524293, 524312, 524384, 528434, 528672, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x200010, 4194881, 0x400242, 4194883, 0x400244, 4194885, 4194896, 4194897, 4194898, 4194899, 4194900, 4194901, 4194912, 4194928};
    private static final int[] MPPS_SET_TAGS = new int[]{524293, 524312, 4194896, 4194897, 4194898, 0x400340};
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long pollInterval = 0L;
    private Integer schedulerID;
    private String calledAET;
    private String[] stationAETs = new String[0];
    private long[] delays;
    private ObjectName mppsScuServiceName;
    private String timerIDCheckSeriesWithoutMPPS;
    private boolean isRunning;
    private boolean ignoreReqAttrIfNoStudyAccNo;

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final ObjectName getMppsScuServiceName() {
        return this.mppsScuServiceName;
    }

    public final void setMppsScuServiceName(ObjectName mppsScuServiceName) {
        this.mppsScuServiceName = mppsScuServiceName;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    public final String getModalityAETitles() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.stationAETs.length; ++i) {
            sb.append(this.stationAETs[i]);
            if (this.delays[i] != 299999L) {
                sb.append(':').append(RetryIntervalls.formatInterval(this.delays[i]));
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public final void setModalityAETitles(String s) {
        StringTokenizer stk = new StringTokenizer(s, "\r\n");
        String[] newStationAETs = new String[stk.countTokens()];
        this.delays = new long[newStationAETs.length];
        for (int i = 0; i < newStationAETs.length; ++i) {
            newStationAETs[i] = stk.nextToken().trim();
            this.delays[i] = 299999L;
            int endAET = newStationAETs[i].indexOf(58);
            if (endAET < 0) continue;
            this.delays[i] = RetryIntervalls.parseInterval(newStationAETs[i].substring(endAET + 1));
            newStationAETs[i] = newStationAETs[i].substring(0, endAET);
        }
        this.stationAETs = newStationAETs;
    }

    public final String getPollInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.pollInterval);
    }

    public void setPollInterval(String interval) throws Exception {
        this.pollInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDCheckSeriesWithoutMPPS, this.schedulerID, this);
            this.schedulerID = this.scheduler.startScheduler(this.timerIDCheckSeriesWithoutMPPS, this.pollInterval, this);
        }
    }

    public boolean isIgnoreReqAttrIfNoStudyAccNo() {
        return this.ignoreReqAttrIfNoStudyAccNo;
    }

    public void setIgnoreReqAttrIfNoStudyAccNo(boolean ignoreReqAttrIfNoStudyAccNo) {
        this.ignoreReqAttrIfNoStudyAccNo = ignoreReqAttrIfNoStudyAccNo;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("org.jboss.system.server.started")) {
            try {
                this.schedulerID = this.scheduler.startScheduler(this.timerIDCheckSeriesWithoutMPPS, this.pollInterval, this);
            }
            catch (Exception x) {
                this.log.error((Object)"Can not start timer!", (Throwable)x);
            }
        } else if (this.stationAETs.length > 0) {
            new Thread(new Runnable(){

                public void run() {
                    MPPSEmulatorService.this.emulateMPPS();
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int emulateMPPS() {
        MPPSEmulator mppsEmulator;
        if (this.stationAETs.length == 0) {
            return 0;
        }
        MPPSEmulatorService mPPSEmulatorService = this;
        synchronized (mPPSEmulatorService) {
            if (this.isRunning) {
                this.log.info((Object)"EmulateMPPS is already running!");
                return -1;
            }
            this.isRunning = true;
        }
        this.log.info((Object)"Check for received series without MPPS");
        int num = 0;
        try {
            mppsEmulator = this.getMPPSEmulatorHome().create();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to emulate MPPS:", (Throwable)e);
            int n = 0;
            Object var14_9 = null;
            this.isRunning = false;
            return n;
        }
        try {
            for (int i = 0; i < this.stationAETs.length; ++i) {
                Collection studyPks;
                try {
                    studyPks = mppsEmulator.getStudiesWithMissingMPPS(this.stationAETs[i], this.delays[i]);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to emulate MPPS for series received from " + this.stationAETs[i] + " failed:"), (Throwable)e);
                    continue;
                }
                this.log.info((Object)("Found " + studyPks.size() + " studies with missing MPPS for sourceAET:" + this.stationAETs[i]));
                for (Long studyPk : studyPks) {
                    Dataset[] studyMpps;
                    try {
                        studyMpps = mppsEmulator.generateMPPS(studyPk, this.ignoreReqAttrIfNoStudyAccNo);
                    }
                    catch (Exception x) {
                        this.log.error((Object)("Failed to emulate MPPS for Study pk:" + studyPk), (Throwable)x);
                        continue;
                    }
                    for (int j = 0; j < studyMpps.length; ++j) {
                        Dataset mpps = studyMpps[j];
                        Dataset ssa = mpps.getItem(4194928);
                        String suid = ssa.getString(0x20000D);
                        this.log.info((Object)("Emulate MPPS for Study:" + suid + " of Patient:" + mpps.getString(0x100010) + " received from Station:" + mpps.getString(4194881) + " (" + mpps.getString(524384) + ")"));
                        try {
                            this.createMPPS(mpps);
                            this.updateMPPS(mpps);
                            ++num;
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Failed to emulate MPPS for Study:" + suid + " of Patient:" + mpps.getString(0x100010) + " received from Station:" + mpps.getString(4194881) + " (" + mpps.getString(524384) + "):"), (Throwable)e);
                        }
                    }
                }
            }
            int n = num;
            Object var14_10 = null;
            this.isRunning = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    public int emulateMPPS(long studyPk) {
        try {
            MPPSEmulator mppsEmulator = this.getMPPSEmulatorHome().create();
            Dataset[] studyMpps = mppsEmulator.generateMPPS(studyPk, this.ignoreReqAttrIfNoStudyAccNo);
            int num = 0;
            for (int j = 0; j < studyMpps.length; ++j) {
                Dataset mpps = studyMpps[j];
                Dataset ssa = mpps.getItem(4194928);
                String suid = ssa.getString(0x20000D);
                this.log.info((Object)("Emulate MPPS for Study:" + suid + " of Patient:" + mpps.getString(0x100010) + " received from Station:" + mpps.getString(4194881) + " (" + mpps.getString(524384) + ")"));
                try {
                    this.createMPPS(mpps);
                    this.updateMPPS(mpps);
                    ++num;
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to emulate MPPS for Study:" + suid + " of Patient:" + mpps.getString(0x100010) + " received from Station:" + mpps.getString(4194881) + " (" + mpps.getString(524384) + "):"), (Throwable)e);
                }
            }
            return num;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to emulate MPPS:", (Throwable)e);
            return -1;
        }
    }

    private void fillType2Attrs(Dataset ds, int[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            if (ds.contains(tags[i])) continue;
            ds.putXX(tags[i]);
        }
    }

    private void createMPPS(Dataset mpps) throws Exception {
        mpps.putCS(4194898, IN_PROGRESS);
        this.fillType2Attrs(mpps, MPPS_CREATE_TAGS);
        this.sendMPPS(true, mpps.subSet(MPPS_CREATE_TAGS), this.calledAET);
    }

    private void updateMPPS(Dataset mpps) throws Exception {
        mpps.putCS(4194898, COMPLETED);
        this.sendMPPS(false, mpps.subSet(MPPS_SET_TAGS), this.calledAET);
    }

    private MPPSEmulatorHome getMPPSEmulatorHome() throws HomeFactoryException {
        return (MPPSEmulatorHome)EJBHomeFactory.getFactory().lookup(MPPSEmulatorHome.class, "ejb/MPPSEmulator");
    }

    private void sendMPPS(boolean create, Dataset mpps, String destination) throws Exception {
        this.server.invoke(this.mppsScuServiceName, "sendMPPS", new Object[]{create, mpps, destination}, new String[]{Boolean.TYPE.getName(), Dataset.class.getName(), String.class.getName()});
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckSeriesWithoutMPPS, this.schedulerID, this);
        super.stopService();
    }

    public String getTimerIDCheckSeriesWithoutMPPS() {
        return this.timerIDCheckSeriesWithoutMPPS;
    }

    public void setTimerIDCheckSeriesWithoutMPPS(String timerIDCheckSeriesWithoutMPPS) {
        this.timerIDCheckSeriesWithoutMPPS = timerIDCheckSeriesWithoutMPPS;
    }
}

