/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mppsscp;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ReflectionException;
import javax.xml.transform.Templates;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.message.ProcedureRecordMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.mppsscp.MPPSScp;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.dcm4chex.archive.util.XSLTUtils;

public class MPPSScpService
extends AbstractScpService {
    public static final String EVENT_TYPE_MPPS_RECEIVED = "org.dcm4chex.archive.dcm.mppsscp#received";
    public static final String EVENT_TYPE_MPPS_LINKED = "org.dcm4chex.archive.dcm.mppsscp#linked";
    public static final String EVENT_TYPE_MPPS_DELETED = "org.dcm4chex.archive.dcm.mppsscp#deleted";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 3688507684001493298L;

        public boolean isNotificationEnabled(Notification notif) {
            return MPPSScpService.EVENT_TYPE_MPPS_RECEIVED.equals(notif.getType());
        }
    };
    private static final String MWL2STORE_XSL = "mwl-cfindrsp2cstorerq.xsl";
    private String addMwlAttrsToMppsXsl;
    private MPPSScp mppsScp = new MPPSScp(this);

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.3.1.2.3.3", this.mppsScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.3.1.2.3.3");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.3.1.2.3.3", MPPSScpService.valuesToStringArray(this.tsuidMap));
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.3.1.2.3.3", null);
    }

    public String getAddMwlAttrsToMppsXsl() {
        return this.addMwlAttrsToMppsXsl == null ? "NONE" : this.addMwlAttrsToMppsXsl;
    }

    public void setAddMwlAttrsToMppsXsl(String addMwlAttrToMppsXsl) {
        this.addMwlAttrsToMppsXsl = "NONE".equals(addMwlAttrToMppsXsl) ? null : addMwlAttrToMppsXsl;
    }

    void sendMPPSNotification(Dataset ds, String eventType) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(eventType, (Object)this, eventID);
        notif.setUserData(ds);
        super.sendNotification(notif);
    }

    public Map linkMppsToMwl(String[] rpspsIDs, String[] mppsIUIDs) throws CreateException, HomeFactoryException, RemoteException, DcmServiceException, FinderException {
        return this.createMpps2MwlLink(rpspsIDs, mppsIUIDs);
    }

    public Map linkMppsToMwl(Dataset[] spsAttrs, String[] mppsIUIDs) throws CreateException, HomeFactoryException, RemoteException, DcmServiceException, FinderException {
        return this.createMpps2MwlLink(spsAttrs, mppsIUIDs);
    }

    private Map createMpps2MwlLink(Object[] sps, String[] mppsIUIDs) throws CreateException, RemoteException, HomeFactoryException, DcmServiceException, FinderException {
        MPPSManager mgr = this.getMPPSManagerHome().create();
        Map map = null;
        Dataset dominant = null;
        HashMap<String, Dataset> mapPrior = new HashMap<String, Dataset>();
        HashMap<String, Dataset> mapCoercedSeries = new HashMap<String, Dataset>();
        for (int i = sps.length - 1; i >= 0; --i) {
            boolean external = sps[i] instanceof Dataset;
            for (int j = 0; j < mppsIUIDs.length; ++j) {
                String spsid;
                if (external) {
                    Dataset spsAttr = (Dataset)sps[i];
                    map = mgr.linkMppsToMwl(spsAttr, mppsIUIDs[j]);
                    spsid = spsAttr.getString(0x400009);
                } else {
                    String[] rpIDspsID = StringUtils.split((String)sps[i], '\\');
                    map = mgr.linkMppsToMwl(rpIDspsID[0], rpIDspsID[1], mppsIUIDs[j]);
                    spsid = rpIDspsID[1];
                }
                if (map.containsKey("mwlPat")) {
                    Collection studyPats;
                    Dataset prior2;
                    if (dominant == null) {
                        dominant = (Dataset)map.get("mwlPat");
                    }
                    if ((prior2 = (Dataset)map.get("mppsPat")) != null) {
                        prior2.setPrivateCreatorID("dcm4che/archive");
                        mapPrior.put(prior2.getString(4390928), prior2);
                        prior2.setPrivateCreatorID(null);
                    }
                    if ((studyPats = (Collection)map.get("studyPats")) != null) {
                        for (Dataset prior2 : studyPats) {
                            prior2.setPrivateCreatorID("dcm4che/archive");
                            mapPrior.put(prior2.getString(4390928), prior2);
                            prior2.setPrivateCreatorID(null);
                        }
                    }
                }
                this.logMppsLinkRecord(map, spsid, mppsIUIDs[j]);
                try {
                    Dataset coerceWL = this.getCoercionDS((Dataset)map.get("mwlAttrs"));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"MWL Attributes:");
                        this.log.debug(map.get("mwlAttrs"));
                        this.log.debug((Object)"Series Attributes from worklist:");
                        this.log.debug((Object)coerceWL);
                    }
                    if (coerceWL != null) {
                        this.log.info((Object)"Coerce MWL attributes to series/study after manual MWL-MPPS linking!");
                        Collection seriesDS = mgr.getSeriesAndStudyDS(mppsIUIDs[j]);
                        Dataset coerce = DcmObjectFactory.getInstance().newDataset();
                        Iterator iter = seriesDS.iterator();
                        while (iter.hasNext()) {
                            coerce.putAll(coerceWL);
                            Dataset series = (Dataset)iter.next();
                            Dataset cSeries = (Dataset)mapCoercedSeries.get(series.getString(0x20000E));
                            if (cSeries == null) {
                                series.remove(4194933);
                                this.coerceAttributes(series, coerce);
                                this.log.debug((Object)("Update series " + series.getString(0x20000E) + " with worklist attributes!"));
                                mapCoercedSeries.put(series.getString(0x20000E), series);
                                continue;
                            }
                            DcmElement newReqAttrSQ = coerce.get(4194933);
                            if (newReqAttrSQ == null) continue;
                            DcmElement reqAttrSQ = cSeries.get(4194933);
                            if (reqAttrSQ == null) {
                                reqAttrSQ = cSeries.putSQ(4194933);
                            }
                            int len = newReqAttrSQ.countItems();
                            for (int k = 0; k < len; ++k) {
                                reqAttrSQ.addItem(newReqAttrSQ.getItem(k));
                            }
                        }
                    }
                }
                catch (Exception x) {
                    this.log.error((Object)"Cant coerce MWL attributes to series)", (Throwable)x);
                }
                if (i != 0) continue;
                Dataset mppsAttrs = (Dataset)map.get("mppsAttrs");
                if (this.addMwlAttrsToMppsXsl != null) {
                    this.addMwlAttrs2Mpps(mppsAttrs, (Dataset)map.get("mwlAttrs"));
                }
                this.sendMPPSNotification(mppsAttrs, EVENT_TYPE_MPPS_LINKED);
            }
        }
        ArrayList studyDsN = this.updateStudySeries(mgr, mapCoercedSeries);
        map.put("StudyMgtDS", studyDsN);
        if (dominant != null) {
            Dataset[] priorPats = mapPrior.values().toArray(new Dataset[mapPrior.size()]);
            map.put("dominant", dominant);
            map.put("priorPats", priorPats);
        }
        return map;
    }

    private void addMwlAttrs2Mpps(Dataset mppsAttrs, Dataset mwlAttrs) {
        try {
            File xslFile = FileUtils.toExistingFile(this.addMwlAttrsToMppsXsl);
            Templates tmpl = this.templates.getTemplates(xslFile);
            if (tmpl != null) {
                Dataset coerce = DcmObjectFactory.getInstance().newDataset();
                XSLTUtils.xslt(mwlAttrs, tmpl, coerce);
                this.coerceAttributes(mppsAttrs, coerce);
            } else {
                this.log.warn((Object)("Coercion template " + this.addMwlAttrsToMppsXsl + " not found! Can not add MWL attributes to MPPS Linked notification!"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Attribute coercion failed! Can not add MWL attributes to MPPS Linked notification!", (Throwable)e);
        }
    }

    private ArrayList updateStudySeries(MPPSManager mgr, Map mapCoercedSeries) throws FinderException, CreateException, RemoteException {
        HashMap<String, ArrayList<Dataset>> mapStudySeries = new HashMap<String, ArrayList<Dataset>>();
        for (Dataset ds : mapCoercedSeries.values()) {
            ArrayList<Dataset> series = (ArrayList<Dataset>)mapStudySeries.get(ds.getString(0x20000D));
            if (series == null) {
                series = new ArrayList<Dataset>();
                mapStudySeries.put(ds.getString(0x20000D), series);
            }
            series.add(ds);
        }
        ArrayList<Dataset> studyDsN = new ArrayList<Dataset>();
        Iterator iter = mapStudySeries.values().iterator();
        while (iter.hasNext()) {
            Dataset dsN = mgr.updateSeriesAndStudy((Collection)iter.next());
            if (dsN == null) continue;
            this.log.debug((Object)"IAN Dataset of coerced study:");
            this.log.debug((Object)dsN);
            studyDsN.add(dsN);
        }
        return studyDsN;
    }

    private Dataset getCoercionDS(Dataset ds) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (ds == null) {
            return null;
        }
        Dataset sps = ds.getItem(0x400100);
        String aet = sps != null ? sps.getString(0x400001) : null;
        Templates tmpl = this.templates.getTemplatesForAET(aet, MWL2STORE_XSL);
        if (tmpl == null) {
            this.log.warn((Object)"Coercion template mwl-cfindrsp2cstorerq.xsl not found! Can not store MWL attributes to series!");
            return null;
        }
        Dataset out = DcmObjectFactory.getInstance().newDataset();
        try {
            XSLTUtils.xslt(ds, tmpl, out);
        }
        catch (Exception e) {
            this.log.error((Object)"Attribute coercion failed:", (Throwable)e);
            return null;
        }
        return out;
    }

    public void unlinkMpps(String mppsIUID) throws RemoteException, CreateException, HomeFactoryException, FinderException {
        MPPSManager mgr = this.getMPPSManagerHome().create();
        Dataset mppsAttrs = mgr.unlinkMpps(mppsIUID);
        DcmElement ssaSQ = mppsAttrs.get(4194928);
        StringBuffer sb = new StringBuffer();
        sb.append("Unlink MPPS iuid:").append(mppsAttrs.getString(524312)).append(" from SPS ID(s): ");
        int len = ssaSQ.countItems();
        for (int i = 0; i < len; ++i) {
            String spsID = ssaSQ.getItem(i).getString(0x400009);
            sb.append(spsID).append(", ");
        }
        this.logProcedureRecord(mppsAttrs, ssaSQ.getItem().getString(524368), ProcedureRecordMessage.UPDATE, sb.substring(0, sb.length() - 2));
    }

    public boolean deleteMPPSEntries(String[] iuids) throws RemoteException, CreateException, HomeFactoryException {
        MPPSManager mgr = this.getMPPSManagerHome().create();
        Dataset[] mppsAttrs = mgr.deleteMPPSEntries(iuids);
        boolean success = true;
        for (Dataset ds : mppsAttrs) {
            if (ds != null) {
                this.sendMPPSNotification(ds, EVENT_TYPE_MPPS_DELETED);
                Dataset ssaItem = ds.getItem(4194928);
                this.logProcedureRecord(ds, ssaItem == null ? null : ssaItem.getString(524368), ProcedureRecordMessage.DELETE, "MPPS deleted:" + ds.getString(524312));
                continue;
            }
            success = false;
        }
        return success;
    }

    public void logMppsLinkRecord(Map map, String spsID, String mppsIUID) {
        Dataset mppsAttrs = (Dataset)map.get("mppsAttrs");
        Dataset mwlAttrs = (Dataset)map.get("mwlAttrs");
        String desc = "MPPS " + mppsIUID + " linked with MWL entry " + spsID;
        this.logProcedureRecord(mppsAttrs, mwlAttrs.getString(524368), ProcedureRecordMessage.UPDATE, desc);
    }

    private void logProcedureRecord(Dataset mppsAttrs, String accNr, AuditEvent.ActionCode actionCode, String desc) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("log Procedure Record! actionCode:" + actionCode));
            this.log.debug((Object)"mppsAttrs:");
            this.log.debug((Object)mppsAttrs);
        }
        try {
            ProcedureRecordMessage msg = new ProcedureRecordMessage(actionCode);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            PersonName pn = mppsAttrs.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            msg.addPatient(mppsAttrs.getString(0x100020), pname);
            ParticipantObjectDescription poDesc = new ParticipantObjectDescription();
            if (accNr != null) {
                poDesc.addAccession(accNr);
            }
            ParticipantObject study = msg.addStudy(mppsAttrs.getItem(4194928).getString(0x20000D), poDesc);
            study.addParticipantObjectDetail("Description", desc);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception x) {
            this.log.warn((Object)"Audit Log 'Procedure Record' failed:", (Throwable)x);
        }
    }

    private MPPSManagerHome getMPPSManagerHome() throws HomeFactoryException {
        return (MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager");
    }
}

