/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mppsscp;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.common.PPSStatus;
import org.dcm4chex.archive.dcm.mppsscp.MPPSScpService;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

public class MPPSScp
extends DcmServiceBase {
    private static final String CREATE_XSL = "mpps-ncreaterq.xsl";
    private static final String SET_XSL = "mpps-nsetrq.xsl";
    private static final String CREATE_XML = "mpps-ncreaterq.xml";
    private static final String SET_XML = "mpps-nsetrq.xml";
    private static final int[] TYPE1_NCREATE_ATTR = new int[]{4194928, 4194899, 4194881, 0x400244, 4194885, 4194898, 524384};
    private static final int[] ONLY_NCREATE_ATTR = new int[]{4194928, 0x100010, 0x100020, 0x100030, 0x100040, 4194899, 4194881, 0x400242, 4194883, 0x400244, 4194885, 524384, 0x200010};
    private static final int[] TYPE1_FINAL_ATTR = new int[]{4194896, 4194897, 0x400340};
    private final MPPSScpService service;
    private final Logger log;

    public MPPSScp(MPPSScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association as = assoc.getAssociation();
        String callingAET = as.getCallingAET();
        String calledAET = as.getCalledAET();
        Command cmd = rq.getCommand();
        Dataset mpps = rq.getDataset();
        String cuid = cmd.getAffectedSOPClassUID();
        String iuid = cmd.getAffectedSOPInstanceUID();
        if (iuid == null) {
            iuid = rspCmd.getAffectedSOPInstanceUID();
        }
        this.log.debug((Object)"Creating MPPS:\n");
        this.log.debug((Object)mpps);
        this.service.logDIMSE(as, CREATE_XML, mpps);
        Dataset coerce = this.service.getCoercionAttributesFor(callingAET, CREATE_XSL, mpps, as);
        if (coerce != null) {
            this.service.coerceAttributes(mpps, coerce);
        }
        this.checkCreateAttributs(mpps);
        if (!callingAET.equals(calledAET)) {
            this.service.ignorePatientIDForUnscheduled(mpps, 4194928, callingAET);
            this.service.supplementIssuerOfPatientID(mpps, as, callingAET, false);
            this.service.generatePatientID(mpps, mpps.getItem(4194928), calledAET);
            DcmElement ssasq = mpps.get(4194928);
            int n = ssasq.countItems();
            for (int i = 0; i < n; ++i) {
                this.service.supplementIssuerOfAccessionNumber(ssasq.getItem(i), as, callingAET, false);
            }
        }
        mpps.putUI(524310, cuid);
        mpps.putUI(524312, iuid);
        this.createMPPS(mpps);
        mpps.setPrivateCreatorID("dcm4che/archive");
        mpps.putAE(4390932, callingAET);
        mpps.setPrivateCreatorID(null);
        this.service.sendMPPSNotification(mpps, "org.dcm4chex.archive.dcm.mppsscp#received");
        return null;
    }

    private MPPSManager getMPPSManager() throws HomeFactoryException, RemoteException, CreateException {
        return ((MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager")).create();
    }

    private void createMPPS(Dataset mpps) throws DcmServiceException {
        try {
            this.getMPPSManager().createMPPS(mpps, this.service.patientMatching());
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    protected Dataset doNSet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association as = assoc.getAssociation();
        String callingAET = as.getCallingAET();
        Command cmd = rq.getCommand();
        Dataset mpps = rq.getDataset();
        String iuid = cmd.getRequestedSOPInstanceUID();
        this.log.debug((Object)"Set MPPS:\n");
        this.log.debug((Object)mpps);
        this.service.logDIMSE(as, SET_XML, mpps);
        Dataset coerce = this.service.getCoercionAttributesFor(callingAET, SET_XSL, mpps, as);
        if (coerce != null) {
            this.service.coerceAttributes(mpps, coerce);
        }
        this.checkSetAttributs(mpps);
        mpps.putUI(524312, iuid);
        this.updateMPPS(mpps);
        mpps.setPrivateCreatorID("dcm4che/archive");
        mpps.putAE(4390932, callingAET);
        mpps.setPrivateCreatorID(null);
        this.service.sendMPPSNotification(mpps, "org.dcm4chex.archive.dcm.mppsscp#received");
        return null;
    }

    private void updateMPPS(Dataset mpps) throws DcmServiceException {
        try {
            this.getMPPSManager().updateMPPS(mpps);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void checkCreateAttributs(Dataset mpps) throws DcmServiceException {
        for (int i = 0; i < TYPE1_NCREATE_ATTR.length; ++i) {
            if (mpps.containsValue(TYPE1_NCREATE_ATTR[i])) continue;
            throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(TYPE1_NCREATE_ATTR[i]));
        }
        DcmElement ssaSq = mpps.get(4194928);
        int n = ssaSq.countItems();
        for (int i = 0; i < n; ++i) {
            if (ssaSq.getItem(i).containsValue(0x20000D)) continue;
            throw new DcmServiceException(289, "Missing Study Instance UID in Scheduled Step Attributes Seq.");
        }
        this.checkCommonAttributs(mpps);
        String status = mpps.getString(4194898);
        try {
            if (PPSStatus.toInt(status) == 0) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        throw new DcmServiceException(262, "Invalid MPPS Status: " + status);
    }

    private void checkSetAttributs(Dataset mpps) throws DcmServiceException {
        for (int i = 0; i < ONLY_NCREATE_ATTR.length; ++i) {
            if (!mpps.contains(ONLY_NCREATE_ATTR[i])) continue;
            throw new DcmServiceException(272, "Cannot update attribute " + Tags.toString(ONLY_NCREATE_ATTR[i]));
        }
        this.checkCommonAttributs(mpps);
        String status = mpps.getString(4194898);
        try {
            if (status == null || PPSStatus.toInt(status) == 0) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(262, "Invalid MPPS Status: " + status);
        }
        for (int i = 0; i < TYPE1_FINAL_ATTR.length; ++i) {
            if (mpps.containsValue(TYPE1_FINAL_ATTR[i])) continue;
            throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(TYPE1_FINAL_ATTR[i]));
        }
    }

    private void checkCommonAttributs(Dataset mpps) throws DcmServiceException {
        this.checkCode(mpps, 528434, true);
        this.checkCode(mpps, 4198418, false);
        this.checkCode(mpps, 4194945, true);
    }

    private void checkCode(Dataset mpps, int tag, boolean single) throws DcmServiceException {
        DcmElement codesq = mpps.get(tag);
        if (codesq == null) {
            return;
        }
        int n = codesq.countItems();
        if (n == 0) {
            return;
        }
        if (n > 1 && single) {
            throw new DcmServiceException(262, Tags.toString(tag) + " contains " + n + " items");
        }
        for (int i = 0; i < n; ++i) {
            Dataset code = codesq.getItem(i);
            if (!code.containsValue(524544)) {
                throw new DcmServiceException(289, "Missing Code Value in item of " + Tags.toString(tag));
            }
            if (code.containsValue(524546)) continue;
            throw new DcmServiceException(289, "Missing Coding Scheme Designator in item of " + Tags.toString(tag));
        }
    }
}

