/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.movescu;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.jboss.system.ServiceMBeanSupport;

public class RouteOnPPSService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String DELIMS = ":;\n\r\t";
    private static final String NONE = "NONE";
    private int routingPriority = 0;
    private ObjectName gpwlScpServiceName;
    private ObjectName moveScuServiceName;
    private LinkedHashMap code2aets = new LinkedHashMap();

    public final String getRoutingRules() {
        if (this.code2aets.isEmpty()) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : this.code2aets.entrySet()) {
            sb.append(e.getKey()).append(':').append(e.getValue()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public final void setRoutingRules(String str) {
        this.code2aets.clear();
        if (str.equalsIgnoreCase(NONE)) {
            return;
        }
        StringTokenizer strtk = new StringTokenizer(str, DELIMS);
        String key = null;
        while (strtk.hasMoreTokens()) {
            String tk = strtk.nextToken();
            if (key != null) {
                this.code2aets.put(key, tk);
                key = null;
                continue;
            }
            key = tk;
        }
    }

    public final String getRoutingPriority() {
        return DicomPriority.toString(this.routingPriority);
    }

    public final void setRoutingPriority(String forwardPriority) {
        this.routingPriority = DicomPriority.toCode(forwardPriority);
    }

    public final ObjectName getGpwlScpServiceName() {
        return this.gpwlScpServiceName;
    }

    public final void setGpwlScpServiceName(ObjectName serviceName) {
        this.gpwlScpServiceName = serviceName;
    }

    public final ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public final void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_PPS_NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_PPS_NOTIF_FILTER, null);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset pps = (Dataset)notif.getUserData();
        String patId = pps.getString(0x100020);
        Dataset codeItem = pps.getItem(4210713);
        if (codeItem == null) {
            return;
        }
        String key = "" + codeItem.getString(524544) + '^' + codeItem.getString(524546);
        String aets = (String)this.code2aets.get(key);
        if (aets == null) {
            this.log.debug((Object)("No Routing Rule for Performed Work Item Code: " + key));
            return;
        }
        this.log.info((Object)("Routing triggered by PPS work item code:" + key));
        Dataset rqItem = pps.getItem(4236144);
        if (rqItem == null) {
            this.log.warn((Object)"Missing Ref.Request Item - Routing abandoned");
            return;
        }
        String suid = rqItem.getString(0x20000D);
        if (suid == null) {
            this.log.warn((Object)"Missing Study Instance UID in Ref.Request Item - Routing abandoned");
            return;
        }
        StringTokenizer st = new StringTokenizer(aets, ",");
        while (st.hasMoreTokens()) {
            String aet = st.nextToken();
            this.scheduleMove(null, aet, patId, suid);
            this.log.info((Object)("Routing of Study[iuid=" + suid + "] to " + aet));
        }
    }

    private void scheduleMove(String retrieveAET, String destAET, String patId, String studyIUID) {
        try {
            this.server.invoke(this.moveScuServiceName, "scheduleMove", new Object[]{retrieveAET, destAET, new Integer(this.routingPriority), patId, studyIUID, null, null, new Long(-1L)}, new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String[].class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule Move failed:", (Throwable)e);
        }
    }

    public void testRouting(String code, String studyUID) {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        Dataset codeItem = ds.putSQ(4210713).addNewItem();
        int pos = code.indexOf(94);
        codeItem.putSH(524544, pos == -1 ? code : code.substring(0, pos));
        if (pos != -1) {
            codeItem.putSH(524546, code.substring(++pos));
        }
        Dataset item = ds.putSQ(4236144).addNewItem();
        item.putUI(0x20000D, studyUID);
        Notification notif = new Notification("testRouting", this, System.currentTimeMillis());
        notif.setUserData(ds);
        this.handleNotification(notif, null);
    }
}

