/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.movescu;

import java.io.IOException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.movescu.MoveOrder;
import org.dcm4chex.archive.mbean.JMSDelegate;

public class MoveScuService
extends AbstractScuService
implements MessageListener {
    private static final int PCID_MOVE = 1;
    private static final String DEF_CALLED_AET = "QR_SCP";
    private String calledAET = "QR_SCP";
    private RetryIntervalls.Map retryIntervalls;
    private int concurrency = 1;
    private String queueName;
    private boolean forceCalledAET;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String retrieveAET) {
        this.calledAET = retrieveAET;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls != null ? this.retryIntervalls.toString() : "NEVER\n";
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls.Map(text);
    }

    public boolean isForceCalledAET() {
        return this.forceCalledAET;
    }

    public void setForceCalledAET(boolean forceCalledAET) {
        this.forceCalledAET = forceCalledAET;
    }

    public void scheduleMove(String retrieveAET, String destAET, int priority, String pid, String studyIUID, String seriesIUID, String[] sopIUIDs, long scheduledTime) {
        MoveOrder moveOrder = new MoveOrder(retrieveAET, destAET, priority, pid, studyIUID, seriesIUID, sopIUIDs);
        moveOrder.processOrderProperties(new Object[0]);
        this.scheduleMoveOrder(moveOrder, scheduledTime);
    }

    public void scheduleMove(String retrieveAET, String destAET, int priority, String pid, String[] studyIUIDs, String[] seriesIUIDs, String[] sopIUIDs, long scheduledTime) {
        MoveOrder moveOrder = new MoveOrder(retrieveAET, destAET, priority, pid, studyIUIDs, seriesIUIDs, sopIUIDs);
        moveOrder.processOrderProperties(new Object[0]);
        this.scheduleMoveOrder(moveOrder, scheduledTime);
    }

    public void scheduleMoveOrder(MoveOrder order, long scheduledTime) {
        try {
            this.log.info((Object)("Schedule order: " + order));
            this.jmsDelegate.queue(this.queueName, order, JMSDelegate.toJMSPriority(order.getPriority()), scheduledTime);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to schedule order: " + order));
        }
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void onMessage(Message message) {
        block5: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                MoveOrder order = (MoveOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(order.getMoveDestination(), failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block5;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.scheduleMoveOrder(order, System.currentTimeMillis() + delay);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(MoveOrder order) throws Exception {
        String aet = order.getRetrieveAET();
        if (this.forceCalledAET || aet == null) {
            aet = this.calledAET;
        }
        ActiveAssociation aa = this.openAssociation(aet, "1.2.840.10008.5.1.4.1.2.1.2");
        try {
            this.invokeDimse(aa, order);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                aa.release(true);
                Thread.sleep(10L);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            aa.release(true);
            Thread.sleep(10L);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
    }

    private void invokeDimse(ActiveAssociation aa, MoveOrder order) throws InterruptedException, IOException, DcmServiceException {
        AssociationFactory af = AssociationFactory.getInstance();
        DcmObjectFactory dof = DcmObjectFactory.getInstance();
        Command cmd = dof.newCommand();
        cmd.initCMoveRQ(aa.getAssociation().nextMsgID(), "1.2.840.10008.5.1.4.1.2.1.2", order.getPriority(), order.getMoveDestination());
        Dataset ds = dof.newDataset();
        ds.putCS(524370, order.getQueryRetrieveLevel());
        MoveScuService.putLO(ds, 0x100020, order.getPatientId());
        MoveScuService.putUI(ds, 0x20000D, order.getStudyIuids());
        MoveScuService.putUI(ds, 0x20000E, order.getSeriesIuids());
        MoveScuService.putUI(ds, 524312, order.getSopIuids());
        this.log.debug((Object)"Move Identifier:\n");
        this.log.debug((Object)ds);
        Dimse dimseRsp = aa.invoke(af.newDimse(1, cmd, ds)).get();
        Command cmdRsp = dimseRsp.getCommand();
        int status = cmdRsp.getStatus();
        if (status != 0) {
            String[] failedUIDs;
            Dataset moveRspData;
            if (status == 45056 && order.getSopIuids() != null && (moveRspData = dimseRsp.getDataset()) != null && (failedUIDs = ds.getStrings(524376)) != null && failedUIDs.length != 0) {
                order.setSopIuids(failedUIDs);
            }
            throw new DcmServiceException(status, cmdRsp.getString(2306));
        }
    }

    private static void putLO(Dataset ds, int tag, String s) {
        if (s != null) {
            ds.putLO(tag, s);
        }
    }

    private static void putUI(Dataset ds, int tag, String[] uids) {
        if (uids != null) {
            ds.putUI(tag, uids);
        }
    }
}

