/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.movescu;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.DTFormat;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.ContentHandlerAdapter;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardService2
extends ServiceMBeanSupport {
    private static final String FORWARD_XSL = "forward.xsl";
    private static final String FORWARD_PRIORS_XSL = "forward_priors.xsl";
    private static final String ALL = "ALL";
    private static final String NONE = "NONE";
    private static final String[] EMPTY = new String[0];
    private String[] forwardOnInstanceLevelFromAETs = EMPTY;
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            ForwardService2.this.onSeriesStored((SeriesStored)notif.getUserData());
        }
    };
    private ObjectName storeScpServiceName;
    private ObjectName moveScuServiceName;
    private TemplatesDelegate templates = new TemplatesDelegate(this);
    private boolean logForwardPriorXML = true;
    private boolean ignoreNotLocalRetrievable;
    public static final SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();

    public final String getConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public final void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public String getForwardOnInstanceLevelFromAETs() {
        return this.forwardOnInstanceLevelFromAETs == null ? ALL : (this.forwardOnInstanceLevelFromAETs.length == 0 ? NONE : StringUtils.toString(this.forwardOnInstanceLevelFromAETs, ','));
    }

    public void setForwardOnInstanceLevelFromAETs(String s) {
        this.forwardOnInstanceLevelFromAETs = ALL.equals(s) ? null : (NONE.equals(s) ? EMPTY : StringUtils.split(s, ','));
    }

    private boolean isForwardOnInstanceLevelFromAET(String aet) {
        if (this.forwardOnInstanceLevelFromAETs == null) {
            return true;
        }
        for (int i = 0; i < this.forwardOnInstanceLevelFromAETs.length; ++i) {
            if (!aet.equals(this.forwardOnInstanceLevelFromAETs[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isLogForwardPriorXML() {
        return this.logForwardPriorXML;
    }

    public void setLogForwardPriorXML(boolean logForwardPriorXML) {
        this.logForwardPriorXML = logForwardPriorXML;
    }

    public boolean isIgnoreNotLocalRetrievable() {
        return this.ignoreNotLocalRetrievable;
    }

    public void setIgnoreNotLocalRetrievable(boolean ignoreNotLocalRetrievable) {
        this.ignoreNotLocalRetrievable = ignoreNotLocalRetrievable;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
    }

    private void onSeriesStored(final SeriesStored stored) {
        if (stored.getRetrieveAET() == null && this.ignoreNotLocalRetrievable) {
            this.log.warn((Object)"Ignore SeriesStored notification! Reason: Series is not locally retrievable.");
            return;
        }
        Templates tpl = this.templates.getTemplatesForAET(stored.getSourceAET(), FORWARD_XSL);
        if (tpl != null) {
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            ds.putAll(stored.getPatientAttrs());
            ds.putAll(stored.getStudyAttrs());
            ds.putAll(stored.getSeriesAttrs());
            final Calendar cal = Calendar.getInstance();
            try {
                this.log.debug((Object)"Forward2 transform input:");
                this.log.debug((Object)ds);
                ForwardService2.xslt(cal, stored.getSourceAET(), stored.getRetrieveAET(), null, ds, tpl, new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attrs) {
                        if (qName.equals("destination") && (attrs.getValue("includePrior") == null || !ForwardService2.this.scheduleMoveWithPriors(stored, attrs, cal))) {
                            ForwardService2.this.scheduleMove(stored.getRetrieveAET(), attrs.getValue("aet"), ForwardService2.toPriority(attrs.getValue("priority")), null, stored.getStudyInstanceUID(), stored.getSeriesInstanceUID(), ForwardService2.this.sopIUIDsOrNull(stored), ForwardService2.this.toScheduledTime(cal, attrs.getValue("delay")));
                        }
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)("Applying forwarding rules to " + stored + " fails:"), (Throwable)e);
            }
        }
    }

    private boolean scheduleMoveWithPriors(SeriesStored stored, Attributes attrs, Calendar cal) {
        this.log.info((Object)("scheduleMoveWithPriors! attrs:" + attrs));
        String includePriors = attrs.getValue("includePrior");
        Templates tpl = this.templates.getTemplatesForAET(stored.getSourceAET(), FORWARD_PRIORS_XSL);
        if (tpl == null) {
            this.log.warn((Object)("Missing forward_priors.xsl! source AET:" + stored.getSourceAET() + " includePriors:" + includePriors));
            return false;
        }
        Properties transformParams = this.toTransformParams(attrs);
        long delay = this.toScheduledTime(cal, attrs.getValue("delay"));
        try {
            Set<Dataset> priors = this.findPriors(stored, attrs);
            this.log.debug((Object)("priors found:" + priors.size()));
            if (priors.isEmpty()) {
                this.log.info((Object)"No priors found to forward!");
                return false;
            }
            Map<String, Map<String, Set<String>>> studies = this.getPriorsToForward(stored, cal, tpl, transformParams, priors);
            this.ensureSeriesStoredInForward(stored, studies);
            String retrAET = stored.getRetrieveAET();
            String destAET = attrs.getValue("aet");
            int priority = ForwardService2.toPriority(attrs.getValue("priority"));
            for (Map.Entry<String, Map<String, Set<String>>> studyEntry : studies.entrySet()) {
                String studyIUID = studyEntry.getKey();
                Map<String, Set<String>> series = studyEntry.getValue();
                if (series == null || series.isEmpty()) {
                    this.scheduleMove(retrAET, destAET, priority, null, studyIUID, null, null, delay);
                    continue;
                }
                for (Map.Entry<String, Set<String>> seriesEntry : series.entrySet()) {
                    this.scheduleMove(retrAET, destAET, priority, null, studyIUID, seriesEntry.getKey(), this.sopIUIDsOrNull(seriesEntry.getValue()), delay);
                }
            }
            return true;
        }
        catch (Exception x) {
            this.log.error((Object)"Failed to schedule forward with priors!", (Throwable)x);
            return false;
        }
    }

    private String[] sopIUIDsOrNull(Set<String> instances) {
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        return instances.toArray(new String[instances.size()]);
    }

    private Properties toTransformParams(Attributes attrs) {
        Properties transformParams = new Properties();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            transformParams.setProperty(attrs.getQName(i), attrs.getValue(i));
        }
        return transformParams;
    }

    private void ensureSeriesStoredInForward(SeriesStored stored, Map<String, Map<String, Set<String>>> studies) {
        Map<String, Set<String>> series = studies.get(stored.getStudyInstanceUID());
        if (series == null) {
            this.log.debug((Object)("Study of SeriesStored not in forwardWithPriors! Add studyIUID:" + stored.getStudyInstanceUID()));
            series = new HashMap<String, Set<String>>();
            studies.put(stored.getStudyInstanceUID(), series);
            series.put(stored.getSeriesInstanceUID(), new HashSet());
        }
        if (series.size() > 0) {
            String[] iuids;
            Set<String> instances = series.get(stored.getSeriesInstanceUID());
            if ((instances == null || instances.isEmpty()) && (iuids = this.sopIUIDsOrNull(stored)) != null && iuids.length > 0) {
                for (int i = 0; i < iuids.length; ++i) {
                    instances.add(iuids[i]);
                }
            }
        } else {
            this.log.debug((Object)"Study of SeriesStored has no series referenced! -> forward whole study!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, Set<String>>> getPriorsToForward(SeriesStored stored, Calendar cal, Templates tpl, Properties transformParams, Set<Dataset> priors) throws TransformerFactoryConfigurationError, TransformerConfigurationException, SAXException, IOException {
        HashMap<String, Map<String, Set<String>>> studies;
        block6: {
            studies = new HashMap<String, Map<String, Set<String>>>();
            if (this.logForwardPriorXML) {
                FileOutputStream fos = null;
                try {
                    File logFile = new File(System.getProperty("jboss.server.log.dir"), "forward_prior/" + new DTFormat().format(new Date()) + ".xml");
                    logFile.getParentFile().mkdirs();
                    TransformerHandler thLog = tf.newTransformerHandler();
                    fos = new FileOutputStream(logFile);
                    thLog.setResult(new StreamResult(fos));
                    this.transformPrior(stored, priors, thLog);
                    this.log.info((Object)("ForwardPrior XML logged in " + logFile));
                    Object var11_10 = null;
                    if (fos == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (fos == null) throw throwable;
                    try {
                        fos.close();
                        throw throwable;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ignore) {}
                fos.close();
            }
        }
        TransformerHandler th = ForwardService2.prepareTransformHandler(cal, stored.getSourceAET(), stored.getRetrieveAET(), transformParams, tpl, new DefaultHandler(){

            public void startElement(String uri, String localName, String qName, Attributes attrs) {
                if (qName.equals("forward")) {
                    ForwardService2.this.add(studies, attrs);
                }
            }
        });
        this.transformPrior(stored, priors, th);
        return studies;
    }

    private void transformPrior(SeriesStored stored, Set<Dataset> priors, TransformerHandler th) throws SAXException, IOException {
        ContentHandlerAdapter cha = new ContentHandlerAdapter(th);
        cha.forcedStartDocument();
        cha.startElement("forward");
        cha.startElement("seriesStored");
        stored.getIAN().writeDataset2(cha, null, null, 64, null);
        cha.endElement("seriesStored");
        cha.startElement("priors");
        for (Dataset ds : priors) {
            ds.writeDataset2(cha, null, null, 64, null);
        }
        cha.endElement("priors");
        cha.endElement("forward");
        cha.forcedEndDocument();
    }

    private Set<Dataset> findPriors(SeriesStored stored, Attributes attrs) {
        boolean instanceLevel = "INSTANCE".equals(attrs.getValue("level"));
        String avail = attrs.getValue("availability");
        int minAvail = avail == null ? 1 : Availability.toInt(avail);
        String retrAETsVal = attrs.getValue("retrAETs");
        String[] retrAETs = null;
        if (retrAETsVal == null) {
            retrAETs = new String[]{stored.getRetrieveAET()};
        } else if (retrAETsVal.trim().length() > 0 && !NONE.equals(retrAETsVal)) {
            retrAETs = StringUtils.split(retrAETsVal, '\\');
        }
        String modalities = attrs.getValue("modalities");
        String notOlderThan = attrs.getValue("notOlderThan");
        Long createdAfter = null;
        if (notOlderThan != null) {
            createdAfter = new Long(System.currentTimeMillis() - RetryIntervalls.parseInterval(notOlderThan));
        }
        try {
            return this.getContentManager().getPriorInfos(stored.getStudyInstanceUID(), instanceLevel, minAvail, createdAfter, retrAETs, StringUtils.split(modalities, '\\'));
        }
        catch (Exception x) {
            this.log.error((Object)("Failed to get prior studies for seriesStored:" + stored), (Throwable)x);
            return null;
        }
    }

    private boolean add(Map<String, Map<String, Set<String>>> studies, Attributes attrs) {
        String studyIUID = attrs.getValue("studyIUID");
        if (studyIUID == null) {
            this.log.warn((Object)"Missing studyIUID attribute in destination element of forward_priors.xsl! Ignored!");
            return false;
        }
        Map<String, Set<String>> series = studies.get(studyIUID);
        if (series == null) {
            series = new HashMap<String, Set<String>>();
            studies.put(studyIUID, series);
        }
        String seriesIUID = attrs.getValue("seriesIUID");
        String iuid = attrs.getValue("iuid");
        if (seriesIUID != null) {
            Set<String> instances = series.get(seriesIUID);
            if (instances == null) {
                instances = new HashSet<String>();
                series.put(seriesIUID, instances);
            }
            if (iuid != null) {
                instances.add(iuid);
            }
        } else if (iuid != null) {
            this.log.warn((Object)("forward_priors.xsl: Missing seriesIUID attribute (sop iuid:" + iuid + ")! SOP Instance UID ignored! -> Study Level"));
        }
        return true;
    }

    private String[] sopIUIDsOrNull(SeriesStored seriesStored) {
        int numI = seriesStored.getNumberOfInstances();
        if (numI > 1 && !this.isForwardOnInstanceLevelFromAET(seriesStored.getSourceAET())) {
            return null;
        }
        String[] iuids = new String[numI];
        DcmElement sq = seriesStored.getIAN().getItem(528661).get(528793);
        for (int i = 0; i < iuids.length; ++i) {
            iuids[i] = sq.getItem(i).getString(528725);
        }
        return iuids;
    }

    private static int toPriority(String s) {
        return s != null ? DicomPriority.toCode(s) : 0;
    }

    private long toScheduledTime(Calendar cal, String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        int index = s.indexOf(33);
        if (index == -1) {
            return cal.getTimeInMillis() + RetryIntervalls.parseInterval(s);
        }
        if (index != 0) {
            cal.setTimeInMillis(cal.getTimeInMillis() + RetryIntervalls.parseInterval(s.substring(0, index)));
        }
        return ForwardingRules.afterBusinessHours(cal, s.substring(index + 1));
    }

    private static void xslt(Calendar cal, String sourceAET, String retrieveAET, Properties params, Dataset ds, Templates tpl, ContentHandler ch) throws TransformerConfigurationException, IOException {
        TransformerHandler th = ForwardService2.prepareTransformHandler(cal, sourceAET, retrieveAET, params, tpl, ch);
        ds.writeDataset2(th, null, null, 64, null);
    }

    private static TransformerHandler prepareTransformHandler(Calendar cal, String sourceAET, String retrieveAET, Properties params, Templates tpl, ContentHandler ch) throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerHandler th = tf.newTransformerHandler(tpl);
        Transformer t = th.getTransformer();
        t.setParameter("source-aet", sourceAET);
        t.setParameter("retrieve-aet", retrieveAET);
        t.setParameter("year", new Integer(cal.get(1)));
        t.setParameter("month", new Integer(cal.get(2) + 1));
        t.setParameter("date", new Integer(cal.get(5)));
        t.setParameter("day", new Integer(cal.get(7) - 1));
        t.setParameter("hour", new Integer(cal.get(11)));
        if (params != null) {
            for (Map.Entry<Object, Object> e : params.entrySet()) {
                t.setParameter((String)e.getKey(), e.getValue());
            }
        }
        th.setResult(new SAXResult(ch));
        return th;
    }

    private void scheduleMove(String retrieveAET, String destAET, int priority, String pid, String studyIUID, String seriesIUID, String[] sopIUIDs, long scheduledTime) {
        try {
            this.server.invoke(this.moveScuServiceName, "scheduleMove", new Object[]{retrieveAET, destAET, new Integer(priority), pid, studyIUID, seriesIUID, sopIUIDs, new Long(scheduledTime)}, new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String[].class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule Move failed:", (Throwable)e);
        }
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }
}

