/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.movescu;

import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.DcmElement;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.dcm.movescu.MoveOrder;
import org.dcm4chex.archive.notif.PatientUpdated;
import org.dcm4chex.archive.notif.SeriesUpdated;
import org.jboss.system.ServiceMBeanSupport;

public class ForwardService
extends ServiceMBeanSupport {
    private static final NotificationFilterSupport seriesUpdatedFilter = new NotificationFilterSupport();
    private static final NotificationFilterSupport patientUpdatedFilter = new NotificationFilterSupport();
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            SeriesStored seriesStored = (SeriesStored)notif.getUserData();
            if (seriesStored.getRetrieveAET() == null && ForwardService.this.ignoreNotLocalRetrievable) {
                ForwardService.this.log.warn((Object)"Ignore SeriesStored notification! Reason: Series is not locally retrievable.");
                return;
            }
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            param.put("calling", new String[]{seriesStored.getSourceAET()});
            String[] destAETs = ForwardService.this.forwardingRules.getForwardDestinationsFor(param);
            for (int i = 0; i < destAETs.length; ++i) {
                String destAET = destAETs[i];
                ForwardService.this.scheduleMove(seriesStored.getRetrieveAET(), ForwardingRules.toAET(destAET), ForwardingRules.toPriority(destAET, ForwardService.this.forwardPriority), null, seriesStored.getStudyInstanceUID(), seriesStored.getSeriesInstanceUID(), ForwardService.this.sopIUIDsOrNull(seriesStored), ForwardingRules.toScheduledTime(destAET));
            }
        }
    };
    private final NotificationListener seriesUpdatedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            SeriesUpdated seriesUpdated = (SeriesUpdated)notif.getUserData();
            ForwardService.this.log.info((Object)("seriesUpdatedListener: series updated:" + seriesUpdated.getSeriesIUID() + " Description:" + seriesUpdated.getDescription()));
            ForwardService.this.sendUpdatedNotification(null, null, seriesUpdated.getSeriesIUID());
        }
    };
    private final NotificationListener patientUpdatedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            PatientUpdated patientUpdated = (PatientUpdated)notif.getUserData();
            ForwardService.this.log.info((Object)("patientUpdatedListener: updated for patient " + patientUpdated.getPatientID() + " Description:" + patientUpdated.getDescription()));
            ForwardService.this.sendUpdatedNotification(patientUpdated.getPatientID(), null, null);
        }
    };
    private static final String ALL = "ALL";
    private static final String NONE = "NONE";
    private static final String[] EMPTY = new String[0];
    private ObjectName storeScpServiceName;
    private ObjectName moveScuServiceName;
    private ObjectName editContentServiceName;
    private String[] forwardOnInstanceLevelFromAETs = EMPTY;
    private String[] forwardModifiedToAETs = EMPTY;
    private int forwardPriority = 0;
    private ForwardingRules forwardingRules = new ForwardingRules("");
    private boolean ignoreNotLocalRetrievable;

    private String[] sopIUIDsOrNull(SeriesStored seriesStored) {
        int numI = seriesStored.getNumberOfInstances();
        if (numI > 1 && !this.isForwardOnInstanceLevelFromAET(seriesStored.getSourceAET())) {
            return null;
        }
        String[] iuids = new String[numI];
        DcmElement sq = seriesStored.getIAN().getItem(528661).get(528793);
        for (int i = 0; i < iuids.length; ++i) {
            iuids[i] = sq.getItem(i).getString(528725);
        }
        return iuids;
    }

    public final String getForwardingRules() {
        return this.forwardingRules.toString();
    }

    public final void setForwardingRules(String forwardingRules) {
        this.forwardingRules = new ForwardingRules(forwardingRules);
    }

    public final String getForwardPriority() {
        return DicomPriority.toString(this.forwardPriority);
    }

    public final void setForwardPriority(String forwardPriority) {
        this.forwardPriority = DicomPriority.toCode(forwardPriority);
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public final void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    public final ObjectName getEditContentServiceName() {
        return this.editContentServiceName;
    }

    public String getForwardOnInstanceLevelFromAETs() {
        return this.forwardOnInstanceLevelFromAETs == null ? ALL : (this.forwardOnInstanceLevelFromAETs.length == 0 ? NONE : StringUtils.toString(this.forwardOnInstanceLevelFromAETs, ','));
    }

    public void setForwardOnInstanceLevelFromAETs(String s) {
        this.forwardOnInstanceLevelFromAETs = ALL.equals(s) ? null : (NONE.equals(s) ? EMPTY : StringUtils.split(s, ','));
    }

    private boolean isForwardOnInstanceLevelFromAET(String aet) {
        if (this.forwardOnInstanceLevelFromAETs == null) {
            return true;
        }
        for (int i = 0; i < this.forwardOnInstanceLevelFromAETs.length; ++i) {
            if (!aet.equals(this.forwardOnInstanceLevelFromAETs[i])) continue;
            return true;
        }
        return false;
    }

    public final void setEditContentServiceName(ObjectName editContentServiceName) {
        this.editContentServiceName = editContentServiceName;
    }

    public boolean isEnablePatientUpdated() {
        return !patientUpdatedFilter.getEnabledTypes().isEmpty();
    }

    public void setEnablePatientUpdated(boolean enablePatientUpdated) {
        if (enablePatientUpdated) {
            patientUpdatedFilter.enableType(PatientUpdated.class.getName());
        } else {
            patientUpdatedFilter.disableAllTypes();
        }
    }

    public boolean isEnableSeriesUpdated() {
        return !seriesUpdatedFilter.getEnabledTypes().isEmpty();
    }

    public void setEnableSeriesUpdated(boolean enableSeriesUpdated) {
        if (enableSeriesUpdated) {
            seriesUpdatedFilter.enableType(SeriesUpdated.class.getName());
        } else {
            seriesUpdatedFilter.disableAllTypes();
        }
    }

    public String getForwardModifiedToAETs() {
        return this.forwardModifiedToAETs.length == 0 ? NONE : StringUtils.toString(this.forwardModifiedToAETs, ',');
    }

    public void setForwardModifiedToAETs(String s) {
        this.forwardModifiedToAETs = NONE.equals(s) ? EMPTY : StringUtils.split(s, ',');
    }

    public boolean isIgnoreNotLocalRetrievable() {
        return this.ignoreNotLocalRetrievable;
    }

    public void setIgnoreNotLocalRetrievable(boolean ignoreNotLocalRetrievable) {
        this.ignoreNotLocalRetrievable = ignoreNotLocalRetrievable;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.editContentServiceName, this.seriesUpdatedListener, (NotificationFilter)seriesUpdatedFilter, null);
        this.server.addNotificationListener(this.editContentServiceName, this.patientUpdatedListener, (NotificationFilter)patientUpdatedFilter, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.editContentServiceName, this.seriesUpdatedListener, (NotificationFilter)seriesUpdatedFilter, null);
        this.server.removeNotificationListener(this.editContentServiceName, this.patientUpdatedListener, (NotificationFilter)patientUpdatedFilter, null);
    }

    protected void scheduleMove(String retrieveAET, String destAET, int priority, String pid, String studyIUID, String seriesIUID, String[] sopIUIDs, long scheduledTime) {
        MoveOrder moveOrder = new MoveOrder(retrieveAET, destAET, priority, pid, studyIUID, seriesIUID, sopIUIDs);
        moveOrder.processOrderProperties(new Object[0]);
        this.scheduleMove(moveOrder, scheduledTime);
    }

    protected void scheduleMove(MoveOrder order, long scheduledTime) {
        try {
            this.server.invoke(this.moveScuServiceName, "scheduleMoveOrder", new Object[]{order, new Long(scheduledTime)}, new String[]{MoveOrder.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule Move failed:", (Throwable)e);
        }
    }

    private void sendUpdatedNotification(String patientID, String studyIUID, String seriesIUID) {
        for (int i = 0; i < this.forwardModifiedToAETs.length; ++i) {
            this.scheduleMove(null, this.forwardModifiedToAETs[i], this.forwardPriority, patientID, studyIUID, seriesIUID, null, 0L);
        }
    }
}

