/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.movescu;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.movescu.MoveOrder;
import org.dcm4chex.archive.ejb.jdbc.QueryForwardCmd;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.jboss.system.ServiceMBeanSupport;

public class ForwardByQueryService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String NONE = "NONE";
    private static final String LF = System.getProperty("line.separator", "\n");
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long pollInterval = 0L;
    private long delay = 0L;
    private int limit = 2000;
    private long lastSeriesPk = 0L;
    private int fetchSize;
    private String calledAET;
    private int forwardPriority = 0;
    private Integer schedulerID;
    private String timerIDForwardPolling;
    private boolean isRunning;
    private ObjectName moveScuServiceName;
    private String sql;
    private QueryForwardCmd sqlCmd;
    private boolean sqlIsValid = false;
    String lastCheckResult = null;

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    public final String getPollInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.pollInterval);
    }

    public void setPollInterval(String interval) throws Exception {
        long l = RetryIntervalls.parseIntervalOrNever(interval);
        if (l != this.pollInterval) {
            this.pollInterval = l;
            if (this.getState() == 3) {
                this.scheduler.stopScheduler(this.timerIDForwardPolling, this.schedulerID, this);
                this.schedulerID = this.scheduler.startScheduler(this.timerIDForwardPolling, this.pollInterval, this);
            }
        }
    }

    public String getQuery() {
        return this.sql + LF;
    }

    public void setQuery(String newSql) throws SQLException {
        if (!(newSql = newSql.trim().replaceAll("\\s\\s+", " ")).equals(this.sql)) {
            this.sql = newSql;
            if (this.getState() == 3) {
                try {
                    this.checkSQL(newSql);
                    this.updateCmd();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Query String nor valid!", t);
                }
            }
        }
    }

    public String getLastQueryCheckResult() {
        return this.lastCheckResult == null ? "NOT CHECKED" : this.lastCheckResult;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getLastSeriesPk() {
        return this.lastSeriesPk;
    }

    private void checkSQL(String sql) throws SQLException {
        this.sqlIsValid = false;
        String sqlUC = sql.toUpperCase();
        if (sqlUC.indexOf("DELETE ") != -1) {
            this.lastCheckResult = "DELETE is not allowed in this SQL statement!";
            throw new IllegalArgumentException(this.lastCheckResult);
        }
        if (sqlUC.indexOf("UPDATE ") != -1) {
            this.lastCheckResult = "UPDATE is not allowed in this SQL statement!";
            throw new IllegalArgumentException(this.lastCheckResult);
        }
        try {
            QueryForwardCmd cmd = QueryForwardCmd.getInstance((String)sql, (int)(this.limit > 0 ? 1 : 0), (int)1);
            cmd.setUpdateDatabaseMaxRetries(1);
            Map chk = cmd.getSeriesIUIDs(sql.indexOf(63) != -1 ? Long.valueOf(System.currentTimeMillis()) : null, 0L);
            this.log.debug((Object)("CheckSQL: QueryForwardCmd.getSeriesIUIDs done with result:" + chk));
            if (chk != null && !chk.isEmpty()) {
                if (((String)chk.keySet().iterator().next()).indexOf(46) != -1) {
                    this.lastCheckResult = "Wrong result! RetrieveAET contains '.'! Query must return series.series_iuid, series.retrieve_aets as first columns!";
                    throw new IllegalArgumentException(this.lastCheckResult);
                }
                List l = (List)chk.values().iterator().next();
                if (!l.isEmpty() && ((String)l.iterator().next()).indexOf(46) == -1) {
                    this.lastCheckResult = "Wrong result! Series Instance UID does NOT contain a '.'! Query must return series.series_iuid, series.retrieve_aets as first columns!";
                    throw new IllegalArgumentException(this.lastCheckResult);
                }
            }
        }
        catch (SQLException x) {
            this.lastCheckResult = x.getCause() == null ? x.toString() : x.getCause().toString();
            throw x;
        }
        this.lastCheckResult = "OK";
        this.sqlIsValid = true;
    }

    private void updateCmd() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("update QueryForwardCmd when state = 3. state:" + this.getState() + " limit:" + this.limit + "\nSQL:" + this.sql));
        }
        if (this.getState() == 3) {
            if (this.sqlCmd != null) {
                this.sqlCmd.close();
            }
            this.sqlCmd = QueryForwardCmd.getInstance((String)this.sql, (int)this.limit, (int)this.fetchSize);
        }
    }

    public String getDelay() {
        return this.delay < 0L ? NONE : RetryIntervalls.formatInterval(this.delay);
    }

    public void setDelay(String delay) {
        this.delay = NONE.equals(delay) ? -1L : RetryIntervalls.parseInterval(delay);
    }

    public final String getForwardPriority() {
        return DicomPriority.toString(this.forwardPriority);
    }

    public final void setForwardPriority(String forwardPriority) {
        this.forwardPriority = DicomPriority.toCode(forwardPriority);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) throws SQLException {
        if (this.limit != limit) {
            this.limit = limit;
            this.updateCmd();
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getTimerIDForwardByQuery() {
        return this.timerIDForwardPolling;
    }

    public void setTimerIDForwardByQuery(String timerID) {
        this.timerIDForwardPolling = timerID;
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public final void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.lastCheckResult == null) {
            try {
                this.checkSQL(this.sql);
                if (this.sqlCmd != null) {
                    this.sqlCmd.close();
                }
                this.sqlCmd = QueryForwardCmd.getInstance((String)this.sql, (int)this.limit, (int)this.fetchSize);
            }
            catch (Throwable t) {
                this.log.error((Object)"Check of SQL statement failed!", t);
            }
        }
        if (this.sqlIsValid) {
            this.checkForward();
        } else {
            this.log.warn((Object)"SQL is not marked to be valid! checkForward is disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkForward() {
        if (this.sqlCmd == null) {
            this.log.warn((Object)"No Query defined!");
            return 0;
        }
        ForwardByQueryService forwardByQueryService = this;
        synchronized (forwardByQueryService) {
            if (this.isRunning) {
                this.log.info((Object)"ForwardByQuery is already running!");
                return -1;
            }
            this.isRunning = true;
        }
        int nrOfSeries = 0;
        try {
            long scheduledTime = 0L;
            Map orders = this.sqlCmd.getSeriesIUIDs(this.delay < 0L ? null : new Long(System.currentTimeMillis() - this.delay), this.lastSeriesPk);
            this.log.info((Object)("Found " + orders.size() + " MoveOrder! lastSeriesPk:" + this.lastSeriesPk));
            this.lastSeriesPk = orders.isEmpty() ? 0L : this.sqlCmd.getLastSeriesPk();
            for (Map.Entry entry : orders.entrySet()) {
                List series = (List)entry.getValue();
                nrOfSeries += series.size();
                int len = series.size();
                for (int i = 0; i < len; ++i) {
                    MoveOrder order = new MoveOrder((String)entry.getKey(), this.calledAET, this.forwardPriority, null, null, (String)series.get(i), null);
                    this.scheduleMove(order, scheduledTime);
                }
            }
            int n = nrOfSeries;
            Object var12_14 = null;
            this.isRunning = false;
            return n;
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"Failed to check for forward:", (Throwable)e);
                int n = 0;
                Object var12_15 = null;
                this.isRunning = false;
                return n;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.isRunning = false;
                throw throwable;
            }
        }
    }

    public String showSQL() {
        return this.sqlCmd == null ? "QueryForwardCmd not set!" : this.sqlCmd.formatSql();
    }

    protected void scheduleMove(MoveOrder order, long scheduledTime) {
        try {
            this.server.invoke(this.moveScuServiceName, "scheduleMoveOrder", new Object[]{order, new Long(scheduledTime)}, new String[]{MoveOrder.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule Move failed:", (Throwable)e);
        }
    }

    protected void startService() throws Exception {
        this.schedulerID = this.scheduler.startScheduler(this.timerIDForwardPolling, this.pollInterval, this);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDForwardPolling, this.schedulerID, this);
        super.stopService();
    }
}

