/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.modify;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.modify.AttributesModificationOrder;
import org.dcm4chex.archive.dcm.modify.AttributesModificationScpService;
import org.dcm4chex.archive.mbean.JMSDelegate;

public class AttributesModificationScuService
extends AbstractScuService
implements MessageListener,
NotificationListener {
    private static final int PCID = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private String queueName;
    private ObjectName attributesModificationScpServiceName;
    private int concurrency = 1;
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private ForwardingRules forwardingRules = new ForwardingRules("");
    private int priority;
    private int noRetryErrorCode;

    public final String getPriority() {
        return DicomPriority.toString(this.priority);
    }

    public final void setPriority(String priority) {
        this.priority = DicomPriority.toCode(priority);
    }

    public final String getForwardingRules() {
        return this.forwardingRules.toString();
    }

    public final void setForwardingRules(String forwardingRules) {
        this.forwardingRules = new ForwardingRules(forwardingRules);
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    public final int getNoRetryErrorCode() {
        return this.noRetryErrorCode;
    }

    public final void setNoRetryErrorCodeAsString(String noRetryErrorCode) {
        this.noRetryErrorCode = noRetryErrorCode.endsWith("H") ? Integer.parseInt(noRetryErrorCode.substring(0, noRetryErrorCode.length() - 1), 16) : Integer.parseInt(noRetryErrorCode);
    }

    public final String getNoRetryErrorCodeAsString() {
        return String.format("%04XH", this.noRetryErrorCode);
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final ObjectName getAttributesModificationScpServiceName() {
        return this.attributesModificationScpServiceName;
    }

    public final void setAttributesModificationScpServiceName(ObjectName serviceName) {
        this.attributesModificationScpServiceName = serviceName;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.attributesModificationScpServiceName, this, AttributesModificationScpService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.attributesModificationScpServiceName, this, AttributesModificationScpService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset modifiedAttrs = (Dataset)notif.getUserData();
        modifiedAttrs.setPrivateCreatorID("dcm4che/archive");
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("calling", new String[]{modifiedAttrs.getString(4390932)});
        modifiedAttrs.setPrivateCreatorID(null);
        String[] destAETs = this.forwardingRules.getForwardDestinationsFor(param);
        for (int i = 0; i < destAETs.length; ++i) {
            AttributesModificationOrder order = new AttributesModificationOrder(modifiedAttrs, ForwardingRules.toAET(destAETs[i]));
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, order, 4, 0L);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                AttributesModificationOrder order = (AttributesModificationOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.sendAttributesModification(order.getDataset(), order.getDestination());
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAttributesModification(Dataset dataset, String aet) throws Exception {
        ActiveAssociation aa = this.openAssociation(aet, "1.2.40.0.13.1.3.1.2.3.1.1");
        Association a = aa.getAssociation();
        try {
            DcmObjectFactory dof = DcmObjectFactory.getInstance();
            Command cmdRq = dof.newCommand();
            cmdRq.initCStoreRQ(a.nextMsgID(), "1.2.40.0.13.1.3.1.2.3.1.1", UIDGenerator.getInstance().createUID(), this.priority);
            Dimse dimseRq = AssociationFactory.getInstance().newDimse(1, cmdRq, dataset);
            Dimse dimseRsp = aa.invoke(dimseRq).get();
            Command cmdRsp = dimseRsp.getCommand();
            int status = cmdRsp.getStatus();
            if (status != 0) {
                this.log.warn((Object)("Received Error Status " + Integer.toHexString(status) + "H, Error Comment: " + cmdRsp.getString(2306)));
                if (status != this.noRetryErrorCode) {
                    throw new DcmServiceException(status, cmdRsp.getString(2306));
                }
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release " + aa.getAssociation()));
        }
    }
}

