/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.modify;

import java.io.IOException;
import java.util.Date;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.modify.AttributesModificationScpService;
import org.dcm4chex.archive.ejb.interfaces.AttributesModification;
import org.dcm4chex.archive.ejb.interfaces.AttributesModificationHome;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class AttributesModificationScp
extends DcmServiceBase {
    private final AttributesModificationScpService service;

    public AttributesModificationScp(AttributesModificationScpService service) {
        this.service = service;
    }

    protected void doCStore(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        try {
            Dataset ds = rq.getDataset();
            String callingAET = assoc.getAssociation().getCallingAET();
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putAE(4390932, callingAET);
            ds.setPrivateCreatorID(null);
            String modifyingSystem = ds.getString(67110243, callingAET);
            String reason = ds.getString(67110245, "COERCE");
            if ("PATIENT".equals(ds.getString(524370))) {
                if (this.getAttributesModification().moveStudyToPatient(ds, this.service.patientMatching(), this.service.isCreatePatientOnMoveStudy())) {
                    this.service.sendAttributesModificationNotification(ds);
                }
            } else if (this.getAttributesModification().modifyAttributes(ds, new Date(), modifyingSystem, reason, this.service.isUpdateOriginalAttributesSeq(), this.service.getEntityNotFoundErrorCode())) {
                this.service.sendAttributesModificationNotification(ds);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private AttributesModification getAttributesModification() throws Exception {
        return ((AttributesModificationHome)EJBHomeFactory.getFactory().lookup(AttributesModificationHome.class, "ejb/AttributesModification")).create();
    }
}

