/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.mcmscu;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.FutureRSP;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.MediaComposer;
import org.dcm4chex.archive.ejb.interfaces.MediaComposerHome;
import org.dcm4chex.archive.ejb.interfaces.MediaDTO;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;

public class MCMScuService
extends AbstractScuService
implements MessageListener {
    private static final Logger log = Logger.getLogger(MCMScuService.class);
    private static final long MIN_MAX_MEDIA_USAGE = 20000000L;
    private static final int INITIATE_MEDIA_CREATION = 1;
    private static final int CANCEL_MEDIA_CREATION = 2;
    private static final String[] prioStrings = new String[]{"MED", "HIGH", "LOW"};
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private String queueName;
    private long maxMediaUsage = 680000000L;
    private long minStudyAge;
    private long maxStudyAge;
    private long scheduleMediaInterval;
    private boolean isRunningScheduleMedia;
    private long updateMediaStatusInterval;
    private boolean isRunningUpdateMediaStatus;
    private long burnMediaInterval;
    private boolean isRunningBurnMedia;
    private Integer scheduleMediaListenerID;
    private Integer updateMediaStatusListenerID;
    private Integer burnMediaListenerID;
    private boolean automaticMediaCreation = false;
    private String notifyBurnMediaEmailTo = "";
    private String notifyBurnMediaEmailFrom = "";
    private int nrOfCopies = 1;
    private static ObjectName sendMailServiceName = null;
    private String fileSetIdPrefix;
    private String retrieveAET;
    private String destAET;
    private String mcmScpAET;
    private boolean useInstanceInfo = false;
    private String includeNonDICOMObj = "NO";
    private int priority = 0;
    private int concurrency = 1;
    private String timerIDCheckForStudiesToSchedule;
    private String timerIDCheckForMediaToBurn;
    private String timerIDCheckMediaStatus;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private MediaComposer mediaComposer;
    private final NotificationListener scheduleMediaListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            new Thread(new Runnable(){

                public void run() {
                    MCMScuService.this.scheduleMedia();
                }
            }).start();
        }
    };
    private final NotificationListener updateMediaStatusListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            new Thread(new Runnable(){

                public void run() {
                    MCMScuService.this.updateMediaStatus();
                }
            }).start();
        }
    };
    private final NotificationListener burnMediaListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            new Thread(new Runnable(){

                public void run() {
                    MCMScuService.this.burnMedia();
                }
            }).start();
        }
    };

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public String getFileSetIdPrefix() {
        return this.fileSetIdPrefix;
    }

    public void setFileSetIdPrefix(String fileSetIdPrefix) {
        this.fileSetIdPrefix = fileSetIdPrefix.toUpperCase();
    }

    public int getNrOfCopies() {
        return this.nrOfCopies;
    }

    public void setNrOfCopies(int nrOfCopies) {
        if (nrOfCopies < 1 || nrOfCopies > 99) {
            throw new IllegalArgumentException("Wrong number of copies! Please enter a number between 1 and 99 (incl.)");
        }
        this.nrOfCopies = nrOfCopies;
    }

    public String getMaxMediaUsage() {
        return FileUtils.formatSize(this.maxMediaUsage);
    }

    public void setMaxMediaUsage(String str) {
        this.maxMediaUsage = FileUtils.parseSize(str, 20000000L);
    }

    public String getMinStudyAge() {
        return RetryIntervalls.formatInterval(this.minStudyAge);
    }

    public void setMinStudyAge(String age) {
        this.minStudyAge = RetryIntervalls.parseInterval(age);
    }

    public String getMaxStudyAge() {
        return RetryIntervalls.formatInterval(this.maxStudyAge);
    }

    public void setMaxStudyAge(String age) {
        this.maxStudyAge = RetryIntervalls.parseInterval(age);
    }

    public final String getBurnMediaInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.burnMediaInterval);
    }

    public void setBurnMediaInterval(String interval) throws Exception {
        this.burnMediaInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDCheckForMediaToBurn, this.burnMediaListenerID, this.burnMediaListener);
            this.burnMediaListenerID = this.scheduler.startScheduler(this.timerIDCheckForMediaToBurn, this.burnMediaInterval, this.burnMediaListener);
        }
    }

    public boolean isAutomaticMediaCreation() {
        return this.automaticMediaCreation;
    }

    public void setAutomaticMediaCreation(boolean automaticMediaCreation) {
        this.automaticMediaCreation = automaticMediaCreation;
    }

    public String getNotifyBurnMediaEmailTo() {
        return this.notifyBurnMediaEmailTo;
    }

    public void setNotifyBurnMediaEmailTo(String emails) {
        this.notifyBurnMediaEmailTo = emails.trim();
    }

    public String getNotifyBurnMediaEmailFrom() {
        return this.notifyBurnMediaEmailFrom == null ? "" : this.notifyBurnMediaEmailFrom;
    }

    public void setNotifyBurnMediaEmailFrom(String notifyBurnMediaEmailFrom) {
        if (notifyBurnMediaEmailFrom != null && notifyBurnMediaEmailFrom.trim().length() < 1) {
            notifyBurnMediaEmailFrom = null;
        }
        this.notifyBurnMediaEmailFrom = notifyBurnMediaEmailFrom;
    }

    public final ObjectName getSendmailServiceName() {
        return sendMailServiceName;
    }

    public final void setSendmailServiceName(ObjectName svName) {
        sendMailServiceName = svName;
    }

    public final String getScheduleMediaInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.scheduleMediaInterval);
    }

    public void setScheduleMediaInterval(String interval) throws Exception {
        this.scheduleMediaInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDCheckForStudiesToSchedule, this.scheduleMediaListenerID, this.scheduleMediaListener);
            this.scheduleMediaListenerID = this.scheduler.startScheduler(this.timerIDCheckForStudiesToSchedule, this.scheduleMediaInterval, this.scheduleMediaListener);
        }
    }

    public final String getUpdateMediaStatusInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.updateMediaStatusInterval);
    }

    public void setUpdateMediaStatusInterval(String interval) throws Exception {
        this.updateMediaStatusInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDCheckMediaStatus, this.updateMediaStatusListenerID, this.updateMediaStatusListener);
            this.updateMediaStatusListenerID = this.scheduler.startScheduler(this.timerIDCheckMediaStatus, this.updateMediaStatusInterval, this.updateMediaStatusListener);
        }
    }

    public boolean isRunningScheduleMedia() {
        return this.isRunningScheduleMedia;
    }

    public boolean isRunningUpdateMediaStatus() {
        return this.isRunningUpdateMediaStatus;
    }

    public boolean isRunningBurnMedia() {
        return this.isRunningBurnMedia;
    }

    public String getRetrieveAET() {
        return this.retrieveAET;
    }

    public void setRetrieveAET(String aet) {
        this.retrieveAET = aet;
    }

    public String getMoveDestinationAET() {
        return this.destAET;
    }

    public void setMoveDestinationAET(String aet) {
        this.destAET = aet;
    }

    public String getMcmScpAET() {
        return this.mcmScpAET;
    }

    public void setMcmScpAET(String aet) {
        this.mcmScpAET = aet;
    }

    public String getPriority() {
        return DicomPriority.toString(this.priority);
    }

    public void setPriority(String priority) {
        this.priority = DicomPriority.toCode(priority);
    }

    public String getIncludeNonDICOMObj() {
        return this.includeNonDICOMObj;
    }

    public void setIncludeNonDICOMObj(String includeNonDICOMObj) {
        this.includeNonDICOMObj = includeNonDICOMObj;
    }

    public boolean isUseInstanceInfo() {
        return this.useInstanceInfo;
    }

    public void setUseInstanceInfo(boolean useInstanceInfo) {
        this.useInstanceInfo = useInstanceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int scheduleMedia() {
        MCMScuService mCMScuService = this;
        synchronized (mCMScuService) {
            if (this.isRunningScheduleMedia) {
                log.info((Object)"RunningScheduleMedia is already running!");
                return -1;
            }
            this.isRunningScheduleMedia = true;
        }
        try {
            int n;
            Collection studies;
            MediaComposer mc;
            long l1;
            block9: {
                log.info((Object)"Check for studies for scheduling on media");
                l1 = System.currentTimeMillis();
                mc = null;
                mc = this.lookupMediaComposer();
                studies = mc.getStudiesReceivedBefore(this.getSearchDate());
                if (!studies.isEmpty()) break block9;
                log.info((Object)"No Studies found for scheduling on media!");
                int n2 = 0;
                Object var9_9 = null;
                this.isRunningScheduleMedia = false;
                return n2;
            }
            try {
                List mediaPool = null;
                String prefix = this.getFileSetIdPrefix();
                log.info((Object)(studies.size() + " are selected for scheduling on media!"));
                Iterator iter = studies.iterator();
                while (iter.hasNext()) {
                    mediaPool = mc.assignStudyToMedia((StudyLocal)iter.next(), mediaPool, this.maxMediaUsage, prefix);
                }
                log.info((Object)("Schedule of " + studies.size() + " studies completed. Number of collecting media:" + mediaPool.size() + ". time:" + (System.currentTimeMillis() - l1) + " ms!"));
                n = studies.size();
            }
            catch (Exception x) {
                log.error((Object)"Can not create MediaComposer!", (Throwable)x);
                int n3 = -1;
                Object var9_11 = null;
                this.isRunningScheduleMedia = false;
                return n3;
            }
            Object var9_10 = null;
            this.isRunningScheduleMedia = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.isRunningScheduleMedia = false;
            throw throwable;
        }
    }

    private long getSearchDate() {
        return System.currentTimeMillis() - this.minStudyAge;
    }

    protected void startService() throws Exception {
        this.scheduleMediaListenerID = this.scheduler.startScheduler(this.timerIDCheckForStudiesToSchedule, this.scheduleMediaInterval, this.scheduleMediaListener);
        this.updateMediaStatusListenerID = this.scheduler.startScheduler(this.timerIDCheckMediaStatus, this.updateMediaStatusInterval, this.updateMediaStatusListener);
        this.burnMediaListenerID = this.scheduler.startScheduler(this.timerIDCheckForMediaToBurn, this.burnMediaInterval, this.burnMediaListener);
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckForStudiesToSchedule, this.scheduleMediaListenerID, this.scheduleMediaListener);
        this.scheduler.stopScheduler(this.timerIDCheckMediaStatus, this.updateMediaStatusListenerID, this.updateMediaStatusListener);
        this.scheduler.stopScheduler(this.timerIDCheckForMediaToBurn, this.burnMediaListenerID, this.burnMediaListener);
        this.jmsDelegate.stopListening(this.queueName);
        super.stopService();
    }

    public void scheduleMediaCreation(MediaDTO mediaDTO) throws Exception {
        this.jmsDelegate.queue(this.queueName, mediaDTO, 4, 0L);
    }

    public void onMessage(Message message) {
        ObjectMessage om = (ObjectMessage)message;
        MediaDTO mediaDTO = null;
        try {
            mediaDTO = (MediaDTO)om.getObject();
            log.info((Object)("Start processing " + mediaDTO));
            this.process(mediaDTO);
        }
        catch (JMSException e) {
            this.handleError(mediaDTO, "jms error during processing message: " + message, e);
        }
        catch (Throwable e) {
            this.handleError(mediaDTO, "unexpected error during processing message: " + message, e);
        }
    }

    private void process(MediaDTO mediaDTO) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        this.lookupMediaComposer().setMediaCreationRequestIuid(mediaDTO.getPk(), null);
        this.lookupMediaComposer().setMediaStatus(mediaDTO.getPk(), 2, "");
        if (this.processMove(mediaDTO)) {
            log.info((Object)("Move instances of " + mediaDTO.getFilesetId() + " done!"));
            this.lookupMediaComposer().setMediaStatus(mediaDTO.getPk(), 3, "");
            if (this.processMediaCreation(mediaDTO)) {
                log.info((Object)("Sending media creation request of " + mediaDTO.getFilesetId() + " done!"));
                return;
            }
        }
        log.error((Object)("processing " + mediaDTO.getFilesetId() + " failed!!!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processMove(MediaDTO mediaDTO) {
        try {
            aa = this.openAssociation(this.retrieveAET, "1.2.840.10008.5.1.4.1.2.2.2");
        }
        catch (Exception e) {
            this.handleError(mediaDTO, "processMove failed for " + mediaDTO.getFilesetId(), e);
            return false;
        }
        try {
            as = aa.getAssociation();
            oFact = DcmObjectFactory.getInstance();
            cmd = oFact.newCommand();
            studyUIDs = this.getStudyUids(mediaDTO);
            ds = oFact.newDataset();
            ds.putCS(524370, "STUDY");
            len = studyUIDs.length;
            for (i = 0; i < len; ++i) {
                cmd.initCMoveRQ(as.nextMsgID(), "1.2.840.10008.5.1.4.1.2.2.2", this.priority, this.getMoveDestinationAET());
                ds.putUI(0x20000D, studyUIDs[i]);
                moveRQ = AssociationFactory.getInstance().newDimse(1, cmd, ds);
                rsp = aa.invoke(moveRQ);
                dimse = rsp.get();
                if (this.checkResponse(dimse, mediaDTO, "for study:" + studyUIDs[i])) continue;
                var13_16 = false;
                var15_17 = null;
                ** GOTO lbl51
            }
            ** GOTO lbl57
        }
        catch (Exception e) {
            this.handleError(mediaDTO, "processMove failed for " + mediaDTO.getFilesetId() + "! Reason: unexpected error", e);
            var4_7 = false;
            var15_19 = null;
            try {
                aa.release(true);
                return var4_7;
            }
            catch (Exception e) {
                MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            return var4_7;
        }
        {
            catch (Throwable var14_25) {
                var15_20 = null;
                ** try [egrp 3[TRYBLOCK] [7 : 283->293)] { 
lbl46:
                // 1 sources

                aa.release(true);
                throw var14_25;
lbl48:
                // 1 sources

                catch (Exception e) {
                    MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                }
                throw var14_25;
            }
lbl51:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 283->293)] { 
lbl52:
            // 1 sources

            aa.release(true);
            return var13_16;
lbl54:
            // 1 sources

            catch (Exception e) {
                MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            return var13_16;
lbl57:
            // 1 sources

            var15_18 = null;
            try {}
            catch (Exception e) {}
            MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            return true;
            aa.release(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processMediaCreation(MediaDTO mediaDTO) {
        try {
            aa = this.openAssociation(this.mcmScpAET, "1.2.840.10008.5.1.1.33");
        }
        catch (Exception e) {
            this.handleError(mediaDTO, "processMove failed for " + mediaDTO.getFilesetId(), e);
            return false;
        }
        try {
            block14: {
                oFact = DcmObjectFactory.getInstance();
                cmd = oFact.newCommand();
                cmd.initNCreateRQ(1, "1.2.840.10008.5.1.1.33", null);
                ds = this.getMediaCreationReqDS(mediaDTO);
                mcRQ = AssociationFactory.getInstance().newDimse(1, cmd, ds);
                rsp = aa.invoke(mcRQ);
                dimse = rsp.get();
                if (this.checkResponse(dimse, mediaDTO, "")) break block14;
                var9_12 = false;
                var15_14 = null;
                ** GOTO lbl53
            }
            iuid = dimse.getCommand().getAffectedSOPInstanceUID();
            cmdRsp = dimse.getCommand();
            dataRsp = dimse.getDataset();
            futureRsp = aa.invoke(AssociationFactory.getInstance().newDimse(1, oFact.newCommand().initNActionRQ(3, "1.2.840.10008.5.1.1.33", iuid, 1), this.getMediaCreationActionDS()));
            dimse = futureRsp.get();
            this.lookupMediaComposer().setMediaCreationRequestIuid(mediaDTO.getPk(), iuid);
            if (this.checkResponse(dimse, mediaDTO, "")) ** GOTO lbl66
            var13_27 = false;
            ** GOTO lbl59
        }
        catch (Exception e) {
            this.handleError(mediaDTO, "processMediaCreation failed for " + mediaDTO.getFilesetId() + "! Reason: unexpected error", e);
            var4_7 = false;
            var15_17 = null;
            try {
                aa.release(true);
                return var4_7;
            }
            catch (Exception e) {
                MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            return var4_7;
        }
        {
            catch (Throwable var14_28) {
                var15_18 = null;
                ** try [egrp 3[TRYBLOCK] [8 : 297->307)] { 
lbl48:
                // 1 sources

                aa.release(true);
                throw var14_28;
lbl50:
                // 1 sources

                catch (Exception e) {
                    MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                }
                throw var14_28;
            }
lbl53:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [8 : 297->307)] { 
lbl54:
            // 1 sources

            aa.release(true);
            return var9_12;
lbl56:
            // 1 sources

            catch (Exception e) {
                MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            return var9_12;
lbl59:
            // 1 sources

            var15_15 = null;
            try {}
            catch (Exception e) {
                MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                return var13_27;
            }
            aa.release(true);
            return var13_27;
lbl66:
            // 1 sources

            var15_16 = null;
            try {}
            catch (Exception e) {}
            MCMScuService.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            return true;
            aa.release(true);
            return true;
        }
    }

    private Dataset getMediaCreationReqDS(MediaDTO mediaDTO) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        Dataset ds = this.lookupMediaComposer().prepareMediaCreationRequest(mediaDTO.getPk());
        ds.putCS(0x22000001, this.isUseInstanceInfo() ? "YES" : "NO");
        ds.putCS(0x22000008, this.includeNonDICOMObj);
        if (log.isDebugEnabled()) {
            log.debug((Object)"getMediaCreationReqDS:\n");
            log.info((Object)ds);
        }
        return ds;
    }

    private Dataset getMediaCreationActionDS() {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.putIS(0x20000010, this.nrOfCopies);
        ds.putCS(0x22000020, prioStrings[this.priority]);
        return ds;
    }

    private void handleError(MediaDTO mediaDTO, String msg, Throwable x) {
        log.error((Object)msg, x);
        if (mediaDTO != null) {
            try {
                this.lookupMediaComposer().setMediaStatus(mediaDTO.getPk(), 999, msg);
            }
            catch (Exception e) {
                log.error((Object)("cant set error media status for " + mediaDTO.getFilesetId()));
            }
        }
    }

    private boolean checkResponse(Dimse rsp, MediaDTO mediaDTO, String msg) {
        Command cmdRsp = rsp.getCommand();
        Dataset dataRsp = null;
        try {
            dataRsp = rsp.getDataset();
        }
        catch (IOException e) {
            log.error((Object)"Cant get Dataset from response message!", (Throwable)e);
        }
        int status = cmdRsp.getStatus();
        switch (status) {
            case 278: {
                log.warn((Object)("Warning: Attribute Value Out Of Range: " + cmdRsp.getString(2306, "") + dataRsp));
            }
            case 0: {
                return true;
            }
        }
        log.error((Object)("Media creation failed!  [" + msg + "]" + "Failure Status " + Integer.toHexString(status) + ": " + cmdRsp.getString(2306, "") + dataRsp));
        this.handleError(mediaDTO, "Media creation failed! return status:" + Integer.toHexString(status) + " Reason:" + cmdRsp.getString(2306, "") + " [" + msg + "]", null);
        return false;
    }

    private String[] getStudyUids(MediaDTO mediaDTO) throws HomeFactoryException, RemoteException, FinderException, CreateException {
        Collection c = this.lookupMediaComposer().getStudyUIDSForMedia(mediaDTO.getPk());
        return c.toArray(new String[c.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public String updateMediaStatus() {
        String string;
        ActiveAssociation aa;
        MCMScuService mCMScuService = this;
        synchronized (mCMScuService) {
            if (this.isRunningUpdateMediaStatus) {
                String msg = "UpdateMediaStatus is already running!";
                log.info((Object)msg);
                return msg;
            }
            this.isRunningUpdateMediaStatus = true;
        }
        try {
            List procList;
            block24: {
                String msg;
                try {
                    procList = this.lookupMediaComposer().getWithStatus(3);
                    if (!procList.isEmpty()) break block24;
                    msg = "No Media in processing status.";
                }
                catch (Exception e) {
                    log.error((Object)"Check for pending media creation processes fails!", (Throwable)e);
                    String string2 = "Error: Check for pending media creation processes fails!";
                    Object var24_12 = null;
                    this.isRunningUpdateMediaStatus = false;
                    return string2;
                }
                Object var24_11 = null;
                this.isRunningUpdateMediaStatus = false;
                return msg;
            }
            try {
                aa = this.openAssociation(this.mcmScpAET, "1.2.840.10008.5.1.1.33");
            }
            catch (Exception e) {
                log.error((Object)"Cant get media creation status!", (Throwable)e);
                String string3 = "Error: could not open association!";
                Object var24_13 = null;
                this.isRunningUpdateMediaStatus = false;
                return string3;
            }
            Association as = aa.getAssociation();
            String iuid = null;
            MediaDTO mediaDTO2 = null;
            int[] getAttrs = new int[]{0x21000020, 553648176, 528792};
            int mediaWithAction = 0;
            int mediaDone = 0;
            int mediaFailed = 0;
            for (MediaDTO mediaDTO2 : procList) {
                String execStatus;
                iuid = mediaDTO2.getMediaCreationRequestIuid();
                int mediaStatus = mediaDTO2.getMediaStatus();
                if (iuid == null || iuid.length() <= 0) continue;
                ++mediaWithAction;
                Command cmdRq = DcmObjectFactory.getInstance().newCommand();
                cmdRq.initNGetRQ(as.nextMsgID(), "1.2.840.10008.5.1.1.33", iuid, getAttrs);
                FutureRSP futureRsp = aa.invoke(AssociationFactory.getInstance().newDimse(1, cmdRq));
                Dimse rsp = futureRsp.get();
                Command cmdRsp = rsp.getCommand();
                Dataset dataRsp = rsp.getDataset();
                int status = cmdRsp.getStatus();
                if (status != 0) {
                    log.error((Object)("Cant get media creation status! Failure Status:" + Integer.toHexString(status) + ": " + cmdRsp.getString(2306, "") + (dataRsp == null ? "" : "\n" + dataRsp)));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received Attributes:\n" + dataRsp));
                }
                if ("DONE".equals(execStatus = dataRsp.getString(0x21000020))) {
                    ++mediaDone;
                    this.mediaComposer.setMediaStatus(mediaDTO2.getPk(), 4, "successfully completed");
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Media " + mediaDTO2.getFilesetId() + " successfully created!"));
                    continue;
                }
                if ("FAILURE".equals(execStatus)) {
                    ++mediaFailed;
                    String info = dataRsp.getString(553648176);
                    if ("NO_INSTANCE".equals(info)) {
                        info = info + "(" + dataRsp.vm(528792) + " number of instances missing)";
                    }
                    log.error((Object)("Cant create media " + mediaDTO2.getFilesetId() + "! Reason:" + info));
                    this.mediaComposer.setMediaStatus(mediaDTO2.getPk(), 999, info);
                    continue;
                }
                this.mediaComposer.setMediaStatus(mediaDTO2.getPk(), mediaStatus, execStatus);
            }
            string = "Media creation status:" + mediaFailed + " media FAILED, " + mediaDone + " media done! Total: " + procList.size() + " media processing / " + mediaWithAction + " with N-ACTION";
            Object var21_35 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var24_16 = null;
            this.isRunningUpdateMediaStatus = false;
            throw throwable;
        }
        Object var24_14 = null;
        this.isRunningUpdateMediaStatus = false;
        {
            return string;
            catch (Exception x) {
                String string4;
                try {
                    log.error((Object)"Cant get media creation status! Reason: unexpected error.", (Throwable)x);
                    string4 = "Cant get media create status: Unexpected error" + x.getMessage();
                    Object var21_36 = null;
                }
                catch (Throwable throwable) {
                    Object var21_37 = null;
                    try {
                        aa.release(true);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                }
                Object var24_15 = null;
                this.isRunningUpdateMediaStatus = false;
                return string4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int burnMedia() {
        MCMScuService mCMScuService = this;
        synchronized (mCMScuService) {
            if (this.isRunningBurnMedia) {
                log.info((Object)"BurnMedia is already running!");
                return -1;
            }
            this.isRunningBurnMedia = true;
        }
        log.info((Object)"Check for scheduled Media to burn");
        try {
            List c = this.lookupMediaComposer().getWithStatus(0);
            long maxAgeDate = System.currentTimeMillis() - (this.maxStudyAge - this.minStudyAge);
            ArrayList<MediaDTO> mediaToBurn = new ArrayList<MediaDTO>();
            for (MediaDTO mediaDTO : c) {
                if (mediaDTO.getCreatedTime().getTime() >= maxAgeDate) continue;
                if (this.isAutomaticMediaCreation()) {
                    this.process(mediaDTO);
                }
                mediaToBurn.add(mediaDTO);
            }
            if (!this.isAutomaticMediaCreation()) {
                this.notifyMediaToBurn(mediaToBurn);
            }
            int n = mediaToBurn.size();
            Object var8_10 = null;
            this.isRunningBurnMedia = false;
            return n;
        }
        catch (Exception e) {
            try {
                log.error((Object)"Failed to initiate media creation:", (Throwable)e);
                int n = -1;
                Object var8_11 = null;
                this.isRunningBurnMedia = false;
                return n;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.isRunningBurnMedia = false;
                throw throwable;
            }
        }
    }

    private void notifyMediaToBurn(List mediaToBurn) throws JMSException {
        log.info((Object)("Notify " + this.notifyBurnMediaEmailTo + " that " + mediaToBurn.size() + " media are ready to burn!"));
        try {
            Object o = this.server.invoke(sendMailServiceName, "send", new Object[]{"Media Creation Service: media ready to burn!", this.notifyBurnMediaEmailFrom, this.notifyBurnMediaEmailTo, this.formatBody(mediaToBurn)}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Exception x) {
            log.error((Object)("Exception occured in notifyMediaToBurn: " + x.getMessage()), (Throwable)x);
        }
    }

    private String formatBody(List mediaToBurn) {
        StringBuffer sb = new StringBuffer("Media Creation Notification: Following media are ready to burn:\n");
        Iterator iter = mediaToBurn.iterator();
        while (iter.hasNext()) {
            sb.append(((MediaDTO)iter.next()).getFilesetId()).append(",");
        }
        return sb.toString();
    }

    public String checkMcmScpAvail() {
        ActiveAssociation aa;
        try {
            aa = this.openAssociation(this.destAET, "1.2.840.10008.5.1.4.1.1.7");
        }
        catch (Exception e) {
            log.info((Object)("Move destination (" + this.destAET + ") is not available!"), (Throwable)e);
            return "MOVE_DEST_UNAVAIL";
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            log.info((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
        try {
            aa = this.openAssociation(this.mcmScpAET, "1.2.840.10008.5.1.1.33");
        }
        catch (Exception e) {
            log.info((Object)("MCM SCP (" + this.mcmScpAET + ") is not available!"), (Throwable)e);
            return "MCM_SCP_UNAVAIL";
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            log.info((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
        return "OK";
    }

    public boolean checkMediaInstances(long mediaPk) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        return this.lookupMediaComposer().checkInstancesAvailable(new Long(mediaPk));
    }

    public void deleteMedia(Long mediaPk) throws RemoteException, RemoveException, FinderException, HomeFactoryException, CreateException {
        this.lookupMediaComposer().deleteMedia(mediaPk);
    }

    private MediaComposer lookupMediaComposer() throws HomeFactoryException, RemoteException, CreateException {
        if (this.mediaComposer == null) {
            MediaComposerHome home = (MediaComposerHome)EJBHomeFactory.getFactory().lookup(MediaComposerHome.class, "ejb/MediaComposer");
            this.mediaComposer = home.create();
        }
        return this.mediaComposer;
    }

    public String getTimerIDCheckForMediaToBurn() {
        return this.timerIDCheckForMediaToBurn;
    }

    public void setTimerIDCheckForMediaToBurn(String timerIDCheckForMediaToBurn) {
        this.timerIDCheckForMediaToBurn = timerIDCheckForMediaToBurn;
    }

    public String getTimerIDCheckForStudiesToSchedule() {
        return this.timerIDCheckForStudiesToSchedule;
    }

    public void setTimerIDCheckForStudiesToSchedule(String timerIDCheckForStudiesToSchedule) {
        this.timerIDCheckForStudiesToSchedule = timerIDCheckForStudiesToSchedule;
    }

    public String getTimerIDCheckMediaStatus() {
        return this.timerIDCheckMediaStatus;
    }

    public void setTimerIDCheckMediaStatus(String timerIDCheckMediaStatus) {
        this.timerIDCheckMediaStatus = timerIDCheckMediaStatus;
    }
}

