/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ianscu;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.UIDs;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PresContext;
import org.dcm4che.util.UIDGenerator;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.IANAndPatientID;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.ianscu.IANOrder;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.notif.StudyDeleted;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IANScuService
extends AbstractScuService
implements MessageListener {
    public static final String EVENT_TYPE = "org.dcm4chex.archive.dcm.ianscu";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = -6323628592613659041L;

        public boolean isNotificationEnabled(Notification notif) {
            return IANScuService.EVENT_TYPE.equals(notif.getType());
        }
    };
    private static final String NONE = "NONE";
    private static final String[] EMPTY = new String[0];
    private static final String[] IAN_ONLY = new String[]{"1.2.840.10008.5.1.4.33"};
    private static final String[] IAN_AND_SCN = new String[]{"1.2.840.10008.5.1.4.33", "1.2.840.10008.1.9"};
    private static final int[] PAT_SUMMARY_AND_STUDY_IDS = new int[]{0x100010, 0x100020, 0x200010};
    private static final int[] EXCLUDE_ATTRS = new int[]{524374, 4251664, 4251665};
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            IANScuService.this.onSeriesStored((SeriesStored)notif.getUserData());
        }
    };
    private final NotificationListener mppsReceivedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Dataset mpps = (Dataset)notif.getUserData();
            if (!IANScuService.this.isIgnoreMPPS(mpps)) {
                String mppsiuid = mpps.getString(524312);
                IANScuService.this.notifyIfRefInstancesAvailable(mppsiuid, null);
            }
        }
    };
    private static final NotificationFilterSupport mppsFilter = new NotificationFilterSupport();
    private final NotificationListener studyDeletedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            IANScuService.this.onStudyDeleted((StudyDeleted)notif.getUserData());
        }
    };
    private ObjectName storeScpServiceName;
    private ObjectName mppsScpServiceName;
    private ObjectName deleteStudyServiceName;
    private ObjectName contentEditServiceName;
    private String queueName;
    private boolean preferInstanceAvailableNotification = true;
    private String[] offeredSOPClasses = IAN_AND_SCN;
    private int scnPriority = 0;
    private String[] notifiedAETs = EMPTY;
    private boolean notifyOtherServices;
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private boolean sendOneIANforEachMPPS;
    private int concurrency = 1;
    private boolean onMppsLinkedEnabled;
    private String xslPath;
    private String retrieveURI;
    private String retrieveLocationUID;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private TemplatesDelegate templates = new TemplatesDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final String getNotifiedAETs() {
        return this.notifiedAETs.length > 0 ? StringUtils.toString(this.notifiedAETs, '\\') : NONE;
    }

    public final void setNotifiedAETs(String notifiedAETs) {
        this.notifiedAETs = NONE.equalsIgnoreCase(notifiedAETs) ? EMPTY : StringUtils.split(notifiedAETs, '\\');
    }

    public boolean isEnabled() {
        return this.notifiedAETs.length != 0 || this.xslPath != null;
    }

    public final void setNotifyOtherServices(boolean notifyOtherServices) {
        this.notifyOtherServices = notifyOtherServices;
    }

    public final boolean isNotifyOtherServices() {
        return this.notifyOtherServices;
    }

    public final boolean isSendOneIANforEachMPPS() {
        return this.sendOneIANforEachMPPS;
    }

    public final void setSendOneIANforEachMPPS(boolean sendOneIANforEachMPPS) {
        this.sendOneIANforEachMPPS = sendOneIANforEachMPPS;
    }

    public boolean isOnMppsLinkedEnabled() {
        return this.onMppsLinkedEnabled;
    }

    public void setOnMppsLinkedEnabled(boolean enable) {
        if (enable) {
            mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#linked");
        } else {
            mppsFilter.disableType("org.dcm4chex.archive.dcm.mppsscp#linked");
        }
        this.onMppsLinkedEnabled = enable;
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String s) {
        this.retryIntervalls = new RetryIntervalls(s);
    }

    public final boolean isOfferStudyContentNotification() {
        return this.offeredSOPClasses == IAN_AND_SCN;
    }

    public final void setOfferStudyContentNotification(boolean offerSCN) {
        this.offeredSOPClasses = offerSCN ? IAN_AND_SCN : IAN_ONLY;
    }

    public final boolean isPreferInstanceAvailableNotification() {
        return this.preferInstanceAvailableNotification;
    }

    public final void setPreferInstanceAvailableNotification(boolean preferIAN) {
        this.preferInstanceAvailableNotification = preferIAN;
    }

    public final String getScnPriority() {
        return DicomPriority.toString(this.scnPriority);
    }

    public final void setScnPriority(String scnPriority) {
        this.scnPriority = DicomPriority.toCode(scnPriority);
    }

    public final String getStylesheet() {
        return this.xslPath == null ? NONE : this.xslPath;
    }

    public void setStylesheet(String path) {
        this.xslPath = NONE.equals(path) ? null : path;
    }

    public String getRetrieveURI() {
        return this.retrieveURI == null ? NONE : this.retrieveURI;
    }

    public void setRetrieveURI(String uri) {
        this.retrieveURI = NONE.equals(uri) ? null : uri;
    }

    public String getRetrieveLocationUID() {
        return this.retrieveLocationUID == null ? NONE : this.retrieveLocationUID;
    }

    public void setRetrieveLocationUID(String uid) {
        if (NONE.equals(uid)) {
            this.retrieveLocationUID = null;
        } else {
            if (!UIDs.isValid(uid)) {
                throw new IllegalArgumentException("Retrieve Location UID must be a valid UID!");
            }
            this.retrieveLocationUID = uid;
        }
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName name) {
        this.mppsScpServiceName = name;
    }

    public ObjectName getDeleteStudyServiceName() {
        return this.deleteStudyServiceName;
    }

    public void setDeleteStudyServiceName(ObjectName name) {
        this.deleteStudyServiceName = name;
    }

    public void setContentEditServiceName(ObjectName name) {
        this.contentEditServiceName = name;
    }

    public ObjectName getContentEditServiceName() {
        return this.contentEditServiceName;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.deleteStudyServiceName, this.studyDeletedListener, StudyDeleted.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.contentEditServiceName, this.studyDeletedListener, StudyDeleted.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.mppsScpServiceName, this.mppsReceivedListener, (NotificationFilter)mppsFilter, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.deleteStudyServiceName, this.studyDeletedListener, StudyDeleted.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.contentEditServiceName, this.studyDeletedListener, StudyDeleted.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.mppsScpServiceName, this.mppsReceivedListener, (NotificationFilter)mppsFilter, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    private void onSeriesStored(SeriesStored stored) {
        Dataset pps;
        if (!this.notifyOtherServices && !this.isEnabled()) {
            return;
        }
        Dataset ian = stored.getIAN();
        if (!this.sendOneIANforEachMPPS) {
            this.schedule(stored.getPatientID(), stored.getPatientName(), stored.getStudyID(), ian);
        }
        if ((pps = ian.getItem(528657)) != null && (this.notifyOtherServices || this.sendOneIANforEachMPPS && this.isEnabled())) {
            this.notifyIfRefInstancesAvailable(pps.getString(528725), stored.getSeriesInstanceUID());
        }
    }

    private MPPSManagerHome getMPPSManagerHome() throws HomeFactoryException {
        return (MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager");
    }

    private void notifyIfRefInstancesAvailable(String mppsIuid, String seriesStoredIuid) {
        try {
            MPPSManager mppsManager = this.getMPPSManagerHome().create();
            Dataset ian = mppsManager.createIANwithPatSummaryAndStudyID(mppsIuid, seriesStoredIuid);
            if (ian != null) {
                if (this.sendOneIANforEachMPPS) {
                    this.schedule(ian.getString(0x100020), ian.getString(0x100010), ian.getString(0x200010), ian.exclude(PAT_SUMMARY_AND_STUDY_IDS));
                }
                if (this.notifyOtherServices) {
                    this.sendMPPSInstancesAvailableNotification(mppsManager.getMPPS(mppsIuid));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failure processing notifyIfRefInstancesAvailable(): ", (Throwable)e);
        }
    }

    void sendMPPSInstancesAvailableNotification(Dataset mpps) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(EVENT_TYPE, (Object)this, eventID);
        notif.setUserData(mpps);
        super.sendNotification(notif);
    }

    private boolean isIgnoreMPPS(Dataset mpps) {
        if (!(this.notifyOtherServices || this.isEnabled() && this.sendOneIANforEachMPPS)) {
            return true;
        }
        if (mpps.get(0x400340) == null) {
            return true;
        }
        String status = mpps.getString(4194898);
        if ("COMPLETED".equals(status)) {
            return false;
        }
        if (!"DISCONTINUE".equals(status)) {
            return true;
        }
        Dataset item = mpps.getItem(4194945);
        if (item != null && "110514".equals(item.getString(524544)) && "DCM".equals(item.getString(524546))) {
            this.log.info((Object)"Ignore MPPS with Discontinuation Reason Code: Wrong Worklist Entry Selected");
            return true;
        }
        return false;
    }

    private void onStudyDeleted(StudyDeleted deleted) {
        if (!this.isEnabled()) {
            return;
        }
        this.schedule(null, null, null, deleted.getInstanceAvailabilityNotification());
    }

    private void schedule(String patid, String patname, String studyid, Dataset ian) {
        Dataset refpps;
        this.updateRetrieveURIandLocationUID(ian);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"IAN Dataset:");
            this.log.debug((Object)ian);
        }
        Dataset mpps = null;
        if (this.xslPath != null && (refpps = ian.getItem(528657)) != null) {
            try {
                mpps = this.getMPPSManagerHome().create().getMPPS(refpps.getString(528725));
            }
            catch (Exception x) {
                this.log.error((Object)"Failed to get referenced MPPS of IAN!", (Throwable)x);
            }
        }
        for (String dest : this.getDestinations(mpps)) {
            IANOrder order = new IANOrder(dest, patid, patname, studyid, ian);
            order.processOrderProperties(new Object[0]);
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, order, 4, 0L);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
    }

    private void updateRetrieveURIandLocationUID(Dataset ian) {
        if (this.retrieveURI != null || this.retrieveLocationUID != null) {
            DcmElement refSerSeq = ian.get(528661);
            int n = refSerSeq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset refSer = refSerSeq.getItem(i);
                DcmElement refSopSeq = refSer.get(528793);
                int m = refSopSeq.countItems();
                for (int j = 0; j < m; ++j) {
                    Dataset refSOP = refSopSeq.getItem(j);
                    refSOP.putUT(4251664, this.retrieveURI);
                    refSOP.putUT(4251665, this.retrieveLocationUID);
                }
            }
        }
    }

    private Set<String> getDestinations(Dataset mpps) {
        final HashSet<String> destinations = new HashSet<String>();
        if (mpps != null && this.xslPath != null) {
            try {
                File xslFile = FileUtils.toExistingFile(this.xslPath);
                Templates tpl = this.templates.getTemplates(xslFile);
                this.log.debug((Object)"IAN SCU transform mpps:");
                this.log.debug((Object)mpps);
                TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler(tpl);
                th.setResult(new SAXResult(new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attrs) {
                        if (qName.equals("destination")) {
                            destinations.add(attrs.getValue("aet"));
                        }
                    }
                }));
                mpps.writeDataset2(th, null, null, 64, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Applying IAN destination rules to MPPS fails:", (Throwable)e);
            }
        }
        for (int i = 0; i < this.notifiedAETs.length; ++i) {
            destinations.add(this.notifiedAETs[i]);
        }
        return destinations;
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                IANOrder order = (IANOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(IANOrder order) throws Exception {
        ActiveAssociation aa = this.openAssociation(order.getDestination(), this.offeredSOPClasses, new ExtNegotiation[0]);
        try {
            this.invokeDimse(aa, order);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
    }

    private void invokeDimse(ActiveAssociation aa, IANOrder order) throws DcmServiceException, IOException, InterruptedException {
        Dimse dimseRq;
        Association a = aa.getAssociation();
        List ianPC = a.listAcceptedPresContext("1.2.840.10008.5.1.4.33");
        boolean ianAccepted = !ianPC.isEmpty();
        List scnPC = a.listAcceptedPresContext("1.2.840.10008.1.9");
        boolean scnAccepted = !scnPC.isEmpty();
        AssociationFactory af = AssociationFactory.getInstance();
        String iuid = UIDGenerator.getInstance().createUID();
        Command cmdRq = DcmObjectFactory.getInstance().newCommand();
        if (ianAccepted && (this.preferInstanceAvailableNotification || !scnAccepted)) {
            cmdRq.initNCreateRQ(a.nextMsgID(), "1.2.840.10008.5.1.4.33", iuid);
            dimseRq = af.newDimse(((PresContext)ianPC.get(0)).pcid(), cmdRq, order.getIAN());
        } else {
            cmdRq.initCStoreRQ(a.nextMsgID(), "1.2.840.10008.1.9", iuid, this.scnPriority);
            Dataset scn = this.toSCN(order);
            scn.putUI(524310, "1.2.840.10008.1.9");
            scn.putUI(524312, iuid);
            dimseRq = af.newDimse(((PresContext)scnPC.get(0)).pcid(), cmdRq, scn);
        }
        this.log.debug((Object)"Dataset:\n");
        this.log.debug((Object)dimseRq.getDataset());
        Dimse dimseRsp = aa.invoke(dimseRq).get();
        Command cmdRsp = dimseRsp.getCommand();
        int status = cmdRsp.getStatus();
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 278: {
                this.log.warn((Object)("Received Warning Status 116H (=Attribute Value Out of Range) from remote AE " + order.getDestination()));
                break;
            }
            default: {
                throw new DcmServiceException(status, cmdRsp.getString(2306));
            }
        }
    }

    private Dataset toSCN(IANOrder order) {
        Dataset scn = DcmObjectFactory.getInstance().newDataset();
        scn.putLO(0x100020, order.getPatientID());
        scn.putPN(0x100010, order.getPatientName());
        scn.putSH(0x200010, order.getStudyID());
        Dataset ian = order.getIAN();
        scn.putUI(0x20000D, ian.getString(0x20000D));
        DcmElement ianSeriesSeq = ian.get(528661);
        DcmElement scnSeriesSeq = scn.putSQ(528661);
        int n = ianSeriesSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset ianSeries = ianSeriesSeq.getItem(i);
            Dataset scnSeries = scnSeriesSeq.addNewItem();
            scnSeries.putUI(0x20000E, ianSeries.getString(0x20000E));
            DcmElement ianSOPSeq = ianSeries.get(528793);
            DcmElement scnSOPSeq = scnSeries.putSQ(528704);
            int m = ianSOPSeq.countItems();
            for (int j = 0; j < m; ++j) {
                scnSOPSeq.addItem(ianSOPSeq.getItem(j).exclude(EXCLUDE_ATTRS));
            }
        }
        return scn;
    }

    public void scheduleRandomIAN(String retrieveAET, String availability, int numSeries, int numInstancesPerSeries) {
        Dataset ian = DcmObjectFactory.getInstance().newDataset();
        UIDGenerator gen = UIDGenerator.getInstance();
        ian.putUI(0x20000D, gen.createUID());
        DcmElement ianSeriesSeq = ian.putSQ(528661);
        for (int i = 0; i < numSeries; ++i) {
            Dataset ianSeries = ianSeriesSeq.addNewItem();
            ianSeries.putUI(0x20000E, gen.createUID());
            DcmElement ianSOPSeq = ianSeries.putSQ(528793);
            for (int j = 0; j < numInstancesPerSeries; ++j) {
                Dataset refSOP = ianSOPSeq.addNewItem();
                refSOP.putUI(528720, "1.2.840.10008.5.1.4.1.1.7");
                refSOP.putUI(528725, gen.createUID());
                refSOP.putAE(524372, retrieveAET);
                refSOP.putCS(524374, availability);
            }
        }
        this.schedule(null, null, null, ian);
    }

    public void scheduleIANforStudy(String uid) throws Exception {
        IANAndPatientID ian = IANScuService.fileSystemMgt().createIANforStudy(uid);
        for (Dataset ds : ian.ians) {
            this.schedule(ian.patid, ian.patname, ian.studyid, ds);
        }
    }

    public void scheduleIANforSeries(String uid) throws Exception {
        IANAndPatientID ian = IANScuService.fileSystemMgt().createIANforSeries(uid);
        this.schedule(ian.patid, ian.patname, ian.studyid, ian.ians.iterator().next());
    }

    static FileSystemMgt2 fileSystemMgt() throws Exception {
        FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
        return home.create();
    }

    static {
        mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#received");
    }
}

