/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ianscu;

import java.io.Serializable;
import java.util.ArrayList;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.BaseJmsOrder;

public class IANOrder
extends BaseJmsOrder
implements Serializable {
    private static final long serialVersionUID = -9036249052896177876L;
    private final String dest;
    private final String patname;
    private final String patid;
    private final String studyid;
    private final Dataset ian;

    public IANOrder(String dest, String patid, String patname, String studyid, Dataset ian) {
        if (dest == null) {
            throw new NullPointerException();
        }
        if (ian == null) {
            throw new NullPointerException();
        }
        this.dest = dest;
        this.patid = patid;
        this.patname = patname;
        this.studyid = studyid;
        this.ian = ian;
    }

    public final String getDestination() {
        return this.dest;
    }

    public String getPatientID() {
        return this.patid;
    }

    public String getPatientName() {
        return this.patname;
    }

    public String getStudyID() {
        return this.studyid;
    }

    public final Dataset getIAN() {
        return this.ian;
    }

    public String getOrderDetails() {
        return "dest=" + this.dest + ", suid=" + this.ian.getString(0x20000D);
    }

    public void processOrderProperties(Object ... properties) {
        this.setOrderProperty("StudyInstanceUID", this.ian.getString(0x20000D));
        this.setOrderProperty("PatientID", this.patid != null ? this.patid : this.ian.getString(0x100020));
        this.setOrderProperty("IssuerOfPatientID", this.ian.getString(0x100021));
        ArrayList<String> seriesUIDList = new ArrayList<String>();
        DcmElement refSeriesSeq = this.ian.get(528661);
        if (refSeriesSeq != null) {
            for (int j = 0; j < refSeriesSeq.countItems(); ++j) {
                Dataset refSeriesDS = refSeriesSeq.getItem(j);
                seriesUIDList.add(refSeriesDS.getString(0x20000E));
            }
        }
        this.setOrderMultiProperty("SeriesInstanceUID", seriesUIDList.toArray(new String[0]));
    }
}

