/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ianscp;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmService;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.ejb.interfaces.AvailabilityUpdate;
import org.dcm4chex.archive.ejb.interfaces.AvailabilityUpdateHome;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class IANScpService
extends AbstractScpService {
    private final DcmService ianScp = new DcmServiceBase(){

        protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
            IANScpService.this.process(rq.getDataset());
            return null;
        }
    };

    protected void process(Dataset ian) throws DcmServiceException {
        this.log.debug((Object)"Received IAN:\n");
        this.log.debug((Object)ian);
        this.validate(ian);
        try {
            int n = this.getAvailabilityUpdate().updateAvailability(ian);
            if (n > 0) {
                this.log.info((Object)("Updated Availability of " + n + " Instances of Study[uid=" + ian.getString(0x20000D) + "]."));
            }
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private AvailabilityUpdate getAvailabilityUpdate() throws Exception {
        return ((AvailabilityUpdateHome)EJBHomeFactory.getFactory().lookup(AvailabilityUpdateHome.class, "ejb/AvailabilityUpdate")).create();
    }

    private void validate(Dataset ian) throws DcmServiceException {
        this.assertType1(ian, 0x20000D);
        this.assertType1(ian, 528661);
        DcmElement refSeriesSq = ian.get(528661);
        int nS = refSeriesSq.countItems();
        for (int i = 0; i < nS; ++i) {
            Dataset refSeries = refSeriesSq.getItem(i);
            this.assertType1(refSeries, 0x20000E);
            this.assertType1(refSeries, 528793);
            DcmElement refSOPSq = refSeries.get(528793);
            int nI = refSOPSq.countItems();
            for (int j = 0; j < nI; ++j) {
                Dataset refSop = refSOPSq.getItem(j);
                this.assertType1(refSop, 528720);
                this.assertType1(refSop, 528725);
                this.assertType1(refSop, 524374);
                this.assertType1(refSop, 524372);
                this.validateAvailability(refSop.getString(524374));
            }
        }
    }

    private void validateAvailability(String value) throws DcmServiceException {
        try {
            Availability.toInt(value);
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(278, "Illegal value for Instance Availability: " + value);
        }
    }

    private void assertType1(Dataset ian, int tag) throws DcmServiceException {
        if (!ian.containsValue(tag)) {
            throw new DcmServiceException(289, "Missing attribute (value): " + Tags.toString(tag));
        }
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.33", this.ianScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.33");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.5.1.4.33", IANScpService.valuesToStringArray(this.tsuidMap));
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.5.1.4.33", null);
    }
}

