/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.hpscp;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.hpscp.HPScpService;
import org.dcm4chex.archive.ejb.interfaces.HPStorage;
import org.dcm4chex.archive.ejb.interfaces.HPStorageHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

public class HPStoreScp
extends DcmServiceBase {
    private final HPScpService service;
    private final Logger log;
    private static final int[] TYPE1_HP_ATTR = new int[]{0x720002, 7471108, 7471110, 7471112, 7471114, 7471116, 7471124, 0x720020, 0x720200};
    private static final int[] TYPE1_IMAGESET_ATTR = new int[]{0x720022, 7471152};
    private static final int[] TYPE1_IMAGESET_SELECTOR_ATTR = new int[]{7471140, 7471142, 7471184};
    private static final int[] TYPE1_TIMEBASED_IMAGESET_ATTR = new int[]{7471154, 7471156};
    private static final int[] TYPE1_DISPLAYSET_ATTR = new int[]{0x720202, 7471620, 7471154, 7471872};
    private static final int[] TYPE1_IMAGEBOX_ATTR = new int[]{7471874, 7471368, 7471876};

    public HPStoreScp(HPScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected void doCStore(ActiveAssociation activeAssoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command rqCmd = rq.getCommand();
        String iuid = rqCmd.getAffectedSOPInstanceUID();
        String cuid = rqCmd.getAffectedSOPClassUID();
        Dataset hp = rq.getDataset();
        this.log.debug((Object)"Receive HP:\n");
        this.log.debug((Object)hp);
        this.checkAttrs(hp, iuid, cuid);
        this.updateDB(hp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDB(Dataset hp) throws DcmServiceException {
        try {
            HPStorage hpStorage = this.getStorageHome().create();
            try {
                hpStorage.store(hp);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    hpStorage.remove();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            hpStorage.remove();
            return;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private HPStorageHome getStorageHome() throws HomeFactoryException {
        return (HPStorageHome)EJBHomeFactory.getFactory().lookup(HPStorageHome.class, "ejb/HPStorage");
    }

    private void checkAttrs(Dataset hp, String iuid, String cuid) throws DcmServiceException {
        int j;
        int m;
        String s = hp.getString(524312);
        if (!iuid.equals(s)) {
            this.datasetDoesNotMatchSOPClass("SOP Instance UID: " + s);
        }
        if (!cuid.equals(s = hp.getString(524310))) {
            this.datasetDoesNotMatchSOPClass("SOP Class UID: " + s);
        }
        this.checkType1Attrs(hp, TYPE1_HP_ATTR, "Missing Type 1 Attribute ");
        DcmElement issq = hp.get(0x720020);
        int n = issq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset is = issq.getItem(i);
            this.checkType1Attrs(is, TYPE1_IMAGESET_ATTR, "Missing Type 1 Attribute (0072,0020)/");
            DcmElement isselsq = is.get(0x720022);
            int m2 = isselsq.countItems();
            for (int j2 = 0; j2 < m2; ++j2) {
                this.checkType1Attrs(isselsq.getItem(j2), TYPE1_IMAGESET_SELECTOR_ATTR, "Missing Type 1 Attribute (0072,0020)/(0072,0022)/");
            }
            DcmElement tbissq = is.get(7471152);
            m = tbissq.countItems();
            for (j = 0; j < m; ++j) {
                this.checkType1Attrs(tbissq.getItem(j), TYPE1_TIMEBASED_IMAGESET_ATTR, "Missing Type 1 Attribute (0072,0020)/(0072,0030)/");
            }
        }
        DcmElement dssq = hp.get(0x720200);
        int n2 = dssq.countItems();
        for (int i = 0; i < n2; ++i) {
            Dataset ds = dssq.getItem(i);
            this.checkType1Attrs(ds, TYPE1_DISPLAYSET_ATTR, "Missing Type 1 Attribute (0072,0200)/");
            DcmElement ibsq = ds.get(7471872);
            m = ibsq.countItems();
            for (j = 0; j < m; ++j) {
                this.checkType1Attrs(ibsq.getItem(j), TYPE1_IMAGEBOX_ATTR, "Missing Type 1 Attribute (0072,0200)/(0072,0300)/");
            }
        }
    }

    private void checkType1Attrs(Dataset attrs, int[] type1, String prompt) throws DcmServiceException {
        for (int i = 0; i < type1.length; ++i) {
            if (attrs.containsValue(type1[i])) continue;
            this.datasetDoesNotMatchSOPClass(prompt + Tags.toString(type1[i]));
        }
    }

    private void datasetDoesNotMatchSOPClass(String msg) throws DcmServiceException {
        throw new DcmServiceException(43264, msg);
    }
}

