/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.hpscp;

import java.net.InetAddress;
import java.net.Socket;
import javax.management.JMException;
import javax.management.ObjectName;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.hpscp.HPFindScp;
import org.dcm4chex.archive.dcm.hpscp.HPMoveScp;
import org.dcm4chex.archive.dcm.hpscp.HPStoreScp;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.jdbc.HPQueryCmd;
import org.dcm4chex.archive.ejb.jdbc.HPRetrieveCmd;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;

public class HPScpService
extends AbstractScpService {
    private final HPStoreScp hpStoreScp = new HPStoreScp(this);
    private final HPFindScp hpFindScp = new HPFindScp(this);
    private final HPMoveScp hpMoveScp = new HPMoveScp(this);
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);
    private boolean sendPendingMoveRSP = true;
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private int fetchSize;

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final int getReceiveBufferSize() {
        return this.tlsConfig.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.tlsConfig.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.tlsConfig.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.tlsConfig.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.tlsConfig.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.tlsConfig.setTcpNoDelay(on);
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public final void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public final boolean isSendPendingMoveRSP() {
        return this.sendPendingMoveRSP;
    }

    public final void setSendPendingMoveRSP(boolean sendPendingMoveRSP) {
        this.sendPendingMoveRSP = sendPendingMoveRSP;
    }

    public final boolean getQueryAccessBlobAsLongVarBinary() {
        return HPQueryCmd.blobAccessType == -4;
    }

    public final void setQueryAccessBlobAsLongVarBinary(boolean enable) {
        HPQueryCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final boolean getRetrieveAccessBlobAsLongVarBinary() {
        return HPRetrieveCmd.blobAccessType == -4;
    }

    public final void setRetrieveAccessBlobAsLongVarBinary(boolean enable) {
        HPRetrieveCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final String getQueryTransactionIsolationLevel() {
        return HPQueryCmd.transactionIsolationLevelAsString((int)HPQueryCmd.transactionIsolationLevel);
    }

    public final void setQueryTransactionIsolationLevel(String level) {
        HPQueryCmd.transactionIsolationLevel = HPQueryCmd.transactionIsolationLevelOf((String)level);
    }

    public final String getRetrieveTransactionIsolationLevel() {
        return HPRetrieveCmd.transactionIsolationLevelAsString((int)HPRetrieveCmd.transactionIsolationLevel);
    }

    public final void setRetrieveTransactionIsolationLevel(String level) {
        HPRetrieveCmd.transactionIsolationLevel = HPRetrieveCmd.transactionIsolationLevelOf((String)level);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public AEDTO queryAEData(String aet, InetAddress addr) throws DcmServiceException {
        try {
            Object o = this.server.invoke(this.aeServiceName, "getAE", new Object[]{aet, addr}, new String[]{String.class.getName(), InetAddress.class.getName()});
            if (o == null) {
                throw new DcmServiceException(43009, aet);
            }
            return (AEDTO)o;
        }
        catch (JMException e) {
            this.log.error((Object)"Failed to query AEData", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    Socket createSocket(String moveCalledAET, AEDTO destAE) throws Exception {
        return this.tlsConfig.createSocket(this.aeMgr().findByAET(moveCalledAET), destAE);
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.38.1", this.hpStoreScp);
        services.bind("1.2.840.10008.5.1.4.38.2", this.hpFindScp);
        services.bind("1.2.840.10008.5.1.4.38.3", this.hpMoveScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.38.1");
        services.unbind("1.2.840.10008.5.1.4.38.2");
        services.unbind("1.2.840.10008.5.1.4.38.3");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        String[] tsuids = HPScpService.valuesToStringArray(this.tsuidMap);
        policy.putPresContext("1.2.840.10008.5.1.4.38.1", tsuids);
        policy.putPresContext("1.2.840.10008.5.1.4.38.2", tsuids);
        policy.putPresContext("1.2.840.10008.5.1.4.38.3", tsuids);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.840.10008.5.1.4.38.1", null);
        policy.putPresContext("1.2.840.10008.5.1.4.38.2", null);
        policy.putPresContext("1.2.840.10008.5.1.4.38.3", null);
    }
}

