/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.hpscp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.dcm.hpscp.HPScpService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.exceptions.NoPresContextException;
import org.jboss.logging.Logger;

class HPMoveTask
implements Runnable {
    private static final int STORE_PCID = 1;
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private final HPScpService service;
    private final List hpList;
    private Logger log;
    private ActiveAssociation moveAssoc;
    private int movePcid;
    private Command moveRqCmd;
    private Dataset moveRqData;
    private AEDTO aeData;
    private String moveDest;
    private String moveOriginatorAET;
    private String moveCalledAET;
    private int priority;
    private int msgID;
    private int failed = 0;
    private int warnings = 0;
    private int completed = 0;
    private int remaining = 0;
    private boolean canceled = false;
    private ActiveAssociation storeAssoc;
    private final ArrayList failedIUIDs = new ArrayList();

    public HPMoveTask(HPScpService service, ActiveAssociation moveAssoc, int movePcid, Command moveRqCmd, Dataset moveRqData, List hpList, AEDTO aeData, String moveDest) throws DcmServiceException {
        this.service = service;
        this.hpList = hpList;
        this.log = service.getLog();
        this.moveAssoc = moveAssoc;
        this.movePcid = movePcid;
        this.moveRqCmd = moveRqCmd;
        this.moveRqData = moveRqData;
        this.aeData = aeData;
        this.moveDest = moveDest;
        this.moveOriginatorAET = moveAssoc.getAssociation().getCallingAET();
        this.moveCalledAET = moveAssoc.getAssociation().getCalledAET();
        this.priority = moveRqCmd.getInt(1792, 0);
        this.msgID = moveRqCmd.getMessageID();
        if (hpList.isEmpty()) {
            return;
        }
        this.openAssociation();
        moveAssoc.addCancelListener(this.msgID, new DimseListener(){

            public void dimseReceived(Association assoc, Dimse dimse) {
                HPMoveTask.this.canceled = true;
            }
        });
    }

    private void openAssociation() throws DcmServiceException {
        String prompt;
        PDU ac = null;
        Association a = null;
        AssociationFactory asf = AssociationFactory.getInstance();
        try {
            a = asf.newRequestor(this.service.createSocket(this.moveCalledAET, this.aeData));
            a.setAcTimeout(this.service.getAcTimeout());
            AAssociateRQ rq = asf.newAAssociateRQ();
            rq.setCalledAET(this.moveDest);
            rq.setCallingAET(this.moveCalledAET);
            rq.addPresContext(asf.newPresContext(1, "1.2.840.10008.5.1.4.38.1", NATIVE_LE_TS));
            ac = a.connect(rq);
        }
        catch (Exception e) {
            String prompt2 = "Failed to connect " + this.moveDest;
            this.log.error((Object)prompt2, (Throwable)e);
            throw new DcmServiceException(42754, prompt2, e);
        }
        if (!(ac instanceof AAssociateAC)) {
            prompt = "Association not accepted by " + this.moveDest + ":\n" + ac;
            this.log.error((Object)prompt);
            throw new DcmServiceException(42754, prompt);
        }
        this.storeAssoc = asf.newActiveAssociation(a, null);
        this.storeAssoc.start();
        if (a.listAcceptedPresContext("1.2.840.10008.5.1.4.38.1").isEmpty()) {
            prompt = "No Presentation Context for Hanging Protocol Storage not negotiated by " + this.moveDest;
            this.log.error((Object)prompt);
            throw new DcmServiceException(42754, prompt);
        }
    }

    public void run() {
        Dataset hp;
        Association a = this.storeAssoc.getAssociation();
        int n = this.hpList.size();
        for (int i = 0; i < n && a.getState() == 6 && !this.canceled; ++i) {
            hp = (Dataset)this.hpList.get(i);
            final String iuid = hp.getString(524312);
            DimseListener storeScpListener = new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    switch (dimse.getCommand().getStatus()) {
                        case 0: {
                            ++HPMoveTask.this.completed;
                            break;
                        }
                        case 45056: 
                        case 45062: 
                        case 45063: {
                            ++HPMoveTask.this.warnings;
                            break;
                        }
                        default: {
                            ++HPMoveTask.this.failed;
                            HPMoveTask.this.failedIUIDs.add(iuid);
                        }
                    }
                    if (--HPMoveTask.this.remaining > 0) {
                        HPMoveTask.this.notifyMovePending();
                    }
                }
            };
            try {
                this.storeAssoc.invoke(this.makeCStoreRQ(hp), storeScpListener);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Exception during move of " + iuid), (Throwable)e);
            }
        }
        if (a.getState() == 6) {
            try {
                this.storeAssoc.release(true);
                Thread.sleep(10L);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception during release:", (Throwable)e);
            }
        } else {
            try {
                a.abort(AssociationFactory.getInstance().newAAbort(2, 0));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (!this.canceled) {
            n = this.hpList.size();
            for (int i = this.completed + this.warnings + this.failed; i < n; ++i) {
                hp = (Dataset)this.hpList.get(i);
                this.failedIUIDs.add(hp.getString(524312));
            }
            this.remaining = 0;
            this.failed = this.failedIUIDs.size();
        }
        this.notifyMoveFinished();
    }

    private Dimse makeCStoreRQ(Dataset hp) throws NoPresContextException {
        Association assoc = this.storeAssoc.getAssociation();
        Command storeRqCmd = DcmObjectFactory.getInstance().newCommand();
        storeRqCmd.initCStoreRQ(assoc.nextMsgID(), hp.getString(524310), hp.getString(524312), this.priority);
        storeRqCmd.putUS(4145, this.msgID);
        storeRqCmd.putAE(4144, this.moveOriginatorAET);
        return AssociationFactory.getInstance().newDimse(1, storeRqCmd, hp);
    }

    private void notifyMovePending() {
        if (this.service.isSendPendingMoveRSP()) {
            this.notifyMoveSCU(65280, null);
        }
    }

    private void notifyMoveFinished() {
        this.notifyMoveSCU(this.canceled ? 65024 : (this.failed > 0 ? 45056 : 0), this.makeMoveRspIdentifier());
    }

    private void notifyMoveSCU(int status, Dataset ds) {
        if (this.moveAssoc == null) {
            return;
        }
        try {
            this.moveAssoc.getAssociation().write(AssociationFactory.getInstance().newDimse(this.movePcid, this.makeMoveRsp(status), ds));
        }
        catch (Exception e) {
            this.log.info((Object)"Failed to send Move RSP to Move Originator:", (Throwable)e);
            this.moveAssoc = null;
        }
    }

    private Dataset makeMoveRspIdentifier() {
        if (this.failed == 0) {
            return null;
        }
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        if (this.failed == this.failedIUIDs.size()) {
            String[] a = this.failedIUIDs.toArray(new String[this.failedIUIDs.size()]);
            ds.putUI(524376, a);
            if (ds.get(524376).length() < 65536) {
                return ds;
            }
            this.log.warn((Object)"Failed SOP InstanceUID List exceeds 64KB limit - send empty attribute instead");
        }
        ds.putUI(524376);
        return ds;
    }

    private Command makeMoveRsp(int status) {
        Command rspCmd = DcmObjectFactory.getInstance().newCommand();
        rspCmd.initCMoveRSP(this.moveRqCmd.getMessageID(), this.moveRqCmd.getAffectedSOPClassUID(), status);
        if (this.remaining > 0) {
            rspCmd.putUS(4128, this.remaining);
        } else {
            rspCmd.remove(4128);
        }
        rspCmd.putUS(4129, this.completed);
        rspCmd.putUS(4131, this.warnings);
        rspCmd.putUS(4130, this.failed);
        return rspCmd;
    }
}

