/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.hpscp;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.List;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.hpscp.HPMoveTask;
import org.dcm4chex.archive.dcm.hpscp.HPScpService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.jdbc.HPRetrieveCmd;
import org.jboss.logging.Logger;

public class HPMoveScp
extends DcmServiceBase {
    private final HPScpService service;
    private final Logger log;

    public HPMoveScp(HPScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    public void c_move(ActiveAssociation assoc, Dimse rq) throws IOException {
        Command rqCmd = rq.getCommand();
        try {
            Dataset rqData = rq.getDataset();
            this.log.debug((Object)"Identifier:\n");
            this.log.debug((Object)rqData);
            this.checkMoveRQ(assoc.getAssociation(), rq.pcid(), rqCmd, rqData);
            String dest = rqCmd.getString(1536);
            InetAddress host = dest.equals(assoc.getAssociation().getCallingAET()) ? assoc.getAssociation().getSocket().getInetAddress() : null;
            AEDTO destAE = this.service.queryAEData(dest, host);
            List hpList = this.queryHPList(rqData);
            new Thread(new HPMoveTask(this.service, assoc, rq.pcid(), rqCmd, rqData, hpList, destAE, dest)).start();
        }
        catch (DcmServiceException e) {
            Command rspCmd = objFact.newCommand();
            rspCmd.initCMoveRSP(rqCmd.getMessageID(), rqCmd.getAffectedSOPClassUID(), e.getStatus());
            e.writeTo(rspCmd);
            Dimse rsp = fact.newDimse(rq.pcid(), rspCmd);
            assoc.getAssociation().write(rsp);
        }
    }

    private List queryHPList(Dataset rqData) throws DcmServiceException {
        try {
            HPRetrieveCmd cmd = new HPRetrieveCmd(rqData);
            cmd.setFetchSize(this.service.getFetchSize());
            return cmd.getDatasets();
        }
        catch (SQLException e) {
            this.service.getLog().error((Object)"Query DB failed:", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void checkMoveRQ(Association assoc, int pcid, Command rqCmd, Dataset rqData) throws DcmServiceException {
        if (!rqCmd.containsValue(1536)) {
            throw new DcmServiceException(49152, "Missing Move Destination");
        }
        if (!rqData.containsValue(524312)) {
            throw new DcmServiceException(43264, "Missing SOP Instance UID");
        }
    }
}

