/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.hpscp;

import java.io.IOException;
import java.sql.SQLException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4chex.archive.dcm.hpscp.HPScpService;
import org.dcm4chex.archive.ejb.jdbc.HPQueryCmd;
import org.jboss.logging.Logger;

public class HPFindScp
extends DcmServiceBase {
    private final HPScpService service;
    private final Logger log;

    public HPFindScp(HPScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected DcmServiceBase.MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        HPQueryCmd queryCmd;
        try {
            Dataset rqData = rq.getDataset();
            this.log.debug((Object)"Identifier:\n");
            this.log.debug((Object)rqData);
            queryCmd = new HPQueryCmd(rqData);
            queryCmd.setFetchSize(this.service.getFetchSize()).execute();
        }
        catch (Exception e) {
            this.log.error((Object)"Query DB failed:", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
        return new MultiCFindRsp(queryCmd);
    }

    private class MultiCFindRsp
    implements DcmServiceBase.MultiDimseRsp {
        private final HPQueryCmd queryCmd;
        private boolean canceled = false;

        public MultiCFindRsp(HPQueryCmd queryCmd) {
            this.queryCmd = queryCmd;
        }

        public DimseListener getCancelListener() {
            return new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MultiCFindRsp.this.canceled = true;
                }
            };
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            if (this.canceled) {
                rspCmd.putUS(2304, 65024);
                return null;
            }
            try {
                if (!this.queryCmd.next()) {
                    rspCmd.putUS(2304, 0);
                    return null;
                }
                rspCmd.putUS(2304, 65280);
                Dataset rspData = this.queryCmd.getDataset();
                HPFindScp.this.log.debug((Object)"Identifier:\n");
                HPFindScp.this.log.debug((Object)rspData);
                return rspData;
            }
            catch (SQLException e) {
                HPFindScp.this.service.getLog().error((Object)"Retrieve DB record failed:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
            catch (Exception e) {
                HPFindScp.this.service.getLog().error((Object)"Corrupted DB record:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
        }

        public void release() {
            this.queryCmd.close();
        }
    }
}

