/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscu;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.FutureRSP;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.dcm4chex.archive.ejb.jdbc.GPWLQueryCmd;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class GPWLScuService
extends AbstractScuService {
    private static final int PCID_GPWL = 1;
    private String calledAET;
    private int priority = 0;

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String aet) {
        this.calledAET = aet;
    }

    public final boolean isLocal() {
        return "LOCAL".equalsIgnoreCase(this.calledAET);
    }

    public final String getPriority() {
        return DicomPriority.toString(this.priority);
    }

    public final void setPriority(String priority) {
        this.priority = DicomPriority.toCode(priority);
    }

    public boolean deleteGPWLEntry(String spsID) {
        try {
            this.gpwlMgt().removeWorklistItem(spsID);
            this.log.info((Object)("GPWL entry with id " + spsID + " removed!"));
            return true;
        }
        catch (Exception x) {
            this.log.error((Object)("Can't delete GPWLEntry with id:" + spsID), (Throwable)x);
            return false;
        }
    }

    public List findGPWLEntries(Dataset searchDS) throws DcmServiceException {
        if (this.isLocal()) {
            return this.findGPWLEntriesLocal(searchDS);
        }
        return this.findGPWLEntriesFromAET(searchDS);
    }

    private List findGPWLEntriesLocal(Dataset searchDS) throws DcmServiceException {
        ArrayList<Dataset> l = new ArrayList<Dataset>();
        GPWLQueryCmd queryCmd = null;
        try {
            queryCmd = new GPWLQueryCmd(searchDS, false);
            queryCmd.execute();
            while (queryCmd.next()) {
                l.add(queryCmd.getDataset());
            }
        }
        catch (SQLException x) {
            throw new DcmServiceException(272, (Throwable)x);
        }
        if (queryCmd != null) {
            queryCmd.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private List findGPWLEntriesFromAET(Dataset searchDS) {
        try {
            ArrayList<Dataset> arrayList;
            ActiveAssociation aa = this.openAssociation(this.calledAET, "1.2.840.10008.5.1.4.32.1");
            try {
                ArrayList<Dataset> list = new ArrayList<Dataset>();
                Command cmd = DcmObjectFactory.getInstance().newCommand();
                cmd.initCFindRQ(1, "1.2.840.10008.5.1.4.32.1", this.priority);
                Dimse mcRQ = AssociationFactory.getInstance().newDimse(1, cmd, searchDS);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("make CFIND req:" + mcRQ));
                }
                FutureRSP rsp = aa.invoke(mcRQ);
                Dimse dimse = rsp.get();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("CFIND resp:" + dimse));
                }
                List pending = rsp.listPending();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("CFIND pending:" + pending));
                }
                Iterator iter = pending.iterator();
                while (iter.hasNext()) {
                    list.add(((Dimse)iter.next()).getDataset());
                }
                arrayList = list;
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to release " + aa.getAssociation()));
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            return arrayList;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }

    private GPWLManager gpwlMgt() throws Exception {
        GPWLManagerHome home = (GPWLManagerHome)EJBHomeFactory.getFactory().lookup(GPWLManagerHome.class, "ejb/GPWLManager");
        return home.create();
    }
}

