/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.rmi.RemoteException;
import java.util.Date;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.dcm4chex.archive.dcm.gpwlscp.PPSOrder;
import org.dcm4chex.archive.ejb.interfaces.GPPPSManager;
import org.dcm4chex.archive.ejb.interfaces.GPPPSManagerHome;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;

public class PPSScuService
extends AbstractScuService
implements MessageListener,
NotificationListener {
    private static final int PCID_GPPPS = 1;
    private static final String NONE = "NONE";
    private static final String[] EMPTY = new String[0];
    private static final int[] SOP_IUID = new int[]{524312};
    private static final int[] N_CREATE_SPS_ATTRS = new int[]{524293, 0x100010, 0x100020, 0x100030, 0x100040, 4210741, 4236144};
    private static final int[] N_CREATE_TYPE2_ATTRS = new int[]{4236144, 4210741, 4210741, 4210737, 4210738, 0x404033};
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private String[] destAETs = EMPTY;
    private ObjectName gpwlScpServiceName;
    private String queueName;
    private int concurrency = 1;
    private String ppsuidSuffix = ".1";
    private boolean copyWorkitemCode = true;
    private boolean copyProcessingApplicationsCode = true;
    private boolean copyStationGeographicLocationCode = true;
    private boolean copyStationClassCode = true;
    private boolean copyStationNameCode = true;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final boolean isCopyProcessingApplicationsCode() {
        return this.copyProcessingApplicationsCode;
    }

    public final void setCopyProcessingApplicationsCode(boolean copyProcessingApplicationsCode) {
        this.copyProcessingApplicationsCode = copyProcessingApplicationsCode;
    }

    public final boolean isCopyStationClassCode() {
        return this.copyStationClassCode;
    }

    public final void setCopyStationClassCode(boolean copyStationClassCode) {
        this.copyStationClassCode = copyStationClassCode;
    }

    public final boolean isCopyStationGeographicLocationCode() {
        return this.copyStationGeographicLocationCode;
    }

    public final void setCopyStationGeographicLocationCode(boolean copyStationGeographicLocationCode) {
        this.copyStationGeographicLocationCode = copyStationGeographicLocationCode;
    }

    public final boolean isCopyStationNameCode() {
        return this.copyStationNameCode;
    }

    public final void setCopyStationNameCode(boolean copyStationNameCode) {
        this.copyStationNameCode = copyStationNameCode;
    }

    public final boolean isCopyWorkitemCode() {
        return this.copyWorkitemCode;
    }

    public final void setCopyWorkitemCode(boolean copyWorkitemCode) {
        this.copyWorkitemCode = copyWorkitemCode;
    }

    public final String getPpsUidSuffix() {
        return this.ppsuidSuffix;
    }

    public final void setPpsUidSuffix(String ppsuidSuffix) {
        this.ppsuidSuffix = ppsuidSuffix;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    private GPWLManager getGPWLManager() throws HomeFactoryException, RemoteException, CreateException {
        return ((GPWLManagerHome)EJBHomeFactory.getFactory().lookup(GPWLManagerHome.class, "ejb/GPWLManager")).create();
    }

    private GPPPSManager getGPPPSManager() throws HomeFactoryException, RemoteException, CreateException {
        return ((GPPPSManagerHome)EJBHomeFactory.getFactory().lookup(GPPPSManagerHome.class, "ejb/GPPPSManager")).create();
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final String getDestAETs() {
        return this.destAETs.length > 0 ? StringUtils.toString(this.destAETs, '\\') : NONE;
    }

    public final void setDestAETs(String forwardAETs) {
        this.destAETs = NONE.equalsIgnoreCase(forwardAETs) ? EMPTY : StringUtils.split(forwardAETs, '\\');
    }

    public final ObjectName getGpwlScpServiceName() {
        return this.gpwlScpServiceName;
    }

    public final void setGpwlScpServiceName(ObjectName serviceName) {
        this.gpwlScpServiceName = serviceName;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_SPS_ACTION_NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_SPS_ACTION_NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset pps;
        block10: {
            String spsuid = (String)notif.getUserData();
            pps = DcmObjectFactory.getInstance().newDataset();
            try {
                GPWLManager gpwlmgr = this.getGPWLManager();
                Dataset sps = gpwlmgr.getWorklistItem(spsuid);
                String ppsiuid = spsuid + this.ppsuidSuffix;
                String status = sps.getString(0x404001);
                pps.putCS(0x404002, status);
                pps.putUI(524312, ppsiuid);
                Date now = new Date();
                if ("IN PROGRESS".equals(status)) {
                    try {
                        this.getGPPPSManager().getGPPPS(ppsiuid);
                        return;
                    }
                    catch (Exception e) {
                        pps.putSH(4194899, "PPS" + ppsiuid.hashCode());
                        pps.putDA(0x400244, now);
                        pps.putTM(4194885, now);
                        pps.putDA(4194896);
                        pps.putTM(4194897);
                        for (int i = 0; i < N_CREATE_TYPE2_ATTRS.length; ++i) {
                            pps.putXX(N_CREATE_TYPE2_ATTRS[i]);
                        }
                        pps.putAll(sps.subSet(N_CREATE_SPS_ATTRS));
                        this.copyCode(this.copyWorkitemCode, sps.getItem(4210712), pps.putSQ(4210713));
                        this.copyCode(this.copyStationNameCode, sps.getItem(4210725), pps.putSQ(4210728));
                        this.copyCode(this.copyStationClassCode, sps.getItem(4210726), pps.putSQ(4210729));
                        this.copyCode(this.copyStationGeographicLocationCode, sps.getItem(4210727), pps.putSQ(0x404030));
                        this.copyCode(this.copyProcessingApplicationsCode, sps.getItem(0x404004), pps.putSQ(0x404007));
                        break block10;
                    }
                }
                if ("COMPLETED".equals(status) || "DISCONTINUED".equals(status)) {
                    pps.putDA(4194896, now);
                    pps.putTM(4194897, now);
                    pps.putAll(gpwlmgr.getOutputInformation(spsuid));
                    break block10;
                }
                return;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to access GP-SPS[" + spsuid + "]"), (Throwable)e);
                return;
            }
        }
        for (int i = 0; i < this.destAETs.length; ++i) {
            PPSOrder order = new PPSOrder(pps, this.destAETs[i]);
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, order, 4, 0L);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
    }

    private void copyCode(boolean copy, Dataset code, DcmElement sq) {
        if (copy && code != null) {
            sq.addItem(code);
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                PPSOrder order = (PPSOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.sendPPS(order.isCreate(), order.getDataset(), order.getDestination());
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPPS(boolean create, Dataset pps, String aet) throws Exception {
        ActiveAssociation aa = this.openAssociation(aet, "1.2.840.10008.5.1.4.32.3");
        try {
            Association a = aa.getAssociation();
            DcmObjectFactory dof = DcmObjectFactory.getInstance();
            Command cmdRq = dof.newCommand();
            String iuid = pps.getString(524312);
            if (create) {
                cmdRq.initNCreateRQ(a.nextMsgID(), "1.2.840.10008.5.1.4.32.3", iuid);
            } else {
                cmdRq.initNSetRQ(a.nextMsgID(), "1.2.840.10008.5.1.4.32.3", iuid);
            }
            Dimse dimseRq = AssociationFactory.getInstance().newDimse(1, cmdRq, pps.exclude(SOP_IUID));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"GP-PPS Attributes:");
                this.log.debug((Object)pps);
            }
            Dimse dimseRsp = aa.invoke(dimseRq).get();
            Command cmdRsp = dimseRsp.getCommand();
            int status = cmdRsp.getStatus();
            switch (status) {
                case 0: {
                    break;
                }
                case 278: {
                    this.log.warn((Object)("Received Warning Status 116H (=Attribute Value Out of Range) from remote AE " + aet));
                    break;
                }
                default: {
                    throw new DcmServiceException(status, cmdRsp.getString(2306));
                }
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release " + aa.getAssociation()));
        }
    }
}

