/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.common.PPSStatus;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.dcm4chex.archive.ejb.interfaces.GPPPSManager;
import org.dcm4chex.archive.ejb.interfaces.GPPPSManagerHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

class PPSScp
extends DcmServiceBase {
    private static final int[] TYPE1_NCREATE_ATTR = new int[]{4194899, 0x400244, 4194885, 0x404002};
    private static final int[] TYPE1_REF_GPSPS_ATTR = new int[]{528720, 528725, 4210723};
    private static final int[] CODEITEM_SQ_ATTR = new int[]{4210728, 4210729, 0x404030, 0x404007, 4210713};
    private static final int[] TYPE1_CODEITEM_ATTR = new int[]{524544, 524546, 524548};
    private static final int[] ONLY_NCREATE_ATTR = new int[]{4236144, 4210710, 0x100010, 0x100020, 0x100030, 0x100040, 4210741, 4194899, 4210728, 4210729, 0x404030, 0x404007, 4210713, 0x400244, 4194885};
    private static final int[] TYPE1_FINAL_ATTR = new int[]{4194896, 4194897};
    private final GPWLScpService service;
    private final Logger log;

    public PPSScp(GPWLScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association as = assoc.getAssociation();
        String callingAET = as.getCallingAET();
        String calledAET = as.getCalledAET();
        Command cmd = rq.getCommand();
        Dataset gppps = rq.getDataset();
        String cuid = cmd.getAffectedSOPClassUID();
        String iuid = cmd.getAffectedSOPInstanceUID();
        if (iuid == null) {
            iuid = rspCmd.getAffectedSOPInstanceUID();
        }
        this.log.debug((Object)"GP-PPS Attributes:");
        this.log.debug((Object)gppps);
        this.checkCreateAttributs(gppps);
        this.service.supplementIssuerOfPatientID(gppps, as, as.getCallingAET(), false);
        this.service.generatePatientID(gppps, gppps.getItem(4236144), calledAET);
        gppps.putUI(524310, cuid);
        gppps.putUI(524312, iuid);
        this.createGPPPS(gppps);
        this.service.sendPPSNotification(gppps);
        return null;
    }

    protected Dataset doNSet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        Dataset gppps = rq.getDataset();
        String iuid = cmd.getRequestedSOPInstanceUID();
        this.log.debug((Object)"GP-PPS Attributes:");
        this.log.debug((Object)gppps);
        this.checkSetAttributs(gppps);
        gppps.putUI(524312, iuid);
        this.updateGPPPS(gppps);
        this.service.sendPPSNotification(gppps);
        return null;
    }

    protected Dataset doNGet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command rqCmd = rq.getCommand();
        Dataset ds = rq.getDataset();
        String iuid = rqCmd.getAffectedSOPInstanceUID();
        Dataset gppps = this.getGPPPS(iuid);
        int[] filter = rqCmd.getTags(4101);
        return filter != null ? gppps.subSet(filter) : gppps;
    }

    private void checkCreateAttributs(Dataset gppps) throws DcmServiceException {
        int i;
        for (int i2 = 0; i2 < TYPE1_NCREATE_ATTR.length; ++i2) {
            if (gppps.containsValue(TYPE1_NCREATE_ATTR[i2])) continue;
            throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(TYPE1_NCREATE_ATTR[i2]));
        }
        DcmElement refReqSQ = gppps.get(4236144);
        int n = refReqSQ.countItems();
        for (int i3 = 0; i3 < n; ++i3) {
            if (refReqSQ.getItem(i3).containsValue(0x20000D)) continue;
            throw new DcmServiceException(289, "Missing Study Instance UID in Referenced Request Seq.");
        }
        DcmElement refGPSPSSQ = gppps.get(4210710);
        if (refGPSPSSQ != null) {
            int n2 = refGPSPSSQ.countItems();
            for (int i4 = 0; i4 < n2; ++i4) {
                Dataset refGPSPS = refGPSPSSQ.getItem(i4);
                for (int j = 0; j < TYPE1_REF_GPSPS_ATTR.length; ++j) {
                    if (refGPSPS.containsValue(TYPE1_REF_GPSPS_ATTR[j])) continue;
                    throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(TYPE1_REF_GPSPS_ATTR[j]) + " in Referenced General Purpose Scheduled Procedure Step Seq.");
                }
            }
        }
        DcmElement ahpSQ = gppps.get(4210741);
        int n3 = ahpSQ.countItems();
        for (i = 0; i < n3; ++i) {
            Dataset item = ahpSQ.getItem(i);
            this.checkCodeItem(item, 0x404009, true);
        }
        for (i = 0; i < CODEITEM_SQ_ATTR.length; ++i) {
            this.checkCodeItem(gppps, CODEITEM_SQ_ATTR[i], false);
        }
        String status = gppps.getString(0x404002);
        try {
            if (PPSStatus.toInt(status) == 0) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        throw new DcmServiceException(262, "Invalid General Purpose Performed Procedure Step Status: " + status);
    }

    private void checkCodeItem(Dataset ds, int tag, boolean type1) throws DcmServiceException {
        Dataset item = ds.getItem(tag);
        if (item == null) {
            if (type1) {
                throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(tag));
            }
            return;
        }
        for (int i = 0; i < TYPE1_CODEITEM_ATTR.length; ++i) {
            if (item.containsValue(TYPE1_CODEITEM_ATTR[i])) continue;
            throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(tag) + "/" + Tags.toString(TYPE1_CODEITEM_ATTR[i]));
        }
    }

    private void checkSetAttributs(Dataset gppps) throws DcmServiceException {
        for (int i = 0; i < ONLY_NCREATE_ATTR.length; ++i) {
            if (!gppps.contains(ONLY_NCREATE_ATTR[i])) continue;
            throw new DcmServiceException(272, "Cannot update attribute " + Tags.toString(ONLY_NCREATE_ATTR[i]));
        }
        String status = gppps.getString(0x404002);
        try {
            if (status == null || PPSStatus.toInt(status) == 0) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(262, "Invalid GPPPS Status: " + status);
        }
        for (int i = 0; i < TYPE1_FINAL_ATTR.length; ++i) {
            if (gppps.containsValue(TYPE1_FINAL_ATTR[i])) continue;
            throw new DcmServiceException(289, "Missing Type 1 Attribute " + Tags.toString(TYPE1_FINAL_ATTR[i]));
        }
    }

    private GPPPSManager getGPPPSManager() throws HomeFactoryException, RemoteException, CreateException {
        return ((GPPPSManagerHome)EJBHomeFactory.getFactory().lookup(GPPPSManagerHome.class, "ejb/GPPPSManager")).create();
    }

    private void createGPPPS(Dataset gppps) throws DcmServiceException {
        try {
            this.getGPPPSManager().createGPPPS(gppps, this.service.patientMatching());
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void updateGPPPS(Dataset gppps) throws DcmServiceException {
        try {
            this.getGPPPSManager().updateGPPPS(gppps);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private Dataset getGPPPS(String iuid) throws DcmServiceException {
        try {
            return this.getGPPPSManager().getGPPPS(iuid);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }
}

