/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.gpwlscp.GPSPSScp;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLFindScp;
import org.dcm4chex.archive.dcm.gpwlscp.PPSScp;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.GPWLQueryCmd;

public class GPWLScpService
extends AbstractScpService {
    private static final int FUZZY_MATCHING = 2;
    public static final String ON_PPS_NOTIF = "org.dcm4chex.archive.dcm.gpwlscp.onpps";
    public static final NotificationFilter ON_PPS_NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = -1969818592538255743L;

        public boolean isNotificationEnabled(Notification notif) {
            return GPWLScpService.ON_PPS_NOTIF.equals(notif.getType());
        }
    };
    public static final String ON_SPS_ACTION_NOTIF = "org.dcm4chex.archive.dcm.gpwlscp.onspsaction";
    public static final NotificationFilter ON_SPS_ACTION_NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 5671824066766098134L;

        public boolean isNotificationEnabled(Notification notif) {
            return GPWLScpService.ON_SPS_ACTION_NOTIF.equals(notif.getType());
        }
    };
    private static final ExtNegotiator extNegotiator = new ExtNegotiator(){

        public byte[] negotiate(byte[] offered) {
            if (offered.length > 2) {
                offered[2] = (byte)(offered[2] & (AttributeFilter.isSoundexEnabled() ? (byte)1 : 0));
            }
            return offered;
        }
    };
    private Map cuidMap = new LinkedHashMap();
    private GPWLFindScp gpwlFindScp = new GPWLFindScp(this);
    private GPSPSScp spspsScp = new GPSPSScp(this);
    private PPSScp ppsScp = new PPSScp(this);

    void sendActionNotification(String iuid) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(ON_SPS_ACTION_NOTIF, (Object)this, eventID);
        notif.setUserData(iuid);
        super.sendNotification(notif);
    }

    void sendPPSNotification(Dataset pps) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(ON_PPS_NOTIF, (Object)this, eventID);
        notif.setUserData(pps);
        super.sendNotification(notif);
    }

    public String getAcceptedSOPClasses() {
        return this.toString(this.cuidMap);
    }

    public void setAcceptedSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.cuidMap, s, null);
    }

    public final boolean getAccessBlobAsLongVarBinary() {
        return GPWLQueryCmd.blobAccessType == -4;
    }

    public final void setAccessBlobAsLongVarBinary(boolean enable) {
        GPWLQueryCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final String getTransactionIsolationLevel() {
        return GPWLQueryCmd.transactionIsolationLevelAsString((int)GPWLQueryCmd.transactionIsolationLevel);
    }

    public final void setTransactionIsolationLevel(String level) {
        GPWLQueryCmd.transactionIsolationLevel = GPWLQueryCmd.transactionIsolationLevelOf((String)level);
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.32.1", this.gpwlFindScp);
        services.bind("1.2.840.10008.5.1.4.32.2", this.spspsScp);
        services.bind("1.2.840.10008.5.1.4.32.3", this.ppsScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.32.1");
        services.unbind("1.2.840.10008.5.1.4.32.2");
        services.unbind("1.2.840.10008.5.1.4.32.3");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, GPWLScpService.valuesToStringArray(this.cuidMap), GPWLScpService.valuesToStringArray(this.tsuidMap));
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.32.1", extNegotiator);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, GPWLScpService.valuesToStringArray(this.cuidMap), null);
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.32.1", null);
    }
}

