/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.io.IOException;
import java.sql.SQLException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.dcm4chex.archive.ejb.jdbc.GPWLQueryCmd;
import org.jboss.logging.Logger;

class GPWLFindScp
extends DcmServiceBase {
    private static final int FUZZY_MATCHING = 2;
    private final GPWLScpService service;
    private final Logger log;

    public GPWLFindScp(GPWLScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected DcmServiceBase.MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        GPWLQueryCmd queryCmd;
        try {
            Command rqCmd = rq.getCommand();
            Dataset rqData = rq.getDataset();
            this.log.debug((Object)"Identifier:\n");
            this.log.debug((Object)rqData);
            Association a = assoc.getAssociation();
            this.service.logDicomQuery(a, rq.getCommand().getAffectedSOPClassUID(), rqData);
            boolean fuzzyMatchingOfPN = this.fuzzyMatchingOfPN(a.getAcceptedExtNegotiation(rqCmd.getAffectedSOPClassUID()));
            queryCmd = new GPWLQueryCmd(rqData, fuzzyMatchingOfPN);
            queryCmd.execute();
        }
        catch (Exception e) {
            this.service.getLog().error((Object)"Query DB failed:", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
        return new MultiCFindRsp(queryCmd);
    }

    private boolean fuzzyMatchingOfPN(ExtNegotiation extNeg) {
        byte[] info;
        return extNeg != null && (info = extNeg.info()).length > 2 && info[2] != 0;
    }

    private class MultiCFindRsp
    implements DcmServiceBase.MultiDimseRsp {
        private final GPWLQueryCmd queryCmd;
        private boolean canceled = false;

        public MultiCFindRsp(GPWLQueryCmd queryCmd) {
            this.queryCmd = queryCmd;
        }

        public DimseListener getCancelListener() {
            return new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MultiCFindRsp.this.canceled = true;
                }
            };
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            if (this.canceled) {
                rspCmd.putUS(2304, 65024);
                return null;
            }
            try {
                if (!this.queryCmd.next()) {
                    rspCmd.putUS(2304, 0);
                    return null;
                }
                rspCmd.putUS(2304, 65280);
                Dataset rspData = this.queryCmd.getDataset();
                GPWLFindScp.this.log.debug((Object)"Identifier:\n");
                GPWLFindScp.this.log.debug((Object)rspData);
                return rspData;
            }
            catch (SQLException e) {
                GPWLFindScp.this.service.getLog().error((Object)"Retrieve DB record failed:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
            catch (Exception e) {
                GPWLFindScp.this.service.getLog().error((Object)"Corrupted DB record:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
        }

        public void release() {
            this.queryCmd.close();
        }
    }
}

