/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.dcm.ianscu.IANScuService;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.XSLTUtils;
import org.jboss.system.ServiceMBeanSupport;

public class GPWLFeedService2
extends ServiceMBeanSupport {
    private static final String MPPS2GPWL_XSL = "mpps2gpwl.xsl";
    private static final String LOGFILE_PATTERN = "yyyyMMddHHmmss.SSS'-mpps.xml'";
    private String[] logAETs = new String[0];
    private String[] pgpAETs = new String[0];
    private String[] appendAETs = new String[0];
    private File logDir;
    private TemplatesDelegate templates = new TemplatesDelegate(this);
    private ObjectName ianScuServiceName;
    private final NotificationListener ianListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            GPWLFeedService2.this.onIAN((Dataset)notif.getUserData());
        }
    };

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final String getWorkItemConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setWorkItemConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final String getLogStationAETs() {
        return StringUtils.toString(this.logAETs, '\\');
    }

    public final void setLogStationAETs(String aets) {
        this.logAETs = StringUtils.split(aets, '\\');
    }

    public final String getPGPStationAETs() {
        return StringUtils.toString(this.pgpAETs, '\\');
    }

    public final void setPGPStationAETs(String aets) {
        this.pgpAETs = StringUtils.split(aets, '\\');
    }

    public final String getAppendCaseStationAETs() {
        return StringUtils.toString(this.appendAETs, '\\');
    }

    public final void setAppendCaseStationAETs(String aets) {
        this.appendAETs = StringUtils.split(aets, '\\');
    }

    public final ObjectName getIANScuServiceName() {
        return this.ianScuServiceName;
    }

    public final void setIANScuServiceName(ObjectName ianScuServiceName) {
        this.ianScuServiceName = ianScuServiceName;
    }

    protected void startService() throws Exception {
        this.logDir = new File(System.getProperty("jboss.server.log.dir"));
        this.server.addNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    private void onIAN(Dataset mpps) {
        Templates stylesheet;
        String aet = mpps.getString(4194881);
        boolean logMPPS = GPWLFeedService2.contains(this.logAETs, aet);
        if (logMPPS) {
            this.logMPPS(aet, mpps);
        }
        if ((stylesheet = this.templates.getTemplatesForAET(aet, MPPS2GPWL_XSL)) == null) {
            this.log.info((Object)("No mpps2gpwl.xsl found for " + aet));
            return;
        }
        Dataset wkitems = DcmObjectFactory.getInstance().newDataset();
        try {
            XSLTUtils.xslt(mpps, stylesheet, wkitems);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to create work items triggered by MPPS from " + aet), (Throwable)e);
            return;
        }
        DcmElement wkitemSeq = wkitems.get(4390944);
        this.log.info((Object)("Creating " + wkitemSeq.countItems() + " work item(s) triggered by MPPS from " + aet));
        try {
            this.createWorkItems(wkitemSeq, GPWLFeedService2.contains(this.pgpAETs, aet), GPWLFeedService2.contains(this.appendAETs, aet));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to create work item triggered by MPPS from " + aet), (Throwable)e);
        }
    }

    private synchronized void createWorkItems(DcmElement wkitemSeq, boolean checkPGP, boolean checkAppend) throws Exception {
        GPWLManager gpwlmgr = this.getGPWLManager();
        int n = wkitemSeq.countItems();
        for (int i = 0; i < n; ++i) {
            gpwlmgr.addWorklistItem(wkitemSeq.getItem(i), checkPGP, checkAppend);
        }
    }

    private static boolean contains(Object[] a, Object e) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(e)) continue;
            return true;
        }
        return false;
    }

    private GPWLManager getGPWLManager() throws Exception {
        return ((GPWLManagerHome)EJBHomeFactory.getFactory().lookup(GPWLManagerHome.class, "ejb/GPWLManager")).create();
    }

    private void logMPPS(String aet, Dataset mpps) {
        File dir = new File(this.logDir, aet);
        SimpleDateFormat df = new SimpleDateFormat(LOGFILE_PATTERN);
        File f = new File(dir, df.format(new Date()));
        dir.mkdir();
        try {
            this.log.info((Object)("Log MPPS attributes to " + f));
            XSLTUtils.writeTo(mpps, f);
        }
        catch (Exception e) {
            this.log.warn((Object)"Log MPPS attributes failed:", (Throwable)e);
        }
    }
}

