/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.io.File;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.InputSource;

public class GPWLFeedService
extends ServiceMBeanSupport {
    private static final int[] PAT_ATTR_TAGS = new int[]{0x100010, 0x100020, 0x100030, 0x100040};
    private Map humanPerformer = null;
    private List templates = null;
    private File templatePath = null;
    private static DcmObjectFactory dof = DcmObjectFactory.getInstance();

    public String getHumanPerformer() {
        return this.codes2String(this.humanPerformer);
    }

    public void setHumanPerformer(String performer) {
        this.humanPerformer = this.string2Codes(performer, "DCM4CHEE");
    }

    public String getTemplatePath() {
        return this.templatePath.getPath();
    }

    public void setTemplatePath(String path) throws MalformedURLException {
        this.templatePath = new File(path.replace('/', File.separatorChar));
    }

    private String codes2String(Map codes) {
        if (codes == null || codes.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Dataset ds : codes.values()) {
            String design = ds.getString(524546);
            sb.append(ds.getString(524544)).append("^");
            if (design != null) {
                sb.append(design).append("^");
            }
            sb.append(ds.getString(524548)).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Map string2Codes(String codes, String defaultDesign) {
        StringTokenizer st = new StringTokenizer(codes, ",");
        HashMap<String, Dataset> map = new HashMap<String, Dataset>();
        while (st.hasMoreTokens()) {
            StringTokenizer stCode = new StringTokenizer(st.nextToken(), "^");
            int nrOfTokens = stCode.countTokens();
            if (nrOfTokens < 2) {
                throw new IllegalArgumentException("Wrong format of human performer configuration! (<codeValue>[^<designator>]^<meaning>)");
            }
            Dataset ds = dof.newDataset();
            String codeValue = stCode.nextToken();
            ds.putSH(524544, codeValue);
            if (nrOfTokens > 2) {
                ds.putSH(524546, stCode.nextToken());
            } else if (defaultDesign != null) {
                ds.putSH(524546, defaultDesign);
            }
            ds.putLO(524548, stCode.nextToken());
            map.put(codeValue, ds);
        }
        return map;
    }

    public List listTemplates() {
        if (this.templates == null) {
            File tmplPath = FileUtils.resolve(this.templatePath);
            File[] files = tmplPath.listFiles();
            this.templates = new ArrayList();
            for (int i = 0; i < files.length; ++i) {
                String fn = files[i].getName();
                if (!fn.endsWith(".xml")) continue;
                this.templates.add(fn.substring(0, fn.length() - 4));
            }
        }
        this.log.info((Object)("Template List:" + this.templates));
        return this.templates;
    }

    public void clearTemplateList() {
        this.templates = null;
    }

    public void addWorklistItem(Long studyPk, String templateFile, String humanPerformerCode, Long scheduleDate) throws Exception {
        String uri = FileUtils.resolve(new File(this.templatePath, templateFile + ".xml")).toURI().toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("load template file: " + uri));
        }
        Dataset ds = DatasetUtils.fromXML(new InputSource(uri));
        ContentManager cm = this.getContentManager();
        Dataset patDS = cm.getPatientForStudy(studyPk);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Patient Dataset:");
            this.log.debug((Object)patDS);
        }
        ds.putAll(patDS.subSet(PAT_ATTR_TAGS));
        Dataset sopInstRef = cm.getSOPInstanceRefMacro(studyPk, false);
        String studyIUID = sopInstRef.getString(0x20000D);
        ds.putUI(524312, UIDGenerator.getInstance().createUID());
        ds.putUI(0x20000D, studyIUID);
        DcmElement inSq = ds.putSQ(4210721);
        inSq.addItem(sopInstRef);
        DcmElement schedHPSq = ds.putSQ(0x404034);
        Dataset item = schedHPSq.addNewItem();
        DcmElement hpCodeSq = item.putSQ(0x404009);
        Dataset dsCode = (Dataset)this.humanPerformer.get(humanPerformerCode);
        this.log.info((Object)dsCode);
        if (dsCode != null) {
            hpCodeSq.addItem(dsCode);
            item.putPN(4210743, dsCode.getString(524548));
        }
        ds.putDT(0x404005, new Date(scheduleDate));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"GPSPS Dataset:");
            this.log.debug((Object)ds);
        }
        this.addWorklistItem(ds);
    }

    private void addWorklistItem(Dataset ds) {
        if (ds == null) {
            return;
        }
        try {
            this.getGPWLManager().addWorklistItem(ds);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to add Worklist Item:", (Throwable)e);
        }
    }

    private GPWLManager getGPWLManager() throws CreateException, RemoteException, HomeFactoryException {
        return ((GPWLManagerHome)EJBHomeFactory.getFactory().lookup(GPWLManagerHome.class, "ejb/GPWLManager")).create();
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }
}

