/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.gpwlscp;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

class GPSPSScp
extends DcmServiceBase {
    private static final int REQUEST_GPSPS_STATUS_MODIFICATION = 1;
    private final GPWLScpService service;
    private final Logger log;

    public GPSPSScp(GPWLScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected Dataset doNAction(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command rqCmd = rq.getCommand();
        Dataset actionInfo = rq.getDataset();
        this.log.debug((Object)"N-Action Information:");
        this.log.debug((Object)actionInfo);
        String iuid = rqCmd.getAffectedSOPInstanceUID();
        int actionID = rqCmd.getInt(4104, -1);
        if (actionID != 1) {
            throw new DcmServiceException(291, "actionID:" + actionID);
        }
        if (!actionInfo.containsValue(528789)) {
            throw new DcmServiceException(289, "Missing Transaction UID (0008,1195)");
        }
        if (!actionInfo.containsValue(0x404001)) {
            throw new DcmServiceException(289, "Missing GPSPS Status (0040,4001)");
        }
        DcmElement src = actionInfo.get(4210741);
        if (src != null) {
            int n = src.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = src.getItem(i);
                Dataset code = item.getItem(0x404009);
                if (code == null) {
                    this.log.warn((Object)"Missing >Human Performer Code Seq (0040,4009)");
                    continue;
                }
                if (code.containsValue(524544) && code.containsValue(524546)) continue;
                this.log.warn((Object)"Invalid Item in >Human Performer Code Seq (0040,4009)");
            }
        }
        this.modifyStatus(iuid, actionInfo);
        this.service.sendActionNotification(iuid);
        return null;
    }

    private void modifyStatus(String iuid, Dataset actionInfo) throws DcmServiceException {
        try {
            this.getGPWLManager().modifyStatus(iuid, actionInfo);
        }
        catch (DcmServiceException e) {
            this.log.error((Object)"Exception during status update:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during status update:", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private GPWLManager getGPWLManager() throws HomeFactoryException, RemoteException, CreateException {
        return ((GPWLManagerHome)EJBHomeFactory.getFactory().lookup(GPWLManagerHome.class, "ejb/GPWLManager")).create();
    }
}

