/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm;

import java.io.IOException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.UserIdentityNegotiator;
import org.dcm4che.server.DcmHandler;
import org.dcm4che.server.Server;
import org.dcm4che.server.ServerFactory;
import org.dcm4che.util.DcmProtocol;
import org.dcm4chex.archive.mbean.DicomSecurityDelegate;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.notif.CallingAetChanged;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;

public class DcmServerService
extends ServiceMBeanSupport
implements NotificationListener {
    private ServerFactory sf = ServerFactory.getInstance();
    private AssociationFactory af = AssociationFactory.getInstance();
    private AcceptorPolicy policy = this.af.newAcceptorPolicy();
    private DcmServiceRegistry services = this.af.newDcmServiceRegistry();
    private DcmHandler handler = this.sf.newDcmHandler(this.policy, this.services);
    private Server dcmsrv = this.sf.newServer(this.handler);
    private DcmProtocol protocol = DcmProtocol.DICOM;
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);
    private boolean jbossStarted;
    private DicomSecurityDelegate dicomSecurity = new DicomSecurityDelegate(this);

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final ObjectName getDicomSecurityServiceName() {
        return this.dicomSecurity.getDicomSecurityServiceName();
    }

    public final void setDicomSecurityServiceName(ObjectName serviceName) {
        this.dicomSecurity.setDicomSecurityServiceName(serviceName);
    }

    public int getPort() {
        return this.dcmsrv.getPort();
    }

    public void setPort(int port) {
        this.dcmsrv.setPort(port);
    }

    public String getLocalAddress() {
        return this.dcmsrv.getLocalAddress();
    }

    public void setLocalAddress(String localAddress) {
        this.dcmsrv.setLocalAddress(localAddress);
    }

    public String getProtocolName() {
        return this.protocol.toString();
    }

    public void setProtocolName(String protocolName) {
        this.protocol = DcmProtocol.valueOf(protocolName);
    }

    public DcmHandler dcmHandler() {
        return this.handler;
    }

    public int getRqTimeout() {
        return this.handler.getRqTimeout();
    }

    public void setRqTimeout(int newRqTimeout) {
        this.handler.setRqTimeout(newRqTimeout);
    }

    public int getDimseTimeout() {
        return this.handler.getDimseTimeout();
    }

    public void setDimseTimeout(int newDimseTimeout) {
        this.handler.setDimseTimeout(newDimseTimeout);
    }

    public int getSoCloseDelay() {
        return this.handler.getSoCloseDelay();
    }

    public void setSoCloseDelay(int newSoCloseDelay) {
        this.handler.setSoCloseDelay(newSoCloseDelay);
    }

    public boolean isPackPDVs() {
        return this.handler.isPackPDVs();
    }

    public void setPackPDVs(boolean newPackPDVs) {
        this.handler.setPackPDVs(newPackPDVs);
    }

    public final int getSSLHandshakeSoTimeout() {
        return this.dcmsrv.getSSLHandshakeSoTimeout();
    }

    public final void setSSLHandshakeSoTimeout(int soTimeout) {
        this.dcmsrv.setSSLHandshakeSoTimeout(soTimeout);
    }

    public final int getReceiveBufferSize() {
        return this.dcmsrv.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.dcmsrv.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.dcmsrv.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.dcmsrv.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.dcmsrv.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.dcmsrv.setTcpNoDelay(on);
    }

    public int getMaxClients() {
        return this.dcmsrv.getMaxClients();
    }

    public void setMaxClients(int newMaxClients) {
        this.dcmsrv.setMaxClients(newMaxClients);
    }

    public int getNumClients() {
        return this.dcmsrv.getNumClients();
    }

    public int getMaxIdleThreads() {
        return this.dcmsrv.getMaxIdleThreads();
    }

    public int getNumIdleThreads() {
        return this.dcmsrv.getNumIdleThreads();
    }

    public void setMaxIdleThreads(int max) {
        this.dcmsrv.setMaxIdleThreads(max);
    }

    public String[] getCallingAETs() {
        return this.policy.getCallingAETs();
    }

    public void setCallingAETs(String[] newCallingAETs) {
        this.policy.setCallingAETs(newCallingAETs);
    }

    public String[] getCalledAETs() {
        return this.policy.getCalledAETs();
    }

    public void setCalledAETs(String[] newCalledAETs) {
        this.policy.setCalledAETs(newCalledAETs);
    }

    public int getMaxPDULength() {
        return this.policy.getMaxPDULength();
    }

    public void setMaxPDULength(int newMaxPDULength) {
        this.policy.setMaxPDULength(newMaxPDULength);
    }

    public void notifyCallingAETchange(String[] affectedCalledAETs, String[] newCallingAETs) {
        long eventID = this.getNextNotificationSequenceNumber();
        Notification notif = new Notification(CallingAetChanged.class.getName(), this, eventID);
        notif.setUserData(new CallingAetChanged(affectedCalledAETs, newCallingAETs));
        this.log.debug((Object)("send callingAET changed notif:" + notif));
        this.sendNotification(notif);
    }

    public UserIdentityNegotiator userIdentityNegotiator() {
        return this.dicomSecurity.userIdentityNegotiator();
    }

    protected void startService() throws Exception {
        if (this.jbossStarted) {
            this.log.info((Object)"Start DICOM server after restart of DcmServer service!");
            this.startDicomServer();
        } else {
            this.dcmsrv.addHandshakeFailedListener(this.tlsConfig.handshakeFailedListener());
            this.dcmsrv.addHandshakeCompletedListener(this.tlsConfig.handshakeCompletedListener());
            this.dcmsrv.setServerSocketFactory(this.tlsConfig.serverSocketFactory(this.protocol.getCipherSuites()));
            this.server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    public void handleNotification(Notification msg, Object arg1) {
        if (msg.getType().equals("org.jboss.system.server.started")) {
            this.startDicomServer();
            this.jbossStarted = true;
            try {
                this.server.removeNotificationListener(ServerImplMBean.OBJECT_NAME, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startDicomServer() {
        try {
            this.dcmsrv.start();
        }
        catch (IOException x) {
            this.log.error((Object)"Start DICOM Server failed!", (Throwable)x);
        }
    }

    protected void stopService() throws Exception {
        this.dcmsrv.stop();
    }
}

