/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm;

import java.io.IOException;
import javax.management.ObjectName;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDU;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.AEManagerHome;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractScuService
extends ServiceMBeanSupport {
    private static final byte[] RELATIONAL_QUERY = new byte[]{1};
    protected static final int ERR_ASSOC_RJ = -1;
    protected static final int ERR_NO_PC_AC = -2;
    protected static final String[] EXPL_VRLE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    protected static final String[] ONLY_DEF_TS = new String[]{"1.2.840.10008.1.2"};
    protected String callingAET;
    protected String[] offeredTS = ONLY_DEF_TS;
    protected int acTimeout;
    protected int dimseTimeout;
    protected int soCloseDelay;
    protected int maxPDULength = 16352;
    private int fetchSize;
    protected TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final void setCallingAET(String aet) {
        this.callingAET = aet;
    }

    public final boolean getExplicitVRLE() {
        return this.offeredTS == EXPL_VRLE_TS;
    }

    public void setExplicitVRLE(boolean explicitVRLE) {
        this.offeredTS = explicitVRLE ? EXPL_VRLE_TS : ONLY_DEF_TS;
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final int getReceiveBufferSize() {
        return this.tlsConfig.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.tlsConfig.setReceiveBufferSize(size);
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final int getSendBufferSize() {
        return this.tlsConfig.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.tlsConfig.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.tlsConfig.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.tlsConfig.setTcpNoDelay(on);
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getMaxPDULength() {
        return this.maxPDULength;
    }

    public final void setMaxPDULength(int maxPDULength) {
        this.maxPDULength = maxPDULength;
    }

    public final int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public final void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public ActiveAssociation openAssociation(String calledAET, String asuid) throws Exception {
        return this.openAssociation(calledAET, new String[]{asuid}, new ExtNegotiation[0]);
    }

    public ActiveAssociation openAssociation(String calledAET, String asuid, ExtNegotiation extNeg) throws Exception {
        return this.openAssociation(calledAET, new String[]{asuid}, extNeg);
    }

    public ActiveAssociation openAssociation(AEDTO remoteAE, String asuid) throws Exception {
        return this.openAssociation(this.aeMgt().findByAET(this.callingAET), remoteAE, new String[]{asuid}, new ExtNegotiation[0]);
    }

    public ActiveAssociation openAssociation(String calledAET, String[] asuids, ExtNegotiation ... extNegos) throws Exception {
        AEManager aeMgt = this.aeMgt();
        return this.openAssociation(aeMgt.findByAET(this.callingAET), aeMgt.findByAET(calledAET), asuids, extNegos);
    }

    private ActiveAssociation openAssociation(AEDTO localAE, AEDTO remoteAE, String[] asuids, ExtNegotiation ... extNegos) throws IOException, DcmServiceException {
        AssociationFactory af = AssociationFactory.getInstance();
        Association a = af.newRequestor(this.tlsConfig.createSocket(localAE, remoteAE));
        a.setAcTimeout(this.acTimeout);
        a.setDimseTimeout(this.dimseTimeout);
        a.setSoCloseDelay(this.soCloseDelay);
        AAssociateRQ rq = af.newAAssociateRQ();
        rq.setCalledAET(remoteAE.getTitle());
        rq.setCallingAET(this.callingAET);
        for (int i = 0; i < asuids.length; ++i) {
            rq.addPresContext(af.newPresContext(rq.nextPCID(), asuids[i]));
        }
        for (ExtNegotiation extNeg : extNegos) {
            rq.addExtNegotiation(extNeg);
        }
        rq.setMaxPDULength(this.maxPDULength);
        PDU ac = a.connect(rq);
        if (!(ac instanceof AAssociateAC)) {
            throw new DcmServiceException(-1, "Association not accepted by " + remoteAE + ": " + ac);
        }
        ActiveAssociation aa = af.newActiveAssociation(a, null);
        aa.start();
        if (((AAssociateAC)ac).countAcceptedPresContext() > 0) {
            return aa;
        }
        try {
            aa.release(false);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
        throw new DcmServiceException(-2, "No Presentation Context accepted by " + remoteAE + ": " + ac);
    }

    protected AEManager aeMgt() throws Exception {
        AEManagerHome home = (AEManagerHome)EJBHomeFactory.getFactory().lookup(AEManagerHome.class, "ejb/AEManager");
        return home.create();
    }
}

