/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.ejb.ObjectNotFoundException;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.UIDs;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmService;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.UserIdentityNegotiator;
import org.dcm4che.server.DcmHandler;
import org.dcm4che.util.DTFormat;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.QueryMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.AEManagerHome;
import org.dcm4chex.archive.ejb.interfaces.Storage;
import org.dcm4chex.archive.ejb.interfaces.StorageHome;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManager;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManagerHome;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.notif.AetChanged;
import org.dcm4chex.archive.notif.CallingAetChanged;
import org.dcm4chex.archive.util.CoercionUtils;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.XSLTUtils;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScpService
extends ServiceMBeanSupport {
    protected static final String ASSOC_ISSUER_OF_PAT_ID = "ISSUER_OF_PAT_ID";
    protected static final String ASSOC_ISSUER_OF_ACC_NO = "ISSUER_OF_ACC_NO";
    protected static final String ASSOC_INST_NAME = "ASSOC_INST_NAME";
    protected static final String ASSOC_DEPT_NAME = "ASSOC_DEPT_NAME";
    protected static final String ANY = "ANY";
    protected static final String CONFIGURED_AETS = "CONFIGURED_AETS";
    protected static final String NONE = "NONE";
    protected static final String COERCE = "COERCE";
    private static int sequenceInt = new Random().nextInt();
    protected ObjectName dcmServerName;
    protected ObjectName aeServiceName;
    protected DcmHandler dcmHandler;
    protected UserIdentityNegotiator userIdentityNegotiator;
    protected String[] calledAETs;
    protected String[] callingAETs;
    protected String[] generatePatientID = null;
    protected boolean pnameHashInGeneratePatientID;
    protected String issuerOfGeneratedPatientID;
    protected boolean supplementIssuerOfPatientID;
    protected boolean supplementIssuerOfAccessionNumber;
    protected boolean supplementInstitutionName;
    protected boolean supplementInstitutionalDepartmentName;
    protected boolean supplementByHostName;
    protected boolean supplementByHostAddress;
    protected String[] generatePatientIDForUnscheduledFromAETs;
    protected boolean invertGeneratePatientIDForUnscheduledFromAETs;
    protected PatientMatching patientMatching;
    protected Map<String, String> tsuidMap = new LinkedHashMap<String, String>();
    protected int maxPDULength = 16352;
    protected int maxOpsInvoked = 1;
    protected int maxOpsPerformed = 1;
    protected String[] logCallingAETs = new String[0];
    protected File logDir;
    private boolean writeCoercionXmlLog;
    protected TemplatesDelegate templates = new TemplatesDelegate(this);
    private static final NotificationFilterSupport callingAETsChangeFilter = new NotificationFilterSupport();
    private static final NotificationFilterSupport aetChangeFilter;
    private final NotificationListener callingAETChangeListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            try {
                CallingAetChanged userData = (CallingAetChanged)notif.getUserData();
                if (this.areCalledAETsAffected(userData.getAffectedCalledAETs())) {
                    String[] newCallingAets = userData.getNewCallingAETs();
                    String newCallingAETs = newCallingAets == null ? AbstractScpService.ANY : (newCallingAets.length == 0 ? AbstractScpService.CONFIGURED_AETS : StringUtils.toString(newCallingAets, '\\'));
                    AbstractScpService.this.log.debug((Object)("newCallingAETs:" + newCallingAETs));
                    AbstractScpService.this.server.setAttribute(AbstractScpService.this.serviceName, new Attribute("CallingAETitles", newCallingAETs));
                }
            }
            catch (Throwable th) {
                AbstractScpService.this.log.warn((Object)"Failed to process callingAET change notification: ", th);
            }
        }

        private boolean areCalledAETsAffected(String[] affectedCalledAETs) {
            if (AbstractScpService.this.calledAETs == null) {
                return true;
            }
            if (affectedCalledAETs != null) {
                for (int i = 0; i < affectedCalledAETs.length; ++i) {
                    for (int j = 0; j < AbstractScpService.this.calledAETs.length; ++j) {
                        if (!affectedCalledAETs[i].equals(AbstractScpService.this.calledAETs[j])) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private final NotificationListener aetChangeListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            if (AbstractScpService.this.callingAETs != null && AbstractScpService.this.callingAETs.length == 0) {
                try {
                    AbstractScpService.this.log.debug((Object)"Handle AE Title change notification!");
                    AetChanged userData = (AetChanged)notif.getUserData();
                    String removeAET = userData.getOldAET();
                    String addAET = userData.getNewAET();
                    AcceptorPolicy policy = AbstractScpService.this.dcmHandler.getAcceptorPolicy();
                    for (int i = 0; i < AbstractScpService.this.calledAETs.length; ++i) {
                        AcceptorPolicy policy1 = policy.getPolicyForCalledAET(AbstractScpService.this.calledAETs[i]);
                        if (removeAET != null) {
                            policy1.removeCallingAET(removeAET);
                        }
                        if (addAET == null) continue;
                        policy1.addCallingAET(addAET);
                    }
                }
                catch (Throwable th) {
                    AbstractScpService.this.log.warn((Object)"Failed to process AE Title change notification: ", th);
                }
            }
        }
    };

    public final ObjectName getDcmServerName() {
        return this.dcmServerName;
    }

    public final void setDcmServerName(ObjectName dcmServerName) {
        this.dcmServerName = dcmServerName;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public ObjectName getAEServiceName() {
        return this.aeServiceName;
    }

    public void setAEServiceName(ObjectName aeServiceName) {
        this.aeServiceName = aeServiceName;
    }

    public final String getCalledAETs() {
        return this.calledAETs == null ? "" : StringUtils.toString(this.calledAETs, '\\');
    }

    public final void setCalledAETs(String calledAETs) {
        if (this.getCalledAETs().equals(calledAETs)) {
            return;
        }
        this.disableService();
        this.calledAETs = StringUtils.split(calledAETs, '\\');
        this.enableService();
    }

    public final String getLogCallingAETs() {
        return StringUtils.toString(this.logCallingAETs, '\\');
    }

    public final void setLogCallingAETs(String aets) {
        this.logCallingAETs = StringUtils.split(aets, '\\');
    }

    public final String getGeneratePatientID() {
        if (this.generatePatientID == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.generatePatientID.length; ++i) {
            sb.append(this.generatePatientID[i]);
        }
        return sb.toString();
    }

    public final void setGeneratePatientID(String pattern) {
        int sr;
        if (pattern.equalsIgnoreCase(NONE)) {
            this.generatePatientID = null;
            return;
        }
        int pl = pattern.indexOf(35);
        boolean pnameHash = pl != -1;
        int pr = pnameHash ? pattern.lastIndexOf(35) : -1;
        int sl = pattern.indexOf(36);
        int n = sr = sl != -1 ? pattern.lastIndexOf(36) : -1;
        this.generatePatientID = !pnameHash && sl == -1 ? new String[]{pattern} : (pnameHash && sl != -1 ? (pl < sl ? AbstractScpService.split(pattern, pl, pr, sl, sr) : AbstractScpService.split(pattern, sl, sr, pl, pr)) : (pnameHash ? AbstractScpService.split(pattern, pl, pr) : AbstractScpService.split(pattern, sl, sr)));
        this.pnameHashInGeneratePatientID = pnameHash;
    }

    private static String[] split(String pattern, int l1, int r1) {
        return new String[]{pattern.substring(0, l1), pattern.substring(l1, r1 + 1), pattern.substring(r1 + 1)};
    }

    private static String[] split(String pattern, int l1, int r1, int l2, int r2) {
        if (r1 > l2) {
            throw new IllegalArgumentException(pattern);
        }
        return new String[]{pattern.substring(0, l1), pattern.substring(l1, r1 + 1), pattern.substring(r1 + 1, l2), pattern.substring(l2, r2 + 1), pattern.substring(r2 + 1)};
    }

    public final String getIssuerOfGeneratedPatientID() {
        return this.issuerOfGeneratedPatientID;
    }

    public final void setIssuerOfGeneratedPatientID(String issuerOfGeneratedPatientID) {
        this.issuerOfGeneratedPatientID = issuerOfGeneratedPatientID;
    }

    public final boolean isSupplementIssuerOfPatientID() {
        return this.supplementIssuerOfPatientID;
    }

    public final void setSupplementIssuerOfPatientID(boolean supplementIssuerOfPatientID) {
        this.supplementIssuerOfPatientID = supplementIssuerOfPatientID;
    }

    public final boolean isSupplementIssuerOfAccessionNumber() {
        return this.supplementIssuerOfAccessionNumber;
    }

    public final void setSupplementIssuerOfAccessionNumber(boolean enable) {
        this.supplementIssuerOfAccessionNumber = enable;
    }

    public final boolean isSupplementInstitutionName() {
        return this.supplementInstitutionName;
    }

    public final void setSupplementInstitutionName(boolean supplementInstitutionName) {
        this.supplementInstitutionName = supplementInstitutionName;
    }

    public final boolean isSupplementInstitutionalDepartmentName() {
        return this.supplementInstitutionalDepartmentName;
    }

    public final void setSupplementInstitutionalDepartmentName(boolean supplementInstitutionalDepartmentName) {
        this.supplementInstitutionalDepartmentName = supplementInstitutionalDepartmentName;
    }

    public final boolean isSupplementByHostName() {
        return this.supplementByHostName;
    }

    public final void setSupplementByHostName(boolean supplementByHostName) {
        this.supplementByHostName = supplementByHostName;
    }

    public final boolean isSupplementByHostAddress() {
        return this.supplementByHostAddress;
    }

    public final void setSupplementByHostAddress(boolean supplementByHostAddress) {
        this.supplementByHostAddress = supplementByHostAddress;
    }

    public final String getGeneratePatientIDForUnscheduledFromAETs() {
        return this.invertGeneratePatientIDForUnscheduledFromAETs ? "!\\" : "" + (this.generatePatientIDForUnscheduledFromAETs == null ? NONE : StringUtils.toString(this.generatePatientIDForUnscheduledFromAETs, '\\'));
    }

    public final void setGeneratePatientIDForUnscheduledFromAETs(String aets) {
        this.invertGeneratePatientIDForUnscheduledFromAETs = aets.startsWith("!\\");
        if (this.invertGeneratePatientIDForUnscheduledFromAETs) {
            aets = aets.substring(2);
        }
        this.generatePatientIDForUnscheduledFromAETs = aets.equalsIgnoreCase(NONE) ? null : StringUtils.split(aets, '\\');
    }

    protected boolean isGeneratePatientIDForUnscheduledFromAET(String callingAET) {
        if (this.generatePatientIDForUnscheduledFromAETs != null) {
            for (String aet : this.generatePatientIDForUnscheduledFromAETs) {
                if (!aet.equals(callingAET)) continue;
                return !this.invertGeneratePatientIDForUnscheduledFromAETs;
            }
        }
        return this.invertGeneratePatientIDForUnscheduledFromAETs;
    }

    public String getPatientMatching() {
        return this.patientMatching.toString();
    }

    public void setPatientMatching(String s) {
        this.patientMatching = new PatientMatching(s.trim());
    }

    public final PatientMatching patientMatching() {
        return this.patientMatching;
    }

    public final int getMaxPDULength() {
        return this.maxPDULength;
    }

    public final void setMaxPDULength(int maxPDULength) {
        if (this.maxPDULength == maxPDULength) {
            return;
        }
        this.maxPDULength = maxPDULength;
        this.enableService();
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final void setMaxOpsInvoked(int maxOpsInvoked) {
        if (this.maxOpsInvoked == maxOpsInvoked) {
            return;
        }
        this.maxOpsInvoked = maxOpsInvoked;
        this.enableService();
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public final void setMaxOpsPerformed(int maxOpsPerformed) {
        if (this.maxOpsPerformed == maxOpsPerformed) {
            return;
        }
        this.maxOpsPerformed = maxOpsPerformed;
        this.enableService();
    }

    public final String getCoerceConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setCoerceConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public boolean isWriteCoercionXmlLog() {
        return this.writeCoercionXmlLog;
    }

    public void setWriteCoercionXmlLog(boolean writeCoercionXmlLog) {
        this.writeCoercionXmlLog = writeCoercionXmlLog;
    }

    protected boolean enableService() {
        if (this.dcmHandler == null) {
            return false;
        }
        boolean changed = false;
        Object[] callingAETs = this.getCallingAETsForPolicy();
        AcceptorPolicy policy = this.dcmHandler.getAcceptorPolicy();
        for (int i = 0; i < this.calledAETs.length; ++i) {
            AcceptorPolicy policy1 = policy.getPolicyForCalledAET(this.calledAETs[i]);
            if (policy1 == null) {
                policy1 = AssociationFactory.getInstance().newAcceptorPolicy();
                policy1.setCallingAETs((String[])callingAETs);
                policy1.setUserIdentityNegotiator(this.userIdentityNegotiator);
                policy.putPolicyForCalledAET(this.calledAETs[i], policy1);
                policy.addCalledAET(this.calledAETs[i]);
                changed = true;
            } else {
                Object[] aets = policy1.getCallingAETs();
                if (aets.length == 0) {
                    if (callingAETs != null) {
                        policy1.setCallingAETs((String[])callingAETs);
                        changed = true;
                    }
                } else if (!this.haveSameItems(aets, callingAETs)) {
                    policy1.setCallingAETs((String[])callingAETs);
                    changed = true;
                }
            }
            policy1.setMaxPDULength(this.maxPDULength);
            policy1.setAsyncOpsWindow(this.maxOpsInvoked, this.maxOpsPerformed);
            this.enablePresContexts(policy1);
        }
        return changed;
    }

    private String[] getCallingAETsForPolicy() {
        if (this.callingAETs == null) {
            return null;
        }
        if (this.callingAETs.length != 0) {
            return this.callingAETs;
        }
        this.log.debug((Object)"Use 'CONFIGURED_AETS' for list of calling AETs");
        try {
            Collection l = this.aeMgr().findAll();
            if (l.size() == 0) {
                this.log.warn((Object)"No AETs configured! No calling AET is allowed!");
                return this.callingAETs;
            }
            ArrayList<String> dicomAEs = new ArrayList<String>(l.size());
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                String aet = ((AEDTO)iter.next()).getTitle();
                if (aet.indexOf(94) != -1) continue;
                dicomAEs.add(aet);
            }
            this.log.debug((Object)("Use 'CONFIGURED_AETS'. Current list of configured (dicom) AETs" + dicomAEs));
            String[] sa = new String[dicomAEs.size()];
            return dicomAEs.toArray(sa);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to query configured AETs! No calling AET is allowed!", (Throwable)e);
            return this.callingAETs;
        }
    }

    private boolean haveSameItems(Object[] o1, Object[] o2) {
        if (o1 == null || o2 == null || o1.length != o2.length) {
            return false;
        }
        if (o1.length == 1) {
            return o1[0].equals(o2[0]);
        }
        int len = o1.length;
        block0: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (o1[i].equals(o2[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private void disableService() {
        if (this.dcmHandler == null) {
            return;
        }
        AcceptorPolicy policy = this.dcmHandler.getAcceptorPolicy();
        for (int i = 0; i < this.calledAETs.length; ++i) {
            AcceptorPolicy policy1 = policy.getPolicyForCalledAET(this.calledAETs[i]);
            if (policy1 == null) continue;
            this.disablePresContexts(policy1);
            if (!policy1.listPresContext().isEmpty()) continue;
            policy.putPolicyForCalledAET(this.calledAETs[i], null);
            policy.removeCalledAET(this.calledAETs[i]);
        }
    }

    public final String getCallingAETs() {
        return this.callingAETs == null ? ANY : (this.callingAETs.length == 0 ? CONFIGURED_AETS : StringUtils.toString(this.callingAETs, '\\'));
    }

    public final void setCallingAETs(String callingAETs) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.getCallingAETs().equals(callingAETs)) {
            return;
        }
        String[] stringArray = ANY.equalsIgnoreCase(callingAETs) ? null : (this.callingAETs = CONFIGURED_AETS.equalsIgnoreCase(callingAETs) ? new String[]{} : StringUtils.split(callingAETs, '\\'));
        if (this.enableService()) {
            this.server.invoke(this.dcmServerName, "notifyCallingAETchange", new Object[]{this.calledAETs, this.callingAETs}, new String[]{String[].class.getName(), String[].class.getName()});
        }
    }

    protected void updateAcceptedSOPClass(Map<String, String> cuidMap, String newval, DcmService scp) {
        Map<String, String> tmp = AbstractScpService.parseUIDs(newval);
        if (((Object)cuidMap.keySet()).equals(tmp.keySet())) {
            return;
        }
        this.disableService();
        if (scp != null) {
            this.unbindAll(AbstractScpService.valuesToStringArray(cuidMap));
        }
        cuidMap.clear();
        cuidMap.putAll(tmp);
        if (scp != null) {
            this.bindAll(AbstractScpService.valuesToStringArray(cuidMap), scp);
        }
        this.enableService();
    }

    protected static String[] valuesToStringArray(Map<String, String> tsuid) {
        return tsuid.values().toArray(new String[tsuid.size()]);
    }

    protected void bindAll(String[] cuids, DcmService scp) {
        if (this.dcmHandler == null) {
            return;
        }
        DcmServiceRegistry services = this.dcmHandler.getDcmServiceRegistry();
        for (int i = 0; i < cuids.length; ++i) {
            services.bind(cuids[i], scp);
        }
    }

    protected void unbindAll(String[] cuids) {
        if (this.dcmHandler == null) {
            return;
        }
        DcmServiceRegistry services = this.dcmHandler.getDcmServiceRegistry();
        for (int i = 0; i < cuids.length; ++i) {
            services.unbind(cuids[i]);
        }
    }

    public String getAcceptedTransferSyntax() {
        return this.toString(this.tsuidMap);
    }

    public void setAcceptedTransferSyntax(String s) {
        this.updateAcceptedTransferSyntax(this.tsuidMap, s);
    }

    protected void updateAcceptedTransferSyntax(Map<String, String> tsuidMap, String newval) {
        Map<String, String> tmp = AbstractScpService.parseUIDs(newval);
        if (AbstractScpService.equals(tsuidMap, tmp)) {
            return;
        }
        tsuidMap.clear();
        tsuidMap.putAll(tmp);
        this.enableService();
    }

    private static boolean equals(Map<String, String> tsuidMap1, Map<String, String> tsuidMap2) {
        if (tsuidMap1.size() != tsuidMap2.size()) {
            return false;
        }
        Iterator<String> iter1 = tsuidMap1.keySet().iterator();
        Iterator<String> iter2 = tsuidMap2.keySet().iterator();
        while (iter1.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    protected String toString(Map<String, String> uids) {
        if (uids == null || uids.isEmpty()) {
            return "";
        }
        String nl = System.getProperty("line.separator", "\n");
        StringBuffer sb = new StringBuffer();
        Iterator<String> iter = uids.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(nl);
        }
        return sb.toString();
    }

    protected static Map<String, String> parseUIDs(String uids) {
        StringTokenizer st = new StringTokenizer(uids, " \t\r\n;");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (st.hasMoreTokens()) {
            String uid;
            String name = uid = st.nextToken().trim();
            if (AbstractScpService.isDigit(uid.charAt(0))) {
                if (!UIDs.isValid(uid)) {
                    throw new IllegalArgumentException("UID " + uid + " isn't a valid UID!");
                }
            } else {
                uid = UIDs.forName(name);
            }
            map.put(name, uid);
        }
        return map;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected void startService() throws Exception {
        this.logDir = new File(System.getProperty("jboss.server.log.dir"));
        this.userIdentityNegotiator = (UserIdentityNegotiator)this.server.invoke(this.dcmServerName, "userIdentityNegotiator", null, null);
        this.dcmHandler = (DcmHandler)this.server.invoke(this.dcmServerName, "dcmHandler", null, null);
        this.bindDcmServices(this.dcmHandler.getDcmServiceRegistry());
        this.server.addNotificationListener(this.dcmServerName, this.callingAETChangeListener, (NotificationFilter)callingAETsChangeFilter, null);
        this.server.addNotificationListener(this.aeServiceName, this.aetChangeListener, (NotificationFilter)aetChangeFilter, null);
        this.enableService();
    }

    protected void stopService() throws Exception {
        this.disableService();
        this.unbindDcmServices(this.dcmHandler.getDcmServiceRegistry());
        this.dcmHandler = null;
        this.userIdentityNegotiator = null;
        this.server.removeNotificationListener(this.dcmServerName, this.callingAETChangeListener);
        this.server.removeNotificationListener(this.aeServiceName, this.aetChangeListener);
    }

    protected abstract void bindDcmServices(DcmServiceRegistry var1);

    protected abstract void unbindDcmServices(DcmServiceRegistry var1);

    protected abstract void enablePresContexts(AcceptorPolicy var1);

    protected abstract void disablePresContexts(AcceptorPolicy var1);

    protected void putPresContexts(AcceptorPolicy policy, String[] cuids, String[] tsuids) {
        for (int i = 0; i < cuids.length; ++i) {
            policy.putPresContext(cuids[i], tsuids);
        }
    }

    protected void putRoleSelections(AcceptorPolicy policy, String[] cuids, boolean scu, boolean scp) {
        for (int i = 0; i < cuids.length; ++i) {
            policy.putRoleSelection(cuids[i], scu, scp);
        }
    }

    protected void removeRoleSelections(AcceptorPolicy policy, String[] cuids) {
        for (int i = 0; i < cuids.length; ++i) {
            policy.removeRoleSelection(cuids[i]);
        }
    }

    public File getLogFile(Date now, String callingAET, String suffix) {
        File dir = new File(this.logDir, callingAET);
        dir.mkdirs();
        return new File(dir, new DTFormat().format(now) + suffix);
    }

    private boolean contains(Object[] a, Object e) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(e)) continue;
            return true;
        }
        return false;
    }

    public void logDIMSE(Association a, String suffix, Dataset ds) {
        String callingAET = a.getCallingAET();
        if (this.contains(this.logCallingAETs, callingAET)) {
            try {
                XSLTUtils.writeTo(ds, this.getLogFile(new Date(), callingAET, suffix));
            }
            catch (Exception e) {
                this.log.warn((Object)"Logging of attributes failed:", (Throwable)e);
            }
        }
    }

    public Dataset getCoercionAttributesFor(String aet, String xsl, Dataset in, Association a) {
        return this.getCoercionAttributesFor(a, xsl, in, this.getCoercionTemplates(aet, xsl));
    }

    public Templates getCoercionTemplates(String aet, String xsl) {
        return this.templates.getTemplatesForAET(aet, xsl);
    }

    public Dataset getCoercionAttributesFor(Association a, String xsl, Dataset in, Templates stylesheet) {
        Dataset out = CoercionUtils.getCoercionAttributesFor(a, in, stylesheet);
        this.logCoercion(a, xsl, in, out);
        return out;
    }

    public Dataset getCoercionAttributesFor(Association a, String xsl, Dataset in, TransformerHandler th) {
        Dataset out = CoercionUtils.getCoercionAttributesFor(in, th);
        this.logCoercion(a, xsl, in, out);
        return out;
    }

    private void logCoercion(Association a, String xsl, Dataset in, Dataset out) {
        if (this.writeCoercionXmlLog && this.contains(this.logCallingAETs, a.getCallingAET())) {
            try {
                Date now = new Date();
                XSLTUtils.writeTo(in, this.getLogFile(now, "coercion", "." + xsl + ".in"));
                XSLTUtils.writeTo(out, this.getLogFile(now, "coercion", "." + xsl + ".out"));
            }
            catch (Exception e) {
                this.log.error((Object)"Error logging coercion:", (Throwable)e);
            }
        }
    }

    public void coerceAttributes(DcmObject ds, DcmObject coerce) {
        CoercionUtils.coerceAttributes(ds, coerce);
    }

    public void sendJMXNotification(Object o) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send JMX Notification: " + o));
        }
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(o.getClass().getName(), (Object)this, eventID);
        notif.setUserData(o);
        super.sendNotification(notif);
    }

    public void logDicomQuery(Association assoc, String cuid, Dataset keys) {
        try {
            QueryMessage msg = new QueryMessage();
            msg.addDestinationProcess(AuditMessage.getProcessID(), this.calledAETs, AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), false);
            String srcHost = AuditMessage.hostNameOf((InetAddress)assoc.getSocket().getInetAddress());
            msg.addSourceProcess(srcHost, new String[]{assoc.getCallingAET()}, null, srcHost, true);
            byte[] query = DatasetUtils.toByteArray(keys);
            msg.addQuerySOPClass(cuid, "1.2.840.10008.1.2.1", query);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    public static String formatPN(String pname) {
        if (pname == null || pname.length() == 0) {
            return null;
        }
        return DcmObjectFactory.getInstance().newPersonName(pname).format();
    }

    public void supplementIssuerOfPatientID(Dataset ds, Association as, String aet, boolean forQuery) {
        if (this.supplementIssuerOfPatientID && !ds.containsValue(0x100021) && (ds.containsValue(0x100020) || forQuery && !ds.contains(0x100021))) {
            String issuer = this.getAssociatedIssuerOfPatientID(as, aet);
            if (issuer.length() != 0) {
                ds.putLO(0x100021, issuer);
                this.log.info((Object)("Supplement Issuer Of Patient ID " + issuer));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No Issuer Of Patient ID associated to " + as + " - no supplement of Issuer Of Patient ID"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAssociatedIssuerOfPatientID(Association as, String aet) {
        String issuer = (String)as.getProperty(ASSOC_ISSUER_OF_PAT_ID);
        if (issuer == null) {
            try {
                block12: {
                    try {
                        AEManager aeMgr = this.aeMgr();
                        try {
                            issuer = aeMgr.findByAET(aet).getIssuerOfPatientID();
                        }
                        catch (UnknownAETException e) {
                            // empty catch block
                        }
                        InetAddress addr = null;
                        if ((issuer == null || issuer.length() == 0) && this.supplementByHostName) {
                            addr = as.getSocket().getInetAddress();
                            String hostName = addr.getHostName();
                            issuer = this.issuerOfPatientID(aeMgr.findByHostName(hostName), hostName);
                        }
                        if (issuer != null && issuer.length() != 0 || !this.supplementByHostAddress) break block12;
                        if (addr == null) {
                            addr = as.getSocket().getInetAddress();
                        }
                        String hostAddress = addr.getHostAddress();
                        issuer = this.issuerOfPatientID(aeMgr.findByHostName(hostAddress), hostAddress);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to access AE configuration:", (Throwable)e);
                        Object var8_10 = null;
                        if (issuer == null) {
                            issuer = "";
                        }
                        as.putProperty(ASSOC_ISSUER_OF_PAT_ID, issuer);
                    }
                }
                Object var8_9 = null;
                if (issuer == null) {
                    issuer = "";
                }
                as.putProperty(ASSOC_ISSUER_OF_PAT_ID, issuer);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (issuer == null) {
                    issuer = "";
                }
                as.putProperty(ASSOC_ISSUER_OF_PAT_ID, issuer);
                throw throwable;
            }
        }
        return issuer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssociatedInstitutionName(Association as, String aet) {
        String instName = (String)as.getProperty(ASSOC_INST_NAME);
        if (instName == null) {
            String deptName = null;
            try {
                block15: {
                    try {
                        String hostAddress;
                        String hostName;
                        String[] tmp;
                        AEManager aeMgr = this.aeMgr();
                        AEDTO ae = null;
                        try {
                            ae = aeMgr.findByAET(aet);
                            instName = ae.getInstitution();
                            deptName = ae.getDepartment();
                        }
                        catch (UnknownAETException e) {
                            // empty catch block
                        }
                        InetAddress addr = null;
                        if ((instName == null || instName.length() == 0) && this.supplementByHostName && (tmp = this.institutionalData(aeMgr.findByHostName(hostName = (addr = as.getSocket().getInetAddress()).getHostName()), hostName)) != null) {
                            instName = tmp[0];
                            deptName = tmp[1];
                        }
                        if (instName != null && instName.length() != 0 || !this.supplementByHostAddress) break block15;
                        if (addr == null) {
                            addr = as.getSocket().getInetAddress();
                        }
                        if ((tmp = this.institutionalData(aeMgr.findByHostName(hostAddress = addr.getHostAddress()), hostAddress)) == null) break block15;
                        instName = tmp[0];
                        deptName = tmp[1];
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to access AE configuration:", (Throwable)e);
                        Object var11_13 = null;
                        if (instName == null) {
                            instName = "";
                        }
                        if (deptName == null) {
                            deptName = "";
                        }
                        as.putProperty(ASSOC_INST_NAME, instName);
                        as.putProperty(ASSOC_DEPT_NAME, deptName);
                    }
                }
                Object var11_12 = null;
                if (instName == null) {
                    instName = "";
                }
                if (deptName == null) {
                    deptName = "";
                }
                as.putProperty(ASSOC_INST_NAME, instName);
                as.putProperty(ASSOC_DEPT_NAME, deptName);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (instName == null) {
                    instName = "";
                }
                if (deptName == null) {
                    deptName = "";
                }
                as.putProperty(ASSOC_INST_NAME, instName);
                as.putProperty(ASSOC_DEPT_NAME, deptName);
                throw throwable;
            }
        }
        return instName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] getAssociatedIssuerOfAccessionNumber(Association as, String aet) {
        String[] issuer;
        block12: {
            issuer = (String[])as.getProperty(ASSOC_ISSUER_OF_ACC_NO);
            if (issuer != null) return issuer;
            try {
                try {
                    AEManager aeMgr = this.aeMgr();
                    try {
                        issuer = aeMgr.findByAET(aet).getIssuerOfAccessionNumber();
                    }
                    catch (UnknownAETException e) {
                        // empty catch block
                    }
                    InetAddress addr = null;
                    if ((issuer == null || issuer.length == 0) && this.supplementByHostName) {
                        addr = as.getSocket().getInetAddress();
                        String hostName = addr.getHostName();
                        issuer = this.issuerOfAccessionNumber(aeMgr.findByHostName(hostName), hostName);
                    }
                    if ((issuer == null || issuer.length == 0) && this.supplementByHostAddress) {
                        if (addr == null) {
                            addr = as.getSocket().getInetAddress();
                        }
                        String hostAddress = addr.getHostAddress();
                        issuer = this.issuerOfAccessionNumber(aeMgr.findByHostName(hostAddress), hostAddress);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to access AE configuration:", (Throwable)e);
                    Object var8_10 = null;
                    if (issuer == null) {
                        issuer = new String[]{};
                    }
                    as.putProperty(ASSOC_ISSUER_OF_ACC_NO, issuer);
                    return issuer;
                }
                Object var8_9 = null;
                if (issuer != null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (issuer == null) {
                    issuer = new String[]{};
                }
                as.putProperty(ASSOC_ISSUER_OF_ACC_NO, issuer);
                throw throwable;
            }
            issuer = new String[]{};
        }
        as.putProperty(ASSOC_ISSUER_OF_ACC_NO, issuer);
        return issuer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssociatedInstitutionalDepartmentName(Association as, String aet) {
        String deptName = (String)as.getProperty(ASSOC_DEPT_NAME);
        if (deptName == null) {
            String instName = null;
            try {
                block15: {
                    try {
                        String hostAddress;
                        String hostName;
                        String[] tmp;
                        AEManager aeMgr = this.aeMgr();
                        AEDTO ae = null;
                        try {
                            ae = aeMgr.findByAET(aet);
                            instName = ae.getInstitution();
                            deptName = ae.getDepartment();
                        }
                        catch (UnknownAETException e) {
                            // empty catch block
                        }
                        InetAddress addr = null;
                        if ((deptName == null || deptName.length() == 0) && this.supplementByHostName && (tmp = this.institutionalData(aeMgr.findByHostName(hostName = (addr = as.getSocket().getInetAddress()).getHostName()), hostName)) != null) {
                            instName = tmp[0];
                            deptName = tmp[1];
                        }
                        if (deptName != null && deptName.length() != 0 || !this.supplementByHostAddress) break block15;
                        if (addr == null) {
                            addr = as.getSocket().getInetAddress();
                        }
                        if ((tmp = this.institutionalData(aeMgr.findByHostName(hostAddress = addr.getHostAddress()), hostAddress)) == null) break block15;
                        instName = tmp[0];
                        deptName = tmp[1];
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to access AE configuration:", (Throwable)e);
                        Object var11_13 = null;
                        if (instName == null) {
                            instName = "";
                        }
                        if (deptName == null) {
                            deptName = "";
                        }
                        as.putProperty(ASSOC_INST_NAME, instName);
                        as.putProperty(ASSOC_DEPT_NAME, deptName);
                    }
                }
                Object var11_12 = null;
                if (instName == null) {
                    instName = "";
                }
                if (deptName == null) {
                    deptName = "";
                }
                as.putProperty(ASSOC_INST_NAME, instName);
                as.putProperty(ASSOC_DEPT_NAME, deptName);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (instName == null) {
                    instName = "";
                }
                if (deptName == null) {
                    deptName = "";
                }
                as.putProperty(ASSOC_INST_NAME, instName);
                as.putProperty(ASSOC_DEPT_NAME, deptName);
                throw throwable;
            }
        }
        return deptName;
    }

    private String issuerOfPatientID(Collection<AEDTO> aes, String host) {
        String issuer = null;
        for (AEDTO ae : aes) {
            String tmp = ae.getIssuerOfPatientID();
            if (tmp == null || tmp.length() == 0) continue;
            if (issuer == null) {
                issuer = tmp;
                continue;
            }
            if (issuer.equals(tmp)) continue;
            this.log.warn((Object)("Different Issuer of Patient IDs associated to " + host));
            return null;
        }
        return issuer;
    }

    private String[] issuerOfAccessionNumber(Collection<AEDTO> aes, String host) {
        Object[] issuer = null;
        for (AEDTO ae : aes) {
            Object[] tmp = ae.getIssuerOfAccessionNumber();
            if (tmp == null || tmp.length == 0) continue;
            if (issuer == null) {
                issuer = tmp;
                continue;
            }
            if (Arrays.equals(issuer, tmp)) continue;
            this.log.warn((Object)("Different Issuer of Accession Number associated to " + host));
            return null;
        }
        return issuer;
    }

    private String[] institutionalData(Collection<AEDTO> aes, String host) {
        String[] instData = null;
        for (AEDTO ae : aes) {
            String dep;
            String inst = ae.getInstitution();
            if (inst == null) {
                inst = "";
            }
            if ((dep = ae.getDepartment()) == null) {
                dep = "";
            }
            if (inst.length() == 0 && dep.length() == 0) continue;
            String[] tmp = new String[]{inst, dep};
            if (instData == null) {
                instData = new String[]{inst, dep};
                continue;
            }
            if (instData[0].equals(inst) && instData[1].equals(dep)) continue;
            this.log.warn((Object)("Different Institution and/or Department Name associated to " + host));
            return null;
        }
        return instData;
    }

    public void supplementIssuerOfAccessionNumber(Dataset ds, Association as, String aet, boolean forQuery) {
        DcmElement reqAttrSeq;
        if (!this.supplementIssuerOfAccessionNumber) {
            return;
        }
        String[] issuer = null;
        if (AbstractScpService.shallSupplementIssuerOfAccessionNumber(ds, forQuery)) {
            issuer = this.getAssociatedIssuerOfAccessionNumber(as, aet);
            if (issuer.length == 0) {
                return;
            }
            this.supplementIssuerOfAccessionNumber(ds, issuer);
        }
        if ((reqAttrSeq = ds.get(4194933)) != null && reqAttrSeq.hasItems()) {
            int n = reqAttrSeq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = reqAttrSeq.getItem(i);
                if (!AbstractScpService.shallSupplementIssuerOfAccessionNumber(item, forQuery)) continue;
                if (issuer == null) {
                    issuer = this.getAssociatedIssuerOfAccessionNumber(as, aet);
                }
                if (issuer.length == 0) {
                    return;
                }
                this.supplementIssuerOfAccessionNumber(item, issuer);
            }
        }
    }

    private static boolean shallSupplementIssuerOfAccessionNumber(Dataset ds, boolean forQuery) {
        return !AbstractScpService.containsIssuerOfAccessionNumber(ds) && (ds.containsValue(524368) || forQuery && !ds.contains(524369));
    }

    private static boolean containsIssuerOfAccessionNumber(Dataset ds) {
        Dataset item = ds.getItem(524369);
        return item != null && (item.containsValue(4194353) || item.containsValue(4194354));
    }

    private void supplementIssuerOfAccessionNumber(Dataset ds, String[] issuer) {
        Dataset item = ds.putSQ(524369).addNewItem();
        if (issuer[0].length() > 0) {
            item.putUT(4194353, issuer[0]);
        }
        if (issuer.length > 2) {
            item.putUT(4194354, issuer[1]);
            item.putCS(0x400033, issuer[2]);
        }
        this.log.info((Object)("Supplement Issuer Of Accession Number " + StringUtils.toString(issuer, '^')));
    }

    public void supplementInstitutionalData(Dataset ds, Association as, String aet) {
        if (this.supplementInstitutionName) {
            String origName = ds.getString(524416);
            Dataset codeItem = ds.getItem(524418);
            if (codeItem != null && !codeItem.containsValue(524544)) {
                codeItem = null;
            }
            if (origName == null || codeItem == null) {
                String name = this.getAssociatedInstitutionName(as, aet);
                if (name.length() != 0) {
                    String[] code = StringUtils.split(name, '^');
                    if (code.length == 3) {
                        if (codeItem == null) {
                            this.supplementInstitutionCode(ds, as, code, origName);
                            this.log.info((Object)("Supplement Institution Code " + name));
                        }
                        name = code[2];
                    }
                    if (!ds.containsValue(524416)) {
                        ds.putLO(524416, name);
                        this.log.info((Object)("Supplement Institution Name " + name));
                    }
                } else if (origName == null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("No Institution Name associated to " + as + " - no supplement of Institution Name"));
                }
            }
        }
        if (this.supplementInstitutionalDepartmentName && !ds.containsValue(528448)) {
            String name = this.getAssociatedInstitutionalDepartmentName(as, aet);
            if (name.length() != 0) {
                ds.putLO(528448, name);
                this.log.info((Object)("Supplement Institutional Department Name " + name));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No Institutional Department associated to " + as + " - no supplement of Institutional Department Name"));
            }
        }
    }

    private void supplementInstitutionCode(Dataset ds, Association as, String[] code, String origName) {
        int delim;
        Dataset codeItem = ds.putSQ(524418).addNewItem();
        codeItem.putSH(524544, code[0]);
        String scheme = code[1];
        String meaning = code[2];
        if (scheme.endsWith("]") && (delim = scheme.lastIndexOf(91)) > 0) {
            codeItem.putSH(524547, scheme.substring(delim + 1, scheme.length() - 1));
            scheme = scheme.substring(0, delim);
        }
        codeItem.putSH(524546, scheme);
        codeItem.putLO(524548, meaning);
        if (origName != null && !origName.equals(meaning)) {
            DcmElement origAttrSq = ds.get(67110241);
            if (origAttrSq == null) {
                origAttrSq = ds.putSQ(67110241);
            }
            Dataset origAttrItem = origAttrSq.addNewItem();
            origAttrItem.putLO(67110244, as.getCallingAET());
            origAttrItem.putLO(67110243, as.getCalledAET());
            origAttrItem.putDT(67110242, new Date());
            origAttrItem.putCS(67110245, COERCE);
            Dataset modifiedAtts = origAttrItem.putSQ(0x4000550).addNewItem();
            modifiedAtts.putLO(524416, origName);
            ds.remove(524416);
        }
    }

    public void generatePatientID(Dataset pat, Dataset sty, String calledAET) throws DcmServiceException {
        if (this.generatePatientID == null) {
            return;
        }
        String pid = pat.getString(0x100020);
        if (pid != null) {
            return;
        }
        String pname = pat.getString(0x100010);
        String issuer = this.issuerOfGeneratedPatientID(calledAET);
        if (this.generatePatientID.length == 1) {
            pid = this.generatePatientID[0];
        } else {
            String suid = sty != null ? sty.getString(0x20000D) : null;
            int suidHash = suid != null ? suid.hashCode() : (sequenceInt = sequenceInt + 1);
            int pnameHash = pname == null ? suidHash : pname.hashCode() * 37 + pat.getString(0x100030, "").hashCode() + pat.getString(0x100040, "").hashCode();
            pid = this.generatePatientID(pnameHash, suidHash);
            if (this.pnameHashInGeneratePatientID && pname != null) {
                try {
                    Storage s = this.getStorage();
                    while (!pname.equals(s.getPatientByIDWithIssuer(pid, issuer).getString(0x100010))) {
                        pid = this.generatePatientID(++pnameHash, suidHash);
                    }
                }
                catch (ObjectNotFoundException e) {
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to query DB for patient with pid=" + pid + ", issuer=" + issuer));
                    throw new DcmServiceException(272, (Throwable)e);
                }
            }
        }
        pat.putLO(0x100020, pid);
        pat.putLO(0x100021, issuer);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Generate Patient ID: " + pid + "^^^" + issuer + " for Patient: " + pname));
        }
    }

    private String generatePatientID(int pnameHash, int suidHash) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.generatePatientID.length; ++i) {
            String s = this.generatePatientID[i];
            int l = s.length();
            if (l == 0) continue;
            char c = s.charAt(0);
            if (c != '#' && c != '$') {
                sb.append(s);
                continue;
            }
            String v = Long.toString((long)(c == '#' ? pnameHash : suidHash) & 0xFFFFFFFFL);
            for (int j = v.length() - l; j < 0; ++j) {
                sb.append('0');
            }
            sb.append(v);
        }
        return sb.toString();
    }

    private String issuerOfGeneratedPatientID(String calledAET) {
        try {
            AEDTO ae = this.aeMgr().findByAET(calledAET);
            String issuer = ae.getIssuerOfPatientID();
            if (issuer != null) {
                return issuer;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.issuerOfGeneratedPatientID;
    }

    public boolean ignorePatientIDForUnscheduled(Dataset ds, int requestAttrsSeqTag, String callingAET) {
        String pid = ds.getString(0x100020);
        Dataset requestAttrs = ds.getItem(requestAttrsSeqTag);
        if (pid != null && (requestAttrs == null || !requestAttrs.containsValue(0x400009)) && this.isGeneratePatientIDForUnscheduledFromAET(callingAET)) {
            String issuer = ds.getString(0x100021);
            ds.putLO(0x100020);
            ds.remove(0x100021);
            if (this.log.isInfoEnabled()) {
                StringBuffer prompt = new StringBuffer("Ignore Patient ID: ");
                prompt.append(pid);
                if (issuer != null) {
                    prompt.append("^^^").append(issuer);
                }
                prompt.append(" for Patient: ").append(ds.getString(0x100010));
                this.log.info((Object)prompt.toString());
            }
            return true;
        }
        return false;
    }

    protected AEManager aeMgr() throws Exception {
        AEManagerHome home = (AEManagerHome)EJBHomeFactory.getFactory().lookup(AEManagerHome.class, "ejb/AEManager");
        return home.create();
    }

    public StudyPermissionManager getStudyPermissionManager(Association a) throws Exception {
        StudyPermissionManager mgt = (StudyPermissionManager)a.getProperty("ejb/StudyPermissionManager");
        if (mgt == null) {
            mgt = ((StudyPermissionManagerHome)EJBHomeFactory.getFactory().lookup(StudyPermissionManagerHome.class, "ejb/StudyPermissionManager")).create();
            a.putProperty("ejb/StudyPermissionManager", mgt);
        }
        return mgt;
    }

    private Storage getStorage() throws Exception {
        StorageHome home = (StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage");
        return home.create();
    }

    static {
        callingAETsChangeFilter.enableType(CallingAetChanged.class.getName());
        aetChangeFilter = new NotificationFilterSupport();
        aetChangeFilter.enableType(AetChanged.class.getName());
    }
}

